<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/inter_process_communication.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Inter Process Communication"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/IPC"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Inter Process Communication


<img src="https://netdata.cloud/img/network-wired.svg" width="150"/>


Plugin: proc.plugin
Module: ipc

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

IPC stands for Inter-Process Communication. It is a mechanism which allows processes to communicate with each
other and synchronize their actions.

This collector exposes information about:

- Message Queues: This allows messages to be exchanged between processes. It's a more flexible method that
  allows messages to be placed onto a queue and read at a later time.

- Shared Memory: This method allows for the fastest form of IPC because processes can exchange data by
  reading/writing into shared memory segments.

- Semaphores: They are used to synchronize the operations performed by independent processes. So, if multiple
  processes are trying to access a single shared resource, semaphores can ensure that only one process
  accesses the resource at a given time.




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Inter Process Communication instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.ipc_semaphores | semaphores | semaphores |
| system.ipc_semaphore_arrays | arrays | arrays |
| system.message_queue_message | a dimension per queue | messages |
| system.message_queue_bytes | a dimension per queue | bytes |
| system.shared_memory_segments | segments | segments |
| system.shared_memory_bytes | bytes | bytes |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ semaphores_used ](https://github.com/netdata/netdata/blob/master/health/health.d/ipc.conf) | system.ipc_semaphores | IPC semaphore utilization |
| [ semaphore_arrays_used ](https://github.com/netdata/netdata/blob/master/health/health.d/ipc.conf) | system.ipc_semaphore_arrays | IPC semaphore arrays utilization |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


