# Security Policy

The Netatalk Project takes cyber security very seriously.
We commit to follow up to and resolve potential security flaws in our code as quickly as we can.
The reporter of an accepted and patched vulnerability will be given credit in the advisory published by this project.

## Supported Versions

This table indicates the Netatalk release series that are currently guaranteed to get security patches.
Project policy is to support a release series with security patches up to 12 months after a superseding stable release.

| Version | Supported          | Planned End of Life |
| ------- | ------------------ | ------------------- |
| 4.1.x   | :white_check_mark: | Active development  |
| 4.0.x   | :white_check_mark: | Jan 10, 2026        |
| 3.2.x   | :white_check_mark: | Sep 28, 2025        |
| 3.1.x   | :white_check_mark: | May 31, 2025        |
| 3.0.x   | :x:                | -                   |
| 2.4.x   | :white_check_mark: | Sep 28, 2025        |
| < 2.4   | :x:                | -                   |

## Reporting a Vulnerability

If you think you have found an exploitable security vulnerability in Netatalk, the Netatalk Team would be eager to hear from you!

The best way to get in touch with us is by filing a report via the
[private security vulnerability reporting](https://github.com/Netatalk/netatalk/security/advisories/new)
workflow in GitHub. This allows us to collaborate in private and avoid putting end-users at potential risk in the meantime.

In order for us to take effective action on your report, please include as much context as possible:

- An unambiguous link to the affected source code, including the specific line and Git commit hash
- Configurations or input data required to reproduce the issue
- Concrete steps to reproduce the issue
- Ideally, proof-of-concept code that demonstrates the exploit
- A summary of the issue's potental impact

## Response

If we are able to reproduce and subsequently patch the vulnerability, we will publish an advisory on [netatalk.io](https://netatalk.io/support)
where you are credited as finder and reporter. If you also contribute a patch, you will be credited as patch developer.

Please be mindful that Netatalk is a volunteer driven project. We do this on our free time, so response times may vary.
That said, we will try to take action on your report as soon as possible!
