/* $Id: Location_pos_constraint.cpp 436139 2014-05-23 15:56:34Z chenj $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  J. Chen
 *
 * File Description:
 *   Evaluate if pos matches to CLocation_pos_constraint
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Location_pos_constraint.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CLocation_pos_constraint::~CLocation_pos_constraint(void)
{
}

bool CLocation_pos_constraint :: Match(int pos) const
{
   switch (Which())
   {
      case e_Dist_from_end:
            if (pos != GetDist_from_end()) {
               return false;
            }
            break;
      case e_Max_dist_from_end:
            if (pos > GetMax_dist_from_end()) {
              return false;
            }
            break;
      case e_Min_dist_from_end:
            if (pos < GetMin_dist_from_end()) {
               return false;
            }
            break;
      default: break;
   }
   return true;
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1762, CRC32: 25107cba */
