
/*
 * $Header: /cvsroot/mpdist/mpdist/mptool/toolfuns.c,v 1.1.1.1 2002/04/12 16:47:25 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"
#include <string.h>

static void exec_print_job (char *);


void
do_print_cmd(char *filenames)
{
    char *aliasname, buf[BUFFERSIZE], *gsubject, m[MAXLINE], *printer_name;
    int i;
    int copies = get_int_value(F_MAIN, "copies");

    set_icon(I_PRINTING);

#ifdef DEBUG
    STRCPY(buf, "echo mp ");
#else
    STRCPY(buf, "mp ");
#endif /* DEBUG */

    buf_arg(buf, "-printer");                           /* -printer */
    printer_name = str_opt_val(O_PR_NAME);
    if (printer_name && *printer_name != '\0')
        buf_str(buf, printer_name);

    if (get_bool_value(F_MAIN, "file_type_news"))      /* -article */
        buf_arg(buf, "-article");
    if (get_bool_value(F_MAIN, "file_type_post"))      /* -postscript */
        buf_arg(buf, "-postscript");
    if (get_bool_value(F_MAIN, "file_type_text"))      /* -text */
        buf_arg(buf, "-text");
 
    if (get_bool_value(F_MAIN, "output_perorg")) {
        if (get_bool_value(F_MAIN, "franklin"))     /* -franklin */
            buf_arg(buf, "-franklin");
        if (get_bool_value(F_MAIN, "filofax"))     /* -filofax */
            buf_arg(buf, "-filofax");
        if (get_bool_value(F_MAIN, "proplan"))     /* -proplan */
            buf_arg(buf, "-proplan");
        if (get_bool_value(F_MAIN, "time_manager"))     /* -timeman */
            buf_arg(buf, "-timeman");
        if (get_bool_value(F_MAIN, "time_system__intl_"))    /* -tmintl */
            buf_arg(buf, "-tsintl");
        if (get_bool_value(F_MAIN, "time_system__partner_"))    /* -tmpartner */
            buf_arg(buf, "-tspartner");
    }
    if (get_bool_value(F_MAIN, "output_land"))         /* -landscape */
        buf_arg(buf, "-landscape");
 
    if (get_bool_value(F_MAIN, "paper_size_a4"))       /* -a4 */
        buf_arg(buf, "-a4");
    if (get_bool_value(F_MAIN, "paper_size_us"))       /* -us */
        buf_arg(buf, "-us");
 
    if (!int_opt_val(O_BURSTPAGE))                      /* -noburstpage */
        buf_arg(buf, "-noburstpage");
    if (int_opt_val(O_FOLDER))                          /* -folder */
        buf_arg(buf, "-folder");
    if (int_opt_val(O_DIGEST))                          /* -digest */
        buf_arg(buf, "-digest");

    gsubject = get_str_value(F_MAIN, "subject");
    if (gsubject && *gsubject != '\0') {    /* -subject text */
        buf_arg(buf, "-subject");
        buf_str(buf, gsubject);
    }
    if (int_opt_val(O_LLEN) < 1 ||
        int_opt_val(O_LLEN) > MAXLINELENGTH) {  /* -linelength # */
        SPRINTF(m, mptool_strs[(int) S_INVLINE], LINELENGTH);
        notice(F_MAIN, m);
        set_int_opt_val(O_LLEN, LINELENGTH);
        if (output_frame_widget)
            set_int_value(F_OUTPUT, "line_length", LINELENGTH);
    }
    buf_int(buf, "-linelength", int_opt_val(O_LLEN));

    if (int_opt_val(O_PLEN) < 1 ||
        int_opt_val(O_PLEN) > MAXPAGELENGTH) {  /* -pagelength # */
        SPRINTF(m, mptool_strs[(int) S_INVPAGE], PAGELENGTH);
        notice(F_MAIN, m);
        set_int_opt_val(O_PLEN, PAGELENGTH);
        if (output_frame_widget)
            set_int_value(F_OUTPUT, "page_length", PAGELENGTH);
    }
    buf_int(buf, "-pagelength", int_opt_val(O_PLEN));

    if (int_opt_val(O_ALLHDRS)) /* -allhdrs */
        buf_arg(buf, "-allhdrs");
    else {
        for (i = 0; i < int_opt_val(O_REMHDRN); i++) {  /* -remhdr <hdr> */
            buf_arg(buf, "-remhdr");
            buf_str(buf, get_hdr(H_REMOVE, i));
        }

        for (i = 0; i < int_opt_val(O_ADDHDRN); i++) {  /* -addhdr <hdr> */
            buf_arg(buf, "-addhdr");
            buf_str(buf, get_hdr(H_ADD, i));
        }
    }    

    if (copies < 1 || copies > MAXCOPIES) { /* -copies # */
        SPRINTF(m, mptool_strs[(int) S_INVCOPIES], DEFCOPIES);
        notice(F_MAIN, m);
        copies = DEFCOPIES;
        set_int_value(F_MAIN, "copies", 1);
    }
    buf_int(buf, "-copies", copies);

    if (get_bool_value(F_MAIN, "no_sides_double"))
        buf_arg(buf, "-twosided");  /* -twosided */
    else
        buf_arg(buf, "-onesided");  /* -onesided */

    aliasname = str_opt_val(O_ALIAS);
    if (aliasname && *aliasname != '\0') {
        buf_arg(buf, "-alias");
        buf_str(buf, aliasname);
    }
    if (proname && *proname != '\0') {  /* -prologue name */
        buf_arg(buf, "-prologue");
        buf_str(buf, proname);
    }
    buf_int(buf, "-columns", int_opt_val(O_NUMCOLS));   /* -columns # */
    buf_int(buf, "-tab", int_opt_val(O_TABSIZE));   /* -tab # */
    buf_int(buf, "-chars", int_opt_val(O_NAMELEN)); /* -chars # */
    buf_int(buf, "-words", int_opt_val(O_NAMEF));   /* -words # */
    if (int_opt_val(O_WRAPW))
        buf_arg(buf, "-wrap");  /* -wrap */
    if (int_opt_val(O_FLIP))
        buf_arg(buf, "-flip");  /* -flip */
    if (int_opt_val(O_FORCEPAGE))   /* -forcepage */
        buf_arg(buf, "-forcepage");
    if (int_opt_val(O_ELM))
        buf_arg(buf, "-elm");   /* -elm */
    if (int_opt_val(O_NUMBER))
        buf_arg(buf, "-number");    /* -number */
    if (int_opt_val(O_PR_ORIG))
        buf_arg(buf, "-from");  /* -from */
    if (int_opt_val(O_CONTENT))
        buf_arg(buf, "-content");   /* -content */
    if (int_opt_val(O_MODTIME))
        buf_arg(buf, "-modtime");   /* -modtime */
    if (int_opt_val(O_BSDPRINT))
        buf_arg(buf, "-bsdprint");  /* -bsdprint */
    if (int_opt_val(O_TUMBLE))
        buf_arg(buf, "-tumble");    /* -tumble */

    buf_int(buf, "-bottom", get_margin(M_BOTTOM));  /* -bottom # */
    buf_int(buf, "-left",   get_margin(M_LEFT));    /* -left   # */
    buf_int(buf, "-right",  get_margin(M_RIGHT));   /* -right  # */
    buf_int(buf, "-top",    get_margin(M_TOP));     /* -top    # */

    if (filenames == NULL || *filenames == '\0') {
        notice(F_MAIN, mptool_strs[(int) S_NOFILES]);
        return;
    }
    buf_arg(buf, filenames);
    exec_print_job(buf);
    set_icon(I_NORMAL);
}


void
do_startup(int argc, char **argv)
{
    char files[BUFFERSIZE];
    int i;

    Base();
    Header();
    Option();
    get_appname(argc, argv);

    init_text();              /* Internationalise text strings. */
    read_resources();         /* Read resources from merged database. */
    get_options(argc, argv);  /* Read and process command line options */

    files[0] = '\0';          /* Prime the list of files to print. */
    for (i = 0; i < int_opt_val(O_NUMNAMES); i++) {
        STRCAT(files, get_filename(i));
        STRCAT(files, " ");
    }
    files[strlen(files) - 1] = '\0';
    read_str(&filenames, files);

    do_reset_options();
}


static void
exec_print_job(char *buf)
{
    int pid;

    if ((pid = (int) fork()) < 0) {
        notice(F_MAIN, mptool_strs[(int) S_START]);
        return;
    }
    if (pid == 0) {     /* Child process. */
        fprintf(stderr, "exec_print_job: about to exec %s\n", buf);
        (void) execl("/bin/sh", "sh", "-c", buf, (char *) 0);
        perror(mptool_strs[(int) S_EXECUTE]);
        _exit(1);
    }
}
