/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.ByteObjectAssociativeContainer;
import com.carrotsearch.hppc.ByteObjectMap;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ByteObjectCursor;
import com.carrotsearch.hppc.hash.ByteHashFunction;
import com.carrotsearch.hppc.hash.ByteMurmurHash;
import com.carrotsearch.hppc.hash.ObjectHashFunction;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.procedures.ByteObjectProcedure;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteObjectOpenHashMap<VType>
implements ByteObjectMap<VType> {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public byte[] keys;
    public VType[] values;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final ByteHashFunction keyHashFunction;
    public final ObjectHashFunction<? super VType> valueHashFunction;
    private KeySet keySetView;

    public ByteObjectOpenHashMap() {
        this(16);
    }

    public ByteObjectOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteObjectOpenHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new ByteMurmurHash());
    }

    public ByteObjectOpenHashMap(int initialCapacity, float loadFactor, ByteHashFunction keyHashFunction) {
        this(initialCapacity, loadFactor, keyHashFunction, new ObjectHashFunction());
    }

    public ByteObjectOpenHashMap(int initialCapacity, float loadFactor, ByteHashFunction keyHashFunction, ObjectHashFunction<? super VType> valueHashFunction) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.valueHashFunction = valueHashFunction;
        this.keyHashFunction = keyHashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ByteObjectOpenHashMap(ByteObjectAssociativeContainer<VType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public VType put(byte key, VType value) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        VType oldValue = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = value;
        this.states[slot] = 2;
        return oldValue;
    }

    @Override
    public final int putAll(ByteObjectAssociativeContainer<VType> container) {
        int count = this.assigned;
        for (ByteObjectCursor<VType> c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(byte key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndRehash() {
        byte[] oldKeys = this.keys;
        VType[] oldValues = this.values;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.values.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.values[slot] = oldValues[i];
            this.states[slot] = 2;
            oldValues[i] = null;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new byte[capacity];
        this.values = (Object[])Intrinsics.newVTypeArray(capacity);
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public VType remove(byte key) {
        int slot = this.slotFor(key);
        VType value = this.values[slot];
        byte state = this.states[slot];
        if (state == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = 0;
            this.values[slot] = Intrinsics.defaultVTypeValue();
            this.states[slot] = 1;
        } else assert (Intrinsics.defaultVTypeValue() == value) : "Default value expected.";
        return value;
    }

    @Override
    public final int removeAll(ByteContainer container) {
        int before = this.deleted;
        for (ByteCursor cursor : container) {
            this.remove(cursor.value);
        }
        return this.deleted - before;
    }

    @Override
    public final int removeAll(BytePredicate predicate) {
        int before = this.deleted;
        byte[] keys = this.keys;
        VType[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2 || !predicate.apply(keys[i])) continue;
            ++this.deleted;
            --this.assigned;
            keys[i] = 0;
            values[i] = Intrinsics.defaultVTypeValue();
            states[i] = 1;
        }
        return this.deleted - before;
    }

    @Override
    public VType get(byte key) {
        return this.values[this.slotFor(key)];
    }

    public VType lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public VType lset(VType key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        VType previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(byte key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(byte key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.keyHashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keys[slot] == key) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ByteObjectCursor<VType> c : this) {
            h += this.keyHashFunction.hash(c.key) + this.valueHashFunction.hash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ByteObjectMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ByteObjectMap && (other = (ByteObjectMap)obj).size() == this.size()) {
                for (ByteObjectCursor<VType> c : this) {
                    Object v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ByteObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ByteObjectProcedure<VType>> T forEach(T procedure) {
        byte[] keys = this.keys;
        VType[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeySet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySet();
        }
        return this.keySetView;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> ByteObjectOpenHashMap<VType> from(byte[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteObjectOpenHashMap<VType> map = new ByteObjectOpenHashMap<VType>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <VType> ByteObjectOpenHashMap<VType> from(ByteObjectAssociativeContainer<VType> container) {
        return new ByteObjectOpenHashMap<VType>(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySetIterator
    implements Iterator<ByteCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ByteCursor cursor = new ByteCursor();
        private int nextIndex = -1;

        public KeySetIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ByteObjectOpenHashMap.this.keys.length && ByteObjectOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ByteObjectOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ByteCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = ByteObjectOpenHashMap.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeySet
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteObjectOpenHashMap<VType> owner;

        public KeySet() {
            this.owner = ByteObjectOpenHashMap.this;
        }

        @Override
        public boolean contains(byte e) {
            return ByteObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            byte[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length; ++i) {
                if (localStates[i] != 2) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            byte[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length && (localStates[i] != 2 || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<ByteObjectCursor<VType>> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ByteObjectCursor<VType> cursor = new ByteObjectCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ByteObjectOpenHashMap.this.keys.length && ByteObjectOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ByteObjectOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ByteObjectCursor<VType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.key = ByteObjectOpenHashMap.this.keys[this.nextIndex];
            this.cursor.value = ByteObjectOpenHashMap.this.values[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

