/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "StdAppManager.h"

StdAppManager::StdAppManager(const char* kw): MvService(kw)
{
}

void StdAppManager::serve(MvRequest& in,MvRequest& out)
{
	cout << "StdAppManager::serve in" << endl;
	in.print();

	// Get prefix
	string verb = in.getVerb();
	size_t found = verb.find('_');
	if (found == string::npos)
	{
		cout << "ERROR StdAppManager: prefix not found" << endl;
		return;
	}
	string prefix = verb.substr(0,found+1);

    // Build the application verb
    string plotType = prefix + "PLOT_TYPE";
    const char* type = in(plotType.c_str());
    prefix += type;


    // special case - INPUT_XY_AREA only exists in Metview - 
    // Magics should see it as INPUT_XY_POINTS

    if (prefix == "INPUT_XY_AREA")
       prefix = "INPUT_XY_POINTS";


    // Create output request
    out = in;
    out.setVerb(prefix.c_str());
    out.unsetParam(plotType.c_str());
    out("_VERB")  = prefix.c_str();
    out("_CLASS") = prefix.c_str();


    // another special case - Magics does not like having the default
    // value of NETCDF_POSITION_TYPE sent to it
    const char *netcdfPosType = in("NETCDF_POSITION_TYPE");
    if (netcdfPosType && !strcmp(netcdfPosType, "ARRAY"))
    {
        out.unsetParam("NETCDF_POSITION_TYPE");
    }

     cout << "StdAppManager::serve out" << endl;
     out.print();
}

//--------------------------------------------------------

int main(int argc,char **argv)
{
	MvApplication theApp(argc,argv);

     StdAppManager input("INPUT_VISUALISER");
     StdAppManager table("TABLE_VISUALISER");
     StdAppManager netcd("NETCDF_VISUALISER");

	theApp.run();
}
