/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQDragDrop_H
#define MvQDragDrop_H

#include <QStringList>

class QDropEvent;

#include <iostream>
//#include <QtGui/QApplication>
//#include <QWidget>

//#include <QStandardItemModel>
//#include <QPixmap>
//#include <QPalette>

//#include "Highlighter.h"

using namespace std;

class MvQIconDropItem
{
public:

	MvQIconDropItem() { };
	~MvQIconDropItem() { };
	
	void name(string s) {name_=s;};
	void className(string s) {class_=s;};
	void appendToFullName(string);
	void fullNameLen(int i) {fullNameLen_=i;};
	void finalizeFullName();
	void x(int i) {x_=i;};
	void y(int i) {y_=i;};
	void winId(int i) {winId_=i;};
	void count(int i) {count_=i;};
	void format(int i) {format_=i;};
	void iconId(int i) {iconId_=i;};
	void batchNumber(int i) {batchNum_=i;};
//	void totalNumber(int i) {totalNum_=i;};

	string name() {return name_;};
	string className() {return class_;};
	string fullName() {return fullName_;};
	int x() {return x_;};
	int y() {return y_;};
	int winId() {return winId_;};
	int count() {return count_;};
	int format() {return format_;};
	int iconId() {return iconId_;};
	int batchNumber() {return batchNum_;};
//	int totalNumber() {return totalNum_;};

	void clear();

protected:
	string name_;
	string class_;
	string fullName_;
	int fullNameLen_;
	int x_;
	int y_;
	int winId_;
	int count_;
//	int totalNum_;
	int batchNum_;
	int format_;
	int iconId_;
};

class QDropEvent;

class MvQDrop 
{
public:
	MvQDrop(QDropEvent*);
	bool hasData() const {return hasData_;}
	int iconNum() const {return (hasData_)?iconPath_.count():0;}
	QString iconPath(int) const;
	QString iconClass(int) const;

protected:
	bool hasData_;
	QStringList iconPath_;
	QStringList iconClass_;
};


#endif
