<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.devhelp.net/book"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!--
  Copyright (C) 2012 Canonical Ltd. - All Rights Reserved
  Contact: Jim Hodapp <jim.hodapp@canonical.com>
  -->

  <xsl:output method="text" version="1.0" indent="no" encoding="UTF-8"/>

  <xsl:template match="schema">
/**
@page gsettings-schema GSettings Schema

These settings may be used to control the mediascanner-service.
This list is also available on the command-line via:
&lt;pre&gt;gsettings list-keys com.canonical.mediascanner&lt;/pre&gt;

@note Although it might seem natural to use Grilo's configuration 
infrastructure to share settings between the scanner and the media 
store plugin, GrlConfig is based on plain key-value files, doesn't 
provide any change notifications and does not yet store settings 
between sessions. As of this writing, integration of GrlConfig with 
GSettings or DConf is not planned until a later version of Grilo.
Therefore, we use GSettings to maintain settings. 

    <xsl:apply-templates select="key" />
*/
  </xsl:template>

  <xsl:template match="key">
- @anchor gsettings-schema-<xsl:value-of select="@name"/> &lt;b&gt;<xsl:value-of select="@name"/>&lt;/b&gt;
  - Type: <xsl:value-of select="@type"/>
  - Summary: <xsl:apply-templates select="summary" />
  - Description: <xsl:apply-templates select="description" />
  - Default: <xsl:apply-templates select="default" />
&#10;
</xsl:template>

</xsl:stylesheet>

