C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RHQ (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=11)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4HQ                                          
        DATA  DrI, FlI, AlI /   2.,   5.,  .2020 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.600,    5.000,  180.000 /
C        DATA  NX,  NT, NfMx /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000E+01, .100000E+05,
     +  .160000E+01, .203369E+01, .265779E+01, .358285E+01, .500000E+01,
     +  .794903E+01, .135129E+02, .248012E+02, .496935E+02, .110086E+03,
     +  .273574E+03, .775412E+03, .255482E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
C
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .282157E+06, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .118376E+06,
     +  .898527E+05, .670670E+05, .500192E+05, .372830E+05,
     +  .277641E+05, .206623E+05, .153618E+05, .114130E+05,
     +  .847030E+04, .628149E+04, .465297E+04, .344375E+04 /
        DATA (UPDI(I),I=469,520) /
     +  .254564E+04, .188003E+04, .138660E+04, .102165E+04,
     +  .751666E+03, .552423E+03, .405361E+03, .297100E+03,
     +  .217392E+03, .158864E+03, .115890E+03, .844203E+02,
     +  .613906E+02, .445952E+02, .321842E+02, .233045E+02,
     +  .168435E+02, .121618E+02, .876738E+01, .631564E+01,
     +  .454896E+01, .327418E+01, .235613E+01, .169760E+01,
     +  .122403E+01, .884732E+00, .640681E+00, .465886E+00,
     +  .339826E+00, .249028E+00, .183220E+00, .135546E+00,
     +  .100699E+00, .753167E-01, .564358E-01, .426055E-01,
     +  .322037E-01, .244710E-01, .186341E-01, .142356E-01,
     +  .108871E-01, .834267E-02, .638942E-02, .489426E-02,
     +  .374166E-02, .285797E-02, .217487E-02, .165073E-02,
     +  .124619E-02, .936250E-03, .699524E-03, .517849E-03 /
        DATA (UPDI(I),I=521,572) /
     +  .379194E-03, .274634E-03, .195933E-03, .137531E-03,
     +  .943300E-04, .629872E-04, .403978E-04, .245143E-04,
     +  .135390E-04, .633777E-05, .169141E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .264751E+06, .200496E+06,
     +  .149248E+06, .111007E+06, .825121E+05, .612734E+05,
     +  .454697E+05, .337079E+05, .249694E+05, .184762E+05,
     +  .136601E+05, .100876E+05, .744257E+04, .548416E+04,
     +  .403705E+04, .296773E+04, .217928E+04, .159793E+04,
     +  .117028E+04, .855712E+03, .624906E+03, .455575E+03,
     +  .331668E+03, .241024E+03, .174887E+03, .126669E+03 /
        DATA (UPDI(I),I=573,624) /
     +  .916346E+02, .658519E+02, .474774E+02, .341649E+02,
     +  .245568E+02, .176216E+02, .126334E+02, .905569E+01,
     +  .648531E+01, .464324E+01, .332785E+01, .238677E+01,
     +  .171568E+01, .123554E+01, .893313E+00, .647844E+00,
     +  .471928E+00, .345150E+00, .253774E+00, .187371E+00,
     +  .139256E+00, .103686E+00, .777650E-01, .583952E-01,
     +  .440767E-01, .333401E-01, .252968E-01, .192153E-01,
     +  .146225E-01, .111223E-01, .846090E-02, .642480E-02,
     +  .487442E-02, .368552E-02, .277994E-02, .208668E-02,
     +  .155967E-02, .116033E-02, .856363E-03, .626342E-03,
     +  .454270E-03, .325766E-03, .231064E-03, .161443E-03,
     +  .111146E-03, .749663E-04, .494191E-04, .316150E-04,
     +  .196565E-04, .116091E-04, .644830E-05, .323403E-05 /
        DATA (UPDI(I),I=625,676) /
     +  .135546E-05, .324301E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .444056E+06, .335477E+06, .249022E+06,
     +  .184691E+06, .136884E+06, .101353E+06, .749883E+05,
     +  .554242E+05, .409305E+05, .301933E+05, .222528E+05,
     +  .163808E+05, .120465E+05, .884764E+04, .649124E+04,
     +  .475577E+04, .348023E+04, .254294E+04, .185573E+04,
     +  .135202E+04, .983697E+03, .714459E+03, .518144E+03,
     +  .375070E+03, .271067E+03, .195530E+03, .140858E+03,
     +  .100790E+03, .723498E+02, .518331E+02, .370857E+02,
     +  .264889E+02, .188996E+02, .134816E+02, .960637E+01,
     +  .684277E+01, .487838E+01, .348021E+01, .248791E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .178174E+01, .128086E+01, .923559E+00, .668799E+00,
     +  .486236E+00, .355331E+00, .260752E+00, .192580E+00,
     +  .142494E+00, .106183E+00, .792220E-01, .594035E-01,
     +  .446401E-01, .336441E-01, .253858E-01, .191865E-01,
     +  .144951E-01, .109511E-01, .825963E-02, .622353E-02,
     +  .467409E-02, .350198E-02, .261168E-02, .193974E-02,
     +  .143445E-02, .105273E-02, .766239E-03, .553550E-03,
     +  .395973E-03, .280673E-03, .196535E-03, .136115E-03,
     +  .928978E-04, .624767E-04, .413098E-04, .270228E-04,
     +  .173121E-04, .109410E-04, .680829E-05, .420557E-05,
     +  .257802E-05, .159282E-05, .989924E-06, .624050E-06,
     +  .393101E-06, .243779E-06, .142633E-06, .749838E-07,
     +  .321557E-07, .885524E-08, .609208E-09, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .661801E+06, .498735E+06, .369119E+06, .272953E+06,
     +  .201691E+06, .148886E+06, .109817E+06, .809141E+05,
     +  .595657E+05, .438000E+05, .321762E+05, .236082E+05,
     +  .173037E+05, .126660E+05, .926075E+04, .676130E+04,
     +  .493036E+04, .358965E+04, .261002E+04, .189454E+04,
     +  .137322E+04, .993559E+03, .717738E+03, .517491E+03,
     +  .372481E+03, .267571E+03, .191939E+03, .136742E+03,
     +  .977240E+02, .696989E+02, .496385E+02, .352893E+02,
     +  .250571E+02, .177868E+02, .126100E+02, .893641E+01,
     +  .633735E+01, .449693E+01, .319709E+01, .227696E+01,
     +  .162755E+01, .116680E+01, .839982E+00, .607091E+00,
     +  .440968E+00, .321631E+00, .236074E+00, .173593E+00,
     +  .128534E+00, .952892E-01, .709884E-01, .530024E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .396837E-01, .297467E-01, .223319E-01, .167592E-01,
     +  .125764E-01, .942225E-02, .705150E-02, .526076E-02,
     +  .391518E-02, .290086E-02, .214062E-02, .157314E-02,
     +  .114756E-02, .830692E-03, .597161E-03, .425479E-03,
     +  .300730E-03, .210367E-03, .145875E-03, .100021E-03,
     +  .678860E-04, .455965E-04, .305301E-04, .202464E-04,
     +  .134151E-04, .888806E-05, .592803E-05, .397337E-05,
     +  .268891E-05, .181848E-05, .121955E-05, .796326E-06,
     +  .495836E-06, .284095E-06, .142875E-06, .575184E-07,
     +  .148008E-07, .106007E-08, .000000E+00, .923837E+06,
     +  .694419E+06, .512386E+06, .377738E+06, .278253E+06,
     +  .204761E+06, .150551E+06, .110573E+06, .811347E+05,
     +  .594647E+05, .435384E+05, .318375E+05, .232556E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .169640E+05, .123597E+05, .899190E+04, .653325E+04,
     +  .473932E+04, .343312E+04, .248265E+04, .179259E+04,
     +  .129195E+04, .929589E+03, .667542E+03, .478514E+03,
     +  .342299E+03, .244493E+03, .173417E+03, .123383E+03,
     +  .876030E+02, .621003E+02, .439414E+02, .310496E+02,
     +  .219328E+02, .154708E+02, .109076E+02, .769445E+01,
     +  .543084E+01, .383993E+01, .271969E+01, .193300E+01,
     +  .137787E+01, .986143E+00, .708552E+00, .511582E+00,
     +  .370889E+00, .270562E+00, .197732E+00, .145489E+00,
     +  .107181E+00, .793381E-01, .588605E-01, .437845E-01,
     +  .326089E-01, .243196E-01, .181316E-01, .135164E-01,
     +  .100603E-01, .747902E-02, .554332E-02, .409838E-02,
     +  .301718E-02, .221228E-02, .161578E-02, .117159E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .843398E-03, .603227E-03, .427974E-03, .301486E-03,
     +  .210510E-03, .145963E-03, .100335E-03, .685007E-04,
     +  .464871E-04, .315963E-04, .214022E-04, .145657E-04,
     +  .996415E-05, .687636E-05, .476810E-05, .331903E-05,
     +  .229176E-05, .155204E-05, .101352E-05, .624635E-06,
     +  .351344E-06, .171943E-06, .667207E-07, .164854E-07,
     +  .120628E-08, .000000E+00, .123627E+07, .926821E+06,
     +  .681736E+06, .501010E+06, .367887E+06, .269855E+06,
     +  .197767E+06, .144776E+06, .105879E+06, .773406E+05,
     +  .564342E+05, .411262E+05, .299360E+05, .217604E+05,
     +  .157977E+05, .114516E+05, .828992E+04, .599136E+04,
     +  .432373E+04, .311477E+04, .224028E+04, .160825E+04,
     +  .115254E+04, .824283E+03, .588426E+03, .419143E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .298091E+03, .210496E+03, .149096E+03, .105380E+03,
     +  .743554E+02, .523651E+02, .368229E+02, .258836E+02,
     +  .181654E+02, .127419E+02, .894119E+01, .627728E+01,
     +  .441426E+01, .310929E+01, .219747E+01, .155750E+01,
     +  .110825E+01, .791653E+00, .568190E+00, .409471E+00,
     +  .296901E+00, .215662E+00, .157699E+00, .115456E+00,
     +  .849260E-01, .626118E-01, .462785E-01, .342475E-01,
     +  .253769E-01, .187985E-01, .139228E-01, .102964E-01,
     +  .760492E-02, .560068E-02, .411426E-02, .300998E-02,
     +  .219330E-02, .159231E-02, .114785E-02, .821864E-03,
     +  .584938E-03, .413279E-03, .290183E-03, .202234E-03,
     +  .140181E-03, .965487E-04, .662309E-04, .453170E-04,
     +  .311568E-04, .214326E-04, .148540E-04, .103664E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .729234E-05, .514240E-05, .362073E-05, .251486E-05,
     +  .170123E-05, .110330E-05, .671145E-06, .370670E-06,
     +  .177027E-06, .665489E-07, .158852E-07, .118311E-08,
     +  .000000E+00, .160533E+07, .120029E+07, .880086E+06,
     +  .644713E+06, .471875E+06, .345005E+06, .252007E+06,
     +  .183868E+06, .134015E+06, .975602E+05, .709426E+05,
     +  .515194E+05, .373689E+05, .270666E+05, .195789E+05,
     +  .141408E+05, .101987E+05, .734325E+04, .527916E+04,
     +  .378841E+04, .271412E+04, .194069E+04, .138517E+04,
     +  .986602E+03, .701368E+03, .497471E+03, .352267E+03,
     +  .247647E+03, .174625E+03, .122865E+03, .862896E+02,
     +  .604837E+02, .423264E+02, .296066E+02, .206738E+02,
     +  .144275E+02, .100710E+02, .703313E+01, .491903E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .344590E+01, .242177E+01, .170681E+01, .120752E+01,
     +  .857593E+00, .611902E+00, .438368E+00, .315955E+00,
     +  .228121E+00, .165792E+00, .120638E+00, .881888E-01,
     +  .646164E-01, .474616E-01, .349039E-01, .256996E-01,
     +  .189179E-01, .139226E-01, .102316E-01, .750926E-02,
     +  .549582E-02, .401211E-02, .291747E-02, .211313E-02,
     +  .152523E-02, .109336E-02, .778840E-03, .551747E-03,
     +  .388324E-03, .271849E-03, .189148E-03, .131094E-03,
     +  .904669E-04, .623346E-04, .429599E-04, .298221E-04,
     +  .207662E-04, .145862E-04, .103184E-04, .734359E-05,
     +  .522426E-05, .369336E-05, .256452E-05, .172535E-05,
     +  .110814E-05, .664570E-06, .360371E-06, .168120E-06,
     +  .613534E-07, .141899E-07, .107417E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .203727E+07, .151914E+07, .111029E+07, .810715E+06,
     +  .591429E+06, .430989E+06, .313761E+06, .228154E+06,
     +  .165726E+06, .120230E+06, .871228E+05, .630473E+05,
     +  .455676E+05, .328863E+05, .237019E+05, .170556E+05,
     +  .122549E+05, .879052E+04, .629540E+04, .450018E+04,
     +  .321137E+04, .228708E+04, .162580E+04, .115324E+04,
     +  .816407E+03, .576601E+03, .406534E+03, .284526E+03,
     +  .199733E+03, .139895E+03, .977943E+02, .682256E+02,
     +  .475144E+02, .330737E+02, .229793E+02, .159551E+02,
     +  .110795E+02, .769675E+01, .535428E+01, .373046E+01,
     +  .260726E+01, .182727E+01, .128541E+01, .907692E+00,
     +  .643888E+00, .458588E+00, .328579E+00, .235826E+00,
     +  .170361E+00, .123215E+00, .895242E-01, .651969E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .475938E-01, .347867E-01, .254546E-01, .186222E-01,
     +  .136201E-01, .994798E-02, .725614E-02, .527842E-02,
     +  .383015E-02, .276883E-02, .199388E-02, .143119E-02,
     +  .102050E-02, .723444E-03, .510303E-03, .357903E-03,
     +  .249908E-03, .173667E-03, .120392E-03, .832638E-04,
     +  .576238E-04, .399783E-04, .279865E-04, .196833E-04,
     +  .139669E-04, .997336E-05, .714807E-05, .510593E-05,
     +  .360957E-05, .249717E-05, .166699E-05, .105876E-05,
     +  .625578E-06, .333031E-06, .151835E-06, .538544E-07,
     +  .120923E-07, .929674E-09, .000000E+00, .253821E+07,
     +  .188753E+07, .137505E+07, .100076E+07, .727658E+06,
     +  .528496E+06, .383451E+06, .277882E+06, .201154E+06,
     +  .145427E+06, .105011E+06, .757238E+05, .545334E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .392147E+05, .281593E+05, .201882E+05, .144514E+05,
     +  .103268E+05, .736717E+04, .524586E+04, .372872E+04,
     +  .264494E+04, .187256E+04, .132282E+04, .932549E+03,
     +  .655824E+03, .460394E+03, .320791E+03, .224188E+03,
     +  .156314E+03, .108768E+03, .755265E+02, .523473E+02,
     +  .362613E+02, .250688E+02, .173182E+02, .119642E+02,
     +  .826799E+01, .572109E+01, .396460E+01, .275572E+01,
     +  .192064E+01, .134350E+01, .943354E+00, .665349E+00,
     +  .471136E+00, .335606E+00, .239457E+00, .171959E+00,
     +  .123632E+00, .892896E-01, .646381E-01, .469015E-01,
     +  .340746E-01, .247822E-01, .180210E-01, .131008E-01,
     +  .951144E-02, .689615E-02, .498704E-02, .359759E-02,
     +  .258602E-02, .185190E-02, .132228E-02, .938124E-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .662064E-03, .465178E-03, .325251E-03, .226627E-03,
     +  .157365E-03, .109161E-03, .756842E-04, .526100E-04,
     +  .367272E-04, .259015E-04, .183668E-04, .131334E-04,
     +  .943784E-05, .679008E-05, .485475E-05, .342286E-05,
     +  .235436E-05, .155724E-05, .977160E-06, .568599E-06,
     +  .297142E-06, .132431E-06, .456919E-07, .997579E-08,
     +  .778546E-09, .000000E+00, .855473E+05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .402001E+05, .309421E+05, .234756E+05,
     +  .178003E+05, .134942E+05, .102230E+05, .774286E+04,
     +  .586016E+04, .443392E+04, .335216E+04, .253344E+04,
     +  .191303E+04, .144397E+04, .108890E+04, .820761E+03,
     +  .618009E+03, .465104E+03, .349629E+03, .262670E+03,
     +  .197094E+03, .147797E+03, .110683E+03, .828302E+02,
     +  .618987E+02, .462196E+02, .344660E+02, .256892E+02,
     +  .190381E+02, .141604E+02, .105166E+02, .780884E+01,
     +  .579119E+01, .429522E+01, .318611E+01, .236399E+01,
     +  .175413E+01, .130437E+01, .970849E+00, .725021E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .542528E+00, .407999E+00, .307796E+00, .233472E+00,
     +  .177796E+00, .136256E+00, .104850E+00, .812770E-01,
     +  .631219E-01, .494172E-01, .387336E-01, .305365E-01,
     +  .241175E-01, .191208E-01, .151720E-01, .120692E-01,
     +  .959294E-02, .762917E-02, .605443E-02, .480334E-02,
     +  .379624E-02, .299447E-02, .235003E-02, .183707E-02,
     +  .142943E-02, .110377E-02, .844358E-03, .640448E-03,
     +  .480170E-03, .355996E-03, .259777E-03, .186598E-03,
     +  .131014E-03, .898151E-04, .592300E-04, .376481E-04,
     +  .222670E-04, .118517E-04, .503161E-05, .847145E-06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .901968E+05, .692809E+05, .524364E+05, .396634E+05,
     +  .299930E+05, .226648E+05, .171213E+05, .129240E+05,
     +  .975195E+04, .735250E+04, .554099E+04, .417213E+04,
     +  .313988E+04, .236075E+04, .177397E+04, .133163E+04,
     +  .998970E+03, .748542E+03, .560506E+03, .419175E+03,
     +  .313251E+03, .233777E+03, .174323E+03, .129802E+03,
     +  .965624E+02, .717359E+02, .532604E+02, .393140E+02,
     +  .291223E+02, .215403E+02, .159260E+02, .117605E+02,
     +  .868347E+01, .641241E+01, .473541E+01, .349723E+01,
     +  .258767E+01, .191653E+01, .142383E+01, .105996E+01,
     +  .792823E+00, .594898E+00, .448714E+00, .339813E+00,
     +  .258904E+00, .198083E+00, .152629E+00, .117837E+00,
     +  .916833E-01, .714256E-01, .559556E-01, .439216E-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .346005E-01, .272841E-01, .215652E-01, .170336E-01,
     +  .134611E-01, .106176E-01, .837180E-02, .657795E-02,
     +  .515912E-02, .402732E-02, .313278E-02, .242690E-02,
     +  .186712E-02, .142470E-02, .107946E-02, .810082E-03,
     +  .602731E-03, .443083E-03, .322251E-03, .230934E-03,
     +  .163202E-03, .112967E-03, .772135E-04, .513690E-04,
     +  .334145E-04, .210611E-04, .128624E-04, .751841E-05,
     +  .419786E-05, .219752E-05, .106284E-05, .455899E-06,
     +  .164740E-06, .407653E-07, .122705E-08, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .151600E+06,
     +  .116197E+06, .877274E+05, .661918E+05, .499248E+05,
     +  .376287E+05, .283494E+05, .213421E+05, .160594E+05,
     +  .120743E+05, .907337E+04, .681214E+04, .511151E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .383166E+04, .287043E+04, .214802E+04, .160629E+04,
     +  .119976E+04, .895412E+03, .667413E+03, .497055E+03,
     +  .369672E+03, .274679E+03, .203796E+03, .151051E+03,
     +  .111796E+03, .826843E+02, .607929E+02, .448522E+02,
     +  .330410E+02, .243265E+02, .178880E+02, .131496E+02,
     +  .966769E+01, .710639E+01, .522398E+01, .384663E+01,
     +  .283519E+01, .209571E+01, .155228E+01, .115498E+01,
     +  .862116E+00, .646739E+00, .487141E+00, .369076E+00,
     +  .280807E+00, .215127E+00, .165146E+00, .127734E+00,
     +  .989303E-01, .770374E-01, .601126E-01, .470674E-01,
     +  .368926E-01, .289797E-01, .227514E-01, .178688E-01,
     +  .140093E-01, .109781E-01, .857436E-02, .668437E-02,
     +  .518759E-02, .401203E-02, .309063E-02, .236480E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .179545E-02, .135416E-02, .101232E-02, .750865E-03,
     +  .550981E-03, .400581E-03, .287650E-03, .204237E-03,
     +  .142714E-03, .989521E-04, .673404E-04, .452843E-04,
     +  .299583E-04, .195980E-04, .126198E-04, .806237E-05,
     +  .507787E-05, .316002E-05, .192262E-05, .113455E-05,
     +  .628747E-06, .315343E-06, .131871E-06, .367042E-07,
     +  .244083E-08, .000000E+00, .237303E+06, .173051E+06,
     +  .130319E+06, .980744E+05, .737773E+05, .554587E+05,
     +  .416690E+05, .312832E+05, .234738E+05, .175988E+05,
     +  .131865E+05, .987126E+04, .738476E+04, .551900E+04,
     +  .412170E+04, .307476E+04, .229195E+04, .170638E+04,
     +  .126932E+04, .942960E+03, .699870E+03, .518716E+03,
     +  .384060E+03, .283933E+03, .209676E+03, .154609E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .113911E+03, .834240E+02, .613039E+02, .449793E+02,
     +  .329784E+02, .241484E+02, .176746E+02, .129378E+02,
     +  .946687E+01, .692739E+01, .507667E+01, .372399E+01,
     +  .273908E+01, .201880E+01, .149440E+01, .110977E+01,
     +  .828117E+00, .620481E+00, .467541E+00, .353800E+00,
     +  .269539E+00, .205775E+00, .158250E+00, .121873E+00,
     +  .943516E-01, .732022E-01, .569796E-01, .444028E-01,
     +  .346709E-01, .270595E-01, .211253E-01, .164652E-01,
     +  .128251E-01, .995821E-02, .771697E-02, .595422E-02,
     +  .457808E-02, .350647E-02, .266767E-02, .201444E-02,
     +  .151139E-02, .112443E-02, .830318E-03, .607021E-03,
     +  .440005E-03, .315411E-03, .223864E-03, .156755E-03,
     +  .109146E-03, .748805E-04, .509723E-04, .343245E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .229856E-04, .152522E-04, .100923E-04, .660971E-05,
     +  .427744E-05, .269955E-05, .163953E-05, .926837E-06,
     +  .468328E-06, .194391E-06, .529074E-07, .362457E-08,
     +  .000000E+00, .339454E+06, .258899E+06, .194344E+06,
     +  .145790E+06, .109311E+06, .818986E+05, .613263E+05,
     +  .458847E+05, .343102E+05, .256331E+05, .191375E+05,
     +  .142745E+05, .106393E+05, .792180E+04, .589358E+04,
     +  .437975E+04, .325187E+04, .241149E+04, .178654E+04,
     +  .132180E+04, .976932E+03, .721015E+03, .531527E+03,
     +  .391243E+03, .287625E+03, .211124E+03, .154824E+03,
     +  .112845E+03, .825209E+02, .602514E+02, .439520E+02,
     +  .320203E+02, .233122E+02, .169744E+02, .123520E+02,
     +  .898872E+01, .654937E+01, .477673E+01, .349241E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .255875E+01, .188240E+01, .138934E+01, .103015E+01,
     +  .767009E+00, .574187E+00, .431704E+00, .326707E+00,
     +  .247782E+00, .189261E+00, .144778E+00, .111311E+00,
     +  .857752E-01, .662987E-01, .513089E-01, .397772E-01,
     +  .308266E-01, .238919E-01, .184884E-01, .142938E-01,
     +  .110168E-01, .847152E-02, .648608E-02, .494644E-02,
     +  .375701E-02, .283261E-02, .211899E-02, .157359E-02,
     +  .115779E-02, .844291E-03, .608610E-03, .433934E-03,
     +  .305071E-03, .211472E-03, .143897E-03, .966975E-04,
     +  .634425E-04, .408071E-04, .255846E-04, .156596E-04,
     +  .929567E-05, .537331E-05, .300450E-05, .163189E-05,
     +  .855834E-06, .436469E-06, .212059E-06, .969374E-07,
     +  .385912E-07, .106602E-07, .656048E-09, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .480749E+06, .365628E+06, .273554E+06, .204527E+06,
     +  .152832E+06, .114114E+06, .851523E+05, .634881E+05,
     +  .473035E+05, .352131E+05, .261935E+05, .194653E+05,
     +  .144535E+05, .107209E+05, .794509E+04, .588124E+04,
     +  .434928E+04, .321233E+04, .237008E+04, .174628E+04,
     +  .128520E+04, .944483E+03, .693226E+03, .508016E+03,
     +  .371788E+03, .271653E+03, .198279E+03, .143824E+03,
     +  .104664E+03, .760450E+02, .551931E+02, .400052E+02,
     +  .289727E+02, .209847E+02, .151867E+02, .109907E+02,
     +  .796255E+01, .577430E+01, .419692E+01, .305680E+01,
     +  .223516E+01, .163968E+01, .120818E+01, .893977E+00,
     +  .664958E+00, .496766E+00, .373497E+00, .281430E+00,
     +  .213530E+00, .162260E+00, .123906E+00, .948420E-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .728038E-01, .559601E-01, .430805E-01, .331566E-01,
     +  .255175E-01, .196097E-01, .150534E-01, .115216E-01,
     +  .879701E-02, .668857E-02, .506499E-02, .382040E-02,
     +  .286029E-02, .212530E-02, .156786E-02, .114639E-02,
     +  .831009E-03, .595898E-03, .422939E-03, .296368E-03,
     +  .205049E-03, .139653E-03, .941990E-04, .623441E-04,
     +  .406953E-04, .261311E-04, .165658E-04, .103458E-04,
     +  .640429E-05, .391661E-05, .236844E-05, .140383E-05,
     +  .807007E-06, .435454E-06, .211718E-06, .845460E-07,
     +  .220567E-07, .151507E-08, .000000E+00, .655082E+06,
     +  .496780E+06, .370422E+06, .276008E+06, .205532E+06,
     +  .152928E+06, .113711E+06, .844780E+05, .627141E+05,
     +  .465138E+05, .344708E+05, .255201E+05, .188771E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .139480E+05, .102962E+05, .759146E+04, .559141E+04,
     +  .411297E+04, .302202E+04, .221733E+04, .162493E+04,
     +  .118900E+04, .868869E+03, .633905E+03, .461821E+03,
     +  .335884E+03, .244010E+03, .176143E+03, .127561E+03,
     +  .922266E+02, .666005E+02, .480277E+02, .346009E+02,
     +  .249290E+02, .179432E+02, .129144E+02, .930343E+01,
     +  .670839E+01, .484743E+01, .350994E+01, .255110E+01,
     +  .186018E+01, .136222E+01, .100175E+01, .740433E+00,
     +  .549668E+00, .410626E+00, .307423E+00, .231725E+00,
     +  .174937E+00, .132700E+00, .100903E+00, .769361E-01,
     +  .587410E-01, .449129E-01, .343331E-01, .262419E-01,
     +  .200294E-01, .152695E-01, .116073E-01, .880126E-02,
     +  .664634E-02, .499848E-02, .374466E-02, .278451E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .205539E-02, .150652E-02, .109483E-02, .789038E-03,
     +  .562889E-03, .397722E-03, .277772E-03, .191805E-03,
     +  .130691E-03, .884126E-04, .589238E-04, .389110E-04,
     +  .254381E-04, .165301E-04, .106663E-04, .686528E-05,
     +  .438724E-05, .277184E-05, .171071E-05, .101400E-05,
     +  .557976E-06, .272438E-06, .107546E-06, .273989E-07,
     +  .193802E-08, .000000E+00, .867955E+06, .656287E+06,
     +  .487674E+06, .362114E+06, .268704E+06, .199222E+06,
     +  .147601E+06, .109257E+06, .808107E+05, .597130E+05,
     +  .440858E+05, .325142E+05, .239578E+05, .176330E+05,
     +  .129649E+05, .952088E+04, .698404E+04, .511630E+04,
     +  .374355E+04, .273516E+04, .199583E+04, .145407E+04,
     +  .105789E+04, .768362E+03, .557236E+03, .403407E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .291685E+03, .209542E+03, .151012E+03, .108645E+03,
     +  .780624E+02, .560068E+02, .401390E+02, .287669E+02,
     +  .205936E+02, .147410E+02, .105598E+02, .757134E+01,
     +  .543941E+01, .391568E+01, .282910E+01, .205057E+01,
     +  .149251E+01, .109088E+01, .801299E+00, .591148E+00,
     +  .438827E+00, .326456E+00, .244487E+00, .183383E+00,
     +  .138198E+00, .104402E+00, .790791E-01, .599802E-01,
     +  .455537E-01, .345916E-01, .262621E-01, .199114E-01,
     +  .150770E-01, .113846E-01, .857419E-02, .643189E-02,
     +  .480485E-02, .357581E-02, .264141E-02, .193733E-02,
     +  .141117E-02, .101951E-02, .730689E-03, .518711E-03,
     +  .364965E-03, .254105E-03, .175163E-03, .119407E-03,
     +  .809976E-04, .543132E-04, .362176E-04, .240173E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .158951E-04, .104874E-04, .691258E-05, .452338E-05,
     +  .291540E-05, .182610E-05, .108980E-05, .599150E-06,
     +  .289502E-06, .111934E-06, .277499E-07, .200267E-08,
     +  .000000E+00, .112521E+07, .848296E+06, .628153E+06,
     +  .464785E+06, .343663E+06, .253884E+06, .187415E+06,
     +  .138219E+06, .101852E+06, .749786E+05, .551458E+05,
     +  .405151E+05, .297370E+05, .218005E+05, .159652E+05,
     +  .116770E+05, .853068E+04, .622353E+04, .453463E+04,
     +  .329912E+04, .239700E+04, .173874E+04, .125940E+04,
     +  .910632E+03, .657410E+03, .473724E+03, .340917E+03,
     +  .243726E+03, .174796E+03, .125139E+03, .894627E+02,
     +  .638602E+02, .455299E+02, .324594E+02, .231120E+02,
     +  .164537E+02, .117212E+02, .835687E+01, .596938E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .427240E+01, .306868E+01, .221106E+01, .159964E+01,
     +  .116212E+01, .848395E+00, .622038E+00, .458884E+00,
     +  .339242E+00, .252452E+00, .188154E+00, .140884E+00,
     +  .105751E+00, .795815E-01, .599708E-01, .452480E-01,
     +  .341353E-01, .257454E-01, .193922E-01, .145869E-01,
     +  .109426E-01, .818714E-02, .610175E-02, .452856E-02,
     +  .334855E-02, .245775E-02, .179154E-02, .129719E-02,
     +  .931925E-03, .664429E-03, .469524E-03, .329092E-03,
     +  .228510E-03, .157318E-03, .107324E-03, .730074E-04,
     +  .492394E-04, .331205E-04, .222264E-04, .149206E-04,
     +  .100025E-04, .669443E-05, .443957E-05, .288714E-05,
     +  .181576E-05, .108113E-05, .589473E-06, .280423E-06,
     +  .105865E-06, .255103E-07, .187353E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .143296E+07, .107709E+07, .794770E+06, .585986E+06,
     +  .431727E+06, .317787E+06, .233730E+06, .171739E+06,
     +  .126080E+06, .924634E+05, .677458E+05, .495801E+05,
     +  .362482E+05, .264691E+05, .193066E+05, .140638E+05,
     +  .102323E+05, .743403E+04, .539391E+04, .390762E+04,
     +  .282688E+04, .204164E+04, .147225E+04, .105977E+04,
     +  .761599E+03, .546261E+03, .391272E+03, .278376E+03,
     +  .198682E+03, .141543E+03, .100685E+03, .715071E+02,
     +  .507187E+02, .359700E+02, .254749E+02, .180378E+02,
     +  .127788E+02, .906017E+01, .643504E+01, .457933E+01,
     +  .327000E+01, .234230E+01, .168452E+01, .121647E+01,
     +  .882693E+00, .643244E+00, .471617E+00, .346500E+00,
     +  .256243E+00, .189783E+00, .141207E+00, .105326E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .787570E-01, .589720E-01, .442082E-01, .331373E-01,
     +  .248319E-01, .185843E-01, .138890E-01, .103525E-01,
     +  .769600E-02, .569949E-02, .420326E-02, .308866E-02,
     +  .225305E-02, .163262E-02, .117541E-02, .839966E-03,
     +  .595953E-03, .419380E-03, .292953E-03, .202964E-03,
     +  .139624E-03, .953632E-04, .650720E-04, .441354E-04,
     +  .299231E-04, .202849E-04, .137711E-04, .933896E-05,
     +  .631157E-05, .421563E-05, .274920E-05, .172625E-05,
     +  .102079E-05, .550009E-06, .256989E-06, .946143E-07,
     +  .221625E-07, .165444E-08, .000000E+00, .179742E+07,
     +  .134703E+07, .990440E+06, .727657E+06, .534175E+06,
     +  .391771E+06, .287086E+06, .210163E+06, .153710E+06,
     +  .112300E+06, .819643E+05, .597541E+05, .435154E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .316501E+05, .229932E+05, .166816E+05, .120871E+05,
     +  .874527E+04, .631868E+04, .455816E+04, .328331E+04,
     +  .236096E+04, .169501E+04, .121466E+04, .868950E+03,
     +  .620381E+03, .442283E+03, .313157E+03, .222430E+03,
     +  .157690E+03, .111613E+03, .788702E+02, .556544E+02,
     +  .392659E+02, .276618E+02, .194813E+02, .137259E+02,
     +  .967797E+01, .683524E+01, .483656E+01, .343380E+01,
     +  .244536E+01, .174830E+01, .125508E+01, .905256E+00,
     +  .655720E+00, .477854E+00, .348941E+00, .256461E+00,
     +  .188772E+00, .139582E+00, .103469E+00, .768841E-01,
     +  .572096E-01, .426164E-01, .317435E-01, .236374E-01,
     +  .175794E-01, .130552E-01, .967021E-02, .714391E-02,
     +  .525810E-02, .385393E-02, .281493E-02, .204122E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .147076E-02, .105318E-02, .748879E-03, .528946E-03,
     +  .370834E-03, .258290E-03, .178644E-03, .122865E-03,
     +  .840498E-04, .575451E-04, .392457E-04, .268005E-04,
     +  .183248E-04, .125505E-04, .858090E-05, .583310E-05,
     +  .390755E-05, .254547E-05, .159030E-05, .931454E-06,
     +  .494951E-06, .226848E-06, .814102E-07, .185476E-07,
     +  .140640E-08, .000000E+00, .222486E+07, .166241E+07,
     +  .121801E+07, .891667E+06, .652219E+06, .476611E+06,
     +  .347974E+06, .253792E+06, .184924E+06, .134594E+06,
     +  .978603E+05, .710671E+05, .515517E+05, .373471E+05,
     +  .270236E+05, .195265E+05, .140907E+05, .101527E+05,
     +  .730492E+04, .524732E+04, .376352E+04, .269453E+04,
     +  .192598E+04, .137403E+04, .978527E+03, .695403E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .493462E+03, .347725E+03, .245802E+03, .173416E+03,
     +  .122139E+03, .858778E+02, .602912E+02, .423187E+02,
     +  .296559E+02, .207746E+02, .145580E+02, .102085E+02,
     +  .716992E+01, .504493E+01, .356136E+01, .252165E+01,
     +  .179238E+01, .127921E+01, .917217E+00, .660438E+00,
     +  .478420E+00, .347253E+00, .253674E+00, .185585E+00,
     +  .136387E+00, .100484E+00, .742070E-01, .548783E-01,
     +  .406266E-01, .300749E-01, .222566E-01, .164508E-01,
     +  .121418E-01, .893886E-02, .656346E-02, .480200E-02,
     +  .349870E-02, .254063E-02, .183185E-02, .131279E-02,
     +  .935282E-03, .661975E-03, .465655E-03, .325384E-03,
     +  .226088E-03, .156186E-03, .107450E-03, .736498E-04,
     +  .506044E-04, .346960E-04, .238478E-04, .164231E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .113237E-04, .778449E-05, .530678E-05, .355475E-05,
     +  .230688E-05, .143074E-05, .828601E-06, .433665E-06,
     +  .194813E-06, .681426E-07, .151114E-07, .116335E-08,
     +  .000000E+00, .272137E+07, .202740E+07, .148020E+07,
     +  .107976E+07, .786967E+06, .572996E+06, .416813E+06,
     +  .302878E+06, .219865E+06, .159422E+06, .115471E+06,
     +  .835331E+05, .603584E+05, .435553E+05, .313903E+05,
     +  .225906E+05, .162354E+05, .116500E+05, .834732E+04,
     +  .597087E+04, .426421E+04, .303984E+04, .216331E+04,
     +  .153652E+04, .108933E+04, .770615E+03, .544307E+03,
     +  .381736E+03, .268565E+03, .188566E+03, .132161E+03,
     +  .924648E+02, .645888E+02, .451045E+02, .314440E+02,
     +  .219114E+02, .152724E+02, .106517E+02, .744008E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .520600E+01, .365441E+01, .257288E+01, .181831E+01,
     +  .129024E+01, .919736E+00, .658372E+00, .474119E+00,
     +  .342088E+00, .248411E+00, .180646E+00, .131960E+00,
     +  .966388E-01, .709362E-01, .521428E-01, .383672E-01,
     +  .282307E-01, .207655E-01, .152564E-01, .111925E-01,
     +  .819098E-02, .597874E-02, .434881E-02, .315027E-02,
     +  .227482E-02, .163129E-02, .116307E-02, .824665E-03,
     +  .581190E-03, .407323E-03, .283810E-03, .196822E-03,
     +  .135875E-03, .935470E-04, .642671E-04, .443194E-04,
     +  .305396E-04, .211111E-04, .146229E-04, .101316E-04,
     +  .698721E-05, .476565E-05, .318486E-05, .205502E-05,
     +  .126322E-05, .722525E-06, .372132E-06, .163774E-06,
     +  .558398E-07, .120635E-07, .942574E-09, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .716520E+05, .426722E+05, .330799E+05, .256440E+05,
     +  .198797E+05, .154112E+05, .119473E+05, .926206E+04,
     +  .718045E+04, .556678E+04, .431584E+04, .334611E+04,
     +  .259436E+04, .201158E+04, .155980E+04, .120956E+04,
     +  .938035E+03, .727534E+03, .564338E+03, .437813E+03,
     +  .339715E+03, .263655E+03, .204678E+03, .158945E+03,
     +  .123479E+03, .959729E+02, .746369E+02, .578785E+02,
     +  .450858E+02, .351557E+02, .274452E+02, .214558E+02,
     +  .168009E+02, .131905E+02, .103728E+02, .817835E+01,
     +  .646683E+01, .512961E+01, .408250E+01, .326000E+01,
     +  .261279E+01, .210076E+01, .169420E+01, .136994E+01,
     +  .111012E+01, .901007E+00, .732559E+00, .595008E+00,
     +  .483692E+00, .392267E+00, .317801E+00, .256845E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .206946E+00, .166126E+00, .132785E+00, .105617E+00,
     +  .835472E-01, .656897E-01, .513068E-01, .397840E-01,
     +  .306074E-01, .233476E-01, .176460E-01, .132218E-01,
     +  .978304E-02, .715404E-02, .516508E-02, .367751E-02,
     +  .257881E-02, .177846E-02, .120421E-02, .799044E-03,
     +  .518280E-03, .327583E-03, .202089E-03, .120396E-03,
     +  .691964E-04, .381607E-04, .200591E-04, .996608E-05,
     +  .462991E-05, .198594E-05, .766933E-06, .261688E-06,
     +  .755497E-07, .173632E-07, .286798E-08, .281062E-09,
     +  .106249E-10, .390905E-13, .000000E+00, .939372E+05,
     +  .730774E+05, .561388E+05, .431216E+05, .331235E+05,
     +  .254402E+05, .195395E+05, .150055E+05, .115237E+05,
     +  .884868E+04, .679473E+04, .521684E+04, .400547E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .307498E+04, .236074E+04, .181217E+04, .139116E+04,
     +  .106785E+04, .819752E+03, .629255E+03, .483099E+03,
     +  .370891E+03, .284809E+03, .218728E+03, .168035E+03,
     +  .129126E+03, .992867E+02, .760941E+02, .585893E+02,
     +  .451458E+02, .348290E+02, .269021E+02, .208139E+02,
     +  .161440E+02, .125434E+02, .977041E+01, .763411E+01,
     +  .598363E+01, .470708E+01, .371564E+01, .294509E+01,
     +  .234233E+01, .186947E+01, .149650E+01, .120121E+01,
     +  .966067E+00, .778810E+00, .627397E+00, .506213E+00,
     +  .407593E+00, .328048E+00, .263483E+00, .211094E+00,
     +  .168563E+00, .134095E+00, .106192E+00, .836747E-01,
     +  .655575E-01, .510509E-01, .394821E-01, .303131E-01,
     +  .230869E-01, .174310E-01, .130553E-01, .966187E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .707047E-02, .511199E-02, .364707E-02, .256475E-02,
     +  .177471E-02, .120659E-02, .803943E-03, .523753E-03,
     +  .331844E-03, .204782E-03, .121200E-03, .683283E-04,
     +  .359619E-04, .169853E-04, .648536E-05, .111668E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .143284E+06, .110906E+06,
     +  .847038E+05, .646778E+05, .493841E+05, .376974E+05,
     +  .287747E+05, .219583E+05, .167556E+05, .127822E+05,
     +  .975041E+04, .743569E+04, .567011E+04, .432257E+04,
     +  .329508E+04, .251114E+04, .191362E+04, .145789E+04,
     +  .111067E+04, .845948E+03, .644344E+03, .490696E+03,
     +  .373724E+03, .284609E+03, .216786E+03, .165138E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .125861E+03, .955803E+02, .729201E+02, .556628E+02,
     +  .425366E+02, .325387E+02, .249295E+02, .191454E+02,
     +  .147277E+02, .113567E+02, .878476E+01, .681631E+01,
     +  .530888E+01, .414927E+01, .325707E+01, .256587E+01,
     +  .202904E+01, .160967E+01, .128098E+01, .102168E+01,
     +  .817195E+00, .653320E+00, .523405E+00, .418569E+00,
     +  .334740E+00, .267232E+00, .212892E+00, .169096E+00,
     +  .133858E+00, .105515E+00, .827874E-01, .646065E-01,
     +  .501326E-01, .386470E-01, .295897E-01, .224823E-01,
     +  .169420E-01, .126714E-01, .937017E-02, .685544E-02,
     +  .495948E-02, .354361E-02, .249897E-02, .173657E-02,
     +  .118824E-02, .798976E-03, .527359E-03, .340345E-03,
     +  .215740E-03, .132834E-03, .795994E-04, .461756E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .258667E-04, .138804E-04, .710354E-05, .342248E-05,
     +  .152677E-05, .611083E-06, .208548E-06, .506117E-07,
     +  .281397E-08, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .204063E+06, .157332E+06, .119615E+06,
     +  .909119E+05, .690876E+05, .524844E+05, .398656E+05,
     +  .302699E+05, .229804E+05, .174399E+05, .132330E+05,
     +  .100371E+05, .761175E+04, .577018E+04, .437344E+04,
     +  .331346E+04, .250999E+04, .190058E+04, .143894E+04,
     +  .108900E+04, .824099E+03, .623423E+03, .471597E+03,
     +  .356653E+03, .269737E+03, .203983E+03, .154322E+03,
     +  .116295E+03, .880381E+02, .666716E+02, .505391E+02,
     +  .383423E+02, .291302E+02, .221814E+02, .169161E+02,
     +  .129304E+02, .991435E+01, .762484E+01, .588631E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .456015E+01, .354859E+01, .277161E+01, .217340E+01,
     +  .171010E+01, .135014E+01, .106857E+01, .848435E+00,
     +  .673460E+00, .535911E+00, .425783E+00, .338412E+00,
     +  .268575E+00, .212770E+00, .168106E+00, .132411E+00,
     +  .103879E+00, .811410E-01, .630556E-01, .487383E-01,
     +  .374353E-01, .285667E-01, .216396E-01, .162630E-01,
     +  .121353E-01, .895635E-02, .654269E-02, .472864E-02,
     +  .337748E-02, .238297E-02, .165835E-02, .113790E-02,
     +  .768577E-03, .510786E-03, .332981E-03, .214160E-03,
     +  .134661E-03, .831948E-04, .504304E-04, .301203E-04,
     +  .177281E-04, .103760E-04, .604484E-05, .352272E-05,
     +  .204274E-05, .116809E-05, .636199E-06, .316529E-06,
     +  .131984E-06, .367084E-07, .244085E-08, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .224065E+06, .213714E+06, .161840E+06, .122511E+06,
     +  .927199E+05, .701435E+05, .530526E+05, .401083E+05,
     +  .303151E+05, .229025E+05, .172981E+05, .130589E+05,
     +  .985604E+04, .743503E+04, .560721E+04, .422659E+04,
     +  .318507E+04, .239896E+04, .180641E+04, .135953E+04,
     +  .102299E+04, .769397E+03, .578569E+03, .434896E+03,
     +  .326869E+03, .245614E+03, .184610E+03, .138180E+03,
     +  .103893E+03, .781293E+02, .588018E+02, .442857E+02,
     +  .333950E+02, .252364E+02, .190975E+02, .144836E+02,
     +  .110175E+02, .840569E+01, .643724E+01, .494709E+01,
     +  .381917E+01, .295951E+01, .230278E+01, .179816E+01,
     +  .140917E+01, .110726E+01, .873055E+00, .688315E+00,
     +  .544199E+00, .429662E+00, .339454E+00, .267854E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .211035E+00, .165858E+00, .129985E+00, .101486E+00,
     +  .789088E-01, .610533E-01, .469954E-01, .359550E-01,
     +  .273361E-01, .206361E-01, .154592E-01, .115017E-01,
     +  .846616E-02, .617009E-02, .445066E-02, .317418E-02,
     +  .223748E-02, .155677E-02, .106897E-02, .723408E-03,
     +  .482469E-03, .316326E-03, .205188E-03, .130651E-03,
     +  .821729E-04, .510587E-04, .315247E-04, .193666E-04,
     +  .119406E-04, .737566E-05, .456207E-05, .279289E-05,
     +  .166531E-05, .932503E-06, .469219E-06, .194475E-06,
     +  .529105E-07, .362459E-08, .000000E+00, .390600E+06,
     +  .299001E+06, .225431E+06, .169889E+06, .127992E+06,
     +  .963807E+05, .725527E+05, .545877E+05, .410568E+05,
     +  .308633E+05, .231921E+05, .174179E+05, .130762E+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .981109E+04, .735831E+04, .551542E+04, .413239E+04,
     +  .309426E+04, .231598E+04, .173240E+04, .129538E+04,
     +  .968034E+03, .723161E+03, .539942E+03, .403031E+03,
     +  .300713E+03, .224398E+03, .166706E+03, .124392E+03,
     +  .928228E+02, .693063E+02, .517750E+02, .387184E+02,
     +  .290132E+02, .217663E+02, .163635E+02, .123370E+02,
     +  .932821E+01, .707927E+01, .539144E+01, .412471E+01,
     +  .316775E+01, .244299E+01, .189107E+01, .146934E+01,
     +  .114493E+01, .895465E+00, .700415E+00, .549562E+00,
     +  .430697E+00, .337851E+00, .264766E+00, .207223E+00,
     +  .161828E+00, .126049E+00, .978323E-01, .756334E-01,
     +  .581978E-01, .445594E-01, .339168E-01, .256585E-01,
     +  .192770E-01, .143731E-01, .106447E-01, .779942E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .565812E-02, .406220E-02, .288302E-02, .202157E-02,
     +  .139835E-02, .953669E-03, .640065E-03, .422431E-03,
     +  .273193E-03, .173982E-03, .108000E-03, .655497E-04,
     +  .387529E-04, .223248E-04, .124802E-04, .679093E-05,
     +  .358650E-05, .184597E-05, .925304E-06, .455437E-06,
     +  .216181E-06, .975781E-07, .386509E-07, .106624E-07,
     +  .656058E-09, .000000E+00, .531193E+06, .405179E+06,
     +  .304214E+06, .228295E+06, .171256E+06, .128397E+06,
     +  .962241E+05, .720711E+05, .539570E+05, .403711E+05,
     +  .301920E+05, .225650E+05, .168565E+05, .125838E+05,
     +  .938934E+04, .700097E+04, .521739E+04, .388543E+04,
     +  .289197E+04, .215098E+04, .159903E+04, .118788E+04,
     +  .882014E+03, .654473E+03, .485423E+03, .359837E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .266734E+03, .196794E+03, .145820E+03, .108039E+03,
     +  .800788E+02, .593772E+02, .440645E+02, .327632E+02,
     +  .243843E+02, .181839E+02, .135969E+02, .101958E+02,
     +  .767289E+01, .579449E+01, .439578E+01, .334768E+01,
     +  .256025E+01, .196557E+01, .151486E+01, .117102E+01,
     +  .908763E+00, .705405E+00, .549391E+00, .427458E+00,
     +  .332963E+00, .259166E+00, .201502E+00, .156356E+00,
     +  .121030E+00, .933713E-01, .717615E-01, .549053E-01,
     +  .418063E-01, .316512E-01, .238203E-01, .178065E-01,
     +  .132119E-01, .973897E-02, .710336E-02, .513088E-02,
     +  .366862E-02, .259389E-02, .181264E-02, .125023E-02,
     +  .850766E-03, .570293E-03, .376383E-03, .243921E-03,
     +  .156073E-03, .977470E-04, .601989E-04, .364257E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .217312E-04, .127912E-04, .748225E-05, .435463E-05,
     +  .252776E-05, .145492E-05, .820779E-06, .438407E-06,
     +  .212171E-06, .845876E-07, .220582E-07, .151508E-08,
     +  .000000E+00, .704833E+06, .535789E+06, .400661E+06,
     +  .299450E+06, .223704E+06, .167015E+06, .124631E+06,
     +  .929429E+05, .692759E+05, .516006E+05, .384140E+05,
     +  .285770E+05, .212467E+05, .157850E+05, .117203E+05,
     +  .869547E+04, .644728E+04, .477652E+04, .353645E+04,
     +  .261619E+04, .193419E+04, .142881E+04, .105484E+04,
     +  .778137E+03, .573695E+03, .422669E+03, .311352E+03,
     +  .228225E+03, .168003E+03, .123644E+03, .910174E+02,
     +  .670167E+02, .493777E+02, .364467E+02, .269236E+02,
     +  .199256E+02, .147845E+02, .110000E+02, .821286E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .615318E+01, .463077E+01, .349867E+01, .265455E+01,
     +  .202202E+01, .154628E+01, .118618E+01, .913635E+00,
     +  .703955E+00, .544320E+00, .420525E+00, .325309E+00,
     +  .251513E+00, .194273E+00, .149786E+00, .115221E+00,
     +  .883507E-01, .674998E-01, .513460E-01, .388748E-01,
     +  .292697E-01, .219094E-01, .162923E-01, .120264E-01,
     +  .882094E-02, .640245E-02, .460299E-02, .327648E-02,
     +  .230694E-02, .160593E-02, .110395E-02, .749190E-03,
     +  .501307E-03, .330671E-03, .214601E-03, .137844E-03,
     +  .869923E-04, .542515E-04, .334681E-04, .205242E-04,
     +  .125398E-04, .768303E-05, .471610E-05, .289011E-05,
     +  .174819E-05, .102398E-05, .560086E-06, .272757E-06,
     +  .107575E-06, .273999E-07, .193803E-08, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .917024E+06, .694761E+06, .517498E+06, .385234E+06,
     +  .286626E+06, .213115E+06, .158370E+06, .117605E+06,
     +  .872821E+05, .647295E+05, .479744E+05, .355287E+05,
     +  .262944E+05, .194444E+05, .143690E+05, .106094E+05,
     +  .782781E+04, .577039E+04, .425060E+04, .312825E+04,
     +  .230056E+04, .169032E+04, .124105E+04, .910383E+03,
     +  .667359E+03, .488800E+03, .357917E+03, .260737E+03,
     +  .190740E+03, .139485E+03, .102010E+03, .746117E+02,
     +  .545999E+02, .400231E+02, .293563E+02, .215699E+02,
     +  .158875E+02, .117332E+02, .869467E+01, .646506E+01,
     +  .482862E+01, .362050E+01, .272618E+01, .206096E+01,
     +  .156429E+01, .119115E+01, .910806E+00, .696740E+00,
     +  .534959E+00, .410436E+00, .315356E+00, .242206E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .185870E+00, .142399E+00, .108857E+00, .829621E-01,
     +  .630041E-01, .476461E-01, .358663E-01, .268529E-01,
     +  .199895E-01, .147847E-01, .108557E-01, .792113E-02,
     +  .572022E-02, .409241E-02, .289941E-02, .203245E-02,
     +  .140909E-02, .965186E-03, .653096E-03, .436135E-03,
     +  .287472E-03, .186788E-03, .120402E-03, .765174E-04,
     +  .482566E-04, .302668E-04, .189764E-04, .119195E-04,
     +  .753150E-05, .476970E-05, .300299E-05, .185353E-05,
     +  .109701E-05, .600655E-06, .289726E-06, .111954E-06,
     +  .277506E-07, .200267E-08, .000000E+00, .117361E+07,
     +  .886243E+06, .657568E+06, .487588E+06, .361339E+06,
     +  .267586E+06, .198036E+06, .146452E+06, .108234E+06,
     +  .799258E+05, .589806E+05, .434877E+05, .320411E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .235866E+05, .173496E+05, .127501E+05, .936246E+04,
     +  .686827E+04, .503437E+04, .368648E+04, .269723E+04,
     +  .197146E+04, .143978E+04, .105045E+04, .765789E+03,
     +  .557728E+03, .406040E+03, .294034E+03, .213810E+03,
     +  .155400E+03, .112939E+03, .820799E+02, .596738E+02,
     +  .434530E+02, .316564E+02, .231000E+02, .168953E+02,
     +  .123892E+02, .911493E+01, .672861E+01, .498890E+01,
     +  .371343E+01, .277576E+01, .208323E+01, .156978E+01,
     +  .118677E+01, .901060E+00, .684462E+00, .521923E+00,
     +  .397717E+00, .303549E+00, .231616E+00, .176602E+00,
     +  .134446E+00, .102139E+00, .773685E-01, .584042E-01,
     +  .439080E-01, .328609E-01, .244631E-01, .181088E-01,
     +  .133204E-01, .972772E-02, .706066E-02, .507244E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .361083E-02, .254596E-02, .177665E-02, .122663E-02,
     +  .837155E-03, .564790E-03, .376417E-03, .247949E-03,
     +  .161310E-03, .104347E-03, .667643E-04, .425466E-04,
     +  .270787E-04, .172921E-04, .110945E-04, .716173E-05,
     +  .462362E-05, .295186E-05, .183578E-05, .108633E-05,
     +  .590543E-06, .280581E-06, .105879E-06, .255108E-07,
     +  .187353E-08, .000000E+00, .148069E+07, .111452E+07,
     +  .823782E+06, .608476E+06, .449159E+06, .331301E+06,
     +  .244205E+06, .179859E+06, .132374E+06, .973421E+05,
     +  .715274E+05, .525113E+05, .385202E+05, .282301E+05,
     +  .206715E+05, .151217E+05, .110522E+05, .806950E+04,
     +  .588639E+04, .428930E+04, .312265E+04, .227084E+04,
     +  .164987E+04, .119740E+04, .868238E+03, .628879E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .455287E+03, .327798E+03, .236980E+03, .171225E+03,
     +  .123689E+03, .893403E+02, .645445E+02, .467003E+02,
     +  .338003E+02, .245012E+02, .177995E+02, .129632E+02,
     +  .947145E+01, .694314E+01, .511187E+01, .377821E+01,
     +  .280428E+01, .208985E+01, .156373E+01, .117397E+01,
     +  .885214E+00, .667828E+00, .505812E+00, .382872E+00,
     +  .290304E+00, .220082E+00, .166741E+00, .126145E+00,
     +  .952417E-01, .717059E-01, .538058E-01, .402130E-01,
     +  .299208E-01, .221473E-01, .163023E-01, .119255E-01,
     +  .866159E-02, .625336E-02, .446899E-02, .316524E-02,
     +  .222102E-02, .154290E-02, .106085E-02, .721433E-03,
     +  .485336E-03, .322877E-03, .212597E-03, .138519E-03,
     +  .899409E-04, .579349E-04, .372860E-04, .240435E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .155919E-04, .101696E-04, .666353E-05, .435280E-05,
     +  .279690E-05, .174083E-05, .102452E-05, .550768E-06,
     +  .257100E-06, .946239E-07, .221629E-07, .165444E-08,
     +  .000000E+00, .184450E+07, .138394E+07, .101905E+07,
     +  .749837E+06, .551368E+06, .405098E+06, .297416E+06,
     +  .218170E+06, .159916E+06, .117111E+06, .856932E+05,
     +  .626444E+05, .457555E+05, .333863E+05, .243388E+05,
     +  .177244E+05, .128953E+05, .937155E+04, .680397E+04,
     +  .493419E+04, .357465E+04, .258667E+04, .186986E+04,
     +  .135010E+04, .973853E+03, .701615E+03, .505190E+03,
     +  .361692E+03, .260012E+03, .186790E+03, .134144E+03,
     +  .963157E+02, .691611E+02, .497322E+02, .357679E+02,
     +  .257616E+02, .185934E+02, .134523E+02, .976318E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .710884E+01, .519837E+01, .381596E+01, .281295E+01,
     +  .208200E+01, .154725E+01, .115372E+01, .864101E+00,
     +  .647537E+00, .487207E+00, .366374E+00, .276002E+00,
     +  .207909E+00, .156527E+00, .117685E+00, .883095E-01,
     +  .660855E-01, .492930E-01, .366241E-01, .270924E-01,
     +  .199392E-01, .145944E-01, .106171E-01, .766922E-02,
     +  .550739E-02, .391533E-02, .275918E-02, .192683E-02,
     +  .133258E-02, .912552E-03, .618464E-03, .414972E-03,
     +  .275645E-03, .181487E-03, .118469E-03, .772334E-04,
     +  .500862E-04, .325383E-04, .212291E-04, .139451E-04,
     +  .921121E-05, .609753E-05, .400953E-05, .258053E-05,
     +  .160090E-05, .934133E-06, .495488E-06, .226925E-06,
     +  .814168E-07, .185478E-07, .140640E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .227129E+07, .169881E+07, .124623E+07, .913541E+06,
     +  .669175E+06, .489754E+06, .358161E+06, .261689E+06,
     +  .191045E+06, .139338E+06, .101537E+06, .739170E+05,
     +  .537603E+05, .390588E+05, .283501E+05, .205544E+05,
     +  .148872E+05, .107699E+05, .778306E+04, .561774E+04,
     +  .405045E+04, .291676E+04, .209809E+04, .150730E+04,
     +  .108170E+04, .775254E+03, .555260E+03, .395371E+03,
     +  .282666E+03, .201934E+03, .144196E+03, .102934E+03,
     +  .734777E+02, .525202E+02, .375423E+02, .268719E+02,
     +  .192725E+02, .138546E+02, .999021E+01, .722669E+01,
     +  .524977E+01, .382821E+01, .280323E+01, .206103E+01,
     +  .152149E+01, .112699E+01, .838545E+00, .624264E+00,
     +  .466655E+00, .348659E+00, .260986E+00, .195364E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .146169E+00, .109222E+00, .814615E-01, .605955E-01,
     +  .449304E-01, .331877E-01, .244085E-01, .178618E-01,
     +  .130005E-01, .940548E-02, .675706E-02, .482662E-02,
     +  .341358E-02, .239365E-02, .166372E-02, .114563E-02,
     +  .781503E-03, .527956E-03, .353413E-03, .234479E-03,
     +  .154438E-03, .101039E-03, .661555E-04, .431922E-04,
     +  .283086E-04, .186620E-04, .123893E-04, .826161E-05,
     +  .550496E-05, .363038E-05, .233260E-05, .143842E-05,
     +  .830518E-06, .434045E-06, .194867E-06, .681472E-07,
     +  .151115E-07, .116336E-08, .000000E+00, .276717E+07,
     +  .206331E+07, .150803E+07, .110133E+07, .803688E+06,
     +  .585957E+06, .426860E+06, .310665E+06, .225901E+06,
     +  .164100E+06, .119096E+06, .863429E+05, .625359E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .452427E+05, .326978E+05, .236037E+05, .170204E+05,
     +  .122581E+05, .881836E+04, .633571E+04, .454675E+04,
     +  .325861E+04, .233267E+04, .166761E+04, .119077E+04,
     +  .849082E+03, .604997E+03, .428492E+03, .304710E+03,
     +  .216499E+03, .153741E+03, .109131E+03, .774543E+02,
     +  .550408E+02, .391105E+02, .278258E+02, .198344E+02,
     +  .141703E+02, .101537E+02, .729837E+01, .526793E+01,
     +  .381672E+01, .277674E+01, .202833E+01, .148764E+01,
     +  .109478E+01, .809344E+00, .598649E+00, .444660E+00,
     +  .330120E+00, .245561E+00, .182679E+00, .135839E+00,
     +  .100887E+00, .747921E-01, .553038E-01, .407657E-01,
     +  .299368E-01, .218912E-01, .159291E-01, .115292E-01,
     +  .829537E-02, .592739E-02, .421176E-02, .296351E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .206794E-02, .143076E-02, .981105E-03, .666828E-03,
     +  .449167E-03, .300067E-03, .198930E-03, .131126E-03,
     +  .860135E-04, .565749E-04, .371832E-04, .245710E-04,
     +  .163449E-04, .109438E-04, .734750E-05, .491383E-05,
     +  .324082E-05, .207383E-05, .126877E-05, .723893E-06,
     +  .372399E-06, .163812E-06, .558429E-07, .120636E-07,
     +  .942575E-09, .000000E+00, .576738E+05, .853739E+05,
     +  .661840E+05, .513080E+05, .397760E+05, .308363E+05,
     +  .239062E+05, .185338E+05, .143691E+05, .111406E+05,
     +  .863768E+04, .669736E+04, .519315E+04, .402700E+04,
     +  .312294E+04, .242203E+04, .187863E+04, .145732E+04,
     +  .113066E+04, .877376E+03, .680981E+03, .528687E+03,
     +  .410584E+03, .318987E+03, .247940E+03, .192827E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .150067E+03, .116473E+03, .908208E+02, .709022E+02,
     +  .554303E+02, .434073E+02, .340592E+02, .268053E+02,
     +  .211412E+02, .167274E+02, .132827E+02, .105894E+02,
     +  .847841E+01, .681820E+01, .550966E+01, .447208E+01,
     +  .364565E+01, .298371E+01, .245037E+01, .201803E+01,
     +  .166663E+01, .137656E+01, .113880E+01, .940637E+00,
     +  .776564E+00, .639825E+00, .525707E+00, .430430E+00,
     +  .350936E+00, .284722E+00, .229720E+00, .184196E+00,
     +  .146686E+00, .115946E+00, .909052E-01, .706473E-01,
     +  .543823E-01, .414847E-01, .312436E-01, .232479E-01,
     +  .170731E-01, .123608E-01, .881105E-02, .617485E-02,
     +  .424740E-02, .286215E-02, .188478E-02, .120913E-02,
     +  .756787E-03, .457340E-03, .266556E-03, .149032E-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .793999E-04, .399730E-04, .188123E-04, .817241E-05,
     +  .319582E-05, .110390E-05, .322559E-06, .750145E-07,
     +  .125355E-07, .124261E-08, .475051E-10, .176721E-12,
     +  .000000E+00, .147710E+06, .115242E+06, .888264E+05,
     +  .684629E+05, .527693E+05, .406713E+05, .313479E+05,
     +  .241606E+05, .186219E+05, .143523E+05, .110621E+05,
     +  .852589E+04, .657149E+04, .506500E+04, .390414E+04,
     +  .300934E+04, .231986E+04, .178840E+04, .137889E+04,
     +  .106324E+04, .820019E+03, .632542E+03, .488076E+03,
     +  .376711E+03, .290886E+03, .224717E+03, .173726E+03,
     +  .133911E+03, .103709E+03, .804047E+02, .624252E+02,
     +  .485421E+02, .378206E+02, .295542E+02, .231437E+02,
     +  .181801E+02, .143331E+02, .113442E+02, .901765E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .719953E+01, .577639E+01, .465519E+01, .376825E+01,
     +  .306247E+01, .249781E+01, .204309E+01, .167617E+01,
     +  .137528E+01, .113050E+01, .927886E+00, .761342E+00,
     +  .623508E+00, .509304E+00, .414614E+00, .336163E+00,
     +  .271255E+00, .217696E+00, .173653E+00, .137598E+00,
     +  .108231E+00, .844553E-01, .653361E-01, .500697E-01,
     +  .380326E-01, .285249E-01, .211396E-01, .154644E-01,
     +  .111541E-01, .792228E-02, .553247E-02, .379245E-02,
     +  .254655E-02, .167100E-02, .106731E-02, .664593E-03,
     +  .398659E-03, .229717E-03, .125980E-03, .648002E-04,
     +  .304767E-04, .123596E-04, .362749E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .196406E+06, .152560E+06, .116995E+06, .897124E+05,
     +  .687920E+05, .527441E+05, .404400E+05, .310026E+05,
     +  .237677E+05, .182192E+05, .139660E+05, .107046E+05,
     +  .820499E+04, .628843E+04, .481973E+04, .369375E+04,
     +  .283101E+04, .216966E+04, .166298E+04, .127462E+04,
     +  .977129E+03, .749126E+03, .574478E+03, .440630E+03,
     +  .338101E+03, .259525E+03, .199354E+03, .152653E+03,
     +  .117451E+03, .904544E+02, .697595E+02, .538791E+02,
     +  .416939E+02, .323580E+02, .251654E+02, .196314E+02,
     +  .153703E+02, .120804E+02, .953635E+01, .756078E+01,
     +  .602454E+01, .482188E+01, .387670E+01, .312938E+01,
     +  .253549E+01, .206029E+01, .167946E+01, .136919E+01,
     +  .111854E+01, .912444E+00, .744205E+00, .605903E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .492093E+00, .398361E+00, .321221E+00, .257812E+00,
     +  .205824E+00, .163343E+00, .128784E+00, .100805E+00,
     +  .782888E-01, .602890E-01, .459957E-01, .347891E-01,
     +  .259844E-01, .191808E-01, .139793E-01, .100483E-01,
     +  .711506E-02, .495585E-02, .339058E-02, .227427E-02,
     +  .149272E-02, .955304E-03, .597723E-03, .361784E-03,
     +  .211832E-03, .119395E-03, .644566E-04, .330881E-04,
     +  .160257E-04, .724625E-05, .299862E-05, .111122E-05,
     +  .351933E-06, .833290E-07, .816555E-08, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .256562E+06,
     +  .198497E+06, .151527E+06, .115652E+06, .882675E+05,
     +  .673542E+05, .513937E+05, .392079E+05, .299101E+05,
     +  .228129E+05, .173991E+05, .132676E+05, .101168E+05 /
        DATA (UPDI(I),I=4109,4160) /
     +  .771289E+04, .588010E+04, .448211E+04, .341653E+04,
     +  .260392E+04, .198469E+04, .151258E+04, .115291E+04,
     +  .878760E+03, .669937E+03, .510788E+03, .389576E+03,
     +  .297211E+03, .226902E+03, .172650E+03, .132001E+03,
     +  .101011E+03, .774006E+02, .593922E+02, .456591E+02,
     +  .352017E+02, .271953E+02, .210731E+02, .163887E+02,
     +  .127943E+02, .100322E+02, .790061E+01, .625346E+01,
     +  .497192E+01, .397108E+01, .318470E+01, .256376E+01,
     +  .207003E+01, .167691E+01, .135865E+01, .110326E+01,
     +  .894624E+00, .725428E+00, .587242E+00, .474272E+00,
     +  .381831E+00, .306240E+00, .244495E+00, .194186E+00,
     +  .153328E+00, .120291E+00, .937009E-01, .724281E-01,
     +  .555198E-01, .421664E-01, .317542E-01, .236170E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .173618E-01, .126040E-01, .902637E-02, .636978E-02,
     +  .442332E-02, .301864E-02, .202112E-02, .132554E-02,
     +  .848803E-03, .532543E-03, .324241E-03, .191937E-03,
     +  .110215E-03, .613919E-04, .331715E-04, .174885E-04,
     +  .906628E-05, .467439E-05, .243012E-05, .127790E-05,
     +  .660971E-06, .320531E-06, .132370E-06, .367231E-07,
     +  .244092E-08, .000000E+00, .210716E+06, .254407E+06,
     +  .193386E+06, .146967E+06, .111680E+06, .848428E+05,
     +  .644484E+05, .489436E+05, .371652E+05, .282138E+05,
     +  .214163E+05, .162522E+05, .123322E+05, .935537E+04,
     +  .709651E+04, .538177E+04, .408114E+04, .309416E+04,
     +  .234583E+04, .177818E+04, .134797E+04, .102174E+04,
     +  .774574E+03, .587206E+03, .445278E+03, .337717E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .256305E+03, .193839E+03, .147303E+03, .112029E+03,
     +  .853109E+02, .650516E+02, .496934E+02, .380680E+02,
     +  .292209E+02, .224964E+02, .173824E+02, .134818E+02,
     +  .105027E+02, .821745E+01, .646230E+01, .510498E+01,
     +  .405139E+01, .322859E+01, .258289E+01, .207261E+01,
     +  .166885E+01, .134399E+01, .108496E+01, .874669E+00,
     +  .705216E+00, .567691E+00, .455969E+00, .365120E+00,
     +  .291292E+00, .231355E+00, .182813E+00, .143626E+00,
     +  .112126E+00, .869208E-01, .668705E-01, .510238E-01,
     +  .385760E-01, .289225E-01, .214179E-01, .156790E-01,
     +  .113363E-01, .808707E-02, .568624E-02, .393555E-02,
     +  .267798E-02, .178887E-02, .117151E-02, .749927E-03,
     +  .471169E-03, .288011E-03, .171827E-03, .100005E-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .569388E-04, .318211E-04, .176289E-04, .977132E-05,
     +  .546654E-05, .309413E-05, .174977E-05, .951345E-06,
     +  .472227E-06, .194762E-06, .529214E-07, .362464E-08,
     +  .000000E+00, .441783E+06, .339134E+06, .256543E+06,
     +  .194009E+06, .146691E+06, .110877E+06, .837915E+05,
     +  .633014E+05, .478124E+05, .361014E+05, .272534E+05,
     +  .205671E+05, .155182E+05, .117049E+05, .882700E+04,
     +  .665459E+04, .501602E+04, .377979E+04, .284789E+04,
     +  .214519E+04, .161580E+04, .121682E+04, .916387E+03,
     +  .690077E+03, .519735E+03, .391476E+03, .295035E+03,
     +  .221532E+03, .167141E+03, .126194E+03, .953917E+02,
     +  .721990E+02, .547388E+02, .416167E+02, .317010E+02,
     +  .242187E+02, .185688E+02, .142909E+02, .110469E+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .857658E+01, .669291E+01, .524679E+01, .413231E+01,
     +  .326835E+01, .259526E+01, .206723E+01, .165249E+01,
     +  .132128E+01, .105915E+01, .847946E+00, .679020E+00,
     +  .542953E+00, .433236E+00, .344681E+00, .273242E+00,
     +  .215667E+00, .169371E+00, .132263E+00, .102642E+00,
     +  .791031E-01, .605054E-01, .459055E-01, .345105E-01,
     +  .257306E-01, .189479E-01, .137937E-01, .991733E-02,
     +  .703487E-02, .491783E-02, .338334E-02, .228761E-02,
     +  .151754E-02, .986102E-03, .625436E-03, .388525E-03,
     +  .233996E-03, .136786E-03, .773374E-04, .421929E-04,
     +  .221330E-04, .111592E-04, .540870E-05, .252686E-05,
     +  .114965E-05, .517616E-06, .229890E-06, .997402E-07,
     +  .388550E-07, .106701E-07, .656095E-09, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .581673E+06, .444761E+06, .334898E+06, .252084E+06,
     +  .189698E+06, .142695E+06, .107309E+06, .806651E+05,
     +  .606198E+05, .455372E+05, .341974E+05, .256710E+05,
     +  .192649E+05, .144515E+05, .108378E+05, .812439E+04,
     +  .608879E+04, .456145E+04, .341647E+04, .255801E+04,
     +  .191496E+04, .143316E+04, .107250E+04, .802461E+03,
     +  .600441E+03, .449272E+03, .336325E+03, .250794E+03,
     +  .187911E+03, .140885E+03, .105742E+03, .794598E+02,
     +  .598067E+02, .451381E+02, .341295E+02, .258806E+02,
     +  .196949E+02, .150441E+02, .115420E+02, .889387E+01,
     +  .688869E+01, .536015E+01, .419037E+01, .328998E+01,
     +  .259345E+01, .205092E+01, .162784E+01, .129239E+01,
     +  .102884E+01, .818030E+00, .650649E+00, .516816E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .409683E+00, .323844E+00, .255093E+00, .200083E+00,
     +  .156162E+00, .121205E+00, .934954E-01, .716276E-01,
     +  .544674E-01, .410869E-01, .307117E-01, .227699E-01,
     +  .166743E-01, .120720E-01, .863287E-02, .609166E-02,
     +  .423689E-02, .290079E-02, .195251E-02, .129005E-02,
     +  .835505E-03, .528741E-03, .328258E-03, .198081E-03,
     +  .116468E-03, .666461E-04, .371545E-04, .202149E-04,
     +  .108082E-04, .572756E-05, .303495E-05, .162003E-05,
     +  .865949E-06, .448233E-06, .213699E-06, .847301E-07,
     +  .220636E-07, .151511E-08, .000000E+00, .754622E+06,
     +  .574829E+06, .430926E+06, .322913E+06, .241893E+06,
     +  .181117E+06, .135563E+06, .101419E+06, .758474E+05,
     +  .566958E+05, .423645E+05, .316402E+05, .236220E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .176270E+05, .131487E+05, .980337E+04, .730661E+04,
     +  .544315E+04, .405365E+04, .301753E+04, .224568E+04,
     +  .167063E+04, .124261E+04, .924001E+03, .687045E+03,
     +  .510790E+03, .379904E+03, .281403E+03, .209440E+03,
     +  .155966E+03, .116259E+03, .867576E+02, .648410E+02,
     +  .485921E+02, .364784E+02, .274627E+02, .207475E+02,
     +  .157331E+02, .119827E+02, .916624E+01, .704806E+01,
     +  .544445E+01, .422556E+01, .329386E+01, .257804E+01,
     +  .202435E+01, .159557E+01, .125799E+01, .994629E+00,
     +  .785481E+00, .620597E+00, .489706E+00, .385673E+00,
     +  .302913E+00, .237096E+00, .184805E+00, .143347E+00,
     +  .110581E+00, .847855E-01, .645681E-01, .488103E-01,
     +  .366057E-01, .272041E-01, .200546E-01, .146028E-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .105133E-01, .747695E-02, .524774E-02, .363097E-02,
     +  .247362E-02, .165728E-02, .109047E-02, .703850E-03,
     +  .444416E-03, .275737E-03, .166718E-03, .985995E-04,
     +  .570844E-04, .324697E-04, .182358E-04, .102094E-04,
     +  .574801E-05, .326697E-05, .186941E-05, .105671E-05,
     +  .567110E-06, .273834E-06, .107674E-06, .274036E-07,
     +  .193805E-08, .000000E+00, .966132E+06, .733267E+06,
     +  .547349E+06, .408376E+06, .304566E+06, .227024E+06,
     +  .169153E+06, .125965E+06, .937635E+05, .697548E+05,
     +  .518707E+05, .385499E+05, .286371E+05, .212610E+05,
     +  .157778E+05, .117020E+05, .867524E+04, .642777E+04,
     +  .476059E+04, .352397E+04, .260766E+04, .192871E+04,
     +  .142614E+04, .105414E+04, .779054E+03, .575615E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .425436E+03, .313097E+03, .231525E+03, .171284E+03,
     +  .126830E+03, .940102E+02, .697833E+02, .519376E+02,
     +  .387193E+02, .289462E+02, .217144E+02, .163501E+02,
     +  .123644E+02, .939127E+01, .716997E+01, .549951E+01,
     +  .423823E+01, .328060E+01, .254978E+01, .198832E+01,
     +  .155645E+01, .121878E+01, .957157E+00, .750839E+00,
     +  .589318E+00, .461997E+00, .361507E+00, .282125E+00,
     +  .219434E+00, .169973E+00, .131030E+00, .100463E+00,
     +  .765628E-01, .579580E-01, .435544E-01, .324731E-01,
     +  .239925E-01, .175855E-01, .127317E-01, .911447E-02,
     +  .644616E-02, .449975E-02, .309706E-02, .209933E-02,
     +  .139996E-02, .917351E-03, .590132E-03, .371809E-03,
     +  .230586E-03, .139724E-03, .831297E-04, .486797E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .282070E-04, .162796E-04, .944599E-05, .554347E-05,
     +  .328237E-05, .194230E-05, .112067E-05, .605664E-06,
     +  .290484E-06, .112023E-06, .277531E-07, .200268E-08,
     +  .000000E+00, .122205E+07, .924222E+06, .687011E+06,
     +  .510413E+06, .379034E+06, .281304E+06, .208671E+06,
     +  .154698E+06, .114627E+06, .848822E+05, .628234E+05,
     +  .464674E+05, .343515E+05, .253782E+05, .187390E+05,
     +  .138276E+05, .101981E+05, .751649E+04, .553723E+04,
     +  .407664E+04, .300000E+04, .220646E+04, .162222E+04,
     +  .119212E+04, .875840E+03, .643245E+03, .472531E+03,
     +  .345580E+03, .253944E+03, .186677E+03, .137337E+03,
     +  .101135E+03, .745759E+02, .551354E+02, .408261E+02,
     +  .303141E+02, .225850E+02, .168890E+02, .126839E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .956749E+01, .725410E+01, .552570E+01, .422911E+01,
     +  .325112E+01, .250963E+01, .194372E+01, .151131E+01,
     +  .117549E+01, .917052E+00, .714634E+00, .557246E+00,
     +  .434038E+00, .337460E+00, .261694E+00, .202267E+00,
     +  .155703E+00, .119292E+00, .909065E-01, .688617E-01,
     +  .518167E-01, .387086E-01, .286910E-01, .210742E-01,
     +  .153574E-01, .110546E-01, .786901E-02, .553430E-02,
     +  .384219E-02, .263057E-02, .177421E-02, .117769E-02,
     +  .768585E-03, .492860E-03, .309929E-03, .192189E-03,
     +  .116758E-03, .699046E-04, .414006E-04, .244077E-04,
     +  .144240E-04, .860902E-05, .520238E-05, .315845E-05,
     +  .190064E-05, .110339E-05, .594107E-06, .281112E-06,
     +  .105927E-06, .255125E-07, .187354E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .152846E+07, .115198E+07, .852821E+06, .630988E+06,
     +  .466612E+06, .344831E+06, .254694E+06, .187992E+06,
     +  .138679E+06, .102231E+06, .753174E+05, .554500E+05,
     +  .407987E+05, .299970E+05, .220416E+05, .161843E+05,
     +  .118763E+05, .870868E+04, .638221E+04, .467396E+04,
     +  .342112E+04, .250247E+04, .182966E+04, .133700E+04,
     +  .976656E+03, .713104E+03, .520754E+03, .378530E+03,
     +  .276463E+03, .201978E+03, .147663E+03, .108050E+03,
     +  .791638E+02, .581488E+02, .427753E+02, .315518E+02,
     +  .233508E+02, .173450E+02, .129390E+02, .969430E+01,
     +  .730079E+01, .552384E+01, .419926E+01, .320653E+01,
     +  .245866E+01, .189155E+01, .146104E+01, .112888E+01,
     +  .874936E+00, .677372E+00, .524788E+00, .406146E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .313774E+00, .241798E+00, .185725E+00, .142087E+00,
     +  .108193E+00, .819481E-01, .617016E-01, .461516E-01,
     +  .342725E-01, .252537E-01, .184410E-01, .133607E-01,
     +  .956205E-02, .676792E-02, .473338E-02, .326832E-02,
     +  .222596E-02, .149392E-02, .987164E-03, .641751E-03,
     +  .410323E-03, .257621E-03, .159805E-03, .973843E-04,
     +  .586972E-04, .351563E-04, .210637E-04, .127057E-04,
     +  .775491E-05, .478463E-05, .294929E-05, .178810E-05,
     +  .103680E-05, .553298E-06, .257472E-06, .946569E-07,
     +  .221641E-07, .165445E-08, .000000E+00, .189162E+07,
     +  .142089E+07, .104769E+07, .772042E+06, .568581E+06,
     +  .418443E+06, .307762E+06, .226191E+06, .166135E+06,
     +  .121932E+06, .894311E+05, .655426E+05, .480026E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .351288E+05, .256900E+05, .187722E+05, .137079E+05,
     +  .100018E+05, .729280E+04, .531340E+04, .386885E+04,
     +  .281497E+04, .204704E+04, .148764E+04, .108065E+04,
     +  .784554E+03, .569635E+03, .411611E+03, .298844E+03,
     +  .217019E+03, .157693E+03, .114679E+03, .834957E+02,
     +  .609451E+02, .445466E+02, .326474E+02, .240052E+02,
     +  .177152E+02, .131288E+02, .977203E+01, .731099E+01,
     +  .549520E+01, .415002E+01, .314812E+01, .239805E+01,
     +  .183284E+01, .140650E+01, .107966E+01, .831404E+00,
     +  .639529E+00, .492312E+00, .378603E+00, .290659E+00,
     +  .222589E+00, .169913E+00, .129191E+00, .977737E-01,
     +  .736086E-01, .550896E-01, .409604E-01, .302376E-01,
     +  .221499E-01, .160800E-01, .115829E-01, .824204E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .580063E-02, .403439E-02, .277069E-02, .187732E-02,
     +  .125385E-02, .824932E-03, .534332E-03, .340753E-03,
     +  .213695E-03, .132670E-03, .811413E-04, .492551E-04,
     +  .298311E-04, .181425E-04, .111383E-04, .691849E-05,
     +  .433092E-05, .269266E-05, .163526E-05, .942943E-06,
     +  .497279E-06, .227185E-06, .814396E-07, .185486E-07,
     +  .140640E-08, .000000E+00, .231776E+07, .173525E+07,
     +  .127448E+07, .935441E+06, .686152E+06, .502916E+06,
     +  .368365E+06, .269600E+06, .197178E+06, .144093E+06,
     +  .105224E+06, .767751E+05, .559764E+05, .407771E+05,
     +  .296824E+05, .215876E+05, .156884E+05, .113913E+05,
     +  .826498E+04, .599155E+04, .434043E+04, .314174E+04,
     +  .227266E+04, .164279E+04, .118687E+04, .856909E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .618685E+03, .444478E+03, .320847E+03, .231636E+03,
     +  .167317E+03, .120949E+03, .875258E+02, .634957E+02,
     +  .461231E+02, .335916E+02, .245438E+02, .179980E+02,
     +  .132534E+02, .980175E+01, .728622E+01, .544141E+01,
     +  .408295E+01, .307733E+01, .232904E+01, .176865E+01,
     +  .134857E+01, .102855E+01, .787017E+00, .601539E+00,
     +  .460149E+00, .351653E+00, .268288E+00, .204188E+00,
     +  .154908E+00, .117063E+00, .880578E-01, .658948E-01,
     +  .490214E-01, .362322E-01, .265895E-01, .193637E-01,
     +  .139754E-01, .100089E-01, .708136E-02, .495574E-02,
     +  .342786E-02, .234165E-02, .157860E-02, .104942E-02,
     +  .687572E-03, .443864E-03, .282430E-03, .176999E-03,
     +  .110041E-03, .675815E-04, .413292E-04, .253044E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .156014E-04, .972227E-05, .612098E-05, .386898E-05,
     +  .241490E-05, .146334E-05, .836825E-06, .435310E-06,
     +  .195048E-06, .681629E-07, .151121E-07, .116336E-08,
     +  .000000E+00, .281300E+07, .209925E+07, .153589E+07,
     +  .112293E+07, .820432E+06, .598938E+06, .436923E+06,
     +  .318466E+06, .231949E+06, .168789E+06, .122731E+06,
     +  .891615E+05, .647212E+05, .469371E+05, .340116E+05,
     +  .246224E+05, .178103E+05, .128707E+05, .929343E+04,
     +  .670416E+04, .483253E+04, .348030E+04, .250466E+04,
     +  .180105E+04, .129433E+04, .929457E+03, .667401E+03,
     +  .476786E+03, .342237E+03, .245674E+03, .176434E+03,
     +  .126795E+03, .912139E+02, .657773E+02, .474920E+02,
     +  .343781E+02, .249644E+02, .181934E+02, .133142E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .978530E+01, .722846E+01, .536437E+01, .399979E+01,
     +  .299565E+01, .225291E+01, .170002E+01, .128809E+01,
     +  .976218E+00, .742289E+00, .563790E+00, .428585E+00,
     +  .325501E+00, .246804E+00, .186684E+00, .140764E+00,
     +  .105729E+00, .790528E-01, .588020E-01, .434843E-01,
     +  .319497E-01, .233091E-01, .168759E-01, .121092E-01,
     +  .862282E-02, .606607E-02, .422159E-02, .290424E-02,
     +  .197362E-02, .132396E-02, .876181E-03, .571834E-03,
     +  .368029E-03, .233753E-03, .146467E-03, .912356E-04,
     +  .562930E-04, .346888E-04, .214619E-04, .133960E-04,
     +  .845199E-05, .537494E-05, .341752E-05, .213409E-05,
     +  .128680E-05, .728398E-06, .373291E-06, .163938E-06,
     +  .558537E-07, .120640E-07, .942578E-09, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .576165E+05, .853521E+05, .661644E+05, .512904E+05,
     +  .397602E+05, .308222E+05, .238935E+05, .185225E+05,
     +  .143589E+05, .111314E+05, .862947E+04, .668999E+04,
     +  .518654E+04, .402107E+04, .311761E+04, .241725E+04,
     +  .187433E+04, .145346E+04, .112719E+04, .874258E+03,
     +  .678176E+03, .526162E+03, .408307E+03, .316933E+03,
     +  .246085E+03, .191148E+03, .148545E+03, .115092E+03,
     +  .895618E+02, .697512E+02, .543743E+02, .424345E+02,
     +  .331591E+02, .259683E+02, .203592E+02, .159932E+02,
     +  .125902E+02, .993349E+01, .785514E+01, .622463E+01,
     +  .494377E+01, .393281E+01, .313265E+01, .249723E+01,
     +  .199107E+01, .158679E+01, .126425E+01, .100399E+01,
     +  .796393E+00, .628773E+00, .494917E+00, .387779E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .302255E+00, .234218E+00, .180320E+00, .137836E+00,
     +  .104542E+00, .786203E-01, .585857E-01, .432251E-01,
     +  .315511E-01, .227635E-01, .162171E-01, .114142E-01,
     +  .789714E-02, .537448E-02, .359176E-02, .235246E-02,
     +  .150645E-02, .940533E-03, .570501E-03, .334722E-03,
     +  .188795E-03, .101490E-03, .517467E-04, .243471E-04,
     +  .102898E-04, .364399E-05, .854116E-06, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .147684E+06,
     +  .115218E+06, .888050E+05, .684436E+05, .527521E+05,
     +  .406558E+05, .313340E+05, .241482E+05, .186107E+05,
     +  .143423E+05, .110531E+05, .851782E+04, .656426E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .505851E+04, .389832E+04, .300411E+04, .231516E+04,
     +  .178418E+04, .137510E+04, .105983E+04, .816953E+03,
     +  .629781E+03, .485589E+03, .374468E+03, .288860E+03,
     +  .222885E+03, .172066E+03, .132405E+03, .102339E+03,
     +  .791536E+02, .612792E+02, .474886E+02, .368482E+02,
     +  .286528E+02, .223045E+02, .173955E+02, .135966E+02,
     +  .106504E+02, .836225E+01, .657940E+01, .518922E+01,
     +  .409965E+01, .324366E+01, .256876E+01, .203523E+01,
     +  .161208E+01, .127702E+01, .100848E+01, .795871E+00,
     +  .625311E+00, .490019E+00, .382386E+00, .296990E+00,
     +  .229424E+00, .176183E+00, .134408E+00, .101809E+00,
     +  .765194E-01, .570386E-01, .421359E-01, .308317E-01,
     +  .223292E-01, .159937E-01, .113400E-01, .792250E-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .545896E-02, .370656E-02, .247658E-02, .162664E-02,
     +  .104812E-02, .661609E-03, .407775E-03, .244763E-03,
     +  .141847E-03, .793861E-04, .416922E-04, .199423E-04,
     +  .783092E-05, .146082E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .196377E+06, .152534E+06,
     +  .116972E+06, .896914E+05, .687733E+05, .527272E+05,
     +  .404249E+05, .309891E+05, .237556E+05, .182083E+05,
     +  .139563E+05, .106959E+05, .819713E+04, .628138E+04,
     +  .481340E+04, .368807E+04, .282591E+04, .216508E+04,
     +  .165886E+04, .127092E+04, .973801E+03, .746132E+03,
     +  .571781E+03, .438199E+03, .335907E+03, .257541E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .197557E+03, .151026E+03, .115972E+03, .891055E+02,
     +  .685259E+02, .527475E+02, .406519E+02, .313949E+02,
     +  .242718E+02, .187992E+02, .145925E+02, .113515E+02,
     +  .885155E+01, .691669E+01, .541854E+01, .425233E+01,
     +  .334258E+01, .263024E+01, .207114E+01, .163072E+01,
     +  .128447E+01, .100877E+01, .792015E+00, .619232E+00,
     +  .483051E+00, .375356E+00, .290413E+00, .223569E+00,
     +  .171173E+00, .130252E+00, .984612E-01, .738937E-01,
     +  .550381E-01, .406548E-01, .297726E-01, .216015E-01,
     +  .155188E-01, .110517E-01, .776851E-02, .539622E-02,
     +  .370308E-02, .250834E-02, .167699E-02, .110538E-02,
     +  .718640E-03, .460259E-03, .290625E-03, .180341E-03,
     +  .110929E-03, .668828E-04, .397768E-04, .232071E-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .132966E-04, .740208E-05, .399524E-05, .204970E-05,
     +  .983202E-06, .421448E-06, .152816E-06, .375954E-07,
     +  .637387E-09, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .256530E+06, .198469E+06, .151502E+06,
     +  .115630E+06, .882471E+05, .673360E+05, .513774E+05,
     +  .391932E+05, .298970E+05, .228011E+05, .173885E+05,
     +  .132581E+05, .101083E+05, .770526E+04, .587326E+04,
     +  .447597E+04, .341102E+04, .259897E+04, .198025E+04,
     +  .150859E+04, .114932E+04, .875531E+03, .667030E+03,
     +  .508168E+03, .387213E+03, .295076E+03, .224970E+03,
     +  .170903E+03, .130414E+03, .995661E+02, .760813E+02,
     +  .581843E+02, .445496E+02, .341789E+02, .262495E+02,
     +  .201956E+02, .155722E+02, .120326E+02, .932039E+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .723484E+01, .563079E+01, .439039E+01, .342927E+01,
     +  .268173E+01, .209901E+01, .164299E+01, .128690E+01,
     +  .100519E+01, .785167E+00, .610865E+00, .474331E+00,
     +  .366986E+00, .282801E+00, .216909E+00, .165525E+00,
     +  .125584E+00, .946922E-01, .709168E-01, .527381E-01,
     +  .389160E-01, .284887E-01, .206774E-01, .148722E-01,
     +  .106135E-01, .748452E-02, .522214E-02, .360513E-02,
     +  .246099E-02, .166177E-02, .110910E-02, .732431E-03,
     +  .478312E-03, .309395E-03, .197859E-03, .126291E-03,
     +  .797787E-04, .503068E-04, .316082E-04, .199025E-04,
     +  .125059E-04, .789273E-05, .495817E-05, .309678E-05,
     +  .189569E-05, .112537E-05, .626338E-06, .314901E-06,
     +  .131824E-06, .367022E-07, .244082E-08, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .210645E+06, .254377E+06, .193359E+06, .146943E+06,
     +  .111658E+06, .848231E+05, .644308E+05, .489278E+05,
     +  .371510E+05, .282011E+05, .214049E+05, .162420E+05,
     +  .123231E+05, .934716E+04, .708915E+04, .537516E+04,
     +  .407521E+04, .308884E+04, .234106E+04, .177389E+04,
     +  .134412E+04, .101828E+04, .771455E+03, .584397E+03,
     +  .442746E+03, .335432E+03, .254239E+03, .191972E+03,
     +  .145609E+03, .110489E+03, .839071E+02, .637690E+02,
     +  .485181E+02, .369876E+02, .282250E+02, .215758E+02,
     +  .165291E+02, .126895E+02, .976593E+01, .753205E+01,
     +  .582493E+01, .451328E+01, .350351E+01, .272323E+01,
     +  .211895E+01, .164909E+01, .128456E+01, .997970E+00,
     +  .775558E+00, .600426E+00, .464060E+00, .357460E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .274325E+00, .209599E+00, .159381E+00, .120531E+00,
     +  .906183E-01, .676934E-01, .502335E-01, .370044E-01,
     +  .270565E-01, .196247E-01, .141138E-01, .100780E-01,
     +  .711636E-02, .497603E-02, .344611E-02, .236254E-02,
     +  .160426E-02, .107833E-02, .718440E-03, .474298E-03,
     +  .310859E-03, .202005E-03, .131374E-03, .848797E-04,
     +  .549473E-04, .355950E-04, .231962E-04, .151446E-04,
     +  .995041E-05, .651258E-05, .422708E-05, .267842E-05,
     +  .163242E-05, .924999E-06, .467995E-06, .194356E-06,
     +  .529059E-07, .362456E-08, .000000E+00, .441745E+06,
     +  .339101E+06, .256513E+06, .193982E+06, .146667E+06,
     +  .110856E+06, .837722E+05, .632841E+05, .477970E+05,
     +  .360876E+05, .272410E+05, .205560E+05, .155082E+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .116959E+05, .881898E+04, .664739E+04, .500957E+04,
     +  .377401E+04, .284269E+04, .214053E+04, .161161E+04,
     +  .121306E+04, .913004E+03, .687033E+03, .516993E+03,
     +  .389003E+03, .292803E+03, .219517E+03, .165315E+03,
     +  .124538E+03, .938857E+02, .708265E+02, .534847E+02,
     +  .404678E+02, .306460E+02, .232477E+02, .176733E+02,
     +  .134638E+02, .102823E+02, .786978E+01, .604004E+01,
     +  .464496E+01, .357912E+01, .276191E+01, .213387E+01,
     +  .164927E+01, .127615E+01, .985020E+00, .760758E+00,
     +  .585450E+00, .449906E+00, .344681E+00, .263159E+00,
     +  .200097E+00, .151464E+00, .114062E+00, .854201E-01,
     +  .635841E-01, .470332E-01, .345495E-01, .252001E-01,
     +  .182414E-01, .130970E-01, .934013E-02, .658882E-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .460386E-02, .318645E-02, .218313E-02, .148087E-02,
     +  .993535E-03, .659649E-03, .432865E-03, .280859E-03,
     +  .179654E-03, .114076E-03, .711594E-04, .438199E-04,
     +  .265164E-04, .157927E-04, .919903E-05, .525919E-05,
     +  .292882E-05, .159342E-05, .839957E-06, .431209E-06,
     +  .210717E-06, .966978E-07, .385660E-07, .106592E-07,
     +  .656041E-09, .000000E+00, .581632E+06, .444725E+06,
     +  .334866E+06, .252055E+06, .189672E+06, .142671E+06,
     +  .107288E+06, .806463E+05, .606030E+05, .455221E+05,
     +  .341839E+05, .256589E+05, .192541E+05, .144418E+05,
     +  .108291E+05, .811659E+04, .608179E+04, .455517E+04,
     +  .341084E+04, .255296E+04, .191042E+04, .142909E+04,
     +  .106884E+04, .799175E+03, .597484E+03, .446608E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .333924E+03, .248629E+03, .185954E+03, .139113E+03,
     +  .104134E+03, .779979E+02, .584749E+02, .439222E+02,
     +  .330172E+02, .248613E+02, .187593E+02, .141846E+02,
     +  .107519E+02, .816807E+01, .622266E+01, .475040E+01,
     +  .363388E+01, .278424E+01, .213611E+01, .163974E+01,
     +  .126038E+01, .966538E+00, .741829E+00, .567427E+00,
     +  .433517E+00, .330271E+00, .250808E+00, .189734E+00,
     +  .142923E+00, .107136E+00, .798862E-01, .592251E-01,
     +  .436446E-01, .319507E-01, .232325E-01, .167714E-01,
     +  .120130E-01, .855024E-02, .602218E-02, .420345E-02,
     +  .290773E-02, .199235E-02, .135250E-02, .908900E-03,
     +  .605048E-03, .398621E-03, .260075E-03, .167726E-03,
     +  .107688E-03, .682489E-04, .429542E-04, .268032E-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .166432E-04, .102606E-04, .631317E-05, .385811E-05,
     +  .233934E-05, .139202E-05, .803162E-06, .434488E-06,
     +  .211549E-06, .845284E-07, .220560E-07, .151507E-08,
     +  .000000E+00, .754578E+06, .574789E+06, .430890E+06,
     +  .322881E+06, .241865E+06, .181091E+06, .135541E+06,
     +  .101399E+06, .758291E+05, .566794E+05, .423498E+05,
     +  .316271E+05, .236102E+05, .176165E+05, .131393E+05,
     +  .979493E+04, .729905E+04, .543637E+04, .404757E+04,
     +  .301208E+04, .224079E+04, .166624E+04, .123867E+04,
     +  .920466E+03, .683867E+03, .507931E+03, .377330E+03,
     +  .279087E+03, .207349E+03, .154077E+03, .114549E+03,
     +  .852069E+02, .634326E+02, .473106E+02, .353105E+02,
     +  .263971E+02, .197741E+02, .148435E+02, .111696E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .842383E+01, .637115E+01, .482891E+01, .366771E+01,
     +  .279050E+01, .212618E+01, .162109E+01, .123784E+01,
     +  .943127E+00, .719339E+00, .546871E+00, .415353E+00,
     +  .314636E+00, .237625E+00, .178815E+00, .134016E+00,
     +  .999735E-01, .742011E-01, .547697E-01, .401941E-01,
     +  .293106E-01, .212356E-01, .152790E-01, .109105E-01,
     +  .774417E-02, .544110E-02, .379005E-02, .261746E-02,
     +  .179142E-02, .121538E-02, .816882E-03, .544339E-03,
     +  .359409E-03, .235342E-03, .152678E-03, .988544E-04,
     +  .634280E-04, .405979E-04, .259190E-04, .165702E-04,
     +  .105926E-04, .679290E-05, .434218E-05, .274988E-05,
     +  .170196E-05, .101120E-05, .557284E-06, .272319E-06,
     +  .107534E-06, .273984E-07, .193802E-08, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .966084E+06, .733224E+06, .547310E+06, .408341E+06,
     +  .304535E+06, .226996E+06, .169128E+06, .125943E+06,
     +  .937437E+05, .697371E+05, .518548E+05, .385357E+05,
     +  .286244E+05, .212497E+05, .157676E+05, .116929E+05,
     +  .866708E+04, .642046E+04, .475405E+04, .351810E+04,
     +  .260241E+04, .192400E+04, .142192E+04, .105035E+04,
     +  .775650E+03, .572556E+03, .422686E+03, .310627E+03,
     +  .229299E+03, .169277E+03, .125017E+03, .923715E+02,
     +  .682996E+02, .505922E+02, .374979E+02, .278366E+02,
     +  .207055E+02, .154329E+02, .115308E+02, .863464E+01,
     +  .648446E+01, .488027E+01, .368088E+01, .278125E+01,
     +  .210474E+01, .159402E+01, .120922E+01, .915394E+00,
     +  .693827E+00, .524252E+00, .395811E+00, .298109E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .223887E+00, .167569E+00, .124933E+00, .927289E-01,
     +  .684911E-01, .503208E-01, .367651E-01, .266970E-01,
     +  .192646E-01, .138088E-01, .982560E-02, .695113E-02,
     +  .486903E-02, .338236E-02, .233040E-02, .159191E-02,
     +  .107851E-02, .724374E-03, .482746E-03, .319135E-03,
     +  .209528E-03, .136585E-03, .890587E-04, .577383E-04,
     +  .374719E-04, .243583E-04, .159111E-04, .104248E-04,
     +  .685538E-05, .448879E-05, .289888E-05, .181963E-05,
     +  .108777E-05, .598654E-06, .289418E-06, .111925E-06,
     +  .277495E-07, .200266E-08, .000000E+00, .122200E+07,
     +  .924175E+06, .686969E+06, .510376E+06, .379001E+06,
     +  .281274E+06, .208645E+06, .154674E+06, .114606E+06,
     +  .848631E+05, .628063E+05, .464521E+05, .343378E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .253660E+05, .187280E+05, .138178E+05, .101894E+05,
     +  .750864E+04, .553020E+04, .407035E+04, .299436E+04,
     +  .220141E+04, .161769E+04, .118807E+04, .872205E+03,
     +  .639983E+03, .469603E+03, .342954E+03, .251582E+03,
     +  .184552E+03, .135423E+03, .994093E+02, .730183E+02,
     +  .537278E+02, .395534E+02, .291628E+02, .215432E+02,
     +  .159466E+02, .118322E+02, .879902E+01, .656223E+01,
     +  .490479E+01, .367405E+01, .275728E+01, .207262E+01,
     +  .155932E+01, .117524E+01, .883978E+00, .665842E+00,
     +  .500028E+00, .375274E+00, .281003E+00, .209848E+00,
     +  .156200E+00, .115836E+00, .855325E-01, .628597E-01,
     +  .459606E-01, .334230E-01, .241617E-01, .173604E-01,
     +  .123931E-01, .878393E-02, .619135E-02, .432185E-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .299280E-02, .205621E-02, .140127E-02, .947573E-03,
     +  .635681E-03, .423493E-03, .280188E-03, .184377E-03,
     +  .120709E-03, .792131E-04, .518352E-04, .340490E-04,
     +  .224658E-04, .149216E-04, .995008E-05, .664945E-05,
     +  .441310E-05, .287475E-05, .181099E-05, .107965E-05,
     +  .589119E-06, .280364E-06, .105859E-06, .255100E-07,
     +  .187353E-08, .000000E+00, .152841E+07, .115193E+07,
     +  .852776E+06, .630948E+06, .466576E+06, .344799E+06,
     +  .254665E+06, .187966E+06, .138656E+06, .102210E+06,
     +  .752990E+05, .554336E+05, .407840E+05, .299838E+05,
     +  .220298E+05, .161737E+05, .118669E+05, .870025E+04,
     +  .637467E+04, .466722E+04, .341509E+04, .249708E+04,
     +  .182483E+04, .133267E+04, .972784E+03, .709635E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .517645E+03, .375747E+03, .273966E+03, .199735E+03,
     +  .145648E+03, .106239E+03, .775340E+02, .566812E+02,
     +  .414535E+02, .303613E+02, .222786E+02, .163801E+02,
     +  .120718E+02, .891640E+01, .660475E+01, .490324E+01,
     +  .364819E+01, .271961E+01, .203079E+01, .151787E+01,
     +  .113666E+01, .849528E+00, .635923E+00, .474641E+00,
     +  .354096E+00, .263601E+00, .195733E+00, .144885E+00,
     +  .106862E+00, .784911E-01, .573894E-01, .417526E-01,
     +  .302166E-01, .217422E-01, .155519E-01, .110544E-01,
     +  .780263E-02, .547806E-02, .380972E-02, .262913E-02,
     +  .180079E-02, .122397E-02, .825935E-03, .553316E-03,
     +  .368438E-03, .243934E-03, .160877E-03, .105765E-03,
     +  .698354E-04, .460961E-04, .306071E-04, .204510E-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .137633E-04, .929554E-05, .627636E-05, .419545E-05,
     +  .273994E-05, .172274E-05, .101972E-05, .549757E-06,
     +  .256948E-06, .946102E-07, .221624E-07, .165444E-08,
     +  .000000E+00, .189156E+07, .142083E+07, .104765E+07,
     +  .771999E+06, .568542E+06, .418409E+06, .307731E+06,
     +  .226164E+06, .166110E+06, .121910E+06, .894113E+05,
     +  .655249E+05, .479868E+05, .351146E+05, .256773E+05,
     +  .187609E+05, .136978E+05, .999275E+04, .728474E+04,
     +  .530619E+04, .386241E+04, .280921E+04, .204189E+04,
     +  .148304E+04, .107653E+04, .780874E+03, .566343E+03,
     +  .408669E+03, .296210E+03, .214659E+03, .155579E+03,
     +  .112784E+03, .817958E+02, .594198E+02, .431782E+02,
     +  .314202E+02, .229053E+02, .167304E+02, .122485E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .898705E+01, .661294E+01, .487679E+01, .360454E+01,
     +  .266943E+01, .198034E+01, .147059E+01, .109426E+01,
     +  .812687E+00, .604591E+00, .448506E+00, .332604E+00,
     +  .246157E+00, .181735E+00, .133772E+00, .981258E-01,
     +  .716894E-01, .521435E-01, .377440E-01, .271808E-01,
     +  .194645E-01, .138583E-01, .980678E-02, .689226E-02,
     +  .481910E-02, .333844E-02, .229567E-02, .156734E-02,
     +  .106237E-02, .715330E-03, .478550E-03, .318509E-03,
     +  .211045E-03, .139516E-03, .921123E-04, .611906E-04,
     +  .407214E-04, .273019E-04, .184383E-04, .125380E-04,
     +  .854532E-05, .580566E-05, .389221E-05, .253856E-05,
     +  .158773E-05, .930681E-06, .494771E-06, .226819E-06,
     +  .814073E-07, .185475E-07, .140640E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .231770E+07, .173520E+07, .127443E+07, .935394E+06,
     +  .686111E+06, .502878E+06, .368331E+06, .269570E+06,
     +  .197151E+06, .144069E+06, .105202E+06, .767561E+05,
     +  .559594E+05, .407620E+05, .296689E+05, .215755E+05,
     +  .156776E+05, .113816E+05, .825637E+04, .598386E+04,
     +  .433356E+04, .313562E+04, .226720E+04, .163791E+04,
     +  .118251E+04, .853015E+03, .615207E+03, .441377E+03,
     +  .318076E+03, .229160E+03, .165105E+03, .118971E+03,
     +  .857579E+02, .619152E+02, .447109E+02, .323306E+02,
     +  .234189E+02, .169960E+02, .123627E+02, .901204E+01,
     +  .658825E+01, .482701E+01, .354459E+01, .260807E+01,
     +  .192238E+01, .141845E+01, .104883E+01, .774074E+00,
     +  .572334E+00, .422002E+00, .311088E+00, .228891E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .168020E+00, .122982E+00, .897147E-01, .651917E-01,
     +  .471681E-01, .339675E-01, .243388E-01, .173447E-01,
     +  .122909E-01, .865809E-02, .605823E-02, .421823E-02,
     +  .291062E-02, .199421E-02, .135710E-02, .917349E-03,
     +  .616370E-03, .411817E-03, .274015E-03, .181750E-03,
     +  .120462E-03, .798819E-04, .533861E-04, .358027E-04,
     +  .242133E-04, .164994E-04, .113093E-04, .775558E-05,
     +  .528549E-05, .354313E-05, .230174E-05, .142886E-05,
     +  .828045E-06, .433538E-06, .194793E-06, .681407E-07,
     +  .151113E-07, .116335E-08, .000000E+00, .281293E+07,
     +  .209918E+07, .153583E+07, .112288E+07, .820387E+06,
     +  .598898E+06, .436887E+06, .318434E+06, .231921E+06,
     +  .168764E+06, .122709E+06, .891411E+05, .647030E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .469209E+05, .339971E+05, .246095E+05, .177988E+05,
     +  .128604E+05, .928425E+04, .669598E+04, .482524E+04,
     +  .347379E+04, .249886E+04, .179588E+04, .128972E+04,
     +  .925346E+03, .663737E+03, .473525E+03, .339330E+03,
     +  .243083E+03, .174124E+03, .124737E+03, .893806E+02,
     +  .641443E+02, .460388E+02, .330862E+02, .238174E+02,
     +  .171769E+02, .124155E+02, .899316E+01, .653260E+01,
     +  .475570E+01, .346995E+01, .253691E+01, .185809E+01,
     +  .136237E+01, .100110E+01, .734272E+00, .539602E+00,
     +  .395467E+00, .289802E+00, .211988E+00, .154721E+00,
     +  .112612E+00, .816966E-01, .590445E-01, .424945E-01,
     +  .304439E-01, .217040E-01, .153912E-01, .108547E-01,
     +  .761126E-02, .530211E-02, .367620E-02, .252654E-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .172478E-02, .116999E-02, .788768E-03, .528928E-03,
     +  .353009E-03, .234879E-03, .155996E-03, .103690E-03,
     +  .690715E-04, .464356E-04, .313665E-04, .213760E-04,
     +  .146731E-04, .101169E-04, .696392E-05, .474920E-05,
     +  .317609E-05, .205121E-05, .126185E-05, .722125E-06,
     +  .372042E-06, .163760E-06, .558384E-07, .120635E-07,
     +  .942574E-09, .000000E+00, .190745E+07, .147681E+07,
     +  .112838E+07, .862165E+06, .658759E+06, .503345E+06,
     +  .384599E+06, .293870E+06, .224547E+06, .171580E+06,
     +  .131109E+06, .100187E+06, .765598E+05, .585066E+05,
     +  .447124E+05, .341723E+05, .261184E+05, .199643E+05,
     +  .152617E+05, .116682E+05, .892204E+04, .682341E+04,
     +  .521954E+04, .399370E+04, .305674E+04, .234050E+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .179293E+04, .136909E+04, .105025E+04, .806337E+03,
     +  .619702E+03, .476849E+03, .367465E+03, .283891E+03,
     +  .219654E+03, .170400E+03, .132597E+03, .103545E+03,
     +  .811842E+02, .639311E+02, .506060E+02, .402669E+02,
     +  .322205E+02, .259327E+02, .209967E+02, .171024E+02,
     +  .140233E+02, .115503E+02, .957616E+01, .797055E+01,
     +  .666927E+01, .560336E+01, .472457E+01, .399541E+01,
     +  .338670E+01, .287564E+01, .244432E+01, .207859E+01,
     +  .176721E+01, .150122E+01, .127337E+01, .107780E+01,
     +  .909727E+00, .765816E+00, .641329E+00, .534466E+00,
     +  .442905E+00, .364666E+00, .298053E+00, .241595E+00,
     +  .194006E+00, .154157E+00, .121025E+00, .937015E-01,
     +  .716017E-01, .536771E-01, .394510E-01, .283388E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .198199E-01, .134321E-01, .876684E-02, .547124E-02,
     +  .321881E-02, .176617E-02, .882015E-03, .387329E-03,
     +  .141182E-03, .383336E-04, .608072E-05, .259063E-06,
     +  .000000E+00, .285319E+07, .220459E+07, .168029E+07,
     +  .128029E+07, .975526E+06, .743078E+06, .566021E+06,
     +  .431012E+06, .328204E+06, .249833E+06, .190174E+06,
     +  .144709E+06, .110111E+06, .837548E+05, .637049E+05,
     +  .484368E+05, .368267E+05, .279892E+05, .212720E+05,
     +  .161610E+05, .122780E+05, .932493E+04, .708241E+04,
     +  .537776E+04, .408389E+04, .310068E+04, .235482E+04,
     +  .178155E+04, .135384E+04, .102910E+04, .782870E+03,
     +  .595965E+03, .454249E+03, .346945E+03, .265337E+03,
     +  .203375E+03, .156346E+03, .120579E+03, .933687E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .726001E+02, .567490E+02, .445848E+02, .352299E+02,
     +  .279998E+02, .223903E+02, .180119E+02, .145895E+02,
     +  .118697E+02, .972249E+01, .799460E+01, .660937E+01,
     +  .548669E+01, .457111E+01, .381963E+01, .319921E+01,
     +  .268415E+01, .225441E+01, .189429E+01, .159131E+01,
     +  .133566E+01, .111937E+01, .936131E+00, .780593E+00,
     +  .649174E+00, .536982E+00, .441992E+00, .361700E+00,
     +  .294056E+00, .237263E+00, .189823E+00, .150407E+00,
     +  .117895E+00, .912796E-01, .696633E-01, .524528E-01,
     +  .387241E-01, .280084E-01, .197866E-01, .135963E-01,
     +  .904518E-02, .578618E-02, .353513E-02, .203142E-02,
     +  .108656E-02, .527177E-03, .224156E-03, .786628E-04,
     +  .204559E-04, .312034E-05, .135904E-06, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .411326E+07, .316919E+07, .240738E+07, .182784E+07,
     +  .138772E+07, .105306E+07, .799042E+06, .605986E+06,
     +  .459525E+06, .348275E+06, .263924E+06, .199890E+06,
     +  .151369E+06, .114559E+06, .866851E+05, .655535E+05,
     +  .495638E+05, .374508E+05, .282927E+05, .213604E+05,
     +  .161237E+05, .121631E+05, .917400E+04, .691544E+04,
     +  .521238E+04, .392649E+04, .295802E+04, .221895E+04,
     +  .167170E+04, .125935E+04, .949213E+03, .715717E+03,
     +  .540199E+03, .408450E+03, .309170E+03, .234480E+03,
     +  .178337E+03, .136048E+03, .104196E+03, .801243E+02,
     +  .619383E+02, .481214E+02, .376034E+02, .295553E+02,
     +  .233740E+02, .185960E+02, .148984E+02, .119880E+02,
     +  .971264E+01, .789928E+01, .645952E+01, .530393E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .437069E+01, .361227E+01, .299239E+01, .248306E+01,
     +  .206251E+01, .171387E+01, .142373E+01, .118166E+01,
     +  .979184E+00, .809672E+00, .667444E+00, .548729E+00,
     +  .448620E+00, .364930E+00, .295085E+00, .237009E+00,
     +  .188889E+00, .149236E+00, .116737E+00, .903091E-01,
     +  .689879E-01, .519222E-01, .385387E-01, .280303E-01,
     +  .199596E-01, .138723E-01, .936895E-02, .612017E-02,
     +  .383851E-02, .229635E-02, .128921E-02, .672262E-03,
     +  .316921E-03, .130463E-03, .440755E-04, .109769E-04,
     +  .160922E-05, .711717E-07, .000000E+00, .573949E+07,
     +  .440812E+07, .333603E+07, .252322E+07, .190812E+07,
     +  .144211E+07, .108969E+07, .822879E+06, .621253E+06,
     +  .468719E+06, .353544E+06, .266484E+06, .200804E+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .151201E+06, .113814E+06, .856055E+05, .643661E+05,
     +  .483576E+05, .363173E+05, .272524E+05, .204425E+05,
     +  .153215E+05, .114793E+05, .859378E+04, .643154E+04,
     +  .480934E+04, .359584E+04, .267618E+04, .200004E+04,
     +  .149429E+04, .111676E+04, .834725E+03, .624398E+03,
     +  .467808E+03, .350794E+03, .263516E+03, .198482E+03,
     +  .149931E+03, .113692E+03, .865528E+02, .662363E+02,
     +  .509425E+02, .394065E+02, .306602E+02, .240037E+02,
     +  .189046E+02, .149939E+02, .119430E+02, .957919E+01,
     +  .771207E+01, .624280E+01, .507414E+01, .413885E+01,
     +  .338579E+01, .277601E+01, .227979E+01, .187404E+01,
     +  .154102E+01, .126671E+01, .104024E+01, .852828E+00,
     +  .697648E+00, .568865E+00, .462593E+00, .374008E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .300828E+00, .240485E+00, .190927E+00, .150374E+00,
     +  .117384E+00, .906947E-01, .692830E-01, .522456E-01,
     +  .387975E-01, .284027E-01, .203628E-01, .142832E-01,
     +  .977195E-02, .649078E-02, .416595E-02, .256371E-02,
     +  .150289E-02, .825104E-03, .419867E-03, .192574E-03,
     +  .768648E-04, .250550E-04, .599498E-05, .847055E-06,
     +  .375657E-07, .000000E+00, .778800E+07, .596167E+07,
     +  .449429E+07, .338586E+07, .255010E+07, .191933E+07,
     +  .144414E+07, .108581E+07, .816116E+06, .612940E+06,
     +  .460170E+06, .345198E+06, .258842E+06, .193925E+06,
     +  .145222E+06, .108653E+06, .812523E+05, .607050E+05,
     +  .453299E+05, .338162E+05, .252133E+05, .187804E+05,
     +  .139813E+05, .103985E+05, .772984E+04, .574014E+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .426132E+04, .314803E+04, .233504E+04, .173117E+04,
     +  .128358E+04, .951665E+03, .705971E+03, .524461E+03,
     +  .389877E+03, .290302E+03, .216703E+03, .162215E+03,
     +  .121880E+03, .919310E+02, .696993E+02, .531067E+02,
     +  .406967E+02, .313680E+02, .243278E+02, .189801E+02,
     +  .149130E+02, .117666E+02, .934900E+01, .745544E+01,
     +  .597781E+01, .481248E+01, .388780E+01, .314979E+01,
     +  .255746E+01, .207981E+01, .169283E+01, .137822E+01,
     +  .112158E+01, .911790E+00, .739935E+00, .599107E+00,
     +  .483449E+00, .389035E+00, .311195E+00, .247613E+00,
     +  .195782E+00, .153711E+00, .119694E+00, .923560E-01,
     +  .705143E-01, .532156E-01, .396314E-01, .290514E-01,
     +  .209866E-01, .148382E-01, .102580E-01, .691207E-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .451803E-02, .285084E-02, .172261E-02, .990262E-03,
     +  .532120E-03, .264501E-03, .118177E-03, .458045E-04,
     +  .144368E-04, .332828E-05, .454231E-06, .198706E-07,
     +  .000000E+00, .107627E+08, .820595E+07, .615731E+07,
     +  .461676E+07, .346028E+07, .259154E+07, .194005E+07,
     +  .145118E+07, .108498E+07, .810501E+06, .605140E+06,
     +  .451408E+06, .336536E+06, .250658E+06, .186578E+06,
     +  .138741E+06, .103100E+06, .765334E+05, .567725E+05,
     +  .420674E+05, .311483E+05, .230372E+05, .170258E+05,
     +  .125687E+05, .927166E+04, .683108E+04, .503048E+04,
     +  .368525E+04, .271043E+04, .199214E+04, .146397E+04,
     +  .107560E+04, .790504E+03, .581728E+03, .428271E+03,
     +  .315764E+03, .233358E+03, .172920E+03, .128596E+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .959973E+02, .720266E+02, .543081E+02, .411808E+02,
     +  .314078E+02, .241018E+02, .186049E+02, .144637E+02,
     +  .112901E+02, .887475E+01, .700100E+01, .555275E+01,
     +  .442169E+01, .353296E+01, .283074E+01, .227284E+01,
     +  .182763E+01, .147075E+01, .118377E+01, .952246E+00,
     +  .765152E+00, .613664E+00, .490998E+00, .391464E+00,
     +  .311214E+00, .245885E+00, .193210E+00, .150836E+00,
     +  .116901E+00, .898382E-01, .683933E-01, .515053E-01,
     +  .383264E-01, .281335E-01, .203167E-01, .144529E-01,
     +  .100561E-01, .683685E-02, .452704E-02, .290519E-02,
     +  .179785E-02, .106403E-02, .598258E-03, .313818E-03,
     +  .151954E-03, .659557E-04, .247558E-04, .752727E-05,
     +  .166872E-05, .219351E-06, .916947E-08, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .145702E+08, .110639E+08, .826219E+07, .616507E+07,
     +  .459792E+07, .342632E+07, .255184E+07, .189889E+07,
     +  .141217E+07, .104923E+07, .779054E+06, .577882E+06,
     +  .428354E+06, .317184E+06, .234687E+06, .173454E+06,
     +  .128093E+06, .944840E+05, .696329E+05, .512553E+05,
     +  .376938E+05, .276853E+05, .203157E+05, .148887E+05,
     +  .109014E+05, .797067E+04, .582402E+04, .423216E+04,
     +  .308729E+04, .225025E+04, .163955E+04, .119413E+04,
     +  .869802E+03, .634302E+03, .462658E+03, .337919E+03,
     +  .247348E+03, .181519E+03, .133672E+03, .988044E+02,
     +  .733969E+02, .547893E+02, .411285E+02, .310522E+02,
     +  .235879E+02, .180233E+02, .138691E+02, .107147E+02,
     +  .833591E+01, .650763E+01, .510760E+01, .402453E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .318158E+01, .252202E+01, .200316E+01, .159330E+01,
     +  .126812E+01, .100940E+01, .802914E+00, .637890E+00,
     +  .505774E+00, .400020E+00, .315206E+00, .247641E+00,
     +  .193311E+00, .150050E+00, .115693E+00, .885358E-01,
     +  .671666E-01, .504632E-01, .374926E-01, .275155E-01,
     +  .199123E-01, .141690E-01, .992785E-02, .679901E-02,
     +  .454665E-02, .295888E-02, .186451E-02, .113174E-02,
     +  .656107E-03, .360835E-03, .184775E-03, .871534E-04,
     +  .367480E-04, .133547E-04, .391651E-05, .834303E-06,
     +  .105255E-06, .400026E-08, .000000E+00, .193324E+08,
     +  .146209E+08, .108666E+08, .806938E+07, .598860E+07,
     +  .444042E+07, .329032E+07, .243581E+07, .180194E+07,
     +  .133169E+07, .983399E+06, .725428E+06, .534685E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .393649E+06, .289556E+06, .212732E+06, .156141E+06,
     +  .114459E+06, .838186E+05, .612985E+05, .447816E+05,
     +  .326696E+05, .238078E+05, .173252E+05, .125939E+05,
     +  .914016E+04, .662825E+04, .477899E+04, .345874E+04,
     +  .250076E+04, .180708E+04, .130514E+04, .942507E+03,
     +  .681350E+03, .492556E+03, .356512E+03, .258565E+03,
     +  .187992E+03, .137139E+03, .100407E+03, .738754E+02,
     +  .546171E+02, .406028E+02, .303579E+02, .228355E+02,
     +  .172773E+02, .131646E+02, .100694E+02, .775612E+01,
     +  .599417E+01, .465716E+01, .363234E+01, .284214E+01,
     +  .222970E+01, .175254E+01, .137933E+01, .108619E+01,
     +  .855337E+00, .673024E+00, .528873E+00, .414720E+00,
     +  .324358E+00, .252704E+00, .196281E+00, .151444E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .116172E+00, .885025E-01, .669058E-01, .501294E-01,
     +  .371873E-01, .272724E-01, .197501E-01, .140986E-01,
     +  .989117E-02, .683058E-02, .460753E-02, .303297E-02,
     +  .194156E-02, .120248E-02, .716681E-03, .407499E-03,
     +  .219522E-03, .109928E-03, .506117E-04, .207844E-04,
     +  .733710E-05, .208421E-05, .428748E-06, .520057E-07,
     +  .165751E-08, .000000E+00, .251722E+08, .189620E+08,
     +  .140268E+08, .103666E+08, .765620E+07, .564907E+07,
     +  .416501E+07, .306772E+07, .225769E+07, .165976E+07,
     +  .121913E+07, .894446E+06, .655617E+06, .479974E+06,
     +  .351030E+06, .256395E+06, .187070E+06, .136302E+06,
     +  .991976E+05, .720895E+05, .523263E+05, .379238E+05,
     +  .274516E+05, .198404E+05, .143214E+05, .103196E+05 /
        DATA (UPDI(I),I=7125,7176) /
     +  .742897E+04, .531589E+04, .381802E+04, .273911E+04,
     +  .196360E+04, .140672E+04, .100746E+04, .722204E+03,
     +  .517614E+03, .371392E+03, .266976E+03, .192372E+03,
     +  .139063E+03, .100887E+03, .735443E+02, .538684E+02,
     +  .396722E+02, .293840E+02, .218944E+02, .164082E+02,
     +  .123837E+02, .938102E+01, .715649E+01, .547700E+01,
     +  .421381E+01, .325427E+01, .252110E+01, .195812E+01,
     +  .152360E+01, .118698E+01, .925162E+00, .721024E+00,
     +  .561437E+00, .436556E+00, .338702E+00, .262069E+00,
     +  .201962E+00, .155157E+00, .118383E+00, .897881E-01,
     +  .676210E-01, .505262E-01, .374095E-01, .274171E-01,
     +  .198599E-01, .142012E-01, .100069E-01, .692712E-02,
     +  .471859E-02, .313785E-02, .203524E-02, .128298E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .781935E-03, .458239E-03, .255955E-03, .135313E-03,
     +  .664098E-04, .299248E-04, .120082E-04, .413430E-05,
     +  .114335E-05, .228441E-06, .266987E-07, .622752E-09,
     +  .000000E+00, .322065E+08, .241667E+08, .177943E+08,
     +  .130896E+08, .962131E+07, .706486E+07, .518333E+07,
     +  .379882E+07, .278161E+07, .203445E+07, .148654E+07,
     +  .108487E+07, .790901E+06, .575842E+06, .418790E+06,
     +  .304151E+06, .220628E+06, .159806E+06, .115604E+06,
     +  .834990E+05, .602291E+05, .433737E+05, .311925E+05,
     +  .223946E+05, .160555E+05, .114889E+05, .821236E+04,
     +  .583349E+04, .415891E+04, .296127E+04, .210656E+04,
     +  .149734E+04, .106379E+04, .756405E+03, .537636E+03,
     +  .382517E+03, .272625E+03, .194746E+03, .139547E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .100344E+03, .724971E+02, .526253E+02, .384065E+02,
     +  .281884E+02, .208118E+02, .154537E+02, .115561E+02,
     +  .867261E+01, .655456E+01, .496915E+01, .378702E+01,
     +  .289691E+01, .222280E+01, .170982E+01, .131751E+01,
     +  .101640E+01, .784417E+00, .605278E+00, .466604E+00,
     +  .359166E+00, .275832E+00, .211239E+00, .161106E+00,
     +  .122481E+00, .924626E-01, .693773E-01, .516826E-01,
     +  .381922E-01, .279616E-01, .202600E-01, .145058E-01,
     +  .102503E-01, .713577E-02, .487838E-02, .328107E-02,
     +  .215337E-02, .137787E-02, .856474E-03, .514442E-03,
     +  .296937E-03, .163250E-03, .848828E-04, .409370E-04,
     +  .181098E-04, .712748E-05, .240403E-05, .650757E-06,
     +  .127029E-06, .143432E-07, .184260E-09, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .405421E+08, .303060E+08, .222139E+08, .162659E+08,
     +  .119003E+08, .869712E+07, .635030E+07, .463149E+07,
     +  .337456E+07, .245578E+07, .178524E+07, .129613E+07,
     +  .939938E+06, .680698E+06, .492352E+06, .355599E+06,
     +  .256492E+06, .184719E+06, .132845E+06, .953806E+05,
     +  .683817E+05, .489403E+05, .349734E+05, .249476E+05,
     +  .177681E+05, .126289E+05, .896540E+04, .632325E+04,
     +  .447589E+04, .316379E+04, .223389E+04, .157583E+04,
     +  .111090E+04, .783701E+03, .552572E+03, .389947E+03,
     +  .275624E+03, .195241E+03, .138718E+03, .988948E+02,
     +  .708340E+02, .509716E+02, .368742E+02, .268259E+02,
     +  .196308E+02, .144471E+02, .107073E+02, .796326E+01,
     +  .596436E+01, .448062E+01, .338362E+01, .256464E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .194974E+01, .148589E+01, .113430E+01, .866878E+00,
     +  .662718E+00, .506527E+00, .386756E+00, .294848E+00,
     +  .224251E+00, .170069E+00, .128434E+00, .966803E-01,
     +  .722564E-01, .536691E-01, .395735E-01, .289425E-01,
     +  .209686E-01, .150324E-01, .106475E-01, .744178E-02,
     +  .512315E-02, .346267E-02, .230210E-02, .149298E-02,
     +  .943725E-03, .579304E-03, .343505E-03, .195653E-03,
     +  .106102E-03, .543913E-04, .258490E-04, .112625E-04,
     +  .436371E-05, .144812E-05, .385580E-06, .739156E-07,
     +  .808862E-08, .117789E-10, .000000E+00, .502714E+08,
     +  .374397E+08, .273213E+08, .199160E+08, .145044E+08,
     +  .105514E+08, .766814E+07, .556610E+07, .403595E+07,
     +  .292274E+07, .211413E+07, .152716E+07, .110180E+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .793758E+06, .571081E+06, .410238E+06, .294278E+06,
     +  .210749E+06, .150702E+06, .107575E+06, .766690E+05,
     +  .545417E+05, .387370E+05, .274595E+05, .194321E+05,
     +  .137214E+05, .967622E+04, .677765E+04, .476431E+04,
     +  .334390E+04, .234404E+04, .164140E+04, .114844E+04,
     +  .804031E+03, .562504E+03, .393827E+03, .276139E+03,
     +  .194021E+03, .136721E+03, .966636E+02, .686577E+02,
     +  .489900E+02, .351404E+02, .253469E+02, .183899E+02,
     +  .134175E+02, .985867E+01, .726833E+01, .539666E+01,
     +  .401863E+01, .300814E+01, .225998E+01, .170295E+01,
     +  .128631E+01, .973200E+00, .737110E+00, .558455E+00,
     +  .422992E+00, .320053E+00, .241780E+00, .182212E+00,
     +  .136921E+00, .102448E+00, .764071E-01, .565715E-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .416240E-01, .304015E-01, .220223E-01, .158015E-01,
     +  .112181E-01, .786784E-02, .544438E-02, .371041E-02,
     +  .248217E-02, .163325E-02, .104805E-02, .655404E-03,
     +  .397938E-03, .233348E-03, .131406E-03, .704401E-04,
     +  .356852E-04, .167556E-04, .721114E-05, .275944E-05,
     +  .904123E-06, .237664E-06, .449087E-07, .477902E-08,
     +  .000000E+00, .000000E+00, .614688E+08, .456138E+08,
     +  .331419E+08, .240531E+08, .174393E+08, .126293E+08,
     +  .913615E+07, .660095E+07, .476375E+07, .343332E+07,
     +  .247139E+07, .177645E+07, .127522E+07, .914031E+06,
     +  .654210E+06, .467486E+06, .333549E+06, .237575E+06,
     +  .168943E+06, .119917E+06, .849737E+05, .600961E+05,
     +  .424271E+05, .298924E+05, .210224E+05, .147501E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .103345E+05, .719036E+04, .502044E+04, .349953E+04,
     +  .243598E+04, .169364E+04, .117637E+04, .817512E+03,
     +  .567629E+03, .394379E+03, .274380E+03, .191272E+03,
     +  .133712E+03, .937780E+02, .660693E+02, .467590E+02,
     +  .332651E+02, .237967E+02, .171223E+02, .123888E+02,
     +  .902731E+01, .659960E+01, .485922E+01, .358795E+01,
     +  .266317E+01, .198395E+01, .148232E+01, .111019E+01,
     +  .832831E+00, .625437E+00, .469820E+00, .352827E+00,
     +  .264686E+00, .198246E+00, .148127E+00, .110354E+00,
     +  .818602E-01, .605291E-01, .444280E-01, .324056E-01,
     +  .234627E-01, .168475E-01, .119825E-01, .843185E-02,
     +  .586133E-02, .401972E-02, .271489E-02, .179971E-02,
     +  .117345E-02, .746061E-03, .462219E-03, .278008E-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .161478E-03, .900624E-04, .478119E-04, .239848E-04,
     +  .111504E-04, .475068E-05, .179952E-05, .583445E-06,
     +  .151730E-06, .283175E-07, .294002E-08, .000000E+00,
     +  .000000E+00, .741873E+08, .548582E+08, .396896E+08,
     +  .286815E+08, .207045E+08, .149278E+08, .107506E+08,
     +  .773218E+07, .555444E+07, .398451E+07, .285456E+07,
     +  .204201E+07, .145869E+07, .104035E+07, .740863E+06,
     +  .526695E+06, .373835E+06, .264858E+06, .187327E+06,
     +  .132237E+06, .931792E+05, .655241E+05, .459906E+05,
     +  .322113E+05, .225164E+05, .157007E+05, .109315E+05,
     +  .755638E+04, .524154E+04, .362934E+04, .250918E+04,
     +  .173247E+04, .119485E+04, .824414E+03, .568240E+03,
     +  .391879E+03, .270590E+03, .187194E+03, .129854E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .903642E+02, .631656E+02, .443516E+02, .313023E+02,
     +  .222143E+02, .158561E+02, .113807E+02, .822646E+01,
     +  .596561E+01, .435722E+01, .319132E+01, .234971E+01,
     +  .173635E+01, .128690E+01, .956080E+00, .711465E+00,
     +  .530008E+00, .394945E+00, .294224E+00, .218960E+00,
     +  .162690E+00, .120592E+00, .891266E-01, .655882E-01,
     +  .481140E-01, .350351E-01, .253518E-01, .182102E-01,
     +  .129723E-01, .915332E-02, .638999E-02, .440676E-02,
     +  .299817E-02, .200885E-02, .132103E-02, .854497E-03,
     +  .538916E-03, .331198E-03, .197594E-03, .113839E-03,
     +  .629726E-04, .331558E-04, .164938E-04, .760302E-05,
     +  .321118E-05, .120554E-05, .387164E-06, .996771E-07,
     +  .183849E-07, .186758E-08, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .576165E+05, .857622E+05, .665323E+05, .516203E+05,
     +  .400561E+05, .310876E+05, .241316E+05, .187360E+05,
     +  .145505E+05, .113033E+05, .878367E+04, .682835E+04,
     +  .531068E+04, .413248E+04, .321759E+04, .250700E+04,
     +  .195490E+04, .152581E+04, .119217E+04, .932641E+03,
     +  .730647E+03, .573340E+03, .450747E+03, .355133E+03,
     +  .280493E+03, .222166E+03, .176534E+03, .140340E+03,
     +  .112402E+03, .904443E+02, .731552E+02, .595138E+02,
     +  .487257E+02, .401953E+02, .333943E+02, .279716E+02,
     +  .236318E+02, .201440E+02, .173271E+02, .150381E+02,
     +  .131686E+02, .116274E+02, .103466E+02, .927179E+01,
     +  .836032E+01, .757875E+01, .690317E+01, .630655E+01,
     +  .578016E+01, .530499E+01, .487612E+01, .448414E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .412320E+01, .378876E+01, .347731E+01, .318617E+01,
     +  .291329E+01, .265712E+01, .241649E+01, .219049E+01,
     +  .197845E+01, .177980E+01, .159409E+01, .142173E+01,
     +  .126057E+01, .111139E+01, .973878E+00, .847708E+00,
     +  .732540E+00, .628012E+00, .533737E+00, .449293E+00,
     +  .374187E+00, .307886E+00, .250437E+00, .200446E+00,
     +  .157780E+00, .121841E+00, .920257E-01, .677241E-01,
     +  .483245E-01, .332411E-01, .217930E-01, .135000E-01,
     +  .774792E-02, .400693E-02, .178235E-02, .624882E-03,
     +  .141923E-03, .111509E-04, .000000E+00, .148177E+06,
     +  .115661E+06, .892024E+05, .688001E+05, .530718E+05,
     +  .409425E+05, .315911E+05, .243788E+05, .188176E+05,
     +  .145279E+05, .112196E+05, .866715E+04, .669822E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .517869E+04, .400616E+04, .310089E+04, .240202E+04,
     +  .186215E+04, .144511E+04, .112270E+04, .873442E+03,
     +  .680549E+03, .531237E+03, .415533E+03, .325827E+03,
     +  .256190E+03, .202096E+03, .159471E+03, .126800E+03,
     +  .101290E+03, .813453E+02, .657095E+02, .534282E+02,
     +  .437767E+02, .361319E+02, .300707E+02, .252487E+02,
     +  .213923E+02, .182938E+02, .157863E+02, .137472E+02,
     +  .120718E+02, .106844E+02, .952332E+01, .854184E+01,
     +  .770253E+01, .697939E+01, .634277E+01, .578329E+01,
     +  .528019E+01, .482824E+01, .441716E+01, .404072E+01,
     +  .369387E+01, .337285E+01, .307463E+01, .279693E+01,
     +  .253795E+01, .229632E+01, .207092E+01, .186087E+01,
     +  .166546E+01, .148399E+01, .131671E+01, .116135E+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .101852E+01, .887740E+00, .768564E+00, .660512E+00,
     +  .563112E+00, .475857E+00, .398241E+00, .329704E+00,
     +  .269616E+00, .217926E+00, .173279E+00, .135460E+00,
     +  .103856E+00, .778477E-01, .568346E-01, .402063E-01,
     +  .274040E-01, .177851E-01, .108958E-01, .617564E-02,
     +  .314874E-02, .137731E-02, .473265E-03, .105295E-03,
     +  .835996E-05, .000000E+00, .196908E+06, .153011E+06,
     +  .117400E+06, .900749E+05, .691172E+05, .530356E+05,
     +  .407014E+05, .312371E+05, .239780E+05, .184077E+05,
     +  .141352E+05, .108563E+05, .834102E+04, .641044E+04,
     +  .492918E+04, .379193E+04, .291910E+04, .224871E+04,
     +  .173393E+04, .133831E+04, .103432E+04, .800493E+03,
     +  .620636E+03, .482123E+03, .375423E+03, .293118E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .229611E+03, .179889E+03, .142031E+03, .112661E+03,
     +  .898511E+02, .720825E+02, .582167E+02, .473866E+02,
     +  .388617E+02, .321411E+02, .268251E+02, .225951E+02,
     +  .192134E+02, .164886E+02, .142821E+02, .124757E+02,
     +  .109852E+02, .974155E+01, .869365E+01, .780018E+01,
     +  .703285E+01, .635953E+01, .577001E+01, .524195E+01,
     +  .476967E+01, .434209E+01, .395254E+01, .359552E+01,
     +  .326695E+01, .296349E+01, .268262E+01, .242229E+01,
     +  .218090E+01, .195716E+01, .174997E+01, .155847E+01,
     +  .138174E+01, .121987E+01, .107049E+01, .934033E+00,
     +  .809888E+00, .697484E+00, .596228E+00, .505546E+00,
     +  .424835E+00, .353518E+00, .290974E+00, .236505E+00,
     +  .189977E+00, .150076E+00, .116524E+00, .887023E-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .659884E-01, .477909E-01, .335153E-01, .226316E-01,
     +  .145370E-01, .880532E-02, .492682E-02, .247513E-02,
     +  .106375E-02, .357797E-03, .778538E-04, .625248E-05,
     +  .000000E+00, .257100E+06, .198980E+06, .151961E+06,
     +  .116041E+06, .886158E+05, .676665E+05, .516737E+05,
     +  .394589E+05, .301352E+05, .230147E+05, .175800E+05,
     +  .134298E+05, .102623E+05, .784335E+04, .599710E+04,
     +  .458703E+04, .351064E+04, .268834E+04, .206042E+04,
     +  .158053E+04, .121391E+04, .933515E+03, .719111E+03,
     +  .554965E+03, .429285E+03, .332927E+03, .259044E+03,
     +  .201555E+03, .158060E+03, .124527E+03, .986482E+02,
     +  .786142E+02, .630779E+02, .510160E+02, .415782E+02,
     +  .341799E+02, .283603E+02, .237529E+02, .200876E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .171471E+02, .147760E+02, .128420E+02, .112518E+02,
     +  .992918E+01, .881829E+01, .787402E+01, .706564E+01,
     +  .635867E+01, .574191E+01, .519157E+01, .470145E+01,
     +  .425970E+01, .385918E+01, .349398E+01, .315966E+01,
     +  .285260E+01, .257000E+01, .230959E+01, .206955E+01,
     +  .184839E+01, .164481E+01, .145780E+01, .128624E+01,
     +  .113006E+01, .986795E+00, .856732E+00, .739122E+00,
     +  .633292E+00, .538544E+00, .454221E+00, .379638E+00,
     +  .314156E+00, .257110E+00, .207748E+00, .165868E+00,
     +  .130201E+00, .100423E+00, .759150E-01, .560608E-01,
     +  .402849E-01, .280136E-01, .187458E-01, .119210E-01,
     +  .714152E-02, .394623E-02, .195430E-02, .825746E-03,
     +  .272132E-03, .579917E-04, .470872E-05, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .210645E+06, .254923E+06, .193849E+06, .147382E+06,
     +  .112052E+06, .851764E+05, .647475E+05, .492117E+05,
     +  .374055E+05, .284292E+05, .216094E+05, .164253E+05,
     +  .124874E+05, .949447E+04, .722122E+04, .549356E+04,
     +  .418138E+04, .318404E+04, .242643E+04, .185047E+04,
     +  .141282E+04, .107993E+04, .826797E+03, .634090E+03,
     +  .487390E+03, .375567E+03, .290338E+03, .224414E+03,
     +  .174838E+03, .136845E+03, .107704E+03, .852795E+02,
     +  .679932E+02, .546515E+02, .442725E+02, .361814E+02,
     +  .298509E+02, .248642E+02, .209161E+02, .177626E+02,
     +  .152302E+02, .131723E+02, .114860E+02, .100881E+02,
     +  .891771E+01, .792591E+01, .707954E+01, .634178E+01,
     +  .570045E+01, .513034E+01, .462467E+01, .417090E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .376138E+01, .338979E+01, .305135E+01, .274213E+01,
     +  .245908E+01, .219971E+01, .196197E+01, .174416E+01,
     +  .154483E+01, .136278E+01, .119673E+01, .104645E+01,
     +  .909390E+00, .785694E+00, .674499E+00, .575037E+00,
     +  .486520E+00, .408218E+00, .339379E+00, .279317E+00,
     +  .227326E+00, .182621E+00, .144941E+00, .113067E+00,
     +  .866417E-01, .650508E-01, .476919E-01, .340090E-01,
     +  .234544E-01, .155560E-01, .979587E-02, .580524E-02,
     +  .316884E-02, .154748E-02, .643127E-03, .207828E-03,
     +  .434258E-04, .356366E-05, .000000E+00, .442405E+06,
     +  .339693E+06, .257044E+06, .194458E+06, .147093E+06,
     +  .111238E+06, .841148E+05, .635911E+05, .480721E+05,
     +  .363341E+05, .274620E+05, .207540E+05, .156857E+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .118549E+05, .896146E+04, .677507E+04, .512400E+04,
     +  .387656E+04, .293462E+04, .222293E+04, .168548E+04,
     +  .127930E+04, .972421E+03, .740340E+03, .564839E+03,
     +  .431973E+03, .331407E+03, .254166E+03, .196488E+03,
     +  .152604E+03, .119182E+03, .936481E+02, .741028E+02,
     +  .591241E+02, .475506E+02, .385891E+02, .316218E+02,
     +  .261672E+02, .218731E+02, .184618E+02, .157358E+02,
     +  .135308E+02, .117317E+02, .102463E+02, .900736E+01,
     +  .796156E+01, .707257E+01, .630080E+01, .563277E+01,
     +  .504165E+01, .451989E+01, .405412E+01, .363606E+01,
     +  .325891E+01, .291746E+01, .260743E+01, .232543E+01,
     +  .206870E+01, .183494E+01, .162221E+01, .142884E+01,
     +  .125343E+01, .109452E+01, .951678E+00, .822302E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .706347E+00, .602835E+00, .510893E+00, .429645E+00,
     +  .358282E+00, .295995E+00, .242047E+00, .195699E+00,
     +  .156143E+00, .123060E+00, .952980E-01, .724702E-01,
     +  .539775E-01, .392416E-01, .277345E-01, .189448E-01,
     +  .124369E-01, .774426E-02, .453329E-02, .244070E-02,
     +  .117346E-02, .478960E-03, .151594E-03, .310551E-04,
     +  .257681E-05, .000000E+00, .582346E+06, .445365E+06,
     +  .335440E+06, .252569E+06, .190133E+06, .143084E+06,
     +  .107658E+06, .809778E+05, .609000E+05, .457881E+05,
     +  .344222E+05, .258723E+05, .194453E+05, .146131E+05,
     +  .109825E+05, .825398E+04, .620486E+04, .466541E+04,
     +  .350959E+04, .264141E+04, .198967E+04, .150010E+04,
     +  .113248E+04, .856212E+03, .648627E+03, .492489E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .375092E+03, .285529E+03, .219103E+03, .168909E+03,
     +  .130941E+03, .102134E+03, .802327E+02, .635621E+02,
     +  .507656E+02, .409212E+02, .333143E+02, .273944E+02,
     +  .227596E+02, .190969E+02, .161840E+02, .138384E+02,
     +  .119324E+02, .103652E+02, .906285E+01, .796773E+01,
     +  .704035E+01, .623850E+01, .554731E+01, .493847E+01,
     +  .440361E+01, .392857E+01, .350445E+01, .312398E+01,
     +  .278151E+01, .247242E+01, .219301E+01, .194024E+01,
     +  .171155E+01, .150479E+01, .131809E+01, .114985E+01,
     +  .998427E+00, .863233E+00, .741605E+00, .633335E+00,
     +  .537345E+00, .452671E+00, .378367E+00, .313564E+00,
     +  .257405E+00, .209119E+00, .167947E+00, .133070E+00,
     +  .104127E+00, .800328E-01, .603857E-01, .446073E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .321478E-01, .225110E-01, .152237E-01, .988710E-02,
     +  .608392E-02, .351504E-02, .186474E-02, .881525E-03,
     +  .352750E-03, .109096E-03, .218536E-04, .183646E-05,
     +  .000000E+00, .755348E+06, .575480E+06, .431510E+06,
     +  .323436E+06, .242362E+06, .181537E+06, .135939E+06,
     +  .101756E+06, .761491E+05, .569659E+05, .426064E+05,
     +  .318568E+05, .238159E+05, .178006E+05, .133041E+05,
     +  .994250E+04, .743116E+04, .555463E+04, .415343E+04,
     +  .310684E+04, .232562E+04, .174219E+04, .130667E+04,
     +  .981354E+03, .738404E+03, .556800E+03, .421123E+03,
     +  .318284E+03, .242507E+03, .185624E+03, .142878E+03,
     +  .110661E+03, .863263E+02, .679246E+02, .538883E+02,
     +  .431576E+02, .349148E+02, .285368E+02, .235697E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .196645E+02, .165729E+02, .140944E+02, .120884E+02,
     +  .104454E+02, .908509E+01, .794552E+01, .698411E+01,
     +  .615610E+01, .544532E+01, .482200E+01, .427696E+01,
     +  .379529E+01, .336748E+01, .298581E+01, .264420E+01,
     +  .233770E+01, .206230E+01, .181468E+01, .159206E+01,
     +  .139206E+01, .121262E+01, .105199E+01, .908336E+00,
     +  .780923E+00, .667055E+00, .566370E+00, .477707E+00,
     +  .400029E+00, .332333E+00, .273705E+00, .223256E+00,
     +  .180194E+00, .143748E+00, .113104E+00, .878704E-01,
     +  .670316E-01, .501796E-01, .367626E-01, .262634E-01,
     +  .182200E-01, .121987E-01, .783732E-02, .476550E-02,
     +  .271734E-02, .142035E-02, .660158E-03, .258991E-03,
     +  .782808E-04, .153406E-04, .130566E-05, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .966915E+06, .733970E+06, .547978E+06, .408939E+06,
     +  .305071E+06, .227476E+06, .169558E+06, .126328E+06,
     +  .940880E+05, .700453E+05, .521306E+05, .387825E+05,
     +  .288453E+05, .214473E+05, .159445E+05, .118511E+05,
     +  .880864E+04, .654709E+04, .486732E+04, .361943E+04,
     +  .269304E+04, .200506E+04, .149443E+04, .111521E+04,
     +  .833679E+03, .624491E+03, .469164E+03, .352164E+03,
     +  .266495E+03, .202594E+03, .154877E+03, .119144E+03,
     +  .923226E+02, .721682E+02, .568886E+02, .452775E+02,
     +  .364093E+02, .295853E+02, .242980E+02, .201613E+02,
     +  .169010E+02, .142983E+02, .121999E+02, .104877E+02,
     +  .907524E+01, .789628E+01, .690531E+01, .605516E+01,
     +  .532833E+01, .469372E+01, .414136E+01, .365561E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .322638E+01, .284550E+01, .250649E+01, .220408E+01,
     +  .193395E+01, .169254E+01, .147684E+01, .128426E+01,
     +  .111257E+01, .959851E+00, .824150E+00, .704566E+00,
     +  .598392E+00, .505130E+00, .423552E+00, .352562E+00,
     +  .291118E+00, .238270E+00, .193116E+00, .154850E+00,
     +  .122701E+00, .958708E-01, .739478E-01, .559866E-01,
     +  .415818E-01, .302117E-01, .213948E-01, .147043E-01,
     +  .974621E-02, .619405E-02, .372157E-02, .209427E-02,
     +  .107854E-02, .492864E-03, .189588E-03, .560224E-04,
     +  .107489E-04, .926451E-06, .000000E+00, .122289E+07,
     +  .924978E+06, .687688E+06, .511020E+06, .379577E+06,
     +  .281790E+06, .209106E+06, .155087E+06, .114975E+06,
     +  .851940E+05, .631024E+05, .467169E+05, .345747E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .255778E+05, .189175E+05, .139872E+05, .103408E+05,
     +  .764401E+04, .565121E+04, .417849E+04, .309101E+04,
     +  .228777E+04, .169487E+04, .125703E+04, .933824E+03,
     +  .695059E+03, .518821E+03, .386871E+03, .290843E+03,
     +  .219654E+03, .166819E+03, .127497E+03, .981614E+02,
     +  .762512E+02, .597380E+02, .472621E+02, .377856E+02,
     +  .305322E+02, .249400E+02, .205851E+02, .171674E+02,
     +  .144502E+02, .122676E+02, .104933E+02, .903469E+01,
     +  .782155E+01, .680555E+01, .593726E+01, .519790E+01,
     +  .455514E+01, .399822E+01, .351083E+01, .308232E+01,
     +  .270409E+01, .236928E+01, .207231E+01, .180858E+01,
     +  .157429E+01, .136621E+01, .118159E+01, .101801E+01,
     +  .873421E+00, .745752E+00, .633964E+00, .535353E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .449300E+00, .374525E+00, .309890E+00, .254324E+00,
     +  .206860E+00, .166590E+00, .132706E+00, .104448E+00,
     +  .810379E-01, .620570E-01, .466295E-01, .343589E-01,
     +  .247567E-01, .173779E-01, .118319E-01, .776347E-02,
     +  .488049E-02, .289739E-02, .160904E-02, .816418E-03,
     +  .366810E-03, .138362E-03, .399854E-04, .751726E-05,
     +  .656031E-06, .000000E+00, .152937E+07, .115279E+07,
     +  .853550E+06, .631640E+06, .467196E+06, .345354E+06,
     +  .255161E+06, .188409E+06, .139053E+06, .102565E+06,
     +  .756164E+05, .557173E+05, .410377E+05, .302105E+05,
     +  .222325E+05, .163548E+05, .120286E+05, .884475E+04,
     +  .650372E+04, .478245E+04, .351797E+04, .258892E+04,
     +  .190682E+04, .140584E+04, .103809E+04, .767924E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .569656E+03, .422081E+03, .315314E+03, .236634E+03,
     +  .178583E+03, .135637E+03, .103785E+03, .801343E+02,
     +  .624105E+02, .490946E+02, .390333E+02, .313715E+02,
     +  .254923E+02, .209344E+02, .173720E+02, .145507E+02,
     +  .122927E+02, .104635E+02, .896502E+01, .772300E+01,
     +  .668652E+01, .580406E+01, .505562E+01, .440775E+01,
     +  .384891E+01, .336219E+01, .293640E+01, .256254E+01,
     +  .223338E+01, .194306E+01, .168671E+01, .146032E+01,
     +  .126045E+01, .108419E+01, .928983E+00, .792641E+00,
     +  .673002E+00, .568907E+00, .477670E+00, .398567E+00,
     +  .330281E+00, .271647E+00, .221578E+00, .179102E+00,
     +  .143314E+00, .113416E+00, .886631E-01, .683087E-01,
     +  .519317E-01, .387260E-01, .283092E-01, .202278E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .140738E-01, .949226E-02, .616546E-02, .383373E-02,
     +  .224874E-02, .123235E-02, .616045E-03, .272133E-03,
     +  .100670E-03, .284620E-04, .524690E-05, .463567E-06,
     +  .000000E+00, .189259E+07, .142176E+07, .104848E+07,
     +  .772742E+06, .569208E+06, .419004E+06, .308263E+06,
     +  .226639E+06, .166535E+06, .122290E+06, .897512E+05,
     +  .658285E+05, .482581E+05, .353570E+05, .258938E+05,
     +  .189542E+05, .138703E+05, .101467E+05, .742216E+04,
     +  .542879E+04, .397176E+04, .290672E+04, .212883E+04,
     +  .156054E+04, .114561E+04, .842444E+03, .621197E+03,
     +  .457453E+03, .339665E+03, .253361E+03, .190049E+03,
     +  .143481E+03, .109138E+03, .837818E+02, .648831E+02,
     +  .507607E+02, .401439E+02, .320986E+02, .259529E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .212087E+02, .175152E+02, .146010E+02, .122767E+02,
     +  .104002E+02, .886802E+01, .760241E+01, .654997E+01,
     +  .565724E+01, .490307E+01, .425302E+01, .369479E+01,
     +  .321091E+01, .278969E+01, .242176E+01, .209956E+01,
     +  .181696E+01, .156883E+01, .135098E+01, .115978E+01,
     +  .992171E+00, .845483E+00, .717417E+00, .605733E+00,
     +  .509166E+00, .425065E+00, .352618E+00, .290484E+00,
     +  .237483E+00, .192528E+00, .154648E+00, .122954E+00,
     +  .966641E-01, .750560E-01, .574186E-01, .433363E-01,
     +  .320708E-01, .232579E-01, .164795E-01, .113644E-01,
     +  .759265E-02, .488164E-02, .300229E-02, .173991E-02,
     +  .940895E-03, .463383E-03, .201259E-03, .730244E-04,
     +  .202053E-04, .365505E-05, .326877E-06, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .231881E+07, .173619E+07, .127532E+07, .936192E+06,
     +  .686824E+06, .503516E+06, .368902E+06, .270079E+06,
     +  .197606E+06, .144476E+06, .105566E+06, .770807E+05,
     +  .562492E+05, .410207E+05, .298998E+05, .217815E+05,
     +  .158613E+05, .115455E+05, .840249E+04, .611409E+04,
     +  .444960E+04, .323898E+04, .235924E+04, .171985E+04,
     +  .125545E+04, .917930E+03, .672949E+03, .492637E+03,
     +  .363651E+03, .269669E+03, .201104E+03, .150954E+03,
     +  .114172E+03, .871620E+02, .671366E+02, .522490E+02,
     +  .411114E+02, .327106E+02, .263209E+02, .214086E+02,
     +  .175984E+02, .146027E+02, .122214E+02, .103052E+02,
     +  .874561E+01, .746167E+01, .639769E+01, .549848E+01,
     +  .474183E+01, .409238E+01, .353714E+01, .305811E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .264317E+01, .228259E+01, .196850E+01, .169452E+01,
     +  .145533E+01, .124652E+01, .106433E+01, .905571E+00,
     +  .767465E+00, .647623E+00, .543751E+00, .454497E+00,
     +  .377255E+00, .311139E+00, .254803E+00, .207062E+00,
     +  .166838E+00, .133174E+00, .105202E+00, .821621E-01,
     +  .633628E-01, .481312E-01, .360628E-01, .264846E-01,
     +  .190535E-01, .133872E-01, .914993E-02, .605528E-02,
     +  .385360E-02, .234404E-02, .134208E-02, .716139E-03,
     +  .347466E-03, .148382E-03, .528133E-04, .143061E-04,
     +  .254123E-05, .230013E-06, .000000E+00, .281412E+07,
     +  .210025E+07, .153679E+07, .112373E+07, .821152E+06,
     +  .599581E+06, .437497E+06, .318980E+06, .232408E+06,
     +  .169199E+06, .123097E+06, .894877E+05, .650123E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .471968E+05, .342431E+05, .248288E+05, .179943E+05,
     +  .130346E+05, .943939E+04, .683411E+04, .494818E+04,
     +  .358318E+04, .259615E+04, .188238E+04, .136660E+04,
     +  .993665E+03, .724405E+03, .527285E+03, .387034E+03,
     +  .285395E+03, .211642E+03, .157987E+03, .118843E+03,
     +  .902484E+02, .691552E+02, .535510E+02, .419315E+02,
     +  .332062E+02, .265969E+02, .215353E+02, .176232E+02,
     +  .145579E+02, .121289E+02, .101806E+02, .859984E+01,
     +  .730271E+01, .623151E+01, .532949E+01, .457344E+01,
     +  .392721E+01, .337718E+01, .290487E+01, .249775E+01,
     +  .214577E+01, .184080E+01, .157622E+01, .134652E+01,
     +  .114715E+01, .974200E+00, .824386E+00, .694838E+00,
     +  .583102E+00, .486844E+00, .404642E+00, .333948E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .273821E+00, .222918E+00, .180063E+00, .144193E+00,
     +  .114376E+00, .897713E-01, .696478E-01, .533464E-01,
     +  .402358E-01, .299273E-01, .218106E-01, .155653E-01,
     +  .108442E-01, .734579E-02, .481514E-02, .303309E-02,
     +  .182465E-02, .103209E-02, .543409E-03, .259747E-03,
     +  .109065E-03, .380855E-04, .101034E-04, .176352E-05,
     +  .161524E-06, .000000E+00, .576738E+05, .855709E+05,
     +  .663615E+05, .514679E+05, .399202E+05, .309664E+05,
     +  .240235E+05, .186398E+05, .144648E+05, .112270E+05,
     +  .871582E+04, .676804E+04, .525712E+04, .408493E+04,
     +  .317542E+04, .246962E+04, .192181E+04, .149653E+04,
     +  .116629E+04, .909781E+03, .710477E+03, .555559E+03,
     +  .435086E+03, .341350E+03, .268370E+03, .211508E+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .167167E+03, .132120E+03, .105171E+03, .840749E+02,
     +  .675331E+02, .545362E+02, .443003E+02, .362377E+02,
     +  .298316E+02, .247374E+02, .206674E+02, .173979E+02,
     +  .147546E+02, .126011E+02, .108351E+02, .937162E+01,
     +  .814816E+01, .711555E+01, .623586E+01, .547979E+01,
     +  .482695E+01, .425358E+01, .375309E+01, .330866E+01,
     +  .291640E+01, .256789E+01, .225768E+01, .198128E+01,
     +  .173493E+01, .151544E+01, .132005E+01, .114637E+01,
     +  .992249E+00, .855785E+00, .735249E+00, .629067E+00,
     +  .535805E+00, .454505E+00, .383134E+00, .321128E+00,
     +  .267482E+00, .221280E+00, .181691E+00, .147955E+00,
     +  .119386E+00, .953591E-01, .752966E-01, .586760E-01,
     +  .451654E-01, .341440E-01, .253371E-01, .184025E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .130353E-01, .896484E-02, .595168E-02, .378867E-02,
     +  .228169E-02, .128709E-02, .664589E-03, .304111E-03,
     +  .116813E-03, .340220E-04, .597973E-05, .305571E-06,
     +  .000000E+00, .147949E+06, .115457E+06, .890202E+05,
     +  .686375E+05, .529268E+05, .408133E+05, .314761E+05,
     +  .242764E+05, .187264E+05, .144467E+05, .111475E+05,
     +  .860307E+04, .664133E+04, .512822E+04, .396141E+04,
     +  .306125E+04, .236693E+04, .183111E+04, .141768E+04,
     +  .109848E+04, .852068E+03, .661705E+03, .514634E+03,
     +  .400914E+03, .312961E+03, .244868E+03, .192133E+03,
     +  .150716E+03, .119084E+03, .944805E+02, .753207E+02,
     +  .603622E+02, .486614E+02, .395027E+02, .322746E+02,
     +  .265618E+02, .220277E+02, .184065E+02, .154978E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .131417E+02, .112217E+02, .963992E+01, .832587E+01,
     +  .722340E+01, .629032E+01, .549336E+01, .480982E+01,
     +  .421334E+01, .369627E+01, .324011E+01, .284025E+01,
     +  .248732E+01, .217526E+01, .189902E+01, .165438E+01,
     +  .143779E+01, .124616E+01, .107686E+01, .927521E+00,
     +  .796070E+00, .680628E+00, .579533E+00, .491219E+00,
     +  .414672E+00, .347841E+00, .290106E+00, .240430E+00,
     +  .197891E+00, .161644E+00, .130936E+00, .105081E+00,
     +  .834653E-01, .655302E-01, .507618E-01, .388345E-01,
     +  .291698E-01, .215002E-01, .155054E-01, .109007E-01,
     +  .743720E-02, .489470E-02, .308699E-02, .184000E-02,
     +  .102735E-02, .524234E-03, .236673E-03, .894698E-04,
     +  .255809E-04, .441995E-05, .229270E-06, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .196665E+06, .152794E+06, .117206E+06, .899020E+05,
     +  .689631E+05, .528984E+05, .405792E+05, .311283E+05,
     +  .238813E+05, .183217E+05, .140587E+05, .107884E+05,
     +  .828079E+04, .635702E+04, .488184E+04, .375001E+04,
     +  .288200E+04, .221590E+04, .170494E+04, .131271E+04,
     +  .101173E+04, .780575E+03, .603082E+03, .466660E+03,
     +  .361805E+03, .281125E+03, .219046E+03, .170593E+03,
     +  .133827E+03, .105408E+03, .834216E+02, .663644E+02,
     +  .531086E+02, .427974E+02, .347125E+02, .283614E+02,
     +  .233525E+02, .193759E+02, .162013E+02, .136448E+02,
     +  .115742E+02, .987800E+01, .847742E+01, .730923E+01,
     +  .632660E+01, .549234E+01, .478131E+01, .416463E+01,
     +  .363348E+01, .316782E+01, .276221E+01, .240643E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .209381E+01, .181876E+01, .157665E+01, .136357E+01,
     +  .117615E+01, .101151E+01, .867107E+00, .740716E+00,
     +  .630327E+00, .534199E+00, .450661E+00, .378648E+00,
     +  .316108E+00, .262372E+00, .216384E+00, .177218E+00,
     +  .144028E+00, .116067E+00, .926552E-01, .731968E-01,
     +  .571496E-01, .440135E-01, .334713E-01, .249845E-01,
     +  .182948E-01, .131034E-01, .914506E-02, .619154E-02,
     +  .404102E-02, .252609E-02, .149095E-02, .822699E-03,
     +  .414322E-03, .184310E-03, .684766E-04, .191907E-04,
     +  .325451E-05, .171621E-06, .000000E+00, .256842E+06,
     +  .198750E+06, .151755E+06, .115858E+06, .884525E+05,
     +  .675211E+05, .515443E+05, .393438E+05, .300328E+05,
     +  .229238E+05, .174992E+05, .133581E+05, .101986E+05 /
        DATA (UPDI(I),I=9205,9256) /
     +  .778694E+04, .594713E+04, .454279E+04, .347150E+04,
     +  .265373E+04, .202985E+04, .155354E+04, .119009E+04,
     +  .912506E+03, .700590E+03, .538643E+03, .414902E+03,
     +  .320250E+03, .247867E+03, .191710E+03, .149360E+03,
     +  .116824E+03, .918094E+02, .725222E+02, .576267E+02,
     +  .461112E+02, .371380E+02, .301316E+02, .246397E+02,
     +  .203052E+02, .168654E+02, .141112E+02, .118935E+02,
     +  .100871E+02, .860416E+01, .737429E+01, .634583E+01,
     +  .547771E+01, .474221E+01, .410806E+01, .356515E+01,
     +  .309202E+01, .268237E+01, .232517E+01, .201315E+01,
     +  .174023E+01, .150137E+01, .129234E+01, .110950E+01,
     +  .949781E+00, .810449E+00, .689151E+00, .583773E+00,
     +  .492497E+00, .413578E+00, .345903E+00, .287430E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .237451E+00, .194901E+00, .158855E+00, .128470E+00,
     +  .103010E+00, .818084E-01, .642864E-01, .499211E-01,
     +  .382294E-01, .289038E-01, .214437E-01, .156019E-01,
     +  .110999E-01, .769186E-02, .516863E-02, .334607E-02,
     +  .207361E-02, .121227E-02, .662015E-03, .329556E-03,
     +  .144725E-03, .529880E-04, .146150E-04, .244955E-05,
     +  .131730E-06, .000000E+00, .210716E+06, .254679E+06,
     +  .193631E+06, .147188E+06, .111879E+06, .850226E+05,
     +  .646107E+05, .490901E+05, .372974E+05, .283332E+05,
     +  .215241E+05, .163497E+05, .124203E+05, .943502E+04,
     +  .716857E+04, .544696E+04, .414015E+04, .314760E+04,
     +  .239424E+04, .182205E+04, .138774E+04, .105780E+04,
     +  .807289E+03, .616892E+03, .472228E+03, .362193E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .278537E+03, .214009E+03, .165632E+03, .128685E+03,
     +  .100450E+03, .788091E+02, .621962E+02, .494297E+02,
     +  .395413E+02, .318660E+02, .258851E+02, .211920E+02,
     +  .174890E+02, .145408E+02, .121803E+02, .102682E+02,
     +  .870709E+01, .741963E+01, .634903E+01, .545038E+01,
     +  .469333E+01, .404427E+01, .349181E+01, .301308E+01,
     +  .260096E+01, .224364E+01, .193327E+01, .166330E+01,
     +  .142833E+01, .122382E+01, .104590E+01, .891289E+00,
     +  .757125E+00, .640933E+00, .540509E+00, .453972E+00,
     +  .379520E+00, .315997E+00, .261386E+00, .214946E+00,
     +  .175608E+00, .142454E+00, .114651E+00, .914780E-01,
     +  .722835E-01, .565075E-01, .436475E-01, .332400E-01,
     +  .249882E-01, .184280E-01, .133238E-01, .941689E-02 /
        DATA (UPDI(I),I=9361,9412) /
     +  .648026E-02, .432241E-02, .277601E-02, .170576E-02,
     +  .987929E-03, .534034E-03, .262844E-03, .113978E-03,
     +  .411385E-04, .111738E-04, .185146E-05, .101504E-06,
     +  .000000E+00, .442112E+06, .339431E+06, .256811E+06,
     +  .194251E+06, .146909E+06, .111074E+06, .839687E+05,
     +  .634613E+05, .479568E+05, .362317E+05, .273711E+05,
     +  .206734E+05, .156142E+05, .117916E+05, .890542E+04,
     +  .672548E+04, .508015E+04, .383780E+04, .290038E+04,
     +  .219270E+04, .165881E+04, .125577E+04, .951664E+03,
     +  .722033E+03, .548689E+03, .417718E+03, .318818E+03,
     +  .243055E+03, .186647E+03, .143870E+03, .111408E+03,
     +  .867057E+02, .678760E+02, .535104E+02, .424616E+02,
     +  .339471E+02, .273584E+02, .222245E+02, .182014E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .150202E+02, .124899E+02, .104542E+02, .880297E+01,
     +  .745025E+01, .633277E+01, .540101E+01, .462129E+01,
     +  .395726E+01, .339585E+01, .291265E+01, .249946E+01,
     +  .214360E+01, .183655E+01, .157123E+01, .134179E+01,
     +  .114338E+01, .971846E+00, .823731E+00, .695995E+00,
     +  .586048E+00, .491601E+00, .410707E+00, .341519E+00,
     +  .282839E+00, .232693E+00, .190304E+00, .154614E+00,
     +  .124718E+00, .998022E-01, .791641E-01, .621776E-01,
     +  .483077E-01, .370778E-01, .280505E-01, .209437E-01,
     +  .153352E-01, .110048E-01, .771671E-02, .526604E-02,
     +  .348137E-02, .221442E-02, .134665E-02, .771047E-03,
     +  .411547E-03, .199668E-03, .851648E-04, .301423E-04,
     +  .799700E-05, .129267E-05, .715450E-07, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .582032E+06, .445086E+06, .335191E+06, .252347E+06,
     +  .189935E+06, .142909E+06, .107502E+06, .808393E+05,
     +  .607770E+05, .456790E+05, .343254E+05, .257865E+05,
     +  .193692E+05, .145457E+05, .109229E+05, .820126E+04,
     +  .615825E+04, .462422E+04, .347321E+04, .260930E+04,
     +  .196133E+04, .147509E+04, .111041E+04, .836743E+03,
     +  .631443E+03, .477313E+03, .361679E+03, .273681E+03,
     +  .208600E+03, .159579E+03, .122629E+03, .947050E+02,
     +  .735645E+02, .575478E+02, .453132E+02, .359497E+02,
     +  .287529E+02, .231832E+02, .188471E+02, .154412E+02,
     +  .127496E+02, .105979E+02, .886369E+01, .745207E+01,
     +  .629330E+01, .533329E+01, .453504E+01, .385961E+01,
     +  .329225E+01, .280710E+01, .239492E+01, .204223E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .173985E+01, .148023E+01, .125714E+01, .106542E+01,
     +  .900700E+00, .759340E+00, .638168E+00, .534501E+00,
     +  .445982E+00, .370619E+00, .306535E+00, .252507E+00,
     +  .206609E+00, .168043E+00, .135767E+00, .108895E+00,
     +  .866364E-01, .683149E-01, .533311E-01, .411765E-01,
     +  .314023E-01, .235983E-01, .174985E-01, .127202E-01,
     +  .905933E-02, .630213E-02, .426462E-02, .279421E-02,
     +  .176029E-02, .105949E-02, .599813E-03, .316225E-03,
     +  .151335E-03, .635735E-04, .221206E-04, .576342E-05,
     +  .919191E-06, .520578E-07, .000000E+00, .755013E+06,
     +  .575182E+06, .431244E+06, .323200E+06, .242151E+06,
     +  .181350E+06, .135773E+06, .101608E+06, .760181E+05,
     +  .568498E+05, .425034E+05, .317655E+05, .237350E+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .177291E+05, .132408E+05, .988649E+04, .738165E+04,
     +  .551089E+04, .411480E+04, .307274E+04, .229552E+04,
     +  .171562E+04, .128323E+04, .960667E+03, .720138E+03,
     +  .540659E+03, .406850E+03, .305667E+03, .231315E+03,
     +  .175675E+03, .134009E+03, .102730E+03, .792054E+02,
     +  .615016E+02, .480673E+02, .378542E+02, .300555E+02,
     +  .240593E+02, .194210E+02, .158009E+02, .129577E+02,
     +  .106989E+02, .888955E+01, .742580E+01, .623154E+01,
     +  .524821E+01, .443561E+01, .375232E+01, .318193E+01,
     +  .269725E+01, .228804E+01, .194010E+01, .164365E+01,
     +  .139070E+01, .117467E+01, .990159E+00, .832591E+00,
     +  .698182E+00, .583658E+00, .486259E+00, .403585E+00,
     +  .333611E+00, .274455E+00, .224872E+00, .182998E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .148022E+00, .118925E+00, .948456E-01, .750227E-01,
     +  .588074E-01, .456304E-01, .350113E-01, .265294E-01,
     +  .198033E-01, .145833E-01, .105245E-01, .743887E-02,
     +  .513370E-02, .344476E-02, .223687E-02, .139565E-02,
     +  .831390E-03, .465389E-03, .242352E-03, .114412E-03,
     +  .473427E-04, .162002E-04, .414800E-05, .653518E-06,
     +  .378838E-07, .000000E+00, .966557E+06, .733651E+06,
     +  .547694E+06, .408687E+06, .304847E+06, .227277E+06,
     +  .169381E+06, .126171E+06, .939486E+05, .699217E+05,
     +  .520211E+05, .386855E+05, .287593E+05, .213713E+05,
     +  .158772E+05, .117916E+05, .875609E+04, .650068E+04,
     +  .482633E+04, .358324E+04, .266110E+04, .197687E+04,
     +  .146955E+04, .109325E+04, .814280E+03, .607342E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .453992E+03, .338747E+03, .254587E+03, .192005E+03,
     +  .145434E+03, .110697E+03, .847385E+02, .653294E+02,
     +  .506948E+02, .396410E+02, .312533E+02, .248451E+02,
     +  .199185E+02, .160969E+02, .131135E+02, .107575E+02,
     +  .888132E+01, .737253E+01, .614876E+01, .514712E+01,
     +  .432431E+01, .363659E+01, .306597E+01, .258406E+01,
     +  .217966E+01, .183791E+01, .154850E+01, .130305E+01,
     +  .109469E+01, .917802E+00, .767639E+00, .640306E+00,
     +  .532448E+00, .441256E+00, .364302E+00, .299549E+00,
     +  .245120E+00, .199764E+00, .161683E+00, .130062E+00,
     +  .103913E+00, .824031E-01, .648035E-01, .504962E-01,
     +  .389434E-01, .296940E-01, .223558E-01, .165761E-01,
     +  .121226E-01, .868524E-02, .609231E-02, .417091E-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .277514E-02, .178592E-02, .110358E-02, .650637E-03,
     +  .360117E-03, .185238E-03, .862702E-04, .351665E-04,
     +  .118371E-04, .297961E-05, .463896E-06, .275161E-07,
     +  .000000E+00, .122251E+07, .924638E+06, .687385E+06,
     +  .510751E+06, .379338E+06, .281578E+06, .208918E+06,
     +  .154920E+06, .114827E+06, .850626E+05, .629860E+05,
     +  .466139E+05, .344835E+05, .254971E+05, .188461E+05,
     +  .139241E+05, .102851E+05, .759478E+04, .560774E+04,
     +  .414012E+04, .305714E+04, .225788E+04, .166848E+04,
     +  .123373E+04, .913241E+03, .676858E+03, .502713E+03,
     +  .372622E+03, .278193E+03, .208402E+03, .156784E+03,
     +  .118522E+03, .901049E+02, .689906E+02, .531686E+02,
     +  .412922E+02, .323352E+02, .255338E+02, .203359E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .163279E+02, .132168E+02, .107743E+02, .884015E+01,
     +  .729368E+01, .604645E+01, .503146E+01, .420250E+01,
     +  .351367E+01, .294549E+01, .246848E+01, .207057E+01,
     +  .173630E+01, .145491E+01, .121768E+01, .101749E+01,
     +  .848529E+00, .705940E+00, .585736E+00, .484506E+00,
     +  .399415E+00, .328023E+00, .268295E+00, .218376E+00,
     +  .177018E+00, .142495E+00, .113996E+00, .905691E-01,
     +  .714135E-01, .558356E-01, .432500E-01, .331520E-01,
     +  .251199E-01, .187903E-01, .138388E-01, .100507E-01,
     +  .714856E-02, .497627E-02, .337962E-02, .222967E-02,
     +  .142200E-02, .870243E-03, .507782E-03, .277892E-03,
     +  .141196E-03, .648758E-04, .260545E-04, .862866E-05,
     +  .213603E-05, .328728E-06, .199446E-07, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .152896E+07, .115243E+07, .853227E+06, .631354E+06,
     +  .466941E+06, .345128E+06, .254961E+06, .188232E+06,
     +  .138895E+06, .102425E+06, .754928E+05, .556079E+05,
     +  .409409E+05, .301249E+05, .221568E+05, .162879E+05,
     +  .119695E+05, .879257E+04, .645765E+04, .474179E+04,
     +  .348208E+04, .255725E+04, .187885E+04, .138115E+04,
     +  .101627E+04, .748626E+03, .552576E+03, .406969E+03,
     +  .301897E+03, .224699E+03, .167939E+03, .126120E+03,
     +  .952476E+02, .724473E+02, .554640E+02, .427925E+02,
     +  .332921E+02, .261206E+02, .206713E+02, .164933E+02,
     +  .132683E+02, .107505E+02, .876757E+01, .719087E+01,
     +  .592624E+01, .490280E+01, .407160E+01, .338483E+01,
     +  .282157E+01, .235143E+01, .196152E+01, .163589E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .136335E+01, .113493E+01, .943290E+00, .782485E+00,
     +  .647562E+00, .534473E+00, .439783E+00, .360644E+00,
     +  .294626E+00, .239709E+00, .194070E+00, .156474E+00,
     +  .125274E+00, .996676E-01, .787425E-01, .617349E-01,
     +  .479878E-01, .369502E-01, .281502E-01, .211961E-01,
     +  .157527E-01, .115236E-01, .831113E-02, .586822E-02,
     +  .405386E-02, .273109E-02, .178655E-02, .112914E-02,
     +  .684356E-03, .395198E-03, .213848E-03, .107330E-03,
     +  .486557E-04, .192536E-04, .627499E-05, .152818E-05,
     +  .232542E-06, .144267E-07, .000000E+00, .189216E+07,
     +  .142137E+07, .104813E+07, .772437E+06, .568937E+06,
     +  .418763E+06, .308050E+06, .226451E+06, .166368E+06,
     +  .122142E+06, .896200E+05, .657125E+05, .481555E+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .352662E+05, .258135E+05, .188833E+05, .138077E+05,
     +  .100915E+05, .737336E+04, .538572E+04, .393375E+04,
     +  .287318E+04, .209922E+04, .153439E+04, .112250E+04,
     +  .822006E+03, .603107E+03, .441447E+03, .325456E+03,
     +  .240724E+03, .178783E+03, .133413E+03, .100114E+03,
     +  .756653E+02, .575595E+02, .441291E+02, .341170E+02,
     +  .266021E+02, .209234E+02, .165936E+02, .132693E+02,
     +  .106877E+02, .866542E+01, .706596E+01, .578989E+01,
     +  .476272E+01, .393305E+01, .325129E+01, .269527E+01,
     +  .223379E+01, .185323E+01, .153722E+01, .127425E+01,
     +  .105510E+01, .872293E+00, .719776E+00, .592536E+00,
     +  .486494E+00, .398208E+00, .324840E+00, .263983E+00,
     +  .213645E+00, .172049E+00, .137977E+00, .109864E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .869256E-01, .682912E-01, .532357E-01, .411403E-01,
     +  .314887E-01, .238427E-01, .178397E-01, .131724E-01,
     +  .957088E-02, .685473E-02, .480453E-02, .329366E-02,
     +  .220111E-02, .142764E-02, .894158E-03, .536703E-03,
     +  .306730E-03, .164113E-03, .813646E-04, .363935E-04,
     +  .141915E-04, .455268E-05, .109111E-05, .164220E-06,
     +  .104143E-07, .000000E+00, .231835E+07, .173578E+07,
     +  .127495E+07, .935868E+06, .686536E+06, .503261E+06,
     +  .368675E+06, .269879E+06, .197429E+06, .144319E+06,
     +  .105427E+06, .769576E+05, .561404E+05, .409245E+05,
     +  .298148E+05, .217064E+05, .157950E+05, .114870E+05,
     +  .835083E+04, .606851E+04, .440937E+04, .320348E+04,
     +  .232790E+04, .169218E+04, .123100E+04, .896307E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .653812E+03, .475709E+03, .348627E+03, .256311E+03,
     +  .189203E+03, .140327E+03, .104656E+03, .786145E+02,
     +  .594373E+02, .452920E+02, .348049E+02, .269767E+02,
     +  .210927E+02, .166301E+02, .132215E+02, .105882E+02,
     +  .853582E+01, .692096E+01, .563923E+01, .461289E+01,
     +  .378826E+01, .311429E+01, .256759E+01, .211637E+01,
     +  .174634E+01, .144079E+01, .118795E+01, .978435E+00,
     +  .804644E+00, .660468E+00, .540866E+00, .441750E+00,
     +  .359694E+00, .291887E+00, .235959E+00, .189958E+00,
     +  .152159E+00, .121373E+00, .961165E-01, .756287E-01,
     +  .590827E-01, .457940E-01, .351829E-01, .267680E-01,
     +  .201439E-01, .149771E-01, .109867E-01, .792874E-02,
     +  .563896E-02, .392341E-02, .266900E-02, .176927E-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .113778E-02, .706171E-03, .419768E-03, .237421E-03,
     +  .125603E-03, .615151E-04, .271503E-04, .104341E-04,
     +  .329556E-05, .777510E-06, .115778E-06, .750283E-08,
     +  .000000E+00, .281363E+07, .209981E+07, .153640E+07,
     +  .112339E+07, .820846E+06, .599310E+06, .437257E+06,
     +  .318767E+06, .232219E+06, .169032E+06, .122949E+06,
     +  .893572E+05, .648969E+05, .470949E+05, .341531E+05,
     +  .247493E+05, .179241E+05, .129727E+05, .938474E+04,
     +  .678589E+04, .490564E+04, .354564E+04, .256302E+04,
     +  .185313E+04, .134076E+04, .970814E+03, .704186E+03,
     +  .509405E+03, .371172E+03, .271301E+03, .199094E+03,
     +  .146793E+03, .108831E+03, .812700E+02, .610833E+02,
     +  .462743E+02, .353533E+02, .272442E+02, .211804E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .166049E+02, .131274E+02, .104542E+02, .838108E+01,
     +  .675798E+01, .547615E+01, .445491E+01, .363863E+01,
     +  .297496E+01, .243949E+01, .199993E+01, .164142E+01,
     +  .134703E+01, .110476E+01, .905124E+00, .740447E+00,
     +  .604594E+00, .492525E+00, .400169E+00, .324137E+00,
     +  .261658E+00, .210413E+00, .168499E+00, .134250E+00,
     +  .106514E+00, .838895E-01, .656427E-01, .509932E-01,
     +  .392976E-01, .300151E-01, .226993E-01, .169770E-01,
     +  .125426E-01, .914086E-02, .655179E-02, .462702E-02,
     +  .319566E-02, .215721E-02, .141845E-02, .904393E-03,
     +  .556232E-03, .327439E-03, .183284E-03, .958753E-04,
     +  .463861E-04, .202030E-04, .765290E-05, .238028E-05,
     +  .552986E-06, .814954E-07, .539487E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
