# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set_algorithm import PointSetAlgorithm


class ConstrainedSmoothingFilter(PointSetAlgorithm):
    r"""
    ConstrainedSmoothingFilter - adjust point positions using
    constrained smoothing
    
    Superclass: PointSetAlgorithm
    
    ConstrainedSmoothingFilter is a filter that adjusts point
    coordinates using a modified Laplacian smoothing approach. The effect
    is to "relax" the mesh, making the cells better shaped and the points
    more evenly distributed. Note that this filter operates on any
    PointSet and derived classes. Cell topology is never modified;
    note however if the constraints are too lax, cells may self-intersect
    or otherwise be deformed in unfavorable ways.
    
    A central concept of this filter is the point smoothing stencil. A
    smoothing stencil for a point pi is the list of points pj which
    connect to pi via an edge. To smooth the point pi, pi is moved
    towards the average position of pj multiplied by the relaxation
    factor, and limited by the constraint distance. This process is
    repeated either until convergence occurs, or the maximum number of
    iterations is reached. Note that smoothing stencils may be specified;
    or if not provided, the stencils are computed from the input cells
    connected edges (using ExtractEdges with use_all_points enabled).
    
    To constrain the motion of the points, either set the filter's
    constraint distance, or provide an input point data array (of type
    DoubleArray) named "smoothing_constraints." The filter's constraint
    distance is applied to all points; whereas the smoothing data array
    may have different constraint values per point. If provided by the
    user, by default the smoothing data array takes precedence over the
    filter's constraint distance.
    
    @warning
    The smoothing process reduces high frequency information in the
    geometry of the mesh. With excessive smoothing important details may
    be lost, and the surface may shrink towards the centroid. The
    constraints on point movement help significantly in preventing
    shrinkage from happening.
    
    @sa
    WindowedSincPolyDataFilter SmoothPolyDataFilter ExtractEdges
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkConstrainedSmoothingFilter, obj, update, **traits)
    
    generate_error_scalars = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off the generation of scalar distance values. By default,
        the generation of error scalars is disabled.
        """
    )

    def _generate_error_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateErrorScalars,
                        self.generate_error_scalars_)

    generate_error_vectors = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off the generation of error vectors. By default, the
        generation of error vectors is disabled.
        """
    )

    def _generate_error_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateErrorVectors,
                        self.generate_error_vectors_)

    constraint_strategy = tvtk_base.RevPrefixMap({'default': 0, 'constraint_array': 2, 'constraint_distance': 1}, default_value='default', desc=\
        r"""
        Indicate how to apply constraints. By default, a constraint array
        takes precedence over the filter's constraint distance, but if
        not available then the constraint distance is used. If a
        CONSTRAINT_ARRAY strategy is specified, and no constraint array
        is available from the point data, then no constraints are
        provided. Note that is also possible to turn off constraints
        completely by simply specifying a very large constraint distance.
        The default constraint strategy is DEFAULT.
        """
    )

    def _constraint_strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstraintStrategy,
                        self.constraint_strategy_)

    constraint_distance = traits.Trait(0.001, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Specify a constraint distance for point motion. By default, if a
        point data array constraint distance (named
        "smoothing_constraints") is provided in the input point data, then
        the array takes precedence. By default, the constraint distance
        is 0.001.
        """
    )

    def _constraint_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstraintDistance,
                        self.constraint_distance)

    convergence = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Specify a convergence criterion for the iteration process.
        Smaller numbers result in more smoothing iterations. Convergence
        occurs when, for the current iteration, the maximum distance any
        point moves is less than or equal to Convergence. The default
        value is 0.
        """
    )

    def _convergence_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvergence,
                        self.convergence)

    number_of_iterations = traits.Trait(10, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the maximum number of iterations for smoothing. The
        number of iterations may be less if the smoothing process
        converges. The default value is 10.
        """
    )

    def _number_of_iterations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfIterations,
                        self.number_of_iterations)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    relaxation_factor = traits.Float(0.01, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the relaxation factor for smoothing. As in all iterative
        methods, the stability of the process is sensitive to this
        parameter. In general, small relaxation factors and large numbers
        of iterations are more stable than larger relaxation factors and
        smaller numbers of iterations. The default value is 0.01.
        """
    )

    def _relaxation_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRelaxationFactor,
                        self.relaxation_factor)

    def _get_smoothing_stencils(self):
        return wrap_vtk(self._vtk_obj.GetSmoothingStencils())
    def _set_smoothing_stencils(self, arg):
        old_val = self._get_smoothing_stencils()
        my_arg = deref_array([arg], [['vtkCellArray']])
        self._wrap_call(self._vtk_obj.SetSmoothingStencils,
                        my_arg[0])
        self.trait_property_changed('smoothing_stencils', old_val, arg)
    smoothing_stencils = traits.Property(_get_smoothing_stencils, _set_smoothing_stencils, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('generate_error_scalars', 'GetGenerateErrorScalars'),
    ('generate_error_vectors', 'GetGenerateErrorVectors'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('constraint_strategy', 'GetConstraintStrategy'),
    ('constraint_distance', 'GetConstraintDistance'), ('convergence',
    'GetConvergence'), ('number_of_iterations', 'GetNumberOfIterations'),
    ('output_points_precision', 'GetOutputPointsPrecision'),
    ('relaxation_factor', 'GetRelaxationFactor'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_error_scalars',
    'generate_error_vectors', 'global_warning_display',
    'release_data_flag', 'constraint_strategy', 'constraint_distance',
    'convergence', 'number_of_iterations', 'object_name',
    'output_points_precision', 'progress_text', 'relaxation_factor'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ConstrainedSmoothingFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ConstrainedSmoothingFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_error_scalars', 'generate_error_vectors'],
            ['constraint_strategy'], ['constraint_distance', 'convergence',
            'number_of_iterations', 'object_name', 'output_points_precision',
            'relaxation_factor']),
            title='Edit ConstrainedSmoothingFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ConstrainedSmoothingFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

