# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class AbstractTransform(Object):
    r"""
    TransformConcatenationStack - Store a stack of concatenations.
    
    Superclass: Object
    
    A helper class (not derived from Object) to store a stack of
    concatenations.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractTransform, obj, update, **traits)
    
    def _get_inverse(self):
        return wrap_vtk(self._vtk_obj.GetInverse())
    def _set_inverse(self, arg):
        old_val = self._get_inverse()
        self._wrap_call(self._vtk_obj.SetInverse,
                        deref_vtk(arg))
        self.trait_property_changed('inverse', old_val, arg)
    inverse = traits.Property(_get_inverse, _set_inverse, desc=\
        r"""
        Get the inverse of this transform.  If you modify this transform,
        the returned inverse transform will automatically update.  If you
        want the inverse of a Transform, you might want to use
        get_linear_inverse() instead which will type cast the result from
        AbstractTransform to LinearTransform.
        """
    )

    def circuit_check(self, *args):
        """
        circuit_check(self, transform:AbstractTransform) -> int
        C++: virtual int circuit_check(AbstractTransform *transform)
        Check for self-reference.  Will return true if concatenating with
        the specified transform, setting it to be our inverse, or setting
        it to be our input will create a circular reference. circuit_check
        is automatically called by set_input(), set_inverse(), and
        Concatenate(XTransform *).  Avoid using this function, it is
        experimental.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CircuitCheck, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, __a:AbstractTransform) -> None
        C++: void deep_copy(AbstractTransform *)
        Copy this transform from another of the same type.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def internal_transform_derivative(self, *args):
        """
        internal_transform_derivative(self, in_:(float, float, float),
            out:[float, float, float], derivative:[[float, float, float],
            [float, float, float], [float, float, float]]) -> None
        C++: virtual void internal_transform_derivative(const double in[3],
            double out[3], double derivative[3][3])"""
        ret = self._wrap_call(self._vtk_obj.InternalTransformDerivative, *args)
        return ret

    def internal_transform_point(self, *args):
        """
        internal_transform_point(self, in_:(float, float, float),
            out:[float, float, float]) -> None
        C++: virtual void internal_transform_point(const double in[3],
            double out[3])"""
        ret = self._wrap_call(self._vtk_obj.InternalTransformPoint, *args)
        return ret

    def inverse(self):
        """
        inverse(self) -> None
        C++: virtual void inverse()
        Invert the transformation.
        """
        ret = self._vtk_obj.Inverse()
        return ret
        

    def make_transform(self):
        """
        make_transform(self) -> AbstractTransform
        C++: virtual AbstractTransform *make_transform()
        Make another transform of the same type.
        """
        ret = wrap_vtk(self._vtk_obj.MakeTransform())
        return ret
        

    def transform_double_normal_at_point(self, *args):
        """
        transform_double_normal_at_point(self, point:(float, float, float),
            normal:(float, float, float)) -> (float, float, float)
        C++: double *transform_double_normal_at_point(const double point[3],
            const double normal[3])
        Apply the transformation to a double-precision normal at the
        specified vertex.  If the transformation is a LinearTransform,
        you can use transform_double_normal() instead.
        """
        ret = self._wrap_call(self._vtk_obj.TransformDoubleNormalAtPoint, *args)
        return ret

    def transform_double_point(self, *args):
        """
        transform_double_point(self, x:float, y:float, z:float) -> (float,
            float, float)
        C++: double *transform_double_point(double x, double y, double z)
        transform_double_point(self, point:(float, float, float)) -> (float,
             float, float)
        C++: double *transform_double_point(const double point[3])
        Apply the transformation to a double-precision (x,y,z)
        coordinate. Use this if you are programming in Python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformDoublePoint, *args)
        return ret

    def transform_double_vector_at_point(self, *args):
        """
        transform_double_vector_at_point(self, point:(float, float, float),
            vector:(float, float, float)) -> (float, float, float)
        C++: double *transform_double_vector_at_point(const double point[3],
            const double vector[3])
        Apply the transformation to a double-precision vector at the
        specified vertex.  If the transformation is a LinearTransform,
        you can use transform_double_vector() instead.
        """
        ret = self._wrap_call(self._vtk_obj.TransformDoubleVectorAtPoint, *args)
        return ret

    def transform_float_normal_at_point(self, *args):
        """
        transform_float_normal_at_point(self, point:(float, float, float),
            normal:(float, float, float)) -> (float, float, float)
        C++: float *transform_float_normal_at_point(const float point[3],
            const float normal[3])
        Apply the transformation to a single-precision normal at the
        specified vertex.  If the transformation is a LinearTransform,
        you can use transform_float_normal() instead.
        """
        ret = self._wrap_call(self._vtk_obj.TransformFloatNormalAtPoint, *args)
        return ret

    def transform_float_point(self, *args):
        """
        transform_float_point(self, x:float, y:float, z:float) -> (float,
            float, float)
        C++: float *transform_float_point(float x, float y, float z)
        transform_float_point(self, point:(float, float, float)) -> (float,
            float, float)
        C++: float *transform_float_point(const float point[3])
        Apply the transformation to an (x,y,z) coordinate. Use this if
        you are programming in Python or Java.
        """
        ret = self._wrap_call(self._vtk_obj.TransformFloatPoint, *args)
        return ret

    def transform_float_vector_at_point(self, *args):
        """
        transform_float_vector_at_point(self, point:(float, float, float),
            vector:(float, float, float)) -> (float, float, float)
        C++: float *transform_float_vector_at_point(const float point[3],
            const float vector[3])
        Apply the transformation to a single-precision vector at the
        specified vertex.  If the transformation is a LinearTransform,
        you can use transform_float_vector() instead.
        """
        ret = self._wrap_call(self._vtk_obj.TransformFloatVectorAtPoint, *args)
        return ret

    def transform_normal_at_point(self, *args):
        """
        transform_normal_at_point(self, point:(float, float, float), in_:(
            float, float, float), out:[float, float, float]) -> None
        C++: void transform_normal_at_point(const double point[3],
            const double in[3], double out[3])
        transform_normal_at_point(self, point:(float, float, float), normal:(
            float, float, float)) -> (float, float, float)
        C++: double *transform_normal_at_point(const double point[3],
            const double normal[3])"""
        ret = self._wrap_call(self._vtk_obj.TransformNormalAtPoint, *args)
        return ret

    def transform_point(self, *args):
        """
        transform_point(self, in_:(float, float, float), out:[float, float,
             float]) -> None
        C++: void transform_point(const double in[3], double out[3])
        transform_point(self, x:float, y:float, z:float) -> (float, float,
            float)
        C++: double *transform_point(double x, double y, double z)
        transform_point(self, point:(float, float, float)) -> (float,
            float, float)
        C++: double *transform_point(const double point[3])
        Apply the transformation to a double-precision coordinate. You
        can use the same array to store both the input and output point.
        """
        ret = self._wrap_call(self._vtk_obj.TransformPoint, *args)
        return ret

    def transform_points(self, *args):
        """
        transform_points(self, inPts:Points, outPts:Points) -> None
        C++: virtual void transform_points(Points *inPts,
            Points *outPts)
        Apply the transformation to a series of points, and append the
        results to outPts.
        """
        my_args = deref_array(args, [('vtkPoints', 'vtkPoints')])
        ret = self._wrap_call(self._vtk_obj.TransformPoints, *my_args)
        return ret

    def transform_vector_at_point(self, *args):
        """
        transform_vector_at_point(self, point:(float, float, float), in_:(
            float, float, float), out:[float, float, float]) -> None
        C++: void transform_vector_at_point(const double point[3],
            const double in[3], double out[3])
        transform_vector_at_point(self, point:(float, float, float), vector:(
            float, float, float)) -> (float, float, float)
        C++: double *transform_vector_at_point(const double point[3],
            const double vector[3])"""
        ret = self._wrap_call(self._vtk_obj.TransformVectorAtPoint, *args)
        return ret

    def update(self):
        """
        update(self) -> None
        C++: void update()
        Update the transform to account for any changes which have been
        made.  You do not have to call this method yourself, it is called
        automatically whenever the transform needs an update.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractTransform, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit AbstractTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

