#!/bin/sh

mainDir="$HOME/devel/massxpert"

tarballDir="${mainDir}/tarballs"
buildDir="${mainDir}/build-area"

devDir="${mainDir}/development"
debianDir="${devDir}/debian"

cd ${devDir}

# $1 is the branch or tag name of the upstream against which the orig
# is to be built.

upstream=""

if [ "x$1" != "x" ]
then
    upstream=$1
else
    upstream="upstream"
fi


# Check that we are in the master branch

gitOutput=$(git status | head -n1)
if [ "${gitOutput}" != "# On branch master" ]
then
    echo "Checkout the master branch first."
    exit
fi

# Check that we have nothing to commit.

gitOutput=$(git status | \
    grep "nothing to commit" | awk '{print $1 $2 $3}')

if [ "${gitOutput}" != "nothingtocommit" ]
then
    echo "Branch master is not clean." 
    exit
fi

# Check that we have no modification with respect to the upstream
# branch, that is that the only diff between the current master branch
# and the upstream branch are only in debian/.

diffText=$(git diff ${upstream} | grep +++ | grep -v debian)
if [ "x${diffText}" != "x" ]
then
    echo "Branches differ not only by the debian/ contents:"
    echo "${diffText}"
    exit
fi

DEBVER=$(head -n1 ${debianDir}/changelog | \
    awk '{print $2}' | sed 's|(\([0-9\.-]*\))|\1|')
UPVER=$(echo ${DEBVER} | sed 's/-[0-9]\+//')

echo "Making .orig.tar.{gz,bz2} for"
echo "    UPVER=${UPVER}"
echo "    DEBVER=${DEBVER}"

echo ""
echo "Is this correct? Can Ctrl-C to stop process. Return to accept"
read answer
echo "Going on, then."

# Now that we have the Upstream version, we can craft the name of the
# orig.tar.gz tarball.

origTarball=massxpert_${UPVER}.orig.tar.bz2

# We have to make that archive:

git archive --format=tar --verbose \
    --prefix=massxpert-${UPVER}/ ${upstream} -- | \
    bzip2 -c - > ${tarballDir}/${origTarball}

echo ""
echo "Making ${tarballDir}/${origTarball} done."
echo " "
echo "Should start git-buildpackage ? Can Ctr-C to stop process."
read answer
git-buildpackage
