/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module manages the symbol table for constants, variables and rules. */

/* Functions that use the symbol table for rules and functions. =============*/

extern int_t enter_rule( string_t name, 
                         int_t first_instr, 
                         rule_type_t type, 
                         int_t param_count,
			 int_t rule_line,
			 string_t rule_file );
/* Enter into the symbol table the rule NAME of TYPE that starts at FIRST_INSTR
 * and takes PARAM_COUNT parameters. The source is at RULE_LINE in RULE_FILE. 
 * The rule number will be returned. */

extern void enter_function( string_t name, int_t index );
/* Associate standard function NAME with INDEX. */

extern rule_t *find_subrule( string_t name, 
			     int_t *rule_number, 
			     int line, string_t file );
/* Find subrule or standard function NAME and return its rule descriptor.
 * If the rule descriptor is NULL, NAME denotes a standard function.
 * If RULE_NUMBER != NULL, save the rule index in *RULE_NUMBER. */

extern rule_t *find_combi_rule( string_t name, 
				int_t *rule_number, 
				int line, string_t file );
/* Find combi-rule or end-rule NAME and return its rule descriptor.
 * If the rule descriptor is NULL, NAME describes a standard function.
 * If RULE_NUMBER != NULL, save the rule index in *RULE_NUMBER. */

extern void check_rules_defined( void );
/* Check if all rules in the symbol tree are defined. */

extern string_t get_rule_file( string_t name );
/* Return file where rule NAME is defined. */

extern int_t get_rule_line( string_t name );
/* Return line where rule NAME is defined. */

/* Functions that use the symbol table for variables. =======================*/

extern string_t define_variable( string_t name, int_t stack_index );
/* Define the value on index STACK_INDEX to be a new variable with NAME.
 * Return a copy of its name in the string pool. */

extern void undefine_variable( string_t name );
/* Close the scope of variable NAME. */

extern int_t find_variable( string_t name );
/* Find variable NAME in the symbol table and return its stack index. */

/* Functions that use the symbol table for constants. =======================*/

extern int_t find_constant( string_t name );
/* Find constant NAME in the symbol table and return its value pool index. 
 * If the constant only has a default value, it becomes the real value. */

extern void define_constant( string_t name, int_t const_index, bool_t fixed );
/* Define constant NAME with value at CONST_INDEX in the value pool.
 * If FIXED is FALSE, the value given is only a default value. */

/*---------------------------------------------------------------------------*/

extern void dump_variables_and_constants( void );
/* Dump all variables and constants in the table. */

extern void free_symbols( void );
/* Free all memory used by the symbol table. */

/* End of file. =============================================================*/
