#!/usr/bin/python
# Copyright (C) 2005-2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Hello World Test

This is a basic test to verify that mago-ng is working as expected and can
be run with various testing framework

To run it with:
$ mago-ng <path_to_this_file>

You can code ldtp directly in there or an external module
The only mandatory element is 'launcher' (and window_name for now)

set setupOnce to False to launch/close the app for each test

The purpose of this example is to demo a very basic manipulation of an
application and validate the 'force_close' feature when a dialog pops up
inadventently after the end of the test.

"""

from mago import TestCase
import ldtp

class TestHelloWorld(TestCase):
    """Test Class"""

    launcher = 'gedit'
    launcher_args = []
    window_name = 'frm*gedit'
    setupOnce = True

    def test_helloworld(self):
        """Test Method

        Change the content of the edit buffer of gedit marking it dirty
        The close action triggered in the teardown will popup the
        "unsaved changes" dialog.

        The application should close after 30 seconds.
        """

        txt = """Hello World!

A dialog will popup and ask you:
    "Save changes to document "Untitled Document 1" before closing?"

Don't close it but wait 60 seconds and it should close automatically.
If it does not please report a bug against mago.
        """
        ldtp.settextvalue(self.window_name, 'txt1', txt)
        ldtp.wait(2)
