#!/usr/bin/env python

"""
LBAgent is a service to be executed on the nodes of the cluster.
It give a xmlrpc access to hardware specifications and to the current status of the node.
A tread is responsible to refresh status information of all variables
"""

import re
import sys
import string

def execCommand(command):
    import os
    fd = os.popen(command)
    consoleOutput = fd.readlines()
    fd.close()
    for i in range(len(consoleOutput)):
        consoleOutput[i]=string.strip(consoleOutput[i].replace('\n',''))
        try:
            consoleOutput[i]=eval(consoleOutput[i])
        except:
            pass
    if len(consoleOutput) == 1:
        consoleOutput = consoleOutput[0]
    return consoleOutput


class LBAgent:
    """
    LBAgent
    Manage constants and variables
    """
    def __init__(self):
        self.listen=('',8000)
        self.constants = []
        self.variables = []
    def reloadAll(self):
        for c in self.constants:
            c.reload()
        for v in self.variables:
            v.reload()
    def parseString(self,s):
        # Sort by name length
        sTab = [] + self.constants + self.variables
        sTab.sort(lambda v1, v2: cmp(len(v2.name),len(v1.name)))
        # Replace value in string
        for x in sTab:
            if not(isinstance(x.value,list)):
                s = s.replace('$'+x.name,str(x.value))
        return s
    def getSpecsStruct(self):
        return [c.getStruct() for c in self.constants]
    def getStatusStruct(self):
        return [v.getStruct() for v in self.variables]

class LBConstant:
    """
    Constant
    Contains hardware specification
    """
    def __init__(self,lbAgent):
        self._lbAgent=lbAgent
        self.name=None
        self.value=None
        self.command=None
        self.eval=None
    def reload(self):
        if self.command != None:
            self.value = execCommand(self.command)
        elif self.eval != None:
            self.value = eval(self._lbAgent.parseString(self.eval))
    def getStruct(self):
        strt = {}
        strt["name"] = self.name
        strt["value"] = self.value
        return strt

class LBVariable:
    """
    Variable
    Contains status information
    """
    def __init__(self,lbAgent):
        self._lbAgent=lbAgent
        self.name=None
        self.value=None
        self.command=None
        self.eval=None
        self.capacity=None
        self.critical=None
        self.capacityValue=None
        self.criticalValue=None
        self.refresh=60
    def reload(self):
        if self.command != None:
            self.value = execCommand(self.command)
        elif self.eval != None:
            try:
                self.value = eval(self._lbAgent.parseString(self.eval))
            except:
                print "ERROR: Variable :%s eval=%s, eval(%s) except %s"%(self.name,self.eval,str(self._lbAgent.parseString(self.eval)),str(sys.exc_info()[0]))
        if self.capacity!=None:
            self.capacityValue=eval(self._lbAgent.parseString(self.capacity))
        if self.critical!=None:
            self.criticalValue=eval(self._lbAgent.parseString(self.critical))
        
    def getStruct(self):
        strt = {}
        strt["name"] = self.name
        strt["value"] = self.value
        if self.capacityValue != None:
            strt["capacity"] = self.capacityValue
        if self.criticalValue != None:
            strt["critical"] = self.criticalValue
        return strt

def main():
    pass

if __name__ == "__main__":
    main()

