/*
 * Copyright 2020 Ubports Foundation
 *
 * Authors:
 *  Lionel Duboeuf
 *
 * This file is part of messaging-app.
 *
 * lomiri-dialer-app is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * lomiri-dialer-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Qt
#include <QtQuickTest/QtQuickTest>
#include <QtQml/QtQml>

// local
#include "dialpadsearch.h"

class Setup : public QObject
{
    Q_OBJECT

public:
    Setup() {}

public Q_SLOTS:
    void applicationAvailable() {
        const char* uri = "dialerapp.private";
        qmlRegisterType<DialPadSearch>(uri, 0, 1, "DialPadSearch");
    }
};

QUICK_TEST_MAIN_WITH_SETUP(tst_QmlTests, Setup)
#include "tst_QmlTests.moc"
