; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=tailcallelim -verify-dom-info -S | FileCheck %s

; IR for that test was generated from the following C++ source:
;
;int count;
;__attribute__((noinline)) void globalIncrement(const int* param) { count += *param; }
;
;void test(int recurseCount)
;{
;    if (recurseCount == 0) return;
;    int temp = 10;
;    globalIncrement(&temp);
;    test(recurseCount - 1);
;}
;

@count = dso_local local_unnamed_addr global i32 0, align 4

; Function Attrs: nofree noinline norecurse nounwind uwtable
declare void @_Z15globalIncrementPKi(ptr nocapture readonly %param) #0

; Test that TRE could be done for recursive tail routine containing
; call to function receiving a pointer to local stack.

; Function Attrs: nounwind uwtable
define dso_local void @_Z4testi(i32 %recurseCount) local_unnamed_addr #1 {
; CHECK-LABEL: @_Z4testi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEMP:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br label [[TAILRECURSE:%.*]]
; CHECK:       tailrecurse:
; CHECK-NEXT:    [[RECURSECOUNT_TR:%.*]] = phi i32 [ [[RECURSECOUNT:%.*]], [[ENTRY:%.*]] ], [ [[SUB:%.*]], [[IF_END:%.*]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[RECURSECOUNT_TR]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[RETURN:%.*]], label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr nonnull [[TEMP]])
; CHECK-NEXT:    store i32 10, ptr [[TEMP]], align 4
; CHECK-NEXT:    call void @_Z15globalIncrementPKi(ptr nonnull [[TEMP]])
; CHECK-NEXT:    [[SUB]] = add nsw i32 [[RECURSECOUNT_TR]], -1
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 4, ptr nonnull [[TEMP]])
; CHECK-NEXT:    br label [[TAILRECURSE]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %temp = alloca i32, align 4
  %cmp = icmp eq i32 %recurseCount, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %temp) #6
  store i32 10, ptr %temp, align 4
  call void @_Z15globalIncrementPKi(ptr nonnull %temp)
  %sub = add nsw i32 %recurseCount, -1
  call void @_Z4testi(i32 %sub)
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %temp) #6
  br label %return

return:                                           ; preds = %entry, %if.end
  ret void
}

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture) #2

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture) #2

attributes #0 = { nofree noinline norecurse nounwind uwtable }
attributes #1 = { nounwind uwtable }
attributes #2 = { argmemonly nounwind willreturn }
