# Lintian SSG

[![build][build-img]][build-url] [![coverage][cover-img]][cover-url] [![goreport][report-img]][report-url] [![version][version-img]][version-url]

A very simple static site generator that builds a Web version of [Lintian] tags'
explanations, based on the output of `lintian-explain-tags --format=json`.
It is used to generate the pages of <https://lintian.debian.org>.

Interesting examples include [very-long-line-length-in-source-file] as it
displays all fields and [override_dh_auto_test-does-not-check-DEB_BUILD_OPTIONS]
for its rich markup.

[Lintian]: https://salsa.debian.org/lintian/lintian
[very-long-line-length-in-source-file]: https://lintian.club1.fr/tags/very-long-line-length-in-source-file.html
[override_dh_auto_test-does-not-check-DEB_BUILD_OPTIONS]: https://lintian.club1.fr/tags/override_dh_auto_test-does-not-check-DEB_BUILD_OPTIONS.html

## Build

The only build requirement is Go >= `1.18`.

```sh
go generate ./version # to include version, only from a git checkout
go build
go test ./...         # optionally, to run tests
```

## Usage

```--help
Usage: lintian-ssg [OPTION]...

Generate a static web site for Lintian tags' explanations. By default, it will
call lintian-explain-tags in a subprocess, except if the --tags-file option is
provided.

Options:
  --base-url=URL        URL, including the scheme, where the root of the website
                        will be located. This will be used in the sitemap, the
                        canonical link of each page and the robots.txt.

  --footer=TEXT         TEXT to add to the footer, inline Markdown elements will
                        be parsed.

  --lintian-version=V   Override Lintian's version in output with V.
  --manual-file=FILE    Read Lintian's manual from FILE.
                        (default "/usr/share/doc/lintian/lintian.html")

  --no-sitemap          Disable sitemap.xml.gz (and thus robots.txt) generation.
  -o, --output-dir=DIR  Path of the directory DIR where to output the generated
                        website. (default "out")

  --stats               Display some statistics.
  --tags-file=FILE      Read Lintian tags from FILE (in JSON format).

  --debug               Print stack traces on errors.
  -h, --help            Show this help and exit.
  --version             Show version and exit.
```

## Recommended HTTP server configs

### Apache (global, vhost)

```apache
# For a more friendly 404 error page
ErrorDocument 404 /404.html

<Location "/tags/">
	# To allow access .html files without their extension
	Options +MultiViews
</Location>
```

### Nginx (server)

```nginx
# For a more friendly 404 error page
error_page 404 /404.html;

location /tags/ {
    # To allow access .html files without their extension
    try_files $uri.html $uri =404;
}
```

[build-img]: https://salsa.debian.org/lintian/lintian-ssg/badges/main/pipeline.svg
[build-url]: https://salsa.debian.org/lintian/lintian-ssg/-/commits/main
[cover-img]: https://salsa.debian.org/lintian/lintian-ssg/badges/main/coverage.svg
[cover-url]: https://salsa.debian.org/lintian/lintian-ssg/-/graphs/main/charts
[report-img]: https://goreportcard.com/badge/salsa.debian.org/lintian/lintian-ssg
[report-url]: https://goreportcard.com/report/salsa.debian.org/lintian/lintian-ssg
[version-img]: https://badges.debian.net/badges/debian/testing/lintian-ssg/version.svg
[version-url]: https://tracker.debian.org/pkg/lintian-ssg
