/**************************************************************************
    Lightspark, a free flash player implementation

    Copyright (C) 2013  Alessandro Pignotti (a.pignotti@sssup.it)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

/* This file is generated by errorgen - DO NOT EDIT */

#include <initializer_list>
#include "errorconstants.h"
#include "compat.h"

namespace lightspark
{

const std::map<int, const char *> errorMessages = {
	{kOutOfMemoryError, _("The system is out of memory.")},
	{kNotImplementedError, _("The method %1 is not implemented.")},
	{kInvalidPrecisionError, _("Number.toPrecision has a range of 1 to 21. Number.toFixed and Number.toExponential have a range of 0 to 20. Specified value is not within expected range.")},
	{kInvalidRadixError, _("The radix argument must be between 2 and 36; got %1.")},
	{kInvokeOnIncompatibleObjectError, _("Method %1 was invoked on an incompatible object.")},
	{kArrayIndexNotIntegerError, _("Array index is not a positive integer (%1).")},
	{kCallOfNonFunctionError, _("%1 is not a function.")},
	{kConstructOfNonFunctionError, _("Instantiation attempted on a non-constructor.")},
	{kAmbiguousBindingError, _("%1 is ambiguous; Found more than one matching binding.")},
	{kConvertNullToObjectError, _("Cannot access a property or method of a null object reference.")},
	{kConvertUndefinedToObjectError, _("A term is undefined and has no properties.")},
	{kIllegalOpcodeError, _("Method %1 contained illegal opcode %2 at offset %3.")},
	{kLastInstExceedsCodeSizeError, _("The last instruction exceeded code size.")},
	{kFindVarWithNoScopeError, _("Cannot call OP_findproperty when scopeDepth is 0.")},
	{kClassNotFoundError, _("Class %1 could not be found.")},
	{kIllegalSetDxns, _("Method %1 cannot set default xml namespace")},
	{kDescendentsError, _("Descendants operator (..) not supported on type %1.")},
	{kScopeStackOverflowError, _("Scope stack overflow occurred.")},
	{kScopeStackUnderflowError, _("Scope stack underflow occurred.")},
	{kGetScopeObjectBoundsError, _("Getscopeobject %1 is out of bounds.")},
	{kCannotFallOffMethodError, _("Code cannot fall off the end of a method.")},
	{kInvalidBranchTargetError, _("At least one branch target was not on a valid instruction in the method.")},
	{kIllegalVoidError, _("Type void may only be used as a function return type.")},
	{kStackOverflowError, _("Stack overflow occurred.")},
	{kStackUnderflowError, _("Stack underflow occurred.")},
	{kInvalidRegisterError, _("An invalid register %1 was accessed.")},
	{kSlotExceedsCountError, _("Slot %1 exceeds slotCount=%2 of %3.")},
	{kMethodInfoExceedsCountError, _("Method_info %1 exceeds method_count=%2.")},
	{kDispIdExceedsCountError, _("Disp_id %1 exceeds max_disp_id=%2 of %3.")},
	{kDispIdUndefinedError, _("Disp_id %1 is undefined on %2.")},
	{kStackDepthUnbalancedError, _("Stack depth is unbalanced. %1 != %2.")},
	{kScopeDepthUnbalancedError, _("Scope depth is unbalanced. %1 != %2.")},
	{kCpoolIndexRangeError, _("Cpool index %1 is out of range %2.")},
	{kCpoolEntryWrongTypeError, _("Cpool entry %1 is wrong type.")},
	{kCheckTypeFailedError, _("Type Coercion failed: cannot convert %1 to %2.")},
	{kIllegalSuperCallError, _("Illegal super expression found in method %1.")},
	{kCannotAssignToMethodError, _("Cannot assign to a method %1 on %2.")},
	{kRedefinedError, _("%1 is already defined.")},
	{kCannotVerifyUntilReferencedError, _("Cannot verify method until it is referenced.")},
	{kCantUseInstanceofOnNonObjectError, _("The right-hand side of instanceof must be a class or function.")},
	{kIsTypeMustBeClassError, _("The right-hand side of operator must be a class.")},
	{kInvalidMagicError, _("Not an ABC file.  major_version=%1 minor_version=%2.")},
	{kInvalidCodeLengthError, _("Invalid code_length=%1.")},
	{kInvalidMethodInfoFlagsError, _("MethodInfo-%1 unsupported flags=%2.")},
	{kUnsupportedTraitsKindError, _("Unsupported traits kind=%1.")},
	{kMethodInfoOrderError, _("MethodInfo-%1 referenced before definition.")},
	{kMissingEntryPointError, _("No entry point was found.")},
	{kPrototypeTypeError, _("Prototype objects must be vanilla Objects.")},
	{kConvertToPrimitiveError, _("Cannot convert %1 to primitive.")},
	{kIllegalEarlyBindingError, _("Illegal early binding access to %1.")},
	{kInvalidURIError, _("Invalid URI passed to %1 function.")},
	{kIllegalOverrideError, _("Illegal override of %1 in %2.")},
	{kIllegalExceptionHandlerError, _("Illegal range or target offsets in exception handler.")},
	{kWriteSealedError, _("Cannot create property %1 on %2.")},
	{kIllegalSlotError, _("%1 can only contain methods.")},
	{kIllegalOperandTypeError, _("Illegal operand type: %1 must be %2.")},
	{kClassInfoOrderError, _("ClassInfo-%1 is referenced before definition.")},
	{kClassInfoExceedsCountError, _("ClassInfo %1 exceeds class_count=%2.")},
	{kNumberOutOfRangeError, _("The value %1 cannot be converted to %2 without losing precision.")},
	{kWrongArgumentCountError, _("Argument count mismatch on %1. Expected %2, got %3.")},
	{kCannotCallMethodAsConstructor, _("Cannot call method %1 as constructor.")},
	{kUndefinedVarError, _("Variable %1 is not defined.")},
	{kFunctionConstructorError, _("The form function('function body') is not supported.")},
	{kIllegalNativeMethodBodyError, _("Native method %1 has illegal method body.")},
	{kCannotMergeTypesError, _("%1 and %2 cannot be reconciled.")},
	{kReadSealedError, _("Property %1 not found on %2 and there is no default value.")},
	{kCallNotFoundError, _("Method %1 not found on %2")},
	{kAlreadyBoundError, _("Function %1 has already been bound to %2.")},
	{kZeroDispIdError, _("Disp_id 0 is illegal.")},
	{kDuplicateDispIdError, _("Non-override method %1 replaced because of duplicate disp_id %2.")},
	{kConstWriteError, _("Illegal write to read-only property %1 on %2.")},
	{kMathNotFunctionError, _("Math is not a function.")},
	{kMathNotConstructorError, _("Math is not a constructor.")},
	{kWriteOnlyError, _("Illegal read of write-only property %1 on %2.")},
	{kIllegalOpMultinameError, _("Illegal opcode/multiname combination: %1<%2>.")},
	{kIllegalNativeMethodError, _("Native methods are not allowed in loaded code.")},
	{kIllegalNamespaceError, _("Illegal value for namespace.")},
	{kReadSealedErrorNs, _("Property %1 not found on %2 and there is no default value.")},
	{kNoDefaultNamespaceError, _("No default namespace has been set.")},
	{kXMLPrefixNotBound, _("The prefix \"%1\" for element \"%2\" is not bound.")},
	{kXMLBadQName, _("Element or attribute (\"%1\") does not match QName production: QName::=(NCName':')?NCName.")},
	{kXMLUnterminatedElementTag, _("The element type \"%1\" must be terminated by the matching end-tag \"</%2>\".")},
	{kXMLOnlyWorksWithOneItemLists, _("The %1 method only works on lists containing one item.")},
	{kXMLAssignmentToIndexedXMLNotAllowed, _("Assignment to indexed XML is not allowed.")},
	{kXMLMarkupMustBeWellFormed, _("The markup in the document following the root element must be well-formed.")},
	{kXMLAssigmentOneItemLists, _("Assignment to lists with more than one item is not supported.")},
	{kXMLMalformedElement, _("XML parser failure: element is malformed.")},
	{kXMLUnterminatedCData, _("XML parser failure: Unterminated CDATA section.")},
	{kXMLUnterminatedXMLDecl, _("XML parser failure: Unterminated XML declaration.")},
	{kXMLUnterminatedDocTypeDecl, _("XML parser failure: Unterminated DOCTYPE declaration.")},
	{kXMLUnterminatedComment, _("XML parser failure: Unterminated comment.")},
	{kXMLUnterminatedAttribute, _("XML parser failure: Unterminated attribute.")},
	{kXMLUnterminatedElement, _("XML parser failure: Unterminated element.")},
	{kXMLUnterminatedProcessingInstruction, _("XML parser failure: Unterminated processing instruction.")},
	{kXMLNamespaceWithPrefixAndNoURI, _("Illegal prefix %1 for no namespace.")},
	{kRegExpFlagsArgumentError, _("Cannot supply flags when constructing one RegExp from another.")},
	{kNoScopeError, _("Cannot verify method %1 with unknown scope.")},
	{kIllegalDefaultValue, _("Illegal default value for type %1.")},
	{kCannotExtendFinalClass, _("Class %1 cannot extend final base class.")},
	{kXMLDuplicateAttribute, _("Attribute \"%1\" was already specified for element \"%2\".")},
	{kCorruptABCError, _("The ABC data is corrupt, attempt to read out of bounds.")},
	{kInvalidBaseClassError, _("The OP_newclass opcode was used with the incorrect base class.")},
	{kDanglingFunctionError, _("Attempt to directly call unbound function %1 from method %2.")},
	{kCannotExtendError, _("%1 cannot extend %2.")},
	{kCannotImplementError, _("%1 cannot implement %2.")},
	{kCoerceArgumentCountError, _("Argument count mismatch on class coercion.  Expected 1, got %1.")},
	{kInvalidNewActivationError, _("OP_newactivation used in method without NEED_ACTIVATION flag.")},
	{kNoGlobalScopeError, _("OP_getglobalslot or OP_setglobalslot used with no global scope.")},
	{kNotConstructorError, _("%1 is not a constructor.")},
	{kApplyError, _("second argument to Function.prototype.apply must be an array.")},
	{kXMLInvalidName, _("Invalid XML name: %1.")},
	{kXMLIllegalCyclicalLoop, _("Illegal cyclical loop between nodes.")},
	{kDeleteTypeError, _("Delete operator is not supported with operand of type %1.")},
	{kDeleteSealedError, _("Cannot delete property %1 on %2.")},
	{kDuplicateMethodBodyError, _("Method %1 has a duplicate method body.")},
	{kIllegalInterfaceMethodBodyError, _("Interface method %1 has illegal method body.")},
	{kFilterError, _("Filter operator not supported on type %1.")},
	{kInvalidHasNextError, _("OP_hasnext2 requires object and index to be distinct registers.")},
	{kOutOfRangeError, _("The index %1 is out of range %2.")},
	{kVectorFixedError, _("Cannot change the length of a fixed Vector.")},
	{kTypeAppOfNonParamType, _("Type application attempted on a non-parameterized type.")},
	{kWrongTypeArgCountError, _("Incorrect number of type parameters for %1. Expected %2, got %3.")},
	{kJSONCyclicStructure, _("Cyclic structure cannot be converted to JSON string.")},
	{kJSONInvalidReplacer, _("Replacer argument to JSON stringifier must be an array or a two parameter function.")},
	{kJSONInvalidParseInput, _("Invalid JSON parse input.")},
	{kFileOpenError, _("Error occurred opening file %1.")},
	{kFileWriteError, _("Error occurred writing to file %1.")},
	{kScriptTimeoutError, _("A script has executed for longer than the default timeout period of 15 seconds.")},
	{kScriptTerminatedError, _("A script failed to exit after 30 seconds and was terminated.")},
	{kEndOfFileError, _("End of file.")},
	{kStringIndexOutOfBoundsError, _("The string index %1 is out of bounds; must be in range %2 to %3.")},
	{kInvalidRangeError, _("The specified range is invalid.")},
	{kNullArgumentError, _("Argument %1 cannot be null.")},
	{kInvalidArgumentError, _("The value specified for argument %1 is invalid.")},
	{kArrayFilterNonNullObjectError, _("When the callback argument is a method of a class, the optional this argument must be null.")},
	{kWorkerAlreadyStarted, _("Worker is already started.")},
	{kFailedWorkerCannotBeRestarted, _("Starting a worker that already failed is not supported.")},
	{kWorkerTerminated, _("Worker has terminated.\"")},
	{kMutextNotLocked, _("unlock() with no preceding matching lock().")},
	{kConditionInvalidTimeout, _("Invalid condition timeout value: %1.")},
	{kConditionCannotNotify, _("Condition cannot notify if associated mutex is not owned.")},
	{kConditionCannotNotifyAll, _("Condition cannot notifyAll if associated mutex is not owned.")},
	{kConditionCannotWait, _("Condition cannot wait if associated mutex is not owned.")},
	{kConditionCannotBeInitialized, _("Condition cannot be initialized.")},
	{kMutexCannotBeInitialized, _("Mutex cannot be initialized.")},
	{kWorkerIllegalCallToStart, _("Only the worker's parent may call start.")},
	{kInvalidParamError, _("One of the parameters is invalid.")},
	{kParamRangeError, _("The supplied index is out of bounds.")},
	{kNullPointerError, _("Parameter %1 must be non-null.")},
	{kInvalidEnumError, _("Parameter %1 must be one of the accepted values.")},
	{kCantInstantiateError, _("%1 class cannot be instantiated.")},
	{kEOFError, _("End of file was encountered.")},
	{kCompressedDataError, _("There was an error decompressing the data.")},
	{kEmptyStringError, _("Parameter %1 must be non-empty string.")},
	{kProxyGetPropertyError, _("The Proxy class does not implement getProperty. It must be overridden by a subclass.")},
	{kProxySetPropertyError, _("The Proxy class does not implement setProperty. It must be overridden by a subclass.")},
	{kProxyCallPropertyError, _("The Proxy class does not implement callProperty. It must be overridden by a subclass.")},
	{kProxyHasPropertyError, _("The Proxy class does not implement hasProperty. It must be overridden by a subclass.")},
	{kProxyDeletePropertyError, _("The Proxy class does not implement deleteProperty. It must be overridden by a subclass.")},
	{kProxyGetDescendantsError, _("The Proxy class does not implement getDescendants. It must be overridden by a subclass.")},
	{kProxyNextNameIndexError, _("The Proxy class does not implement nextNameIndex. It must be overridden by a subclass.")},
	{kProxyNextNameError, _("The Proxy class does not implement nextName. It must be overridden by a subclass.")},
	{kProxyNextValueError, _("The Proxy class does not implement nextValue. It must be overridden by a subclass.")},
	{kInvalidArrayLengthError, _("The value %1 is not a valid Array length.")},
	{kReadExternalNotImplementedError, _("Unable to read object in stream.  The class %1 does not implement flash.utils.IExternalizable but is aliased to an externalizable class.")},
	};

};
