/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "auth/auth_tcp_client.h"
#include "auth/auth_server.h"
#include "commons/constants.h"
#include "client/ui/client_main_window.h"
#include "server/ui/server_main_window.h"
#include "commons/startup/startup_dialog.h"
#include "commons/startup/update_manager.h"
#include "commons/startup/user_mode.h"
#include <QApplication>
#include <QTimer>
#include <QCommandLinkButton>
#include <QPlastiqueStyle>
#include "server/core/network/connection_controller.h"

int consoleMode(int argc, char *argv[])
{
    // Console mode
    QCoreApplication app(argc, argv);
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    printf("\n---------------------------------------------------------");
    printf("\nKontrolPack Server Mode [Access securely your computer]                \n");
    printf("---------------------------------------------------------                \n");
    printf("   ##   ##                                 ######                        \n"
           "   ##  ##                                  ##  ##                        \n"
           "   ## ##                ##              ## ##  ##             ##  ##     \n"
           "   ####                 ####            ## ##  ##     #       ## ##      \n"
           "   ## ##   ##### ###### ##   #### ##### ## ###### ##### ##### ####       \n"
           "   ##  ##  #   # ##  ## ##   ##   #   # ## ##     ## ## #     ## ##      \n"
           "   ##   ## ##### ##  ## ##   ##   ##### ## ##     ##### ##### ##  ##     \n"
           "                                                                         \n"
           "   #################################################################     \n"
           "   #################################################################     \n\n\n");

    QString password_qstring = "";
    char password[200] = "";
    printf("Choose server master password :\n");
    fgets(password, sizeof password, stdin);
    password_qstring = QString(password);
    password_qstring = password_qstring.mid(0, password_qstring.length() - 1);
    if (password_qstring.length() < 8 || password_qstring.length() > 30) {
        printf("For security reason, password length must be between 8 an 30 digits.\n");
        exit(0);
        return 0;
    }
    QSettings settings("OpenNetwork", "KontrolPack");
    settings.setValue("ui/cli", "true");
    ConnectionController *controller = new ConnectionController;
    int start = controller->start_server(QString(password_qstring), QString(argv[2]), QString(argv[3]).toInt(), QString(argv[4]).toInt());
    if (start == 1 ) {
        printf("Server successfully started.\n");
    } else {
        printf("Server failed to start.\n");
        exit(0);
        return 0;
    }
    return app.exec();
}

bool processArgs(int argc, char **argv)
{
    if (argc >= 2)
    {
        QString arg1(argv[1]);
        if (arg1 == QLatin1String("-c") || arg1 == QLatin1String("-console")) {
            QString ip;
            QString port;
            QString port_file;
            if (argc > 2)
                ip = argv[2];
            if (argc > 4)
            {
                port = argv[3];
                port_file = argv[4];
                consoleMode(argc, argv);
            } else
            {
                printf("\n\n\tIp or ports parameters missing.\n\n");
                printf("kontrolpack -c SERVER_IP SERVER_PORT\n\n"
                           "\t-c(console)\t: Run KontrolPack client in console mode\nn\n");
            }
            return true;
        }
    }
    printf("\n\n\tIp or ports parameters missing.\n\n");
    printf("kontrolpack -c SERVER_IP SERVER_PORT\n\n"
               "\t-c(console)\t: Run KontrolPack client in console mode\nn\n");
    return false;
}

int main(int argc, char *argv[])
{
    if (argc >= 2)
    {
        bool running = processArgs(argc, argv);
        if (running)
            return 0;
    }

    Q_INIT_RESOURCE(resources);
    QSettings settings("OpenNetwork", "KontrolPack");
    settings.setValue("ui/cli", "false");
    QApplication app(argc, argv);
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));


    QString user_mode = settings.value("user/mode",
                                  "NONE").toString();

    app.setApplicationName("KontrolPack");
    app.setApplicationVersion(VERSION);
    app.setOrganizationName("Thomas THELLIEZ");

    QString locale =
            QLocale::system().name().section('_', 0, 0);
    QTranslator translator;
    translator.load(
            QString( ":/langs/kontrolpack_%1" ).arg(locale));

    app.installTranslator(&translator);
    QTranslator qtTranslator;
    qtTranslator.load(QString("qt_") + locale,
                      QLibraryInfo::location(
                              QLibraryInfo::TranslationsPath));

    app.installTranslator(&qtTranslator);

    QString update = settings.value("startup/update",
                                  "false").toString();
    if (update.startsWith("false", Qt::CaseInsensitive))
    {
        UpdateManager *updateManager = new UpdateManager();
        QTimer::singleShot(10000, updateManager, SLOT(autoUpdateManager()));
    }
    QString mode = settings.value("startup/mode",
                                  "NONE").toString();
    if (mode.startsWith("NONE",
                        Qt::CaseSensitive)) {
        StartUpDialog *startup_dialog = new StartUpDialog();
        startup_dialog->setWindowFlags(Qt::FramelessWindowHint);
#ifdef WIN32
        startup_dialog->setAttribute(
                Qt::WA_TranslucentBackground, true);
#elif defined __APPLE__
        startup_dialog->setAttribute(
                Qt::WA_TranslucentBackground, true);
#endif
        startup_dialog->show();
    } else if (mode.startsWith("SERVER",
                               Qt::CaseSensitive)) {
        settings.setValue("startup/mode",
                          "SERVER");
        ServerMainWindow *window = new ServerMainWindow;
        if (QtWin::isCompositionEnabled()) {
            QtWin::extendFrameIntoClientArea(window);
            window->setContentsMargins(0, 0, 0, 0);
        }
        window->show();
    } else if (mode.startsWith("CLIENT", Qt::CaseSensitive)) {
        settings.setValue("startup/mode", "CLIENT");
        ClientMainWindow *window = new ClientMainWindow;
        if (QtWin::isCompositionEnabled()) {
            QtWin::extendFrameIntoClientArea(window);
            window->setContentsMargins(0, 0, 0, 0);
        }
        window->show();
    }
    if (user_mode.startsWith("NONE", Qt::CaseInsensitive)) {
        UserModeWidGet *mode_widget = new UserModeWidGet;
        mode_widget->exec();
    }
    return app.exec();
}

