/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

struct responderplugininfo
{
	std::string pluginname;
};

typedef bool (*initresponderplugintype)(struct responderplugininfo &responderplugininfo,
	class Options &options, bool debugmode);
typedef void (*closeresponderplugintype)(void);
typedef int (*generateresponsestype)(std::vector<struct imevent> &imevents,
	std::vector<struct response> &responses);

class ResponderPlugin
{
	public:
		struct responderplugininfo responderplugininfo;
	
		ResponderPlugin();
		~ResponderPlugin();
		bool loadplugin(std::string filename);
		bool unloadplugin(void);
		
		bool callinitresponderplugin(class Options &options, bool debugmode);
		void callcloseresponderplugin(void);
		int callgenerateresponses(std::vector<struct imevent> &imevents,
			std::vector<struct response> &responses);

	private:
		void *handle;

		initresponderplugintype initresponderplugin;
		closeresponderplugintype closeresponderplugin;
		generateresponsestype generateresponses;
};
