/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012 by Eduard Kalinowski                                 *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include <QWidget>
#include <QString>
#include <QVariant>

#ifndef OPTIONS_H
#define OPTIONS_H

struct trWidgets {
    QWidget*  wg;
    short     gui_ID;
    QString   idString;
    short     wtype;
    short     opttype; // bool, num or string
    //     short     dummy;
    QVariant  value; // value or wrap length for GUI
};

#endif

#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include "../../main/includes/httraqt.h"
#include "ui_OptionsDialog.h"
// #include "ui_optionsBuild.h"

#include "optionslinks.h"
#include "optionslimits.h"
#include "optionsproxy.h"
#include "optionsbuild.h"
#include "optionsrulez.h"
#include "optionsexperts.h"
#include "optionslog.h"
#include "optionsspider.h"
#include "optionsbrowser.h"
#include "optionsflow.h"
#include "optionsmime.h"

#define OPTION_SITES 11

// #define NOWRAP   -1

#define CHECKBOX 0
#define LABEL    1
#define GROUPBOX 2
#define RADIO    4
#define COMBOBOX 5
#define BUTTON   6
#define EDITLINE 7
#define TEXTEDIT 8

#define NOTYPE   0
#define BOOLEAN  1
#define INTEGER  2
#define TEXT     3
#define FLOAT    4


class optionsBuild;
class optionsBrowser;
class optionsFlow;
class optionsLimits;
class optionsLinks;
class optionsProxy;
class optionsRulez;
class optionsExperts;
class optionsLog;
class optionsSpider;
class optionsMime;


class OptionsDialog: public QDialog, public Ui_OptionsDialog, public Translator
{
        Q_OBJECT
    public:
        OptionsDialog(QWidget * parent = 0, Qt::WindowFlags f = 0);
        ~OptionsDialog();

        void onSetDefOptions();
        void setToGUI();
        void getFromGUI();
        void initOptions();
        void setFontForWidgets(void);
        QString autoWrap(const QString &t, const int max);

    private slots:
        void onHelp();
        void onOk();
        void onSaveDefOptions();
        void onResetDefOptions();
        void switchPages();

    private:
        void resizeEvent(QResizeEvent* se);
        trWidgets* findId(const QString& k);

    private:
        optionsBuild*   pBuild;
        optionsBrowser* pBrowser;
        optionsFlow*    pFlow;
        optionsLimits*  pLimits;
        optionsLinks*   pLinks;
        optionsProxy*   pProxy;
        optionsRulez*   pRulez;
        optionsExperts* pExperts;
        optionsLog*     pLog;
        optionsSpider*  pSpider;
        optionsMime*    pMime;

        // max OPTION_SITES
        QToolButton*    buttons[OPTION_SITES];
        QWidget*        pages[OPTION_SITES];
        static int      headers[OPTION_SITES];

        QString         okText;
        QString         helpText;
        QString         cancelText;

    public:
        QVector<trWidgets> _tabTextInfos;
        HTTraQt*        parent;
};

#endif
