{-# OPTIONS_GHC -O2 #-}
{-# LANGUAGE BangPatterns #-}

module Yi.Keymap.Vim.Digraph
    ( charFromDigraph
    , defDigraphs
    , DigraphTbl
    ) where

import Control.Applicative (Alternative ((<|>)))

newtype DigraphTbl = DigraphTbl (Char -> Char -> Maybe Char)

charFromDigraph :: DigraphTbl -> Char -> Char -> Maybe Char
charFromDigraph (DigraphTbl tbl) x y = tbl x y <|> tbl y x

defDigraphs :: DigraphTbl
defDigraphs = DigraphTbl lookupDigraph

lookupDigraph :: Char -> Char -> Maybe Char
lookupDigraph !x !y =
  case switch x y of
    '\xFFFF' -> Nothing
    c        -> Just c

switch :: Char -> Char -> Char
switch 'N' 'U' = '\x0000' -- NULL (NUL)
switch 'S' 'H' = '\x0001' -- START OF HEADING (SOH)
switch 'S' 'X' = '\x0002' -- START OF TEXT (STX)
switch 'E' 'X' = '\x0003' -- END OF TEXT (ETX)
switch 'E' 'T' = '\x0004' -- END OF TRANSMISSION (EOT)
switch 'E' 'Q' = '\x0005' -- ENQUIRY (ENQ)
switch 'A' 'K' = '\x0006' -- ACKNOWLEDGE (ACK)
switch 'B' 'L' = '\x0007' -- BELL (BEL)
switch 'B' 'S' = '\x0008' -- BACKSPACE (BS)
switch 'H' 'T' = '\x0009' -- CHARACTER TABULATION (HT)
switch 'L' 'F' = '\x000A' -- LINE FEED (LF)
switch 'V' 'T' = '\x000B' -- LINE TABULATION (VT)
switch 'F' 'F' = '\x000C' -- FORM FEED (FF)
switch 'C' 'R' = '\x000D' -- CARRIAGE RETURN (CR)
switch 'S' 'O' = '\x000E' -- SHIFT OUT (SO)
switch 'S' 'I' = '\x000F' -- SHIFT IN (SI)
switch 'D' 'L' = '\x0010' -- DATALINK ESCAPE (DLE)
switch 'D' '1' = '\x0011' -- DEVICE CONTROL ONE (DC1)
switch 'D' '2' = '\x0012' -- DEVICE CONTROL TWO (DC2)
switch 'D' '3' = '\x0013' -- DEVICE CONTROL THREE (DC3)
switch 'D' '4' = '\x0014' -- DEVICE CONTROL FOUR (DC4)
switch 'N' 'K' = '\x0015' -- NEGATIVE ACKNOWLEDGE (NAK)
switch 'S' 'Y' = '\x0016' -- SYNCHRONOUS IDLE (SYN)
switch 'E' 'B' = '\x0017' -- END OF TRANSMISSION BLOCK (ETB)
switch 'C' 'N' = '\x0018' -- CANCEL (CAN)
switch 'E' 'M' = '\x0019' -- END OF MEDIUM (EM)
switch 'S' 'B' = '\x001A' -- SUBSTITUTE (SUB)
switch 'E' 'C' = '\x001B' -- ESCAPE (ESC)
switch 'F' 'S' = '\x001C' -- FILE SEPARATOR (IS4)
switch 'G' 'S' = '\x001D' -- GROUP SEPARATOR (IS3)
switch 'R' 'S' = '\x001E' -- RECORD SEPARATOR (IS2)
switch 'U' 'S' = '\x001F' -- UNIT SEPARATOR (IS1)
switch 'S' 'P' = '\x0020' -- SPACE
switch 'N' 'b' = '\x0023' -- NUMBER SIGN
switch 'D' 'O' = '\x0024' -- DOLLAR SIGN
switch 'A' 't' = '\x0040' -- COMMERCIAL AT
switch '<' '(' = '\x005B' -- LEFT SQUARE BRACKET
switch '/' '/' = '\x005C' -- REVERSE SOLIDUS
switch ')' '>' = '\x005D' -- RIGHT SQUARE BRACKET
switch '\'' '>' = '\x005E' -- CIRCUMFLEX ACCENT
switch '\'' '!' = '\x0060' -- GRAVE ACCENT
switch '(' '!' = '\x007B' -- LEFT CURLY BRACKET
switch '!' '!' = '\x007C' -- VERTICAL LINE
switch '!' ')' = '\x007D' -- RIGHT CURLY BRACKET
switch '\'' '?' = '\x007E' -- TILDE
switch 'D' 'T' = '\x007F' -- DELETE (DEL)
switch 'P' 'A' = '\x0080' -- PADDING CHARACTER (PAD)
switch 'H' 'O' = '\x0081' -- HIGH OCTET PRESET (HOP)
switch 'B' 'H' = '\x0082' -- BREAK PERMITTED HERE (BPH)
switch 'N' 'H' = '\x0083' -- NO BREAK HERE (NBH)
switch 'I' 'N' = '\x0084' -- INDEX (IND)
switch 'N' 'L' = '\x0085' -- NEXT LINE (NEL)
switch 'S' 'A' = '\x0086' -- START OF SELECTED AREA (SSA)
switch 'E' 'S' = '\x0087' -- END OF SELECTED AREA (ESA)
switch 'H' 'S' = '\x0088' -- CHARACTER TABULATION SET (HTS)
switch 'H' 'J' = '\x0089' -- CHARACTER TABULATION WITH JUSTIFICATION (HTJ)
switch 'V' 'S' = '\x008A' -- LINE TABULATION SET (VTS)
switch 'P' 'D' = '\x008B' -- PARTIAL LINE FORWARD (PLD)
switch 'P' 'U' = '\x008C' -- PARTIAL LINE BACKWARD (PLU)
switch 'R' 'I' = '\x008D' -- REVERSE LINE FEED (RI)
switch 'S' '2' = '\x008E' -- SINGLE-SHIFT TWO (SS2)
switch 'S' '3' = '\x008F' -- SINGLE-SHIFT THREE (SS3)
switch 'D' 'C' = '\x0090' -- DEVICE CONTROL STRING (DCS)
switch 'P' '1' = '\x0091' -- PRIVATE USE ONE (PU1)
switch 'P' '2' = '\x0092' -- PRIVATE USE TWO (PU2)
switch 'T' 'S' = '\x0093' -- SET TRANSMIT STATE (STS)
switch 'C' 'C' = '\x0094' -- CANCEL CHARACTER (CCH)
switch 'M' 'W' = '\x0095' -- MESSAGE WAITING (MW)
switch 'S' 'G' = '\x0096' -- START OF GUARDED AREA (SPA)
switch 'E' 'G' = '\x0097' -- END OF GUARDED AREA (EPA)
switch 'S' 'S' = '\x0098' -- START OF STRING (SOS)
switch 'G' 'C' = '\x0099' -- SINGLE GRAPHIC CHARACTER INTRODUCER (SGCI)
switch 'S' 'C' = '\x009A' -- SINGLE CHARACTER INTRODUCER (SCI)
switch 'C' 'I' = '\x009B' -- CONTROL SEQUENCE INTRODUCER (CSI)
switch 'S' 'T' = '\x009C' -- STRING TERMINATOR (ST)
switch 'O' 'C' = '\x009D' -- OPERATING SYSTEM COMMAND (OSC)
switch 'P' 'M' = '\x009E' -- PRIVACY MESSAGE (PM)
switch 'A' 'C' = '\x009F' -- APPLICATION PROGRAM COMMAND (APC)
switch 'N' 'S' = '\x00A0' -- NO-BREAK SPACE
switch '!' 'I' = '\x00A1' -- INVERTED EXCLAMATION MARK
switch 'C' 't' = '\x00A2' -- CENT SIGN
switch 'P' 'd' = '\x00A3' -- POUND SIGN
switch 'C' 'u' = '\x00A4' -- CURRENCY SIGN
switch 'Y' 'e' = '\x00A5' -- YEN SIGN
switch 'B' 'B' = '\x00A6' -- BROKEN BAR
switch 'S' 'E' = '\x00A7' -- SECTION SIGN
switch '\'' ':' = '\x00A8' -- DIAERESIS
switch 'C' 'o' = '\x00A9' -- COPYRIGHT SIGN
switch '-' 'a' = '\x00AA' -- FEMININE ORDINAL INDICATOR
switch '<' '<' = '\x00AB' -- LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
switch 'N' 'O' = '\x00AC' -- NOT SIGN
switch '-' '-' = '\x00AD' -- SOFT HYPHEN
switch 'R' 'g' = '\x00AE' -- REGISTERED SIGN
switch '\'' 'm' = '\x00AF' -- MACRON
switch 'D' 'G' = '\x00B0' -- DEGREE SIGN
switch '+' '-' = '\x00B1' -- PLUS-MINUS SIGN
switch '2' 'S' = '\x00B2' -- SUPERSCRIPT TWO
switch '3' 'S' = '\x00B3' -- SUPERSCRIPT THREE
switch '\'' '\'' = '\x00B4' -- ACUTE ACCENT
switch 'M' 'y' = '\x00B5' -- MICRO SIGN
switch 'P' 'I' = '\x00B6' -- PILCROW SIGN
switch '.' 'M' = '\x00B7' -- MIDDLE DOT
switch '\'' ',' = '\x00B8' -- CEDILLA
switch '1' 'S' = '\x00B9' -- SUPERSCRIPT ONE
switch '-' 'o' = '\x00BA' -- MASCULINE ORDINAL INDICATOR
switch '>' '>' = '\x00BB' -- RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
switch '1' '4' = '\x00BC' -- VULGAR FRACTION ONE QUARTER
switch '1' '2' = '\x00BD' -- VULGAR FRACTION ONE HALF
switch '3' '4' = '\x00BE' -- VULGAR FRACTION THREE QUARTERS
switch '?' 'I' = '\x00BF' -- INVERTED QUESTION MARK
switch 'A' '!' = '\x00C0' -- LATIN CAPITAL LETTER A WITH GRAVE
switch 'A' '\'' = '\x00C1' -- LATIN CAPITAL LETTER A WITH ACUTE
switch 'A' '>' = '\x00C2' -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX
switch 'A' '?' = '\x00C3' -- LATIN CAPITAL LETTER A WITH TILDE
switch 'A' ':' = '\x00C4' -- LATIN CAPITAL LETTER A WITH DIAERESIS
switch 'A' 'A' = '\x00C5' -- LATIN CAPITAL LETTER A WITH RING ABOVE
switch 'A' 'E' = '\x00C6' -- LATIN CAPITAL LETTER AE
switch 'C' ',' = '\x00C7' -- LATIN CAPITAL LETTER C WITH CEDILLA
switch 'E' '!' = '\x00C8' -- LATIN CAPITAL LETTER E WITH GRAVE
switch 'E' '\'' = '\x00C9' -- LATIN CAPITAL LETTER E WITH ACUTE
switch 'E' '>' = '\x00CA' -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX
switch 'E' ':' = '\x00CB' -- LATIN CAPITAL LETTER E WITH DIAERESIS
switch 'I' '!' = '\x00CC' -- LATIN CAPITAL LETTER I WITH GRAVE
switch 'I' '\'' = '\x00CD' -- LATIN CAPITAL LETTER I WITH ACUTE
switch 'I' '>' = '\x00CE' -- LATIN CAPITAL LETTER I WITH CIRCUMFLEX
switch 'I' ':' = '\x00CF' -- LATIN CAPITAL LETTER I WITH DIAERESIS
switch 'D' '-' = '\x00D0' -- LATIN CAPITAL LETTER ETH (Icelandic)
switch 'N' '?' = '\x00D1' -- LATIN CAPITAL LETTER N WITH TILDE
switch 'O' '!' = '\x00D2' -- LATIN CAPITAL LETTER O WITH GRAVE
switch 'O' '\'' = '\x00D3' -- LATIN CAPITAL LETTER O WITH ACUTE
switch 'O' '>' = '\x00D4' -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX
switch 'O' '?' = '\x00D5' -- LATIN CAPITAL LETTER O WITH TILDE
switch 'O' ':' = '\x00D6' -- LATIN CAPITAL LETTER O WITH DIAERESIS
switch '*' 'X' = '\x00D7' -- MULTIPLICATION SIGN
switch 'O' '/' = '\x00D8' -- LATIN CAPITAL LETTER O WITH STROKE
switch 'U' '!' = '\x00D9' -- LATIN CAPITAL LETTER U WITH GRAVE
switch 'U' '\'' = '\x00DA' -- LATIN CAPITAL LETTER U WITH ACUTE
switch 'U' '>' = '\x00DB' -- LATIN CAPITAL LETTER U WITH CIRCUMFLEX
switch 'U' ':' = '\x00DC' -- LATIN CAPITAL LETTER U WITH DIAERESIS
switch 'Y' '\'' = '\x00DD' -- LATIN CAPITAL LETTER Y WITH ACUTE
switch 'T' 'H' = '\x00DE' -- LATIN CAPITAL LETTER THORN (Icelandic)
switch 's' 's' = '\x00DF' -- LATIN SMALL LETTER SHARP S (German)
switch 'a' '!' = '\x00E0' -- LATIN SMALL LETTER A WITH GRAVE
switch 'a' '\'' = '\x00E1' -- LATIN SMALL LETTER A WITH ACUTE
switch 'a' '>' = '\x00E2' -- LATIN SMALL LETTER A WITH CIRCUMFLEX
switch 'a' '?' = '\x00E3' -- LATIN SMALL LETTER A WITH TILDE
switch 'a' ':' = '\x00E4' -- LATIN SMALL LETTER A WITH DIAERESIS
switch 'a' 'a' = '\x00E5' -- LATIN SMALL LETTER A WITH RING ABOVE
switch 'a' 'e' = '\x00E6' -- LATIN SMALL LETTER AE
switch 'c' ',' = '\x00E7' -- LATIN SMALL LETTER C WITH CEDILLA
switch 'e' '!' = '\x00E8' -- LATIN SMALL LETTER E WITH GRAVE
switch 'e' '\'' = '\x00E9' -- LATIN SMALL LETTER E WITH ACUTE
switch 'e' '>' = '\x00EA' -- LATIN SMALL LETTER E WITH CIRCUMFLEX
switch 'e' ':' = '\x00EB' -- LATIN SMALL LETTER E WITH DIAERESIS
switch 'i' '!' = '\x00EC' -- LATIN SMALL LETTER I WITH GRAVE
switch 'i' '\'' = '\x00ED' -- LATIN SMALL LETTER I WITH ACUTE
switch 'i' '>' = '\x00EE' -- LATIN SMALL LETTER I WITH CIRCUMFLEX
switch 'i' ':' = '\x00EF' -- LATIN SMALL LETTER I WITH DIAERESIS
switch 'd' '-' = '\x00F0' -- LATIN SMALL LETTER ETH (Icelandic)
switch 'n' '?' = '\x00F1' -- LATIN SMALL LETTER N WITH TILDE
switch 'o' '!' = '\x00F2' -- LATIN SMALL LETTER O WITH GRAVE
switch 'o' '\'' = '\x00F3' -- LATIN SMALL LETTER O WITH ACUTE
switch 'o' '>' = '\x00F4' -- LATIN SMALL LETTER O WITH CIRCUMFLEX
switch 'o' '?' = '\x00F5' -- LATIN SMALL LETTER O WITH TILDE
switch 'o' ':' = '\x00F6' -- LATIN SMALL LETTER O WITH DIAERESIS
switch '-' ':' = '\x00F7' -- DIVISION SIGN
switch 'o' '/' = '\x00F8' -- LATIN SMALL LETTER O WITH STROKE
switch 'u' '!' = '\x00F9' -- LATIN SMALL LETTER U WITH GRAVE
switch 'u' '\'' = '\x00FA' -- LATIN SMALL LETTER U WITH ACUTE
switch 'u' '>' = '\x00FB' -- LATIN SMALL LETTER U WITH CIRCUMFLEX
switch 'u' ':' = '\x00FC' -- LATIN SMALL LETTER U WITH DIAERESIS
switch 'y' '\'' = '\x00FD' -- LATIN SMALL LETTER Y WITH ACUTE
switch 't' 'h' = '\x00FE' -- LATIN SMALL LETTER THORN (Icelandic)
switch 'y' ':' = '\x00FF' -- LATIN SMALL LETTER Y WITH DIAERESIS
switch 'A' '-' = '\x0100' -- LATIN CAPITAL LETTER A WITH MACRON
switch 'a' '-' = '\x0101' -- LATIN SMALL LETTER A WITH MACRON
switch 'A' '(' = '\x0102' -- LATIN CAPITAL LETTER A WITH BREVE
switch 'a' '(' = '\x0103' -- LATIN SMALL LETTER A WITH BREVE
switch 'A' ';' = '\x0104' -- LATIN CAPITAL LETTER A WITH OGONEK
switch 'a' ';' = '\x0105' -- LATIN SMALL LETTER A WITH OGONEK
switch 'C' '\'' = '\x0106' -- LATIN CAPITAL LETTER C WITH ACUTE
switch 'c' '\'' = '\x0107' -- LATIN SMALL LETTER C WITH ACUTE
switch 'C' '>' = '\x0108' -- LATIN CAPITAL LETTER C WITH CIRCUMFLEX
switch 'c' '>' = '\x0109' -- LATIN SMALL LETTER C WITH CIRCUMFLEX
switch 'C' '.' = '\x010A' -- LATIN CAPITAL LETTER C WITH DOT ABOVE
switch 'c' '.' = '\x010B' -- LATIN SMALL LETTER C WITH DOT ABOVE
switch 'C' '<' = '\x010C' -- LATIN CAPITAL LETTER C WITH CARON
switch 'c' '<' = '\x010D' -- LATIN SMALL LETTER C WITH CARON
switch 'D' '<' = '\x010E' -- LATIN CAPITAL LETTER D WITH CARON
switch 'd' '<' = '\x010F' -- LATIN SMALL LETTER D WITH CARON
switch 'D' '/' = '\x0110' -- LATIN CAPITAL LETTER D WITH STROKE
switch 'd' '/' = '\x0111' -- LATIN SMALL LETTER D WITH STROKE
switch 'E' '-' = '\x0112' -- LATIN CAPITAL LETTER E WITH MACRON
switch 'e' '-' = '\x0113' -- LATIN SMALL LETTER E WITH MACRON
switch 'E' '(' = '\x0114' -- LATIN CAPITAL LETTER E WITH BREVE
switch 'e' '(' = '\x0115' -- LATIN SMALL LETTER E WITH BREVE
switch 'E' '.' = '\x0116' -- LATIN CAPITAL LETTER E WITH DOT ABOVE
switch 'e' '.' = '\x0117' -- LATIN SMALL LETTER E WITH DOT ABOVE
switch 'E' ';' = '\x0118' -- LATIN CAPITAL LETTER E WITH OGONEK
switch 'e' ';' = '\x0119' -- LATIN SMALL LETTER E WITH OGONEK
switch 'E' '<' = '\x011A' -- LATIN CAPITAL LETTER E WITH CARON
switch 'e' '<' = '\x011B' -- LATIN SMALL LETTER E WITH CARON
switch 'G' '>' = '\x011C' -- LATIN CAPITAL LETTER G WITH CIRCUMFLEX
switch 'g' '>' = '\x011D' -- LATIN SMALL LETTER G WITH CIRCUMFLEX
switch 'G' '(' = '\x011E' -- LATIN CAPITAL LETTER G WITH BREVE
switch 'g' '(' = '\x011F' -- LATIN SMALL LETTER G WITH BREVE
switch 'G' '.' = '\x0120' -- LATIN CAPITAL LETTER G WITH DOT ABOVE
switch 'g' '.' = '\x0121' -- LATIN SMALL LETTER G WITH DOT ABOVE
switch 'G' ',' = '\x0122' -- LATIN CAPITAL LETTER G WITH CEDILLA
switch 'g' ',' = '\x0123' -- LATIN SMALL LETTER G WITH CEDILLA
switch 'H' '>' = '\x0124' -- LATIN CAPITAL LETTER H WITH CIRCUMFLEX
switch 'h' '>' = '\x0125' -- LATIN SMALL LETTER H WITH CIRCUMFLEX
switch 'H' '/' = '\x0126' -- LATIN CAPITAL LETTER H WITH STROKE
switch 'h' '/' = '\x0127' -- LATIN SMALL LETTER H WITH STROKE
switch 'I' '?' = '\x0128' -- LATIN CAPITAL LETTER I WITH TILDE
switch 'i' '?' = '\x0129' -- LATIN SMALL LETTER I WITH TILDE
switch 'I' '-' = '\x012A' -- LATIN CAPITAL LETTER I WITH MACRON
switch 'i' '-' = '\x012B' -- LATIN SMALL LETTER I WITH MACRON
switch 'I' '(' = '\x012C' -- LATIN CAPITAL LETTER I WITH BREVE
switch 'i' '(' = '\x012D' -- LATIN SMALL LETTER I WITH BREVE
switch 'I' ';' = '\x012E' -- LATIN CAPITAL LETTER I WITH OGONEK
switch 'i' ';' = '\x012F' -- LATIN SMALL LETTER I WITH OGONEK
switch 'I' '.' = '\x0130' -- LATIN CAPITAL LETTER I WITH DOT ABOVE
switch 'i' '.' = '\x0131' -- LATIN SMALL LETTER DOTLESS I
switch 'I' 'J' = '\x0132' -- LATIN CAPITAL LIGATURE IJ
switch 'i' 'j' = '\x0133' -- LATIN SMALL LIGATURE IJ
switch 'J' '>' = '\x0134' -- LATIN CAPITAL LETTER J WITH CIRCUMFLEX
switch 'j' '>' = '\x0135' -- LATIN SMALL LETTER J WITH CIRCUMFLEX
switch 'K' ',' = '\x0136' -- LATIN CAPITAL LETTER K WITH CEDILLA
switch 'k' ',' = '\x0137' -- LATIN SMALL LETTER K WITH CEDILLA
switch 'k' 'k' = '\x0138' -- LATIN SMALL LETTER KRA
switch 'L' '\'' = '\x0139' -- LATIN CAPITAL LETTER L WITH ACUTE
switch 'l' '\'' = '\x013A' -- LATIN SMALL LETTER L WITH ACUTE
switch 'L' ',' = '\x013B' -- LATIN CAPITAL LETTER L WITH CEDILLA
switch 'l' ',' = '\x013C' -- LATIN SMALL LETTER L WITH CEDILLA
switch 'L' '<' = '\x013D' -- LATIN CAPITAL LETTER L WITH CARON
switch 'l' '<' = '\x013E' -- LATIN SMALL LETTER L WITH CARON
switch 'L' '.' = '\x013F' -- LATIN CAPITAL LETTER L WITH MIDDLE DOT
switch 'l' '.' = '\x0140' -- LATIN SMALL LETTER L WITH MIDDLE DOT
switch 'L' '/' = '\x0141' -- LATIN CAPITAL LETTER L WITH STROKE
switch 'l' '/' = '\x0142' -- LATIN SMALL LETTER L WITH STROKE
switch 'N' '\'' = '\x0143' -- LATIN CAPITAL LETTER N WITH ACUTE `
switch 'n' '\'' = '\x0144' -- LATIN SMALL LETTER N WITH ACUTE `
switch 'N' ',' = '\x0145' -- LATIN CAPITAL LETTER N WITH CEDILLA `
switch 'n' ',' = '\x0146' -- LATIN SMALL LETTER N WITH CEDILLA `
switch 'N' '<' = '\x0147' -- LATIN CAPITAL LETTER N WITH CARON `
switch 'n' '<' = '\x0148' -- LATIN SMALL LETTER N WITH CARON `
switch '\'' 'n' = '\x0149' -- LATIN SMALL LETTER N PRECEDED BY APOSTROPHE `
switch 'N' 'G' = '\x014A' -- LATIN CAPITAL LETTER ENG
switch 'n' 'g' = '\x014B' -- LATIN SMALL LETTER ENG
switch 'O' '-' = '\x014C' -- LATIN CAPITAL LETTER O WITH MACRON
switch 'o' '-' = '\x014D' -- LATIN SMALL LETTER O WITH MACRON
switch 'O' '(' = '\x014E' -- LATIN CAPITAL LETTER O WITH BREVE
switch 'o' '(' = '\x014F' -- LATIN SMALL LETTER O WITH BREVE
switch 'O' '"' = '\x0150' -- LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
switch 'o' '"' = '\x0151' -- LATIN SMALL LETTER O WITH DOUBLE ACUTE
switch 'O' 'E' = '\x0152' -- LATIN CAPITAL LIGATURE OE
switch 'o' 'e' = '\x0153' -- LATIN SMALL LIGATURE OE
switch 'R' '\'' = '\x0154' -- LATIN CAPITAL LETTER R WITH ACUTE
switch 'r' '\'' = '\x0155' -- LATIN SMALL LETTER R WITH ACUTE
switch 'R' ',' = '\x0156' -- LATIN CAPITAL LETTER R WITH CEDILLA
switch 'r' ',' = '\x0157' -- LATIN SMALL LETTER R WITH CEDILLA
switch 'R' '<' = '\x0158' -- LATIN CAPITAL LETTER R WITH CARON
switch 'r' '<' = '\x0159' -- LATIN SMALL LETTER R WITH CARON
switch 'S' '\'' = '\x015A' -- LATIN CAPITAL LETTER S WITH ACUTE
switch 's' '\'' = '\x015B' -- LATIN SMALL LETTER S WITH ACUTE
switch 'S' '>' = '\x015C' -- LATIN CAPITAL LETTER S WITH CIRCUMFLEX
switch 's' '>' = '\x015D' -- LATIN SMALL LETTER S WITH CIRCUMFLEX
switch 'S' ',' = '\x015E' -- LATIN CAPITAL LETTER S WITH CEDILLA
switch 's' ',' = '\x015F' -- LATIN SMALL LETTER S WITH CEDILLA
switch 'S' '<' = '\x0160' -- LATIN CAPITAL LETTER S WITH CARON
switch 's' '<' = '\x0161' -- LATIN SMALL LETTER S WITH CARON
switch 'T' ',' = '\x0162' -- LATIN CAPITAL LETTER T WITH CEDILLA
switch 't' ',' = '\x0163' -- LATIN SMALL LETTER T WITH CEDILLA
switch 'T' '<' = '\x0164' -- LATIN CAPITAL LETTER T WITH CARON
switch 't' '<' = '\x0165' -- LATIN SMALL LETTER T WITH CARON
switch 'T' '/' = '\x0166' -- LATIN CAPITAL LETTER T WITH STROKE
switch 't' '/' = '\x0167' -- LATIN SMALL LETTER T WITH STROKE
switch 'U' '?' = '\x0168' -- LATIN CAPITAL LETTER U WITH TILDE
switch 'u' '?' = '\x0169' -- LATIN SMALL LETTER U WITH TILDE
switch 'U' '-' = '\x016A' -- LATIN CAPITAL LETTER U WITH MACRON
switch 'u' '-' = '\x016B' -- LATIN SMALL LETTER U WITH MACRON
switch 'U' '(' = '\x016C' -- LATIN CAPITAL LETTER U WITH BREVE
switch 'u' '(' = '\x016D' -- LATIN SMALL LETTER U WITH BREVE
switch 'U' '0' = '\x016E' -- LATIN CAPITAL LETTER U WITH RING ABOVE
switch 'u' '0' = '\x016F' -- LATIN SMALL LETTER U WITH RING ABOVE
switch 'U' '"' = '\x0170' -- LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
switch 'u' '"' = '\x0171' -- LATIN SMALL LETTER U WITH DOUBLE ACUTE
switch 'U' ';' = '\x0172' -- LATIN CAPITAL LETTER U WITH OGONEK
switch 'u' ';' = '\x0173' -- LATIN SMALL LETTER U WITH OGONEK
switch 'W' '>' = '\x0174' -- LATIN CAPITAL LETTER W WITH CIRCUMFLEX
switch 'w' '>' = '\x0175' -- LATIN SMALL LETTER W WITH CIRCUMFLEX
switch 'Y' '>' = '\x0176' -- LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
switch 'y' '>' = '\x0177' -- LATIN SMALL LETTER Y WITH CIRCUMFLEX
switch 'Y' ':' = '\x0178' -- LATIN CAPITAL LETTER Y WITH DIAERESIS
switch 'Z' '\'' = '\x0179' -- LATIN CAPITAL LETTER Z WITH ACUTE
switch 'z' '\'' = '\x017A' -- LATIN SMALL LETTER Z WITH ACUTE
switch 'Z' '.' = '\x017B' -- LATIN CAPITAL LETTER Z WITH DOT ABOVE
switch 'z' '.' = '\x017C' -- LATIN SMALL LETTER Z WITH DOT ABOVE
switch 'Z' '<' = '\x017D' -- LATIN CAPITAL LETTER Z WITH CARON
switch 'z' '<' = '\x017E' -- LATIN SMALL LETTER Z WITH CARON
switch 'O' '9' = '\x01A0' -- LATIN CAPITAL LETTER O WITH HORN
switch 'o' '9' = '\x01A1' -- LATIN SMALL LETTER O WITH HORN
switch 'O' 'I' = '\x01A2' -- LATIN CAPITAL LETTER OI
switch 'o' 'i' = '\x01A3' -- LATIN SMALL LETTER OI
switch 'y' 'r' = '\x01A6' -- LATIN LETTER YR
switch 'U' '9' = '\x01AF' -- LATIN CAPITAL LETTER U WITH HORN
switch 'u' '9' = '\x01B0' -- LATIN SMALL LETTER U WITH HORN
switch 'Z' '/' = '\x01B5' -- LATIN CAPITAL LETTER Z WITH STROKE
switch 'z' '/' = '\x01B6' -- LATIN SMALL LETTER Z WITH STROKE
switch 'E' 'D' = '\x01B7' -- LATIN CAPITAL LETTER EZH
switch 'A' '<' = '\x01CD' -- LATIN CAPITAL LETTER A WITH CARON
switch 'a' '<' = '\x01CE' -- LATIN SMALL LETTER A WITH CARON
switch 'I' '<' = '\x01CF' -- LATIN CAPITAL LETTER I WITH CARON
switch 'i' '<' = '\x01D0' -- LATIN SMALL LETTER I WITH CARON
switch 'O' '<' = '\x01D1' -- LATIN CAPITAL LETTER O WITH CARON
switch 'o' '<' = '\x01D2' -- LATIN SMALL LETTER O WITH CARON
switch 'U' '<' = '\x01D3' -- LATIN CAPITAL LETTER U WITH CARON
switch 'u' '<' = '\x01D4' -- LATIN SMALL LETTER U WITH CARON
switch 'A' '1' = '\x01DE' -- LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
switch 'a' '1' = '\x01DF' -- LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
switch 'A' '7' = '\x01E0' -- LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
switch 'a' '7' = '\x01E1' -- LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
switch 'A' '3' = '\x01E2' -- LATIN CAPITAL LETTER AE WITH MACRON
switch 'a' '3' = '\x01E3' -- LATIN SMALL LETTER AE WITH MACRON
switch 'G' '/' = '\x01E4' -- LATIN CAPITAL LETTER G WITH STROKE
switch 'g' '/' = '\x01E5' -- LATIN SMALL LETTER G WITH STROKE
switch 'G' '<' = '\x01E6' -- LATIN CAPITAL LETTER G WITH CARON
switch 'g' '<' = '\x01E7' -- LATIN SMALL LETTER G WITH CARON
switch 'K' '<' = '\x01E8' -- LATIN CAPITAL LETTER K WITH CARON
switch 'k' '<' = '\x01E9' -- LATIN SMALL LETTER K WITH CARON
switch 'O' ';' = '\x01EA' -- LATIN CAPITAL LETTER O WITH OGONEK
switch 'o' ';' = '\x01EB' -- LATIN SMALL LETTER O WITH OGONEK
switch 'O' '1' = '\x01EC' -- LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
switch 'o' '1' = '\x01ED' -- LATIN SMALL LETTER O WITH OGONEK AND MACRON
switch 'E' 'Z' = '\x01EE' -- LATIN CAPITAL LETTER EZH WITH CARON
switch 'e' 'z' = '\x01EF' -- LATIN SMALL LETTER EZH WITH CARON
switch 'j' '<' = '\x01F0' -- LATIN SMALL LETTER J WITH CARON
switch 'G' '\'' = '\x01F4' -- LATIN CAPITAL LETTER G WITH ACUTE
switch 'g' '\'' = '\x01F5' -- LATIN SMALL LETTER G WITH ACUTE
switch ';' 'S' = '\x02BF' -- MODIFIER LETTER LEFT HALF RING
switch '\'' '<' = '\x02C7' -- CARON
switch '\'' '(' = '\x02D8' -- BREVE
switch '\'' '.' = '\x02D9' -- DOT ABOVE
switch '\'' '0' = '\x02DA' -- RING ABOVE
switch '\'' ';' = '\x02DB' -- OGONEK
switch '\'' '"' = '\x02DD' -- DOUBLE ACUTE ACCENT
switch 'A' '%' = '\x0386' -- GREEK CAPITAL LETTER ALPHA WITH TONOS
switch 'E' '%' = '\x0388' -- GREEK CAPITAL LETTER EPSILON WITH TONOS
switch 'Y' '%' = '\x0389' -- GREEK CAPITAL LETTER ETA WITH TONOS
switch 'I' '%' = '\x038A' -- GREEK CAPITAL LETTER IOTA WITH TONOS
switch 'O' '%' = '\x038C' -- GREEK CAPITAL LETTER OMICRON WITH TONOS
switch 'U' '%' = '\x038E' -- GREEK CAPITAL LETTER UPSILON WITH TONOS
switch 'W' '%' = '\x038F' -- GREEK CAPITAL LETTER OMEGA WITH TONOS
switch 'i' '3' = '\x0390' -- GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
switch 'A' '*' = '\x0391' -- GREEK CAPITAL LETTER ALPHA
switch 'B' '*' = '\x0392' -- GREEK CAPITAL LETTER BETA
switch 'G' '*' = '\x0393' -- GREEK CAPITAL LETTER GAMMA
switch 'D' '*' = '\x0394' -- GREEK CAPITAL LETTER DELTA
switch 'E' '*' = '\x0395' -- GREEK CAPITAL LETTER EPSILON
switch 'Z' '*' = '\x0396' -- GREEK CAPITAL LETTER ZETA
switch 'Y' '*' = '\x0397' -- GREEK CAPITAL LETTER ETA
switch 'H' '*' = '\x0398' -- GREEK CAPITAL LETTER THETA
switch 'I' '*' = '\x0399' -- GREEK CAPITAL LETTER IOTA
switch 'K' '*' = '\x039A' -- GREEK CAPITAL LETTER KAPPA
switch 'L' '*' = '\x039B' -- GREEK CAPITAL LETTER LAMDA
switch 'M' '*' = '\x039C' -- GREEK CAPITAL LETTER MU
switch 'N' '*' = '\x039D' -- GREEK CAPITAL LETTER NU
switch 'C' '*' = '\x039E' -- GREEK CAPITAL LETTER XI
switch 'O' '*' = '\x039F' -- GREEK CAPITAL LETTER OMICRON
switch 'P' '*' = '\x03A0' -- GREEK CAPITAL LETTER PI
switch 'R' '*' = '\x03A1' -- GREEK CAPITAL LETTER RHO
switch 'S' '*' = '\x03A3' -- GREEK CAPITAL LETTER SIGMA
switch 'T' '*' = '\x03A4' -- GREEK CAPITAL LETTER TAU
switch 'U' '*' = '\x03A5' -- GREEK CAPITAL LETTER UPSILON
switch 'F' '*' = '\x03A6' -- GREEK CAPITAL LETTER PHI
switch 'X' '*' = '\x03A7' -- GREEK CAPITAL LETTER CHI
switch 'Q' '*' = '\x03A8' -- GREEK CAPITAL LETTER PSI
switch 'W' '*' = '\x03A9' -- GREEK CAPITAL LETTER OMEGA
switch 'J' '*' = '\x03AA' -- GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
switch 'V' '*' = '\x03AB' -- GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
switch 'a' '%' = '\x03AC' -- GREEK SMALL LETTER ALPHA WITH TONOS
switch 'e' '%' = '\x03AD' -- GREEK SMALL LETTER EPSILON WITH TONOS
switch 'y' '%' = '\x03AE' -- GREEK SMALL LETTER ETA WITH TONOS
switch 'i' '%' = '\x03AF' -- GREEK SMALL LETTER IOTA WITH TONOS
switch 'u' '3' = '\x03B0' -- GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
switch 'a' '*' = '\x03B1' -- GREEK SMALL LETTER ALPHA
switch 'b' '*' = '\x03B2' -- GREEK SMALL LETTER BETA
switch 'g' '*' = '\x03B3' -- GREEK SMALL LETTER GAMMA
switch 'd' '*' = '\x03B4' -- GREEK SMALL LETTER DELTA
switch 'e' '*' = '\x03B5' -- GREEK SMALL LETTER EPSILON
switch 'z' '*' = '\x03B6' -- GREEK SMALL LETTER ZETA
switch 'y' '*' = '\x03B7' -- GREEK SMALL LETTER ETA
switch 'h' '*' = '\x03B8' -- GREEK SMALL LETTER THETA
switch 'i' '*' = '\x03B9' -- GREEK SMALL LETTER IOTA
switch 'k' '*' = '\x03BA' -- GREEK SMALL LETTER KAPPA
switch 'l' '*' = '\x03BB' -- GREEK SMALL LETTER LAMDA
switch 'm' '*' = '\x03BC' -- GREEK SMALL LETTER MU
switch 'n' '*' = '\x03BD' -- GREEK SMALL LETTER NU
switch 'c' '*' = '\x03BE' -- GREEK SMALL LETTER XI
switch 'o' '*' = '\x03BF' -- GREEK SMALL LETTER OMICRON
switch 'p' '*' = '\x03C0' -- GREEK SMALL LETTER PI
switch 'r' '*' = '\x03C1' -- GREEK SMALL LETTER RHO
switch '*' 's' = '\x03C2' -- GREEK SMALL LETTER FINAL SIGMA
switch 's' '*' = '\x03C3' -- GREEK SMALL LETTER SIGMA
switch 't' '*' = '\x03C4' -- GREEK SMALL LETTER TAU
switch 'u' '*' = '\x03C5' -- GREEK SMALL LETTER UPSILON
switch 'f' '*' = '\x03C6' -- GREEK SMALL LETTER PHI
switch 'x' '*' = '\x03C7' -- GREEK SMALL LETTER CHI
switch 'q' '*' = '\x03C8' -- GREEK SMALL LETTER PSI
switch 'w' '*' = '\x03C9' -- GREEK SMALL LETTER OMEGA
switch 'j' '*' = '\x03CA' -- GREEK SMALL LETTER IOTA WITH DIALYTIKA
switch 'v' '*' = '\x03CB' -- GREEK SMALL LETTER UPSILON WITH DIALYTIKA
switch 'o' '%' = '\x03CC' -- GREEK SMALL LETTER OMICRON WITH TONOS
switch 'u' '%' = '\x03CD' -- GREEK SMALL LETTER UPSILON WITH TONOS
switch 'w' '%' = '\x03CE' -- GREEK SMALL LETTER OMEGA WITH TONOS
switch '\'' 'G' = '\x03D8' -- GREEK LETTER ARCHAIC KOPPA
switch ',' 'G' = '\x03D9' -- GREEK SMALL LETTER ARCHAIC KOPPA
switch 'T' '3' = '\x03DA' -- GREEK LETTER STIGMA
switch 't' '3' = '\x03DB' -- GREEK SMALL LETTER STIGMA
switch 'M' '3' = '\x03DC' -- GREEK LETTER DIGAMMA
switch 'm' '3' = '\x03DD' -- GREEK SMALL LETTER DIGAMMA
switch 'K' '3' = '\x03DE' -- GREEK LETTER KOPPA
switch 'k' '3' = '\x03DF' -- GREEK SMALL LETTER KOPPA
switch 'P' '3' = '\x03E0' -- GREEK LETTER SAMPI
switch 'p' '3' = '\x03E1' -- GREEK SMALL LETTER SAMPI
switch '\'' '%' = '\x03F4' -- GREEK CAPITAL THETA SYMBOL
switch 'j' '3' = '\x03F5' -- GREEK LUNATE EPSILON SYMBOL
switch 'I' 'O' = '\x0401' -- CYRILLIC CAPITAL LETTER IO
switch 'D' '%' = '\x0402' -- CYRILLIC CAPITAL LETTER DJE
switch 'G' '%' = '\x0403' -- CYRILLIC CAPITAL LETTER GJE
switch 'I' 'E' = '\x0404' -- CYRILLIC CAPITAL LETTER UKRAINIAN IE
switch 'D' 'S' = '\x0405' -- CYRILLIC CAPITAL LETTER DZE
switch 'I' 'I' = '\x0406' -- CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
switch 'Y' 'I' = '\x0407' -- CYRILLIC CAPITAL LETTER YI
switch 'J' '%' = '\x0408' -- CYRILLIC CAPITAL LETTER JE
switch 'L' 'J' = '\x0409' -- CYRILLIC CAPITAL LETTER LJE
switch 'N' 'J' = '\x040A' -- CYRILLIC CAPITAL LETTER NJE
switch 'T' 's' = '\x040B' -- CYRILLIC CAPITAL LETTER TSHE
switch 'K' 'J' = '\x040C' -- CYRILLIC CAPITAL LETTER KJE
switch 'V' '%' = '\x040E' -- CYRILLIC CAPITAL LETTER SHORT U
switch 'D' 'Z' = '\x040F' -- CYRILLIC CAPITAL LETTER DZHE
switch 'A' '=' = '\x0410' -- CYRILLIC CAPITAL LETTER A
switch 'B' '=' = '\x0411' -- CYRILLIC CAPITAL LETTER BE
switch 'V' '=' = '\x0412' -- CYRILLIC CAPITAL LETTER VE
switch 'G' '=' = '\x0413' -- CYRILLIC CAPITAL LETTER GHE
switch 'D' '=' = '\x0414' -- CYRILLIC CAPITAL LETTER DE
switch 'E' '=' = '\x0415' -- CYRILLIC CAPITAL LETTER IE
switch 'Z' '%' = '\x0416' -- CYRILLIC CAPITAL LETTER ZHE
switch 'Z' '=' = '\x0417' -- CYRILLIC CAPITAL LETTER ZE
switch 'I' '=' = '\x0418' -- CYRILLIC CAPITAL LETTER I
switch 'J' '=' = '\x0419' -- CYRILLIC CAPITAL LETTER SHORT I
switch 'K' '=' = '\x041A' -- CYRILLIC CAPITAL LETTER KA
switch 'L' '=' = '\x041B' -- CYRILLIC CAPITAL LETTER EL
switch 'M' '=' = '\x041C' -- CYRILLIC CAPITAL LETTER EM
switch 'N' '=' = '\x041D' -- CYRILLIC CAPITAL LETTER EN
switch 'O' '=' = '\x041E' -- CYRILLIC CAPITAL LETTER O
switch 'P' '=' = '\x041F' -- CYRILLIC CAPITAL LETTER PE
switch 'R' '=' = '\x0420' -- CYRILLIC CAPITAL LETTER ER
switch 'S' '=' = '\x0421' -- CYRILLIC CAPITAL LETTER ES
switch 'T' '=' = '\x0422' -- CYRILLIC CAPITAL LETTER TE
switch 'U' '=' = '\x0423' -- CYRILLIC CAPITAL LETTER U
switch 'F' '=' = '\x0424' -- CYRILLIC CAPITAL LETTER EF
switch 'H' '=' = '\x0425' -- CYRILLIC CAPITAL LETTER HA
switch 'C' '=' = '\x0426' -- CYRILLIC CAPITAL LETTER TSE
switch 'C' '%' = '\x0427' -- CYRILLIC CAPITAL LETTER CHE
switch 'S' '%' = '\x0428' -- CYRILLIC CAPITAL LETTER SHA
switch 'S' 'c' = '\x0429' -- CYRILLIC CAPITAL LETTER SHCHA
switch '=' '"' = '\x042A' -- CYRILLIC CAPITAL LETTER HARD SIGN
switch 'Y' '=' = '\x042B' -- CYRILLIC CAPITAL LETTER YERU
switch '%' '"' = '\x042C' -- CYRILLIC CAPITAL LETTER SOFT SIGN
switch 'J' 'E' = '\x042D' -- CYRILLIC CAPITAL LETTER E
switch 'J' 'U' = '\x042E' -- CYRILLIC CAPITAL LETTER YU
switch 'J' 'A' = '\x042F' -- CYRILLIC CAPITAL LETTER YA
switch 'a' '=' = '\x0430' -- CYRILLIC SMALL LETTER A
switch 'b' '=' = '\x0431' -- CYRILLIC SMALL LETTER BE
switch 'v' '=' = '\x0432' -- CYRILLIC SMALL LETTER VE
switch 'g' '=' = '\x0433' -- CYRILLIC SMALL LETTER GHE
switch 'd' '=' = '\x0434' -- CYRILLIC SMALL LETTER DE
switch 'e' '=' = '\x0435' -- CYRILLIC SMALL LETTER IE
switch 'z' '%' = '\x0436' -- CYRILLIC SMALL LETTER ZHE
switch 'z' '=' = '\x0437' -- CYRILLIC SMALL LETTER ZE
switch 'i' '=' = '\x0438' -- CYRILLIC SMALL LETTER I
switch 'j' '=' = '\x0439' -- CYRILLIC SMALL LETTER SHORT I
switch 'k' '=' = '\x043A' -- CYRILLIC SMALL LETTER KA
switch 'l' '=' = '\x043B' -- CYRILLIC SMALL LETTER EL
switch 'm' '=' = '\x043C' -- CYRILLIC SMALL LETTER EM
switch 'n' '=' = '\x043D' -- CYRILLIC SMALL LETTER EN
switch 'o' '=' = '\x043E' -- CYRILLIC SMALL LETTER O
switch 'p' '=' = '\x043F' -- CYRILLIC SMALL LETTER PE
switch 'r' '=' = '\x0440' -- CYRILLIC SMALL LETTER ER
switch 's' '=' = '\x0441' -- CYRILLIC SMALL LETTER ES
switch 't' '=' = '\x0442' -- CYRILLIC SMALL LETTER TE
switch 'u' '=' = '\x0443' -- CYRILLIC SMALL LETTER U
switch 'f' '=' = '\x0444' -- CYRILLIC SMALL LETTER EF
switch 'h' '=' = '\x0445' -- CYRILLIC SMALL LETTER HA
switch 'c' '=' = '\x0446' -- CYRILLIC SMALL LETTER TSE
switch 'c' '%' = '\x0447' -- CYRILLIC SMALL LETTER CHE
switch 's' '%' = '\x0448' -- CYRILLIC SMALL LETTER SHA
switch 's' 'c' = '\x0449' -- CYRILLIC SMALL LETTER SHCHA
switch '=' '\'' = '\x044A' -- CYRILLIC SMALL LETTER HARD SIGN
switch 'y' '=' = '\x044B' -- CYRILLIC SMALL LETTER YERU
switch '%' '\'' = '\x044C' -- CYRILLIC SMALL LETTER SOFT SIGN
switch 'j' 'e' = '\x044D' -- CYRILLIC SMALL LETTER E
switch 'j' 'u' = '\x044E' -- CYRILLIC SMALL LETTER YU
switch 'j' 'a' = '\x044F' -- CYRILLIC SMALL LETTER YA
switch 'i' 'o' = '\x0451' -- CYRILLIC SMALL LETTER IO
switch 'd' '%' = '\x0452' -- CYRILLIC SMALL LETTER DJE
switch 'g' '%' = '\x0453' -- CYRILLIC SMALL LETTER GJE
switch 'i' 'e' = '\x0454' -- CYRILLIC SMALL LETTER UKRAINIAN IE
switch 'd' 's' = '\x0455' -- CYRILLIC SMALL LETTER DZE
switch 'i' 'i' = '\x0456' -- CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
switch 'y' 'i' = '\x0457' -- CYRILLIC SMALL LETTER YI
switch 'j' '%' = '\x0458' -- CYRILLIC SMALL LETTER JE
switch 'l' 'j' = '\x0459' -- CYRILLIC SMALL LETTER LJE
switch 'n' 'j' = '\x045A' -- CYRILLIC SMALL LETTER NJE
switch 't' 's' = '\x045B' -- CYRILLIC SMALL LETTER TSHE
switch 'k' 'j' = '\x045C' -- CYRILLIC SMALL LETTER KJE
switch 'v' '%' = '\x045E' -- CYRILLIC SMALL LETTER SHORT U
switch 'd' 'z' = '\x045F' -- CYRILLIC SMALL LETTER DZHE
switch 'Y' '3' = '\x0462' -- CYRILLIC CAPITAL LETTER YAT
switch 'y' '3' = '\x0463' -- CYRILLIC SMALL LETTER YAT
switch 'O' '3' = '\x046A' -- CYRILLIC CAPITAL LETTER BIG YUS
switch 'o' '3' = '\x046B' -- CYRILLIC SMALL LETTER BIG YUS
switch 'F' '3' = '\x0472' -- CYRILLIC CAPITAL LETTER FITA
switch 'f' '3' = '\x0473' -- CYRILLIC SMALL LETTER FITA
switch 'V' '3' = '\x0474' -- CYRILLIC CAPITAL LETTER IZHITSA
switch 'v' '3' = '\x0475' -- CYRILLIC SMALL LETTER IZHITSA
switch 'C' '3' = '\x0480' -- CYRILLIC CAPITAL LETTER KOPPA
switch 'c' '3' = '\x0481' -- CYRILLIC SMALL LETTER KOPPA
switch 'G' '3' = '\x0490' -- CYRILLIC CAPITAL LETTER GHE WITH UPTURN
switch 'g' '3' = '\x0491' -- CYRILLIC SMALL LETTER GHE WITH UPTURN
switch 'A' '+' = '\x05D0' -- HEBREW LETTER ALEF
switch 'B' '+' = '\x05D1' -- HEBREW LETTER BET
switch 'G' '+' = '\x05D2' -- HEBREW LETTER GIMEL
switch 'D' '+' = '\x05D3' -- HEBREW LETTER DALET
switch 'H' '+' = '\x05D4' -- HEBREW LETTER HE
switch 'W' '+' = '\x05D5' -- HEBREW LETTER VAV
switch 'Z' '+' = '\x05D6' -- HEBREW LETTER ZAYIN
switch 'X' '+' = '\x05D7' -- HEBREW LETTER HET
switch 'T' 'j' = '\x05D8' -- HEBREW LETTER TET
switch 'J' '+' = '\x05D9' -- HEBREW LETTER YOD
switch 'K' '%' = '\x05DA' -- HEBREW LETTER FINAL KAF
switch 'K' '+' = '\x05DB' -- HEBREW LETTER KAF
switch 'L' '+' = '\x05DC' -- HEBREW LETTER LAMED
switch 'M' '%' = '\x05DD' -- HEBREW LETTER FINAL MEM
switch 'M' '+' = '\x05DE' -- HEBREW LETTER MEM
switch 'N' '%' = '\x05DF' -- HEBREW LETTER FINAL NUN `
switch 'N' '+' = '\x05E0' -- HEBREW LETTER NUN `
switch 'S' '+' = '\x05E1' -- HEBREW LETTER SAMEKH
switch 'E' '+' = '\x05E2' -- HEBREW LETTER AYIN
switch 'P' '%' = '\x05E3' -- HEBREW LETTER FINAL PE
switch 'P' '+' = '\x05E4' -- HEBREW LETTER PE
switch 'Z' 'j' = '\x05E5' -- HEBREW LETTER FINAL TSADI
switch 'Z' 'J' = '\x05E6' -- HEBREW LETTER TSADI
switch 'Q' '+' = '\x05E7' -- HEBREW LETTER QOF
switch 'R' '+' = '\x05E8' -- HEBREW LETTER RESH
switch 'S' 'h' = '\x05E9' -- HEBREW LETTER SHIN
switch 'T' '+' = '\x05EA' -- HEBREW LETTER TAV
switch ',' '+' = '\x060C' -- ARABIC COMMA
switch ';' '+' = '\x061B' -- ARABIC SEMICOLON
switch '?' '+' = '\x061F' -- ARABIC QUESTION MARK
switch 'H' '\'' = '\x0621' -- ARABIC LETTER HAMZA
switch 'a' 'M' = '\x0622' -- ARABIC LETTER ALEF WITH MADDA ABOVE
switch 'a' 'H' = '\x0623' -- ARABIC LETTER ALEF WITH HAMZA ABOVE
switch 'w' 'H' = '\x0624' -- ARABIC LETTER WAW WITH HAMZA ABOVE
switch 'a' 'h' = '\x0625' -- ARABIC LETTER ALEF WITH HAMZA BELOW
switch 'y' 'H' = '\x0626' -- ARABIC LETTER YEH WITH HAMZA ABOVE
switch 'a' '+' = '\x0627' -- ARABIC LETTER ALEF
switch 'b' '+' = '\x0628' -- ARABIC LETTER BEH
switch 't' 'm' = '\x0629' -- ARABIC LETTER TEH MARBUTA
switch 't' '+' = '\x062A' -- ARABIC LETTER TEH
switch 't' 'k' = '\x062B' -- ARABIC LETTER THEH
switch 'g' '+' = '\x062C' -- ARABIC LETTER JEEM
switch 'h' 'k' = '\x062D' -- ARABIC LETTER HAH
switch 'x' '+' = '\x062E' -- ARABIC LETTER KHAH
switch 'd' '+' = '\x062F' -- ARABIC LETTER DAL
switch 'd' 'k' = '\x0630' -- ARABIC LETTER THAL
switch 'r' '+' = '\x0631' -- ARABIC LETTER REH
switch 'z' '+' = '\x0632' -- ARABIC LETTER ZAIN
switch 's' '+' = '\x0633' -- ARABIC LETTER SEEN
switch 's' 'n' = '\x0634' -- ARABIC LETTER SHEEN
switch 'c' '+' = '\x0635' -- ARABIC LETTER SAD
switch 'd' 'd' = '\x0636' -- ARABIC LETTER DAD
switch 't' 'j' = '\x0637' -- ARABIC LETTER TAH
switch 'z' 'H' = '\x0638' -- ARABIC LETTER ZAH
switch 'e' '+' = '\x0639' -- ARABIC LETTER AIN
switch 'i' '+' = '\x063A' -- ARABIC LETTER GHAIN
switch '+' '+' = '\x0640' -- ARABIC TATWEEL
switch 'f' '+' = '\x0641' -- ARABIC LETTER FEH
switch 'q' '+' = '\x0642' -- ARABIC LETTER QAF
switch 'k' '+' = '\x0643' -- ARABIC LETTER KAF
switch 'l' '+' = '\x0644' -- ARABIC LETTER LAM
switch 'm' '+' = '\x0645' -- ARABIC LETTER MEEM
switch 'n' '+' = '\x0646' -- ARABIC LETTER NOON
switch 'h' '+' = '\x0647' -- ARABIC LETTER HEH
switch 'w' '+' = '\x0648' -- ARABIC LETTER WAW
switch 'j' '+' = '\x0649' -- ARABIC LETTER ALEF MAKSURA
switch 'y' '+' = '\x064A' -- ARABIC LETTER YEH
switch ':' '+' = '\x064B' -- ARABIC FATHATAN
switch '"' '+' = '\x064C' -- ARABIC DAMMATAN
switch '=' '+' = '\x064D' -- ARABIC KASRATAN
switch '/' '+' = '\x064E' -- ARABIC FATHA
switch '\'' '+' = '\x064F' -- ARABIC DAMMA
switch '1' '+' = '\x0650' -- ARABIC KASRA
switch '3' '+' = '\x0651' -- ARABIC SHADDA
switch '0' '+' = '\x0652' -- ARABIC SUKUN
switch 'a' 'S' = '\x0670' -- ARABIC LETTER SUPERSCRIPT ALEF
switch 'p' '+' = '\x067E' -- ARABIC LETTER PEH
switch 'v' '+' = '\x06A4' -- ARABIC LETTER VEH
switch 'g' 'f' = '\x06AF' -- ARABIC LETTER GAF
switch '0' 'a' = '\x06F0' -- EXTENDED ARABIC-INDIC DIGIT ZERO
switch '1' 'a' = '\x06F1' -- EXTENDED ARABIC-INDIC DIGIT ONE
switch '2' 'a' = '\x06F2' -- EXTENDED ARABIC-INDIC DIGIT TWO
switch '3' 'a' = '\x06F3' -- EXTENDED ARABIC-INDIC DIGIT THREE
switch '4' 'a' = '\x06F4' -- EXTENDED ARABIC-INDIC DIGIT FOUR
switch '5' 'a' = '\x06F5' -- EXTENDED ARABIC-INDIC DIGIT FIVE
switch '6' 'a' = '\x06F6' -- EXTENDED ARABIC-INDIC DIGIT SIX
switch '7' 'a' = '\x06F7' -- EXTENDED ARABIC-INDIC DIGIT SEVEN
switch '8' 'a' = '\x06F8' -- EXTENDED ARABIC-INDIC DIGIT EIGHT
switch '9' 'a' = '\x06F9' -- EXTENDED ARABIC-INDIC DIGIT NINE
switch 'B' '.' = '\x1E02' -- LATIN CAPITAL LETTER B WITH DOT ABOVE
switch 'b' '.' = '\x1E03' -- LATIN SMALL LETTER B WITH DOT ABOVE
switch 'B' '_' = '\x1E06' -- LATIN CAPITAL LETTER B WITH LINE BELOW
switch 'b' '_' = '\x1E07' -- LATIN SMALL LETTER B WITH LINE BELOW
switch 'D' '.' = '\x1E0A' -- LATIN CAPITAL LETTER D WITH DOT ABOVE
switch 'd' '.' = '\x1E0B' -- LATIN SMALL LETTER D WITH DOT ABOVE
switch 'D' '_' = '\x1E0E' -- LATIN CAPITAL LETTER D WITH LINE BELOW
switch 'd' '_' = '\x1E0F' -- LATIN SMALL LETTER D WITH LINE BELOW
switch 'D' ',' = '\x1E10' -- LATIN CAPITAL LETTER D WITH CEDILLA
switch 'd' ',' = '\x1E11' -- LATIN SMALL LETTER D WITH CEDILLA
switch 'F' '.' = '\x1E1E' -- LATIN CAPITAL LETTER F WITH DOT ABOVE
switch 'f' '.' = '\x1E1F' -- LATIN SMALL LETTER F WITH DOT ABOVE
switch 'G' '-' = '\x1E20' -- LATIN CAPITAL LETTER G WITH MACRON
switch 'g' '-' = '\x1E21' -- LATIN SMALL LETTER G WITH MACRON
switch 'H' '.' = '\x1E22' -- LATIN CAPITAL LETTER H WITH DOT ABOVE
switch 'h' '.' = '\x1E23' -- LATIN SMALL LETTER H WITH DOT ABOVE
switch 'H' ':' = '\x1E26' -- LATIN CAPITAL LETTER H WITH DIAERESIS
switch 'h' ':' = '\x1E27' -- LATIN SMALL LETTER H WITH DIAERESIS
switch 'H' ',' = '\x1E28' -- LATIN CAPITAL LETTER H WITH CEDILLA
switch 'h' ',' = '\x1E29' -- LATIN SMALL LETTER H WITH CEDILLA
switch 'K' '\'' = '\x1E30' -- LATIN CAPITAL LETTER K WITH ACUTE
switch 'k' '\'' = '\x1E31' -- LATIN SMALL LETTER K WITH ACUTE
switch 'K' '_' = '\x1E34' -- LATIN CAPITAL LETTER K WITH LINE BELOW
switch 'k' '_' = '\x1E35' -- LATIN SMALL LETTER K WITH LINE BELOW
switch 'L' '_' = '\x1E3A' -- LATIN CAPITAL LETTER L WITH LINE BELOW
switch 'l' '_' = '\x1E3B' -- LATIN SMALL LETTER L WITH LINE BELOW
switch 'M' '\'' = '\x1E3E' -- LATIN CAPITAL LETTER M WITH ACUTE
switch 'm' '\'' = '\x1E3F' -- LATIN SMALL LETTER M WITH ACUTE
switch 'M' '.' = '\x1E40' -- LATIN CAPITAL LETTER M WITH DOT ABOVE
switch 'm' '.' = '\x1E41' -- LATIN SMALL LETTER M WITH DOT ABOVE
switch 'N' '.' = '\x1E44' -- LATIN CAPITAL LETTER N WITH DOT ABOVE `
switch 'n' '.' = '\x1E45' -- LATIN SMALL LETTER N WITH DOT ABOVE `
switch 'N' '_' = '\x1E48' -- LATIN CAPITAL LETTER N WITH LINE BELOW `
switch 'n' '_' = '\x1E49' -- LATIN SMALL LETTER N WITH LINE BELOW `
switch 'P' '\'' = '\x1E54' -- LATIN CAPITAL LETTER P WITH ACUTE
switch 'p' '\'' = '\x1E55' -- LATIN SMALL LETTER P WITH ACUTE
switch 'P' '.' = '\x1E56' -- LATIN CAPITAL LETTER P WITH DOT ABOVE
switch 'p' '.' = '\x1E57' -- LATIN SMALL LETTER P WITH DOT ABOVE
switch 'R' '.' = '\x1E58' -- LATIN CAPITAL LETTER R WITH DOT ABOVE
switch 'r' '.' = '\x1E59' -- LATIN SMALL LETTER R WITH DOT ABOVE
switch 'R' '_' = '\x1E5E' -- LATIN CAPITAL LETTER R WITH LINE BELOW
switch 'r' '_' = '\x1E5F' -- LATIN SMALL LETTER R WITH LINE BELOW
switch 'S' '.' = '\x1E60' -- LATIN CAPITAL LETTER S WITH DOT ABOVE
switch 's' '.' = '\x1E61' -- LATIN SMALL LETTER S WITH DOT ABOVE
switch 'T' '.' = '\x1E6A' -- LATIN CAPITAL LETTER T WITH DOT ABOVE
switch 't' '.' = '\x1E6B' -- LATIN SMALL LETTER T WITH DOT ABOVE
switch 'T' '_' = '\x1E6E' -- LATIN CAPITAL LETTER T WITH LINE BELOW
switch 't' '_' = '\x1E6F' -- LATIN SMALL LETTER T WITH LINE BELOW
switch 'V' '?' = '\x1E7C' -- LATIN CAPITAL LETTER V WITH TILDE
switch 'v' '?' = '\x1E7D' -- LATIN SMALL LETTER V WITH TILDE
switch 'W' '!' = '\x1E80' -- LATIN CAPITAL LETTER W WITH GRAVE
switch 'w' '!' = '\x1E81' -- LATIN SMALL LETTER W WITH GRAVE
switch 'W' '\'' = '\x1E82' -- LATIN CAPITAL LETTER W WITH ACUTE
switch 'w' '\'' = '\x1E83' -- LATIN SMALL LETTER W WITH ACUTE
switch 'W' ':' = '\x1E84' -- LATIN CAPITAL LETTER W WITH DIAERESIS
switch 'w' ':' = '\x1E85' -- LATIN SMALL LETTER W WITH DIAERESIS
switch 'W' '.' = '\x1E86' -- LATIN CAPITAL LETTER W WITH DOT ABOVE
switch 'w' '.' = '\x1E87' -- LATIN SMALL LETTER W WITH DOT ABOVE
switch 'X' '.' = '\x1E8A' -- LATIN CAPITAL LETTER X WITH DOT ABOVE
switch 'x' '.' = '\x1E8B' -- LATIN SMALL LETTER X WITH DOT ABOVE
switch 'X' ':' = '\x1E8C' -- LATIN CAPITAL LETTER X WITH DIAERESIS
switch 'x' ':' = '\x1E8D' -- LATIN SMALL LETTER X WITH DIAERESIS
switch 'Y' '.' = '\x1E8E' -- LATIN CAPITAL LETTER Y WITH DOT ABOVE
switch 'y' '.' = '\x1E8F' -- LATIN SMALL LETTER Y WITH DOT ABOVE
switch 'Z' '>' = '\x1E90' -- LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
switch 'z' '>' = '\x1E91' -- LATIN SMALL LETTER Z WITH CIRCUMFLEX
switch 'Z' '_' = '\x1E94' -- LATIN CAPITAL LETTER Z WITH LINE BELOW
switch 'z' '_' = '\x1E95' -- LATIN SMALL LETTER Z WITH LINE BELOW
switch 'h' '_' = '\x1E96' -- LATIN SMALL LETTER H WITH LINE BELOW
switch 't' ':' = '\x1E97' -- LATIN SMALL LETTER T WITH DIAERESIS
switch 'w' '0' = '\x1E98' -- LATIN SMALL LETTER W WITH RING ABOVE
switch 'y' '0' = '\x1E99' -- LATIN SMALL LETTER Y WITH RING ABOVE
switch 'A' '2' = '\x1EA2' -- LATIN CAPITAL LETTER A WITH HOOK ABOVE
switch 'a' '2' = '\x1EA3' -- LATIN SMALL LETTER A WITH HOOK ABOVE
switch 'E' '2' = '\x1EBA' -- LATIN CAPITAL LETTER E WITH HOOK ABOVE
switch 'e' '2' = '\x1EBB' -- LATIN SMALL LETTER E WITH HOOK ABOVE
switch 'E' '?' = '\x1EBC' -- LATIN CAPITAL LETTER E WITH TILDE
switch 'e' '?' = '\x1EBD' -- LATIN SMALL LETTER E WITH TILDE
switch 'I' '2' = '\x1EC8' -- LATIN CAPITAL LETTER I WITH HOOK ABOVE
switch 'i' '2' = '\x1EC9' -- LATIN SMALL LETTER I WITH HOOK ABOVE
switch 'O' '2' = '\x1ECE' -- LATIN CAPITAL LETTER O WITH HOOK ABOVE
switch 'o' '2' = '\x1ECF' -- LATIN SMALL LETTER O WITH HOOK ABOVE
switch 'U' '2' = '\x1EE6' -- LATIN CAPITAL LETTER U WITH HOOK ABOVE
switch 'u' '2' = '\x1EE7' -- LATIN SMALL LETTER U WITH HOOK ABOVE
switch 'Y' '!' = '\x1EF2' -- LATIN CAPITAL LETTER Y WITH GRAVE
switch 'y' '!' = '\x1EF3' -- LATIN SMALL LETTER Y WITH GRAVE
switch 'Y' '2' = '\x1EF6' -- LATIN CAPITAL LETTER Y WITH HOOK ABOVE
switch 'y' '2' = '\x1EF7' -- LATIN SMALL LETTER Y WITH HOOK ABOVE
switch 'Y' '?' = '\x1EF8' -- LATIN CAPITAL LETTER Y WITH TILDE
switch 'y' '?' = '\x1EF9' -- LATIN SMALL LETTER Y WITH TILDE
switch ';' '\'' = '\x1F00' -- GREEK SMALL LETTER ALPHA WITH PSILI
switch ',' '\'' = '\x1F01' -- GREEK SMALL LETTER ALPHA WITH DASIA
switch ';' '!' = '\x1F02' -- GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
switch ',' '!' = '\x1F03' -- GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
switch '?' ';' = '\x1F04' -- GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
switch '?' ',' = '\x1F05' -- GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
switch '!' ':' = '\x1F06' -- GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
switch '?' ':' = '\x1F07' -- GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
switch '1' 'N' = '\x2002' -- EN SPACE
switch '1' 'M' = '\x2003' -- EM SPACE
switch '3' 'M' = '\x2004' -- THREE-PER-EM SPACE
switch '4' 'M' = '\x2005' -- FOUR-PER-EM SPACE
switch '6' 'M' = '\x2006' -- SIX-PER-EM SPACE
switch '1' 'T' = '\x2009' -- THIN SPACE
switch '1' 'H' = '\x200A' -- HAIR SPACE
switch '-' '1' = '\x2010' -- HYPHEN
switch '-' 'N' = '\x2013' -- EN DASH `
switch '-' 'M' = '\x2014' -- EM DASH
switch '-' '3' = '\x2015' -- HORIZONTAL BAR
switch '!' '2' = '\x2016' -- DOUBLE VERTICAL LINE
switch '=' '2' = '\x2017' -- DOUBLE LOW LINE
switch '\'' '6' = '\x2018' -- LEFT SINGLE QUOTATION MARK
switch '\'' '9' = '\x2019' -- RIGHT SINGLE QUOTATION MARK
switch '.' '9' = '\x201A' -- SINGLE LOW-9 QUOTATION MARK
switch '9' '\'' = '\x201B' -- SINGLE HIGH-REVERSED-9 QUOTATION MARK
switch '"' '6' = '\x201C' -- LEFT DOUBLE QUOTATION MARK
switch '"' '9' = '\x201D' -- RIGHT DOUBLE QUOTATION MARK
switch ':' '9' = '\x201E' -- DOUBLE LOW-9 QUOTATION MARK
switch '9' '"' = '\x201F' -- DOUBLE HIGH-REVERSED-9 QUOTATION MARK
switch '/' '-' = '\x2020' -- DAGGER
switch '/' '=' = '\x2021' -- DOUBLE DAGGER
switch '.' '.' = '\x2025' -- TWO DOT LEADER
switch '%' '0' = '\x2030' -- PER MILLE SIGN
switch '1' '\'' = '\x2032' -- PRIME
switch '2' '\'' = '\x2033' -- DOUBLE PRIME
switch '3' '\'' = '\x2034' -- TRIPLE PRIME
switch '1' '"' = '\x2035' -- REVERSED PRIME
switch '2' '"' = '\x2036' -- REVERSED DOUBLE PRIME
switch '3' '"' = '\x2037' -- REVERSED TRIPLE PRIME
switch 'C' 'a' = '\x2038' -- CARET
switch '<' '1' = '\x2039' -- SINGLE LEFT-POINTING ANGLE QUOTATION MARK
switch '>' '1' = '\x203A' -- SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
switch ':' 'X' = '\x203B' -- REFERENCE MARK
switch '\'' '-' = '\x203E' -- OVERLINE
switch '/' 'f' = '\x2044' -- FRACTION SLASH
switch '0' 'S' = '\x2070' -- SUPERSCRIPT ZERO
switch '4' 'S' = '\x2074' -- SUPERSCRIPT FOUR
switch '5' 'S' = '\x2075' -- SUPERSCRIPT FIVE
switch '6' 'S' = '\x2076' -- SUPERSCRIPT SIX
switch '7' 'S' = '\x2077' -- SUPERSCRIPT SEVEN
switch '8' 'S' = '\x2078' -- SUPERSCRIPT EIGHT
switch '9' 'S' = '\x2079' -- SUPERSCRIPT NINE
switch '+' 'S' = '\x207A' -- SUPERSCRIPT PLUS SIGN
switch '-' 'S' = '\x207B' -- SUPERSCRIPT MINUS
switch '=' 'S' = '\x207C' -- SUPERSCRIPT EQUALS SIGN
switch '(' 'S' = '\x207D' -- SUPERSCRIPT LEFT PARENTHESIS
switch ')' 'S' = '\x207E' -- SUPERSCRIPT RIGHT PARENTHESIS
switch 'n' 'S' = '\x207F' -- SUPERSCRIPT LATIN SMALL LETTER N `
switch '0' 's' = '\x2080' -- SUBSCRIPT ZERO
switch '1' 's' = '\x2081' -- SUBSCRIPT ONE
switch '2' 's' = '\x2082' -- SUBSCRIPT TWO
switch '3' 's' = '\x2083' -- SUBSCRIPT THREE
switch '4' 's' = '\x2084' -- SUBSCRIPT FOUR
switch '5' 's' = '\x2085' -- SUBSCRIPT FIVE
switch '6' 's' = '\x2086' -- SUBSCRIPT SIX
switch '7' 's' = '\x2087' -- SUBSCRIPT SEVEN
switch '8' 's' = '\x2088' -- SUBSCRIPT EIGHT
switch '9' 's' = '\x2089' -- SUBSCRIPT NINE
switch '+' 's' = '\x208A' -- SUBSCRIPT PLUS SIGN
switch '-' 's' = '\x208B' -- SUBSCRIPT MINUS
switch '=' 's' = '\x208C' -- SUBSCRIPT EQUALS SIGN
switch '(' 's' = '\x208D' -- SUBSCRIPT LEFT PARENTHESIS
switch ')' 's' = '\x208E' -- SUBSCRIPT RIGHT PARENTHESIS
switch 'L' 'i' = '\x20A4' -- LIRA SIGN
switch 'P' 't' = '\x20A7' -- PESETA SIGN
switch 'W' '=' = '\x20A9' -- WON SIGN
switch 'E' 'u' = '\x20AC' -- EURO SIGN
switch 'o' 'C' = '\x2103' -- DEGREE CELSIUS
switch 'c' 'o' = '\x2105' -- CARE OF
switch 'o' 'F' = '\x2109' -- DEGREE FAHRENHEIT
switch 'N' '0' = '\x2116' -- NUMERO SIGN
switch 'P' 'O' = '\x2117' -- SOUND RECORDING COPYRIGHT
switch 'R' 'x' = '\x211E' -- PRESCRIPTION TAKE
switch 'S' 'M' = '\x2120' -- SERVICE MARK
switch 'T' 'M' = '\x2122' -- TRADE MARK SIGN
switch 'O' 'm' = '\x2126' -- OHM SIGN
switch 'A' 'O' = '\x212B' -- ANGSTROM SIGN
switch '1' '3' = '\x2153' -- VULGAR FRACTION ONE THIRD
switch '2' '3' = '\x2154' -- VULGAR FRACTION TWO THIRDS
switch '1' '5' = '\x2155' -- VULGAR FRACTION ONE FIFTH
switch '2' '5' = '\x2156' -- VULGAR FRACTION TWO FIFTHS
switch '3' '5' = '\x2157' -- VULGAR FRACTION THREE FIFTHS
switch '4' '5' = '\x2158' -- VULGAR FRACTION FOUR FIFTHS
switch '1' '6' = '\x2159' -- VULGAR FRACTION ONE SIXTH
switch '5' '6' = '\x215A' -- VULGAR FRACTION FIVE SIXTHS
switch '1' '8' = '\x215B' -- VULGAR FRACTION ONE EIGHTH
switch '3' '8' = '\x215C' -- VULGAR FRACTION THREE EIGHTHS
switch '5' '8' = '\x215D' -- VULGAR FRACTION FIVE EIGHTHS
switch '7' '8' = '\x215E' -- VULGAR FRACTION SEVEN EIGHTHS
switch '1' 'R' = '\x2160' -- ROMAN NUMERAL ONE
switch '2' 'R' = '\x2161' -- ROMAN NUMERAL TWO
switch '3' 'R' = '\x2162' -- ROMAN NUMERAL THREE
switch '4' 'R' = '\x2163' -- ROMAN NUMERAL FOUR
switch '5' 'R' = '\x2164' -- ROMAN NUMERAL FIVE
switch '6' 'R' = '\x2165' -- ROMAN NUMERAL SIX
switch '7' 'R' = '\x2166' -- ROMAN NUMERAL SEVEN
switch '8' 'R' = '\x2167' -- ROMAN NUMERAL EIGHT
switch '9' 'R' = '\x2168' -- ROMAN NUMERAL NINE
switch 'a' 'R' = '\x2169' -- ROMAN NUMERAL TEN
switch 'b' 'R' = '\x216A' -- ROMAN NUMERAL ELEVEN
switch 'c' 'R' = '\x216B' -- ROMAN NUMERAL TWELVE
switch '1' 'r' = '\x2170' -- SMALL ROMAN NUMERAL ONE
switch '2' 'r' = '\x2171' -- SMALL ROMAN NUMERAL TWO
switch '3' 'r' = '\x2172' -- SMALL ROMAN NUMERAL THREE
switch '4' 'r' = '\x2173' -- SMALL ROMAN NUMERAL FOUR
switch '5' 'r' = '\x2174' -- SMALL ROMAN NUMERAL FIVE
switch '6' 'r' = '\x2175' -- SMALL ROMAN NUMERAL SIX
switch '7' 'r' = '\x2176' -- SMALL ROMAN NUMERAL SEVEN
switch '8' 'r' = '\x2177' -- SMALL ROMAN NUMERAL EIGHT
switch '9' 'r' = '\x2178' -- SMALL ROMAN NUMERAL NINE
switch 'a' 'r' = '\x2179' -- SMALL ROMAN NUMERAL TEN
switch 'b' 'r' = '\x217A' -- SMALL ROMAN NUMERAL ELEVEN
switch 'c' 'r' = '\x217B' -- SMALL ROMAN NUMERAL TWELVE
switch '<' '-' = '\x2190' -- LEFTWARDS ARROW
switch '-' '!' = '\x2191' -- UPWARDS ARROW
switch '-' '>' = '\x2192' -- RIGHTWARDS ARROW
switch '-' 'v' = '\x2193' -- DOWNWARDS ARROW
switch '<' '>' = '\x2194' -- LEFT RIGHT ARROW
switch 'U' 'D' = '\x2195' -- UP DOWN ARROW
switch '<' '=' = '\x21D0' -- LEFTWARDS DOUBLE ARROW
switch '=' '>' = '\x21D2' -- RIGHTWARDS DOUBLE ARROW
switch '=' '=' = '\x21D4' -- LEFT RIGHT DOUBLE ARROW
switch 'F' 'A' = '\x2200' -- FOR ALL
switch 'd' 'P' = '\x2202' -- PARTIAL DIFFERENTIAL
switch 'T' 'E' = '\x2203' -- THERE EXISTS
switch '/' '0' = '\x2205' -- EMPTY SET
switch 'D' 'E' = '\x2206' -- INCREMENT
switch 'N' 'B' = '\x2207' -- NABLA
switch '(' '-' = '\x2208' -- ELEMENT OF
switch '-' ')' = '\x220B' -- CONTAINS AS MEMBER
switch '*' 'P' = '\x220F' -- N-ARY PRODUCT `
switch '+' 'Z' = '\x2211' -- N-ARY SUMMATION `
switch '-' '2' = '\x2212' -- MINUS SIGN
switch '-' '+' = '\x2213' -- MINUS-OR-PLUS SIGN
switch '*' '-' = '\x2217' -- ASTERISK OPERATOR
switch 'O' 'b' = '\x2218' -- RING OPERATOR
switch 'S' 'b' = '\x2219' -- BULLET OPERATOR
switch 'R' 'T' = '\x221A' -- SQUARE ROOT
switch '0' '(' = '\x221D' -- PROPORTIONAL TO
switch '0' '0' = '\x221E' -- INFINITY
switch '-' 'L' = '\x221F' -- RIGHT ANGLE
switch '-' 'V' = '\x2220' -- ANGLE
switch 'P' 'P' = '\x2225' -- PARALLEL TO
switch 'A' 'N' = '\x2227' -- LOGICAL AND
switch 'O' 'R' = '\x2228' -- LOGICAL OR
switch '(' 'U' = '\x2229' -- INTERSECTION
switch ')' 'U' = '\x222A' -- UNION
switch 'I' 'n' = '\x222B' -- INTEGRAL
switch 'D' 'I' = '\x222C' -- DOUBLE INTEGRAL
switch 'I' 'o' = '\x222E' -- CONTOUR INTEGRAL
switch '.' ':' = '\x2234' -- THEREFORE
switch ':' '.' = '\x2235' -- BECAUSE
switch ':' 'R' = '\x2236' -- RATIO
switch ':' ':' = '\x2237' -- PROPORTION
switch '?' '1' = '\x223C' -- TILDE OPERATOR
switch 'C' 'G' = '\x223E' -- INVERTED LAZY S
switch '?' '-' = '\x2243' -- ASYMPTOTICALLY EQUAL TO
switch '?' '=' = '\x2245' -- APPROXIMATELY EQUAL TO
switch '?' '2' = '\x2248' -- ALMOST EQUAL TO
switch '=' '?' = '\x224C' -- ALL EQUAL TO
switch 'H' 'I' = '\x2253' -- IMAGE OF OR APPROXIMATELY EQUAL TO
switch '!' '=' = '\x2260' -- NOT EQUAL TO
switch '=' '3' = '\x2261' -- IDENTICAL TO
switch '=' '<' = '\x2264' -- LESS-THAN OR EQUAL TO
switch '>' '=' = '\x2265' -- GREATER-THAN OR EQUAL TO
switch '<' '*' = '\x226A' -- MUCH LESS-THAN
switch '*' '>' = '\x226B' -- MUCH GREATER-THAN
switch '!' '<' = '\x226E' -- NOT LESS-THAN
switch '!' '>' = '\x226F' -- NOT GREATER-THAN
switch '(' 'C' = '\x2282' -- SUBSET OF
switch ')' 'C' = '\x2283' -- SUPERSET OF
switch '(' '_' = '\x2286' -- SUBSET OF OR EQUAL TO
switch ')' '_' = '\x2287' -- SUPERSET OF OR EQUAL TO
switch '0' '.' = '\x2299' -- CIRCLED DOT OPERATOR
switch '0' '2' = '\x229A' -- CIRCLED RING OPERATOR
switch '-' 'T' = '\x22A5' -- UP TACK
switch '.' 'P' = '\x22C5' -- DOT OPERATOR
switch ':' '3' = '\x22EE' -- VERTICAL ELLIPSIS
switch '.' '3' = '\x22EF' -- MIDLINE HORIZONTAL ELLIPSIS
switch 'E' 'h' = '\x2302' -- HOUSE
switch '<' '7' = '\x2308' -- LEFT CEILING
switch '>' '7' = '\x2309' -- RIGHT CEILING
switch '7' '<' = '\x230A' -- LEFT FLOOR
switch '7' '>' = '\x230B' -- RIGHT FLOOR
switch 'N' 'I' = '\x2310' -- REVERSED NOT SIGN
switch '(' 'A' = '\x2312' -- ARC
switch 'T' 'R' = '\x2315' -- TELEPHONE RECORDER
switch 'I' 'u' = '\x2320' -- TOP HALF INTEGRAL
switch 'I' 'l' = '\x2321' -- BOTTOM HALF INTEGRAL
switch '<' '/' = '\x2329' -- LEFT-POINTING ANGLE BRACKET
switch '/' '>' = '\x232A' -- RIGHT-POINTING ANGLE BRACKET
switch 'V' 's' = '\x2423' -- OPEN BOX
switch '1' 'h' = '\x2440' -- OCR HOOK
switch '3' 'h' = '\x2441' -- OCR CHAIR
switch '2' 'h' = '\x2442' -- OCR FORK
switch '4' 'h' = '\x2443' -- OCR INVERTED FORK
switch '1' 'j' = '\x2446' -- OCR BRANCH BANK IDENTIFICATION
switch '2' 'j' = '\x2447' -- OCR AMOUNT OF CHECK
switch '3' 'j' = '\x2448' -- OCR DASH
switch '4' 'j' = '\x2449' -- OCR CUSTOMER ACCOUNT NUMBER
switch '1' '.' = '\x2488' -- DIGIT ONE FULL STOP
switch '2' '.' = '\x2489' -- DIGIT TWO FULL STOP
switch '3' '.' = '\x248A' -- DIGIT THREE FULL STOP
switch '4' '.' = '\x248B' -- DIGIT FOUR FULL STOP
switch '5' '.' = '\x248C' -- DIGIT FIVE FULL STOP
switch '6' '.' = '\x248D' -- DIGIT SIX FULL STOP
switch '7' '.' = '\x248E' -- DIGIT SEVEN FULL STOP
switch '8' '.' = '\x248F' -- DIGIT EIGHT FULL STOP
switch '9' '.' = '\x2490' -- DIGIT NINE FULL STOP
switch 'h' 'h' = '\x2500' -- BOX DRAWINGS LIGHT HORIZONTAL
switch 'H' 'H' = '\x2501' -- BOX DRAWINGS HEAVY HORIZONTAL
switch 'v' 'v' = '\x2502' -- BOX DRAWINGS LIGHT VERTICAL
switch 'V' 'V' = '\x2503' -- BOX DRAWINGS HEAVY VERTICAL
switch '3' '-' = '\x2504' -- BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
switch '3' '_' = '\x2505' -- BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
switch '3' '!' = '\x2506' -- BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
switch '3' '/' = '\x2507' -- BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
switch '4' '-' = '\x2508' -- BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
switch '4' '_' = '\x2509' -- BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
switch '4' '!' = '\x250A' -- BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
switch '4' '/' = '\x250B' -- BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
switch 'd' 'r' = '\x250C' -- BOX DRAWINGS LIGHT DOWN AND RIGHT
switch 'd' 'R' = '\x250D' -- BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
switch 'D' 'r' = '\x250E' -- BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
switch 'D' 'R' = '\x250F' -- BOX DRAWINGS HEAVY DOWN AND RIGHT
switch 'd' 'l' = '\x2510' -- BOX DRAWINGS LIGHT DOWN AND LEFT
switch 'd' 'L' = '\x2511' -- BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
switch 'D' 'l' = '\x2512' -- BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
switch 'L' 'D' = '\x2513' -- BOX DRAWINGS HEAVY DOWN AND LEFT
switch 'u' 'r' = '\x2514' -- BOX DRAWINGS LIGHT UP AND RIGHT
switch 'u' 'R' = '\x2515' -- BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
switch 'U' 'r' = '\x2516' -- BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
switch 'U' 'R' = '\x2517' -- BOX DRAWINGS HEAVY UP AND RIGHT
switch 'u' 'l' = '\x2518' -- BOX VOICED SOUND MARKDRAWINGS LIGHT UP AND LEFT
switch 'u' 'L' = '\x2519' -- BOX DRAWINGS UP LIGHT AND LEFT HEAVY
switch 'U' 'l' = '\x251A' -- BOX DRAWINGS UP HEAVY AND LEFT LIGHT
switch 'U' 'L' = '\x251B' -- BOX DRAWINGS HEAVY UP AND LEFT
switch 'v' 'r' = '\x251C' -- BOX DRAWINGS LIGHT VERTICAL AND RIGHT
switch 'v' 'R' = '\x251D' -- BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
switch 'V' 'r' = '\x2520' -- BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
switch 'V' 'R' = '\x2523' -- BOX DRAWINGS HEAVY VERTICAL AND RIGHT
switch 'v' 'l' = '\x2524' -- BOX DRAWINGS LIGHT VERTICAL AND LEFT
switch 'v' 'L' = '\x2525' -- BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
switch 'V' 'l' = '\x2528' -- BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
switch 'V' 'L' = '\x252B' -- BOX DRAWINGS HEAVY VERTICAL AND LEFT
switch 'd' 'h' = '\x252C' -- BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
switch 'd' 'H' = '\x252F' -- BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
switch 'D' 'h' = '\x2530' -- BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
switch 'D' 'H' = '\x2533' -- BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
switch 'u' 'h' = '\x2534' -- BOX DRAWINGS LIGHT UP AND HORIZONTAL
switch 'u' 'H' = '\x2537' -- BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
switch 'U' 'h' = '\x2538' -- BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
switch 'U' 'H' = '\x253B' -- BOX DRAWINGS HEAVY UP AND HORIZONTAL
switch 'v' 'h' = '\x253C' -- BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
switch 'v' 'H' = '\x253F' -- BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
switch 'V' 'h' = '\x2542' -- BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
switch 'V' 'H' = '\x254B' -- BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
switch 'F' 'D' = '\x2571' -- BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
switch 'B' 'D' = '\x2572' -- BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
switch 'T' 'B' = '\x2580' -- UPPER HALF BLOCK
switch 'L' 'B' = '\x2584' -- LOWER HALF BLOCK
switch 'F' 'B' = '\x2588' -- FULL BLOCK
switch 'l' 'B' = '\x258C' -- LEFT HALF BLOCK
switch 'R' 'B' = '\x2590' -- RIGHT HALF BLOCK
switch '.' 'S' = '\x2591' -- LIGHT SHADE
switch ':' 'S' = '\x2592' -- MEDIUM SHADE
switch '?' 'S' = '\x2593' -- DARK SHADE
switch 'f' 'S' = '\x25A0' -- BLACK SQUARE
switch 'O' 'S' = '\x25A1' -- WHITE SQUARE
switch 'R' 'O' = '\x25A2' -- WHITE SQUARE WITH ROUNDED CORNERS
switch 'R' 'r' = '\x25A3' -- WHITE SQUARE CONTAINING BLACK SMALL SQUARE
switch 'R' 'F' = '\x25A4' -- SQUARE WITH HORIZONTAL FILL
switch 'R' 'Y' = '\x25A5' -- SQUARE WITH VERTICAL FILL
switch 'R' 'H' = '\x25A6' -- SQUARE WITH ORTHOGONAL CROSSHATCH FILL
switch 'R' 'Z' = '\x25A7' -- SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
switch 'R' 'K' = '\x25A8' -- SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
switch 'R' 'X' = '\x25A9' -- SQUARE WITH DIAGONAL CROSSHATCH FILL
switch 's' 'B' = '\x25AA' -- BLACK SMALL SQUARE
switch 'S' 'R' = '\x25AC' -- BLACK RECTANGLE
switch 'O' 'r' = '\x25AD' -- WHITE RECTANGLE
switch 'U' 'T' = '\x25B2' -- BLACK UP-POINTING TRIANGLE
switch 'u' 'T' = '\x25B3' -- WHITE UP-POINTING TRIANGLE
switch 'P' 'R' = '\x25B6' -- BLACK RIGHT-POINTING TRIANGLE
switch 'T' 'r' = '\x25B7' -- WHITE RIGHT-POINTING TRIANGLE
switch 'D' 't' = '\x25BC' -- BLACK DOWN-POINTING TRIANGLE
switch 'd' 'T' = '\x25BD' -- WHITE DOWN-POINTING TRIANGLE
switch 'P' 'L' = '\x25C0' -- BLACK LEFT-POINTING TRIANGLE
switch 'T' 'l' = '\x25C1' -- WHITE LEFT-POINTING TRIANGLE
switch 'D' 'b' = '\x25C6' -- BLACK DIAMOND
switch 'D' 'w' = '\x25C7' -- WHITE DIAMOND
switch 'L' 'Z' = '\x25CA' -- LOZENGE
switch '0' 'm' = '\x25CB' -- WHITE CIRCLE
switch '0' 'o' = '\x25CE' -- BULLSEYE
switch '0' 'M' = '\x25CF' -- BLACK CIRCLE
switch '0' 'L' = '\x25D0' -- CIRCLE WITH LEFT HALF BLACK
switch '0' 'R' = '\x25D1' -- CIRCLE WITH RIGHT HALF BLACK
switch 'S' 'n' = '\x25D8' -- INVERSE BULLET
switch 'I' 'c' = '\x25D9' -- INVERSE WHITE CIRCLE
switch 'F' 'd' = '\x25E2' -- BLACK LOWER RIGHT TRIANGLE
switch 'B' 'd' = '\x25E3' -- BLACK LOWER LEFT TRIANGLE
switch '*' '2' = '\x2605' -- BLACK STAR
switch '*' '1' = '\x2606' -- WHITE STAR
switch '<' 'H' = '\x261C' -- WHITE LEFT POINTING INDEX
switch '>' 'H' = '\x261E' -- WHITE RIGHT POINTING INDEX
switch '0' 'u' = '\x263A' -- WHITE SMILING FACE
switch '0' 'U' = '\x263B' -- BLACK SMILING FACE
switch 'S' 'U' = '\x263C' -- WHITE SUN WITH RAYS
switch 'F' 'm' = '\x2640' -- FEMALE SIGN
switch 'M' 'l' = '\x2642' -- MALE SIGN
switch 'c' 'S' = '\x2660' -- BLACK SPADE SUIT
switch 'c' 'H' = '\x2661' -- WHITE HEART SUIT
switch 'c' 'D' = '\x2662' -- WHITE DIAMOND SUIT
switch 'c' 'C' = '\x2663' -- BLACK CLUB SUIT
switch 'M' 'd' = '\x2669' -- QUARTER NOTE `
switch 'M' '8' = '\x266A' -- EIGHTH NOTE `
switch 'M' '2' = '\x266B' -- BEAMED EIGHTH NOTES
switch 'M' 'b' = '\x266D' -- MUSIC FLAT SIGN
switch 'M' 'x' = '\x266E' -- MUSIC NATURAL SIGN
switch 'M' 'X' = '\x266F' -- MUSIC SHARP SIGN
switch 'O' 'K' = '\x2713' -- CHECK MARK
switch 'X' 'X' = '\x2717' -- BALLOT X
switch '-' 'X' = '\x2720' -- MALTESE CROSS
switch 'I' 'S' = '\x3000' -- IDEOGRAPHIC SPACE
switch ',' '_' = '\x3001' -- IDEOGRAPHIC COMMA
switch '.' '_' = '\x3002' -- IDEOGRAPHIC FULL STOP
switch '+' '"' = '\x3003' -- DITTO MARK
switch '+' '_' = '\x3004' -- JAPANESE INDUSTRIAL STANDARD SYMBOL
switch '*' '_' = '\x3005' -- IDEOGRAPHIC ITERATION MARK
switch ';' '_' = '\x3006' -- IDEOGRAPHIC CLOSING MARK
switch '0' '_' = '\x3007' -- IDEOGRAPHIC NUMBER ZERO
switch '<' '+' = '\x300A' -- LEFT DOUBLE ANGLE BRACKET
switch '>' '+' = '\x300B' -- RIGHT DOUBLE ANGLE BRACKET
switch '<' '\'' = '\x300C' -- LEFT CORNER BRACKET
switch '>' '\'' = '\x300D' -- RIGHT CORNER BRACKET
switch '<' '"' = '\x300E' -- LEFT WHITE CORNER BRACKET
switch '>' '"' = '\x300F' -- RIGHT WHITE CORNER BRACKET
switch '(' '"' = '\x3010' -- LEFT BLACK LENTICULAR BRACKET
switch ')' '"' = '\x3011' -- RIGHT BLACK LENTICULAR BRACKET
switch '=' 'T' = '\x3012' -- POSTAL MARK
switch '=' '_' = '\x3013' -- GETA MARK
switch '(' '\'' = '\x3014' -- LEFT TORTOISE SHELL BRACKET
switch ')' '\'' = '\x3015' -- RIGHT TORTOISE SHELL BRACKET
switch '(' 'I' = '\x3016' -- LEFT WHITE LENTICULAR BRACKET
switch ')' 'I' = '\x3017' -- RIGHT WHITE LENTICULAR BRACKET
switch '-' '?' = '\x301C' -- WAVE DASH
switch 'A' '5' = '\x3041' -- HIRAGANA LETTER SMALL A
switch 'a' '5' = '\x3042' -- HIRAGANA LETTER A
switch 'I' '5' = '\x3043' -- HIRAGANA LETTER SMALL I
switch 'i' '5' = '\x3044' -- HIRAGANA LETTER I
switch 'U' '5' = '\x3045' -- HIRAGANA LETTER SMALL U
switch 'u' '5' = '\x3046' -- HIRAGANA LETTER U
switch 'E' '5' = '\x3047' -- HIRAGANA LETTER SMALL E
switch 'e' '5' = '\x3048' -- HIRAGANA LETTER E
switch 'O' '5' = '\x3049' -- HIRAGANA LETTER SMALL O
switch 'o' '5' = '\x304A' -- HIRAGANA LETTER O
switch 'k' 'a' = '\x304B' -- HIRAGANA LETTER KA
switch 'g' 'a' = '\x304C' -- HIRAGANA LETTER GA
switch 'k' 'i' = '\x304D' -- HIRAGANA LETTER KI
switch 'g' 'i' = '\x304E' -- HIRAGANA LETTER GI
switch 'k' 'u' = '\x304F' -- HIRAGANA LETTER KU
switch 'g' 'u' = '\x3050' -- HIRAGANA LETTER GU
switch 'k' 'e' = '\x3051' -- HIRAGANA LETTER KE
switch 'g' 'e' = '\x3052' -- HIRAGANA LETTER GE
switch 'k' 'o' = '\x3053' -- HIRAGANA LETTER KO
switch 'g' 'o' = '\x3054' -- HIRAGANA LETTER GO
switch 's' 'a' = '\x3055' -- HIRAGANA LETTER SA
switch 'z' 'a' = '\x3056' -- HIRAGANA LETTER ZA
switch 's' 'i' = '\x3057' -- HIRAGANA LETTER SI
switch 'z' 'i' = '\x3058' -- HIRAGANA LETTER ZI
switch 's' 'u' = '\x3059' -- HIRAGANA LETTER SU
switch 'z' 'u' = '\x305A' -- HIRAGANA LETTER ZU
switch 's' 'e' = '\x305B' -- HIRAGANA LETTER SE
switch 'z' 'e' = '\x305C' -- HIRAGANA LETTER ZE
switch 's' 'o' = '\x305D' -- HIRAGANA LETTER SO
switch 'z' 'o' = '\x305E' -- HIRAGANA LETTER ZO
switch 't' 'a' = '\x305F' -- HIRAGANA LETTER TA
switch 'd' 'a' = '\x3060' -- HIRAGANA LETTER DA
switch 't' 'i' = '\x3061' -- HIRAGANA LETTER TI
switch 'd' 'i' = '\x3062' -- HIRAGANA LETTER DI
switch 't' 'U' = '\x3063' -- HIRAGANA LETTER SMALL TU
switch 't' 'u' = '\x3064' -- HIRAGANA LETTER TU
switch 'd' 'u' = '\x3065' -- HIRAGANA LETTER DU
switch 't' 'e' = '\x3066' -- HIRAGANA LETTER TE
switch 'd' 'e' = '\x3067' -- HIRAGANA LETTER DE
switch 't' 'o' = '\x3068' -- HIRAGANA LETTER TO
switch 'd' 'o' = '\x3069' -- HIRAGANA LETTER DO
switch 'n' 'a' = '\x306A' -- HIRAGANA LETTER NA
switch 'n' 'i' = '\x306B' -- HIRAGANA LETTER NI
switch 'n' 'u' = '\x306C' -- HIRAGANA LETTER NU
switch 'n' 'e' = '\x306D' -- HIRAGANA LETTER NE
switch 'n' 'o' = '\x306E' -- HIRAGANA LETTER NO
switch 'h' 'a' = '\x306F' -- HIRAGANA LETTER HA
switch 'b' 'a' = '\x3070' -- HIRAGANA LETTER BA
switch 'p' 'a' = '\x3071' -- HIRAGANA LETTER PA
switch 'h' 'i' = '\x3072' -- HIRAGANA LETTER HI
switch 'b' 'i' = '\x3073' -- HIRAGANA LETTER BI
switch 'p' 'i' = '\x3074' -- HIRAGANA LETTER PI
switch 'h' 'u' = '\x3075' -- HIRAGANA LETTER HU
switch 'b' 'u' = '\x3076' -- HIRAGANA LETTER BU
switch 'p' 'u' = '\x3077' -- HIRAGANA LETTER PU
switch 'h' 'e' = '\x3078' -- HIRAGANA LETTER HE
switch 'b' 'e' = '\x3079' -- HIRAGANA LETTER BE
switch 'p' 'e' = '\x307A' -- HIRAGANA LETTER PE
switch 'h' 'o' = '\x307B' -- HIRAGANA LETTER HO
switch 'b' 'o' = '\x307C' -- HIRAGANA LETTER BO
switch 'p' 'o' = '\x307D' -- HIRAGANA LETTER PO
switch 'm' 'a' = '\x307E' -- HIRAGANA LETTER MA
switch 'm' 'i' = '\x307F' -- HIRAGANA LETTER MI
switch 'm' 'u' = '\x3080' -- HIRAGANA LETTER MU
switch 'm' 'e' = '\x3081' -- HIRAGANA LETTER ME
switch 'm' 'o' = '\x3082' -- HIRAGANA LETTER MO
switch 'y' 'A' = '\x3083' -- HIRAGANA LETTER SMALL YA
switch 'y' 'a' = '\x3084' -- HIRAGANA LETTER YA
switch 'y' 'U' = '\x3085' -- HIRAGANA LETTER SMALL YU
switch 'y' 'u' = '\x3086' -- HIRAGANA LETTER YU
switch 'y' 'O' = '\x3087' -- HIRAGANA LETTER SMALL YO
switch 'y' 'o' = '\x3088' -- HIRAGANA LETTER YO
switch 'r' 'a' = '\x3089' -- HIRAGANA LETTER RA
switch 'r' 'i' = '\x308A' -- HIRAGANA LETTER RI
switch 'r' 'u' = '\x308B' -- HIRAGANA LETTER RU
switch 'r' 'e' = '\x308C' -- HIRAGANA LETTER RE
switch 'r' 'o' = '\x308D' -- HIRAGANA LETTER RO
switch 'w' 'A' = '\x308E' -- HIRAGANA LETTER SMALL WA
switch 'w' 'a' = '\x308F' -- HIRAGANA LETTER WA
switch 'w' 'i' = '\x3090' -- HIRAGANA LETTER WI
switch 'w' 'e' = '\x3091' -- HIRAGANA LETTER WE
switch 'w' 'o' = '\x3092' -- HIRAGANA LETTER WO
switch 'n' '5' = '\x3093' -- HIRAGANA LETTER N `
switch 'v' 'u' = '\x3094' -- HIRAGANA LETTER VU
switch '"' '5' = '\x309B' -- KATAKANA-HIRAGANA VOICED SOUND MARK
switch '0' '5' = '\x309C' -- KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
switch '*' '5' = '\x309D' -- HIRAGANA ITERATION MARK
switch '+' '5' = '\x309E' -- HIRAGANA VOICED ITERATION MARK
switch 'a' '6' = '\x30A1' -- KATAKANA LETTER SMALL A
switch 'A' '6' = '\x30A2' -- KATAKANA LETTER A
switch 'i' '6' = '\x30A3' -- KATAKANA LETTER SMALL I
switch 'I' '6' = '\x30A4' -- KATAKANA LETTER I
switch 'u' '6' = '\x30A5' -- KATAKANA LETTER SMALL U
switch 'U' '6' = '\x30A6' -- KATAKANA LETTER U
switch 'e' '6' = '\x30A7' -- KATAKANA LETTER SMALL E
switch 'E' '6' = '\x30A8' -- KATAKANA LETTER E
switch 'o' '6' = '\x30A9' -- KATAKANA LETTER SMALL O
switch 'O' '6' = '\x30AA' -- KATAKANA LETTER O
switch 'K' 'a' = '\x30AB' -- KATAKANA LETTER KA
switch 'G' 'a' = '\x30AC' -- KATAKANA LETTER GA
switch 'K' 'i' = '\x30AD' -- KATAKANA LETTER KI
switch 'G' 'i' = '\x30AE' -- KATAKANA LETTER GI
switch 'K' 'u' = '\x30AF' -- KATAKANA LETTER KU
switch 'G' 'u' = '\x30B0' -- KATAKANA LETTER GU
switch 'K' 'e' = '\x30B1' -- KATAKANA LETTER KE
switch 'G' 'e' = '\x30B2' -- KATAKANA LETTER GE
switch 'K' 'o' = '\x30B3' -- KATAKANA LETTER KO
switch 'G' 'o' = '\x30B4' -- KATAKANA LETTER GO
switch 'S' 'a' = '\x30B5' -- KATAKANA LETTER SA
switch 'Z' 'a' = '\x30B6' -- KATAKANA LETTER ZA
switch 'S' 'i' = '\x30B7' -- KATAKANA LETTER SI
switch 'Z' 'i' = '\x30B8' -- KATAKANA LETTER ZI
switch 'S' 'u' = '\x30B9' -- KATAKANA LETTER SU
switch 'Z' 'u' = '\x30BA' -- KATAKANA LETTER ZU
switch 'S' 'e' = '\x30BB' -- KATAKANA LETTER SE
switch 'Z' 'e' = '\x30BC' -- KATAKANA LETTER ZE
switch 'S' 'o' = '\x30BD' -- KATAKANA LETTER SO
switch 'Z' 'o' = '\x30BE' -- KATAKANA LETTER ZO
switch 'T' 'a' = '\x30BF' -- KATAKANA LETTER TA
switch 'D' 'a' = '\x30C0' -- KATAKANA LETTER DA
switch 'T' 'i' = '\x30C1' -- KATAKANA LETTER TI
switch 'D' 'i' = '\x30C2' -- KATAKANA LETTER DI
switch 'T' 'U' = '\x30C3' -- KATAKANA LETTER SMALL TU
switch 'T' 'u' = '\x30C4' -- KATAKANA LETTER TU
switch 'D' 'u' = '\x30C5' -- KATAKANA LETTER DU
switch 'T' 'e' = '\x30C6' -- KATAKANA LETTER TE
switch 'D' 'e' = '\x30C7' -- KATAKANA LETTER DE
switch 'T' 'o' = '\x30C8' -- KATAKANA LETTER TO
switch 'D' 'o' = '\x30C9' -- KATAKANA LETTER DO
switch 'N' 'a' = '\x30CA' -- KATAKANA LETTER NA
switch 'N' 'i' = '\x30CB' -- KATAKANA LETTER NI
switch 'N' 'u' = '\x30CC' -- KATAKANA LETTER NU
switch 'N' 'e' = '\x30CD' -- KATAKANA LETTER NE
switch 'N' 'o' = '\x30CE' -- KATAKANA LETTER NO
switch 'H' 'a' = '\x30CF' -- KATAKANA LETTER HA
switch 'B' 'a' = '\x30D0' -- KATAKANA LETTER BA
switch 'P' 'a' = '\x30D1' -- KATAKANA LETTER PA
switch 'H' 'i' = '\x30D2' -- KATAKANA LETTER HI
switch 'B' 'i' = '\x30D3' -- KATAKANA LETTER BI
switch 'P' 'i' = '\x30D4' -- KATAKANA LETTER PI
switch 'H' 'u' = '\x30D5' -- KATAKANA LETTER HU
switch 'B' 'u' = '\x30D6' -- KATAKANA LETTER BU
switch 'P' 'u' = '\x30D7' -- KATAKANA LETTER PU
switch 'H' 'e' = '\x30D8' -- KATAKANA LETTER HE
switch 'B' 'e' = '\x30D9' -- KATAKANA LETTER BE
switch 'P' 'e' = '\x30DA' -- KATAKANA LETTER PE
switch 'H' 'o' = '\x30DB' -- KATAKANA LETTER HO
switch 'B' 'o' = '\x30DC' -- KATAKANA LETTER BO
switch 'P' 'o' = '\x30DD' -- KATAKANA LETTER PO
switch 'M' 'a' = '\x30DE' -- KATAKANA LETTER MA
switch 'M' 'i' = '\x30DF' -- KATAKANA LETTER MI
switch 'M' 'u' = '\x30E0' -- KATAKANA LETTER MU
switch 'M' 'e' = '\x30E1' -- KATAKANA LETTER ME
switch 'M' 'o' = '\x30E2' -- KATAKANA LETTER MO
switch 'Y' 'A' = '\x30E3' -- KATAKANA LETTER SMALL YA
switch 'Y' 'a' = '\x30E4' -- KATAKANA LETTER YA
switch 'Y' 'U' = '\x30E5' -- KATAKANA LETTER SMALL YU
switch 'Y' 'u' = '\x30E6' -- KATAKANA LETTER YU
switch 'Y' 'O' = '\x30E7' -- KATAKANA LETTER SMALL YO
switch 'Y' 'o' = '\x30E8' -- KATAKANA LETTER YO
switch 'R' 'a' = '\x30E9' -- KATAKANA LETTER RA
switch 'R' 'i' = '\x30EA' -- KATAKANA LETTER RI
switch 'R' 'u' = '\x30EB' -- KATAKANA LETTER RU
switch 'R' 'e' = '\x30EC' -- KATAKANA LETTER RE
switch 'R' 'o' = '\x30ED' -- KATAKANA LETTER RO
switch 'W' 'A' = '\x30EE' -- KATAKANA LETTER SMALL WA
switch 'W' 'a' = '\x30EF' -- KATAKANA LETTER WA
switch 'W' 'i' = '\x30F0' -- KATAKANA LETTER WI
switch 'W' 'e' = '\x30F1' -- KATAKANA LETTER WE
switch 'W' 'o' = '\x30F2' -- KATAKANA LETTER WO
switch 'N' '6' = '\x30F3' -- KATAKANA LETTER N `
switch 'V' 'u' = '\x30F4' -- KATAKANA LETTER VU
switch 'K' 'A' = '\x30F5' -- KATAKANA LETTER SMALL KA
switch 'K' 'E' = '\x30F6' -- KATAKANA LETTER SMALL KE
switch 'V' 'a' = '\x30F7' -- KATAKANA LETTER VA
switch 'V' 'i' = '\x30F8' -- KATAKANA LETTER VI
switch 'V' 'e' = '\x30F9' -- KATAKANA LETTER VE
switch 'V' 'o' = '\x30FA' -- KATAKANA LETTER VO
switch '.' '6' = '\x30FB' -- KATAKANA MIDDLE DOT
switch '-' '6' = '\x30FC' -- KATAKANA-HIRAGANA PROLONGED SOUND MARK
switch '*' '6' = '\x30FD' -- KATAKANA ITERATION MARK
switch '+' '6' = '\x30FE' -- KATAKANA VOICED ITERATION MARK
switch 'b' '4' = '\x3105' -- BOPOMOFO LETTER B
switch 'p' '4' = '\x3106' -- BOPOMOFO LETTER P
switch 'm' '4' = '\x3107' -- BOPOMOFO LETTER M
switch 'f' '4' = '\x3108' -- BOPOMOFO LETTER F
switch 'd' '4' = '\x3109' -- BOPOMOFO LETTER D
switch 't' '4' = '\x310A' -- BOPOMOFO LETTER T
switch 'n' '4' = '\x310B' -- BOPOMOFO LETTER N `
switch 'l' '4' = '\x310C' -- BOPOMOFO LETTER L
switch 'g' '4' = '\x310D' -- BOPOMOFO LETTER G
switch 'k' '4' = '\x310E' -- BOPOMOFO LETTER K
switch 'h' '4' = '\x310F' -- BOPOMOFO LETTER H
switch 'j' '4' = '\x3110' -- BOPOMOFO LETTER J
switch 'q' '4' = '\x3111' -- BOPOMOFO LETTER Q
switch 'x' '4' = '\x3112' -- BOPOMOFO LETTER X
switch 'z' 'h' = '\x3113' -- BOPOMOFO LETTER ZH
switch 'c' 'h' = '\x3114' -- BOPOMOFO LETTER CH
switch 's' 'h' = '\x3115' -- BOPOMOFO LETTER SH
switch 'r' '4' = '\x3116' -- BOPOMOFO LETTER R
switch 'z' '4' = '\x3117' -- BOPOMOFO LETTER Z
switch 'c' '4' = '\x3118' -- BOPOMOFO LETTER C
switch 's' '4' = '\x3119' -- BOPOMOFO LETTER S
switch 'a' '4' = '\x311A' -- BOPOMOFO LETTER A
switch 'o' '4' = '\x311B' -- BOPOMOFO LETTER O
switch 'e' '4' = '\x311C' -- BOPOMOFO LETTER E
switch 'a' 'i' = '\x311E' -- BOPOMOFO LETTER AI
switch 'e' 'i' = '\x311F' -- BOPOMOFO LETTER EI
switch 'a' 'u' = '\x3120' -- BOPOMOFO LETTER AU
switch 'o' 'u' = '\x3121' -- BOPOMOFO LETTER OU
switch 'a' 'n' = '\x3122' -- BOPOMOFO LETTER AN
switch 'e' 'n' = '\x3123' -- BOPOMOFO LETTER EN
switch 'a' 'N' = '\x3124' -- BOPOMOFO LETTER ANG
switch 'e' 'N' = '\x3125' -- BOPOMOFO LETTER ENG
switch 'e' 'r' = '\x3126' -- BOPOMOFO LETTER ER
switch 'i' '4' = '\x3127' -- BOPOMOFO LETTER I
switch 'u' '4' = '\x3128' -- BOPOMOFO LETTER U
switch 'i' 'u' = '\x3129' -- BOPOMOFO LETTER IU
switch 'v' '4' = '\x312A' -- BOPOMOFO LETTER V
switch 'n' 'G' = '\x312B' -- BOPOMOFO LETTER NG
switch 'g' 'n' = '\x312C' -- BOPOMOFO LETTER GN
switch '1' 'c' = '\x3220' -- PARENTHESIZED IDEOGRAPH ONE
switch '2' 'c' = '\x3221' -- PARENTHESIZED IDEOGRAPH TWO
switch '3' 'c' = '\x3222' -- PARENTHESIZED IDEOGRAPH THREE
switch '4' 'c' = '\x3223' -- PARENTHESIZED IDEOGRAPH FOUR
switch '5' 'c' = '\x3224' -- PARENTHESIZED IDEOGRAPH FIVE
switch '6' 'c' = '\x3225' -- PARENTHESIZED IDEOGRAPH SIX
switch '7' 'c' = '\x3226' -- PARENTHESIZED IDEOGRAPH SEVEN
switch '8' 'c' = '\x3227' -- PARENTHESIZED IDEOGRAPH EIGHT
switch '9' 'c' = '\x3228' -- PARENTHESIZED IDEOGRAPH NINE
switch 'f' 'f' = '\xFB00' -- LATIN SMALL LIGATURE FF
switch 'f' 'i' = '\xFB01' -- LATIN SMALL LIGATURE FI
switch 'f' 'l' = '\xFB02' -- LATIN SMALL LIGATURE FL
switch 'f' 't' = '\xFB05' -- LATIN SMALL LIGATURE LONG S T
switch 's' 't' = '\xFB06' -- LATIN SMALL LIGATURE ST
switch _   _   = '\xFFFF' -- Fallback
