/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioVideoCommandNumber;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.CommandStatus;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.VideoDeviceCapabilities;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.VideoDeviceState;
import com.dsi.ant.plugins.antplus.pcc.controls.pccbase.AntPlusBaseControllableDevicePcc;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusVideoControllableDevicePcc
extends AntPlusBaseControllableDevicePcc {
    private static final String TAG = AntPlusVideoControllableDevicePcc.class.getSimpleName();
    IVideoCommandReceiver mVideoCommandReceiver;

    public static PccReleaseHandle<AntPlusVideoControllableDevicePcc> requestAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusVideoControllableDevicePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, final IVideoCommandReceiver videoCommandReceiver, final VideoDeviceCapabilities capabilities, int channelDeviceId) {
        if (AntPlusVideoControllableDevicePcc.getInstalledPluginsVersionNumber(bindToContext) == 10000) {
            AntPlusBaseControllableDevicePcc.IpcDefines.PATH_ANTPLUS_CONTROLLABLEDEVICEPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.controls.ControlsService";
        }
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", ControlsMode.VIDEO_MODE.getRequestAccessModeValue());
        b.putInt("int_ChannelDeviceId", channelDeviceId);
        final AntPlusVideoControllableDevicePcc potentialRetObj = new AntPlusVideoControllableDevicePcc();
        return AntPlusVideoControllableDevicePcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new AntPluginPcc.RequestAccessResultHandler<AntPlusVideoControllableDevicePcc>(){

            @Override
            public boolean handleRequestAccessResult(Message msg) {
                boolean result = super.handleRequestAccessResult(msg);
                int resultCode = msg.what;
                if (resultCode == 0) {
                    potentialRetObj.subscribeVideoCommandEvent(videoCommandReceiver);
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            potentialRetObj.setVideoCapabilities(capabilities);
                        }
                    });
                    t.start();
                }
                return result;
            }
        }, resultReceiver, stateReceiver);
    }

    private AntPlusVideoControllableDevicePcc() {
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Video Controllable Device";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 203: {
                if (this.mVideoCommandReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int serialNumber = b.getInt("int_serialNumber");
                int commandData = b.getInt("int_commandData");
                final int sequenceNumber = b.getInt("int_sequenceNumber");
                final AudioVideoCommandNumber commandNumber = AudioVideoCommandNumber.getValueFromInt(b.getInt("int_commandNumber"));
                final CommandStatus status = this.mVideoCommandReceiver.onNewVideoCommand(estTimestamp, eventFlags, serialNumber, sequenceNumber, commandNumber, commandData);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        AntPlusVideoControllableDevicePcc.this.updateVideoCommandStatus(sequenceNumber, status, commandNumber);
                    }
                });
                t.start();
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void updateVideoStatus(int volume, boolean muted, int timeRemaining, int timeProgressed, VideoDeviceState videoState) {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20007;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_volume", volume);
        params.putBoolean("bool_muted", muted);
        params.putInt("int_timeRemaining", timeRemaining);
        params.putInt("int_timeProgressed", timeProgressed);
        params.putInt("int_videoState", videoState.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd updateVideoStatus died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd updateVideoStatus failed with code " + ret.arg1);
            throw new RuntimeException("updateVideoStatus cmd failed internally");
        }
        ret.recycle();
    }

    private void subscribeVideoCommandEvent(IVideoCommandReceiver VideoCommandReceiver) {
        this.mVideoCommandReceiver = VideoCommandReceiver;
        if (VideoCommandReceiver != null) {
            this.subscribeToEvent(203);
        } else {
            this.unsubscribeFromEvent(203);
        }
    }

    private void setVideoCapabilities(VideoDeviceCapabilities capab) {
        if (capab == null) {
            return;
        }
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20006;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        capab.writeToBundle(params);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd setVideoCapabilities died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd setVideoCapabilities failed with code " + ret.arg1);
            throw new RuntimeException("setVideoCapabilities cmd failed internally");
        }
        ret.recycle();
    }

    private void updateVideoCommandStatus(int sequenceNumber, CommandStatus commandStatus, AudioVideoCommandNumber commandNumber) {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20003;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_sequenceNumber", sequenceNumber);
        params.putInt("int_commandStatus", commandStatus.getIntValue());
        params.putInt("int_commandNumber", commandNumber.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd updateVideoCommandStatus died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd updateVideoCommandStatus failed with code " + ret.arg1);
            throw new RuntimeException("updateVideoCommandStatus cmd failed internally");
        }
        ret.recycle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IVideoCommandReceiver {
        public CommandStatus onNewVideoCommand(long var1, EnumSet<EventFlag> var3, int var4, int var5, AudioVideoCommandNumber var6, int var7);
    }

    public static class IpcDefines {
        public static final int MSG_EVENT_CONTROLS_whatVIDEOCOMMAND = 203;
        public static final String MSG_EVENT_CONTROLS_VIDEOCOMMAND_PARAM_intSERIALNUMBER = "int_serialNumber";
        public static final String MSG_EVENT_CONTROLS_VIDEOCOMMAND_PARAM_intSEQUENCENUMBER = "int_sequenceNumber";
        public static final int MSG_CMD_CONTROLS_whatUPDATEVIDEOCOMMANDSTATUS = 20003;
        public static final String MSG_CMD_CONTROLS_UPDATEVIDEOCOMMANDSTATUS_PARAM_intSEQUENCENUMBER = "int_sequenceNumber";
        public static final String MSG_CMD_CONTROLS_UPDATEVIDEOCOMMANDSTATUS_PARAM_intCOMMANDSTATUS = "int_commandStatus";
        public static final String MSG_CMD_CONTROLS_UPDATEVIDEOCOMMANDSTATUS_PARAM_intCOMMANDNUMBER = "int_commandNumber";
        public static final int MSG_CMD_CONTROLS_whatSETVIDEOCAPABILITIES = 20006;
        public static final String MSG_CMD_CONTROLS_SETVIDEOCAPABILITIES_PARAM_boolVIDEOPLAYBACKSUPPORT = "bool_videoPlaybackSupport";
        public static final String MSG_CMD_CONTROLS_SETVIDEOCAPABILITIES_PARAM_boolVIDEORECORDERSUPPORT = "bool_videoRecorderSupport";
        public static final int MSG_CMD_CONTROLS_whatUPDATEVIDEOSTATUS = 20007;
    }
}

