// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package storagegateway provides a client for AWS Storage Gateway.
package storagegateway

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opActivateGateway = "ActivateGateway"

// ActivateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the ActivateGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ActivateGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ActivateGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ActivateGatewayRequest method.
//    req, resp := client.ActivateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ActivateGatewayRequest(input *ActivateGatewayInput) (req *request.Request, output *ActivateGatewayOutput) {
	op := &request.Operation{
		Name:       opActivateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ActivateGatewayOutput{}
	req.Data = output
	return
}

// ActivateGateway API operation for AWS Storage Gateway.
//
// Activates the gateway you previously deployed on your host. For more information,
// see  Activate the AWS Storage Gateway (http://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedActivateGateway-common.html).
// In the activation process, you specify information such as the you want to
// use for storing snapshots, the time zone for scheduled snapshots the gateway
// snapshot schedule window, an activation key, and a name for your gateway.
// The activation process also associates your gateway with your account; for
// more information, see UpdateGatewayInformation.
//
// You must turn on the gateway VM before you can activate your gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ActivateGateway for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ActivateGateway(input *ActivateGatewayInput) (*ActivateGatewayOutput, error) {
	req, out := c.ActivateGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opAddCache = "AddCache"

// AddCacheRequest generates a "aws/request.Request" representing the
// client's request for the AddCache operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddCache for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddCache method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddCacheRequest method.
//    req, resp := client.AddCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) AddCacheRequest(input *AddCacheInput) (req *request.Request, output *AddCacheOutput) {
	op := &request.Operation{
		Name:       opAddCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddCacheOutput{}
	req.Data = output
	return
}

// AddCache API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as cache for a cached-volume gateway.
// This operation is supported only for the gateway-cached volume architecture
// (see Storage Gateway Concepts (http://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html)).
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add cache, and one or more disk IDs that you want to configure
// as cache.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddCache for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) AddCache(input *AddCacheInput) (*AddCacheOutput, error) {
	req, out := c.AddCacheRequest(input)
	err := req.Send()
	return out, err
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToResourceOutput{}
	req.Data = output
	return
}

// AddTagsToResource API operation for AWS Storage Gateway.
//
// Adds one or more tags to the specified resource. You use tags to add metadata
// to resources, which you can use to categorize these resources. For example,
// you can categorize resources by purpose, owner, environment, or team. Each
// tag consists of a key and a value, which you define. You can add tags to
// the following AWS Storage Gateway resources:
//
//    * Storage gateways of all types
//
//    * Storage Volumes
//
//    * Virtual Tapes
//
// You can create a maximum of 10 tags for each resource. Virtual tapes and
// storage volumes that are recovered to a new gateway maintain their tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opAddUploadBuffer = "AddUploadBuffer"

// AddUploadBufferRequest generates a "aws/request.Request" representing the
// client's request for the AddUploadBuffer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddUploadBuffer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddUploadBuffer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddUploadBufferRequest method.
//    req, resp := client.AddUploadBufferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) AddUploadBufferRequest(input *AddUploadBufferInput) (req *request.Request, output *AddUploadBufferOutput) {
	op := &request.Operation{
		Name:       opAddUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUploadBufferInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddUploadBufferOutput{}
	req.Data = output
	return
}

// AddUploadBuffer API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as upload buffer for a specified
// gateway. This operation is supported for both the gateway-stored and gateway-cached
// volume architectures.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add upload buffer, and one or more disk IDs that you want to
// configure as upload buffer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddUploadBuffer for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) AddUploadBuffer(input *AddUploadBufferInput) (*AddUploadBufferOutput, error) {
	req, out := c.AddUploadBufferRequest(input)
	err := req.Send()
	return out, err
}

const opAddWorkingStorage = "AddWorkingStorage"

// AddWorkingStorageRequest generates a "aws/request.Request" representing the
// client's request for the AddWorkingStorage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddWorkingStorage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddWorkingStorage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddWorkingStorageRequest method.
//    req, resp := client.AddWorkingStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) AddWorkingStorageRequest(input *AddWorkingStorageInput) (req *request.Request, output *AddWorkingStorageOutput) {
	op := &request.Operation{
		Name:       opAddWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddWorkingStorageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddWorkingStorageOutput{}
	req.Data = output
	return
}

// AddWorkingStorage API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as working storage for a gateway.
// This operation is supported only for the gateway-stored volume architecture.
// This operation is deprecated in cached-volumes API version 20120630. Use
// AddUploadBuffer instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// AddUploadBuffer operation to add upload buffer to a stored-volume gateway.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add working storage, and one or more disk IDs that you want to
// configure as working storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddWorkingStorage for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) AddWorkingStorage(input *AddWorkingStorageInput) (*AddWorkingStorageOutput, error) {
	req, out := c.AddWorkingStorageRequest(input)
	err := req.Send()
	return out, err
}

const opCancelArchival = "CancelArchival"

// CancelArchivalRequest generates a "aws/request.Request" representing the
// client's request for the CancelArchival operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelArchival for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelArchival method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelArchivalRequest method.
//    req, resp := client.CancelArchivalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CancelArchivalRequest(input *CancelArchivalInput) (req *request.Request, output *CancelArchivalOutput) {
	op := &request.Operation{
		Name:       opCancelArchival,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelArchivalInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelArchivalOutput{}
	req.Data = output
	return
}

// CancelArchival API operation for AWS Storage Gateway.
//
// Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after
// the archiving process is initiated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CancelArchival for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CancelArchival(input *CancelArchivalInput) (*CancelArchivalOutput, error) {
	req, out := c.CancelArchivalRequest(input)
	err := req.Send()
	return out, err
}

const opCancelRetrieval = "CancelRetrieval"

// CancelRetrievalRequest generates a "aws/request.Request" representing the
// client's request for the CancelRetrieval operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelRetrieval for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelRetrieval method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelRetrievalRequest method.
//    req, resp := client.CancelRetrievalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CancelRetrievalRequest(input *CancelRetrievalInput) (req *request.Request, output *CancelRetrievalOutput) {
	op := &request.Operation{
		Name:       opCancelRetrieval,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelRetrievalInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelRetrievalOutput{}
	req.Data = output
	return
}

// CancelRetrieval API operation for AWS Storage Gateway.
//
// Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
// a gateway after the retrieval process is initiated. The virtual tape is returned
// to the VTS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CancelRetrieval for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CancelRetrieval(input *CancelRetrievalInput) (*CancelRetrievalOutput, error) {
	req, out := c.CancelRetrievalRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCachediSCSIVolume = "CreateCachediSCSIVolume"

// CreateCachediSCSIVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateCachediSCSIVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCachediSCSIVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCachediSCSIVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateCachediSCSIVolumeRequest method.
//    req, resp := client.CreateCachediSCSIVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CreateCachediSCSIVolumeRequest(input *CreateCachediSCSIVolumeInput) (req *request.Request, output *CreateCachediSCSIVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateCachediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCachediSCSIVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCachediSCSIVolumeOutput{}
	req.Data = output
	return
}

// CreateCachediSCSIVolume API operation for AWS Storage Gateway.
//
// Creates a cached volume on a specified cached gateway. This operation is
// supported only for the gateway-cached volume architecture.
//
// Cache storage must be allocated to the gateway before you can create a cached
// volume. Use the AddCache operation to add cache storage to a gateway.
//
// In the request, you must specify the gateway, size of the volume in bytes,
// the iSCSI target name, an IP address on which to expose the target, and a
// unique client token. In response, AWS Storage Gateway creates the volume
// and returns information about it such as the volume Amazon Resource Name
// (ARN), its size, and the iSCSI target ARN that initiators can use to connect
// to the volume target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateCachediSCSIVolume for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CreateCachediSCSIVolume(input *CreateCachediSCSIVolumeInput) (*CreateCachediSCSIVolumeOutput, error) {
	req, out := c.CreateCachediSCSIVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotOutput{}
	req.Data = output
	return
}

// CreateSnapshot API operation for AWS Storage Gateway.
//
// Initiates a snapshot of a volume.
//
// AWS Storage Gateway provides the ability to back up point-in-time snapshots
// of your data to Amazon Simple Storage (S3) for durable off-site recovery,
// as well as import the data to an Amazon Elastic Block Store (EBS) volume
// in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway
// volume on a scheduled or ad-hoc basis. This API enables you to take ad-hoc
// snapshot. For more information, see Working With Snapshots in the AWS Storage
// Gateway Console (http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
//
// In the CreateSnapshot request you identify the volume by providing its Amazon
// Resource Name (ARN). You must also provide description for the snapshot.
// When AWS Storage Gateway takes the snapshot of specified volume, the snapshot
// and description appears in the AWS Storage Gateway Console. In response,
// AWS Storage Gateway returns you a snapshot ID. You can use this snapshot
// ID to check the snapshot progress or later use it when you want to create
// a volume from a snapshot.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// see DescribeSnapshots or DeleteSnapshot in the EC2 API reference (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Operations.html).
//
// Volume and snapshot IDs are changing to a longer length ID format. For more
// information, see the important note on the Welcome (http://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html)
// page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshotFromVolumeRecoveryPoint = "CreateSnapshotFromVolumeRecoveryPoint"

// CreateSnapshotFromVolumeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotFromVolumeRecoveryPoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshotFromVolumeRecoveryPoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshotFromVolumeRecoveryPoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotFromVolumeRecoveryPointRequest method.
//    req, resp := client.CreateSnapshotFromVolumeRecoveryPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPointRequest(input *CreateSnapshotFromVolumeRecoveryPointInput) (req *request.Request, output *CreateSnapshotFromVolumeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotFromVolumeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotFromVolumeRecoveryPointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotFromVolumeRecoveryPointOutput{}
	req.Data = output
	return
}

// CreateSnapshotFromVolumeRecoveryPoint API operation for AWS Storage Gateway.
//
// Initiates a snapshot of a gateway from a volume recovery point. This operation
// is supported only for the gateway-cached volume architecture.
//
// A volume recovery point is a point in time at which all data of the volume
// is consistent and from which you can create a snapshot. To get a list of
// volume recovery point for gateway-cached volumes, use ListVolumeRecoveryPoints.
//
// In the CreateSnapshotFromVolumeRecoveryPoint request, you identify the volume
// by providing its Amazon Resource Name (ARN). You must also provide a description
// for the snapshot. When AWS Storage Gateway takes a snapshot of the specified
// volume, the snapshot and its description appear in the AWS Storage Gateway
// console. In response, AWS Storage Gateway returns you a snapshot ID. You
// can use this snapshot ID to check the snapshot progress or later use it when
// you want to create a volume from a snapshot.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// in Amazon Elastic Compute Cloud API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSnapshotFromVolumeRecoveryPoint for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPoint(input *CreateSnapshotFromVolumeRecoveryPointInput) (*CreateSnapshotFromVolumeRecoveryPointOutput, error) {
	req, out := c.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStorediSCSIVolume = "CreateStorediSCSIVolume"

// CreateStorediSCSIVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorediSCSIVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateStorediSCSIVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateStorediSCSIVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateStorediSCSIVolumeRequest method.
//    req, resp := client.CreateStorediSCSIVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CreateStorediSCSIVolumeRequest(input *CreateStorediSCSIVolumeInput) (req *request.Request, output *CreateStorediSCSIVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateStorediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStorediSCSIVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStorediSCSIVolumeOutput{}
	req.Data = output
	return
}

// CreateStorediSCSIVolume API operation for AWS Storage Gateway.
//
// Creates a volume on a specified gateway. This operation is supported only
// for the gateway-stored volume architecture.
//
// The size of the volume to create is inferred from the disk size. You can
// choose to preserve existing data on the disk, create volume from an existing
// snapshot, or create an empty volume. If you choose to create an empty gateway
// volume, then any existing data on the disk is erased.
//
// In the request you must specify the gateway and the disk information on which
// you are creating the volume. In response, AWS Storage Gateway creates the
// volume and returns volume information such as the volume Amazon Resource
// Name (ARN), its size, and the iSCSI target ARN that initiators can use to
// connect to the volume target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateStorediSCSIVolume for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CreateStorediSCSIVolume(input *CreateStorediSCSIVolumeInput) (*CreateStorediSCSIVolumeOutput, error) {
	req, out := c.CreateStorediSCSIVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTapeWithBarcode = "CreateTapeWithBarcode"

// CreateTapeWithBarcodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapeWithBarcode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTapeWithBarcode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTapeWithBarcode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTapeWithBarcodeRequest method.
//    req, resp := client.CreateTapeWithBarcodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CreateTapeWithBarcodeRequest(input *CreateTapeWithBarcodeInput) (req *request.Request, output *CreateTapeWithBarcodeOutput) {
	op := &request.Operation{
		Name:       opCreateTapeWithBarcode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapeWithBarcodeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTapeWithBarcodeOutput{}
	req.Data = output
	return
}

// CreateTapeWithBarcode API operation for AWS Storage Gateway.
//
// Creates a virtual tape by using your own barcode. You write data to the virtual
// tape and then archive the tape.
//
// Cache storage must be allocated to the gateway before you can create a virtual
// tape. Use the AddCache operation to add cache storage to a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapeWithBarcode for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CreateTapeWithBarcode(input *CreateTapeWithBarcodeInput) (*CreateTapeWithBarcodeOutput, error) {
	req, out := c.CreateTapeWithBarcodeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTapes = "CreateTapes"

// CreateTapesRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTapes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTapes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTapesRequest method.
//    req, resp := client.CreateTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) CreateTapesRequest(input *CreateTapesInput) (req *request.Request, output *CreateTapesOutput) {
	op := &request.Operation{
		Name:       opCreateTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTapesOutput{}
	req.Data = output
	return
}

// CreateTapes API operation for AWS Storage Gateway.
//
// Creates one or more virtual tapes. You write data to the virtual tapes and
// then archive the tapes.
//
// Cache storage must be allocated to the gateway before you can create virtual
// tapes. Use the AddCache operation to add cache storage to a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapes for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) CreateTapes(input *CreateTapesInput) (*CreateTapesOutput, error) {
	req, out := c.CreateTapesRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBandwidthRateLimit = "DeleteBandwidthRateLimit"

// DeleteBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBandwidthRateLimit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBandwidthRateLimit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBandwidthRateLimit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBandwidthRateLimitRequest method.
//    req, resp := client.DeleteBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteBandwidthRateLimitRequest(input *DeleteBandwidthRateLimitInput) (req *request.Request, output *DeleteBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opDeleteBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBandwidthRateLimitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBandwidthRateLimitOutput{}
	req.Data = output
	return
}

// DeleteBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Deletes the bandwidth rate limits of a gateway. You can delete either the
// upload and download bandwidth rate limit, or you can delete both. If you
// delete only one of the limits, the other limit remains unchanged. To specify
// which gateway to work with, use the Amazon Resource Name (ARN) of the gateway
// in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteBandwidthRateLimit for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteBandwidthRateLimit(input *DeleteBandwidthRateLimitInput) (*DeleteBandwidthRateLimitOutput, error) {
	req, out := c.DeleteBandwidthRateLimitRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteChapCredentials = "DeleteChapCredentials"

// DeleteChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChapCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteChapCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteChapCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteChapCredentialsRequest method.
//    req, resp := client.DeleteChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteChapCredentialsRequest(input *DeleteChapCredentialsInput) (req *request.Request, output *DeleteChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opDeleteChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChapCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteChapCredentialsOutput{}
	req.Data = output
	return
}

// DeleteChapCredentials API operation for AWS Storage Gateway.
//
// Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for
// a specified iSCSI target and initiator pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteChapCredentials for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteChapCredentials(input *DeleteChapCredentialsInput) (*DeleteChapCredentialsOutput, error) {
	req, out := c.DeleteChapCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteGatewayRequest method.
//    req, resp := client.DeleteGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteGatewayRequest(input *DeleteGatewayInput) (req *request.Request, output *DeleteGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteGatewayOutput{}
	req.Data = output
	return
}

// DeleteGateway API operation for AWS Storage Gateway.
//
// Deletes a gateway. To specify which gateway to delete, use the Amazon Resource
// Name (ARN) of the gateway in your request. The operation deletes the gateway;
// however, it does not delete the gateway virtual machine (VM) from your host
// computer.
//
// After you delete a gateway, you cannot reactivate it. Completed snapshots
// of the gateway volumes are not deleted upon deleting the gateway, however,
// pending snapshots will not complete. After you delete a gateway, your next
// step is to remove it from your environment.
//
// You no longer pay software charges after the gateway is deleted; however,
// your existing Amazon EBS snapshots persist and you will continue to be billed
// for these snapshots. You can choose to remove all remaining Amazon EBS snapshots
// by canceling your Amazon EC2 subscription.  If you prefer not to cancel your
// Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2
// console. For more information, see the  AWS Storage Gateway Detail Page (http://aws.amazon.com/storagegateway).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteGateway for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshotSchedule = "DeleteSnapshotSchedule"

// DeleteSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotSchedule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSnapshotSchedule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSnapshotSchedule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSnapshotScheduleRequest method.
//    req, resp := client.DeleteSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteSnapshotScheduleRequest(input *DeleteSnapshotScheduleInput) (req *request.Request, output *DeleteSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotScheduleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSnapshotScheduleOutput{}
	req.Data = output
	return
}

// DeleteSnapshotSchedule API operation for AWS Storage Gateway.
//
// Deletes a snapshot of a volume.
//
// You can take snapshots of your gateway volumes on a scheduled or ad hoc basis.
// This API action enables you to delete a snapshot schedule for a volume. For
// more information, see Working with Snapshots (http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
// In the DeleteSnapshotSchedule request, you identify the volume by providing
// its Amazon Resource Name (ARN).
//
// To list or delete a snapshot, you must use the Amazon EC2 API. in Amazon
// Elastic Compute Cloud API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteSnapshotSchedule(input *DeleteSnapshotScheduleInput) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTape = "DeleteTape"

// DeleteTapeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTape operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTape for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTape method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTapeRequest method.
//    req, resp := client.DeleteTapeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteTapeRequest(input *DeleteTapeInput) (req *request.Request, output *DeleteTapeOutput) {
	op := &request.Operation{
		Name:       opDeleteTape,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTapeOutput{}
	req.Data = output
	return
}

// DeleteTape API operation for AWS Storage Gateway.
//
// Deletes the specified virtual tape.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTape for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteTape(input *DeleteTapeInput) (*DeleteTapeOutput, error) {
	req, out := c.DeleteTapeRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTapeArchive = "DeleteTapeArchive"

// DeleteTapeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTapeArchive operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTapeArchive for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTapeArchive method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTapeArchiveRequest method.
//    req, resp := client.DeleteTapeArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteTapeArchiveRequest(input *DeleteTapeArchiveInput) (req *request.Request, output *DeleteTapeArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeArchiveInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTapeArchiveOutput{}
	req.Data = output
	return
}

// DeleteTapeArchive API operation for AWS Storage Gateway.
//
// Deletes the specified virtual tape from the virtual tape shelf (VTS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTapeArchive for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteTapeArchive(input *DeleteTapeArchiveInput) (*DeleteTapeArchiveOutput, error) {
	req, out := c.DeleteTapeArchiveRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVolumeRequest method.
//    req, resp := client.DeleteVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVolumeOutput{}
	req.Data = output
	return
}

// DeleteVolume API operation for AWS Storage Gateway.
//
// Deletes the specified gateway volume that you previously created using the
// CreateCachediSCSIVolume or CreateStorediSCSIVolume API. For gateway-stored
// volumes, the local disk that was configured as the storage volume is not
// deleted. You can reuse the local disk to create another storage volume.
//
// Before you delete a gateway volume, make sure there are no iSCSI connections
// to the volume you are deleting. You should also make sure there is no snapshot
// in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API
// to query snapshots on the volume you are deleting and check the snapshot
// status. For more information, go to DescribeSnapshots (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// In the request, you must provide the Amazon Resource Name (ARN) of the storage
// volume you want to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteVolume for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeBandwidthRateLimit = "DescribeBandwidthRateLimit"

// DescribeBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBandwidthRateLimit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeBandwidthRateLimit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeBandwidthRateLimit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeBandwidthRateLimitRequest method.
//    req, resp := client.DescribeBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeBandwidthRateLimitRequest(input *DescribeBandwidthRateLimitInput) (req *request.Request, output *DescribeBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opDescribeBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBandwidthRateLimitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeBandwidthRateLimitOutput{}
	req.Data = output
	return
}

// DescribeBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Returns the bandwidth rate limits of a gateway. By default, these limits
// are not set, which means no bandwidth rate limiting is in effect.
//
// This operation only returns a value for a bandwidth rate limit only if the
// limit is set. If no limits are set for the gateway, then this operation returns
// only the gateway ARN in the response body. To specify which gateway to describe,
// use the Amazon Resource Name (ARN) of the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeBandwidthRateLimit for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeBandwidthRateLimit(input *DescribeBandwidthRateLimitInput) (*DescribeBandwidthRateLimitOutput, error) {
	req, out := c.DescribeBandwidthRateLimitRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCache = "DescribeCache"

// DescribeCacheRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCache operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCache for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCache method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCacheRequest method.
//    req, resp := client.DescribeCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeCacheRequest(input *DescribeCacheInput) (req *request.Request, output *DescribeCacheOutput) {
	op := &request.Operation{
		Name:       opDescribeCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheOutput{}
	req.Data = output
	return
}

// DescribeCache API operation for AWS Storage Gateway.
//
// Returns information about the cache of a gateway. This operation is supported
// only for the gateway-cached volume architecture.
//
// The response includes disk IDs that are configured as cache, and it includes
// the amount of cache allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeCache for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeCache(input *DescribeCacheInput) (*DescribeCacheOutput, error) {
	req, out := c.DescribeCacheRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCachediSCSIVolumes = "DescribeCachediSCSIVolumes"

// DescribeCachediSCSIVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCachediSCSIVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCachediSCSIVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCachediSCSIVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCachediSCSIVolumesRequest method.
//    req, resp := client.DescribeCachediSCSIVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeCachediSCSIVolumesRequest(input *DescribeCachediSCSIVolumesInput) (req *request.Request, output *DescribeCachediSCSIVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeCachediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCachediSCSIVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCachediSCSIVolumesOutput{}
	req.Data = output
	return
}

// DescribeCachediSCSIVolumes API operation for AWS Storage Gateway.
//
// Returns a description of the gateway volumes specified in the request. This
// operation is supported only for the gateway-cached volume architecture.
//
// The list of gateway volumes in the request must be from one gateway. In the
// response Amazon Storage Gateway returns volume information sorted by volume
// Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeCachediSCSIVolumes for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeCachediSCSIVolumes(input *DescribeCachediSCSIVolumesInput) (*DescribeCachediSCSIVolumesOutput, error) {
	req, out := c.DescribeCachediSCSIVolumesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeChapCredentials = "DescribeChapCredentials"

// DescribeChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChapCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeChapCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeChapCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeChapCredentialsRequest method.
//    req, resp := client.DescribeChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeChapCredentialsRequest(input *DescribeChapCredentialsInput) (req *request.Request, output *DescribeChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opDescribeChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChapCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeChapCredentialsOutput{}
	req.Data = output
	return
}

// DescribeChapCredentials API operation for AWS Storage Gateway.
//
// Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
// information for a specified iSCSI target, one for each target-initiator pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeChapCredentials for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeChapCredentials(input *DescribeChapCredentialsInput) (*DescribeChapCredentialsOutput, error) {
	req, out := c.DescribeChapCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeGatewayInformation = "DescribeGatewayInformation"

// DescribeGatewayInformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayInformation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeGatewayInformation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeGatewayInformation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeGatewayInformationRequest method.
//    req, resp := client.DescribeGatewayInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeGatewayInformationRequest(input *DescribeGatewayInformationInput) (req *request.Request, output *DescribeGatewayInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGatewayInformationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeGatewayInformationOutput{}
	req.Data = output
	return
}

// DescribeGatewayInformation API operation for AWS Storage Gateway.
//
// Returns metadata about a gateway such as its name, network interfaces, configured
// time zone, and the state (whether the gateway is running or not). To specify
// which gateway to describe, use the Amazon Resource Name (ARN) of the gateway
// in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeGatewayInformation for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeGatewayInformation(input *DescribeGatewayInformationInput) (*DescribeGatewayInformationOutput, error) {
	req, out := c.DescribeGatewayInformationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMaintenanceStartTime = "DescribeMaintenanceStartTime"

// DescribeMaintenanceStartTimeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceStartTime operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeMaintenanceStartTime for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeMaintenanceStartTime method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeMaintenanceStartTimeRequest method.
//    req, resp := client.DescribeMaintenanceStartTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeMaintenanceStartTimeRequest(input *DescribeMaintenanceStartTimeInput) (req *request.Request, output *DescribeMaintenanceStartTimeOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceStartTimeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMaintenanceStartTimeOutput{}
	req.Data = output
	return
}

// DescribeMaintenanceStartTime API operation for AWS Storage Gateway.
//
// Returns your gateway's weekly maintenance start time including the day and
// time of the week. Note that values are in terms of the gateway's time zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeMaintenanceStartTime for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeMaintenanceStartTime(input *DescribeMaintenanceStartTimeInput) (*DescribeMaintenanceStartTimeOutput, error) {
	req, out := c.DescribeMaintenanceStartTimeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshotSchedule = "DescribeSnapshotSchedule"

// DescribeSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotSchedule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSnapshotSchedule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSnapshotSchedule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSnapshotScheduleRequest method.
//    req, resp := client.DescribeSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeSnapshotScheduleRequest(input *DescribeSnapshotScheduleInput) (req *request.Request, output *DescribeSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotScheduleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotScheduleOutput{}
	req.Data = output
	return
}

// DescribeSnapshotSchedule API operation for AWS Storage Gateway.
//
// Describes the snapshot schedule for the specified gateway volume. The snapshot
// schedule information includes intervals at which snapshots are automatically
// initiated on the volume.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeSnapshotSchedule(input *DescribeSnapshotScheduleInput) (*DescribeSnapshotScheduleOutput, error) {
	req, out := c.DescribeSnapshotScheduleRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStorediSCSIVolumes = "DescribeStorediSCSIVolumes"

// DescribeStorediSCSIVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorediSCSIVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStorediSCSIVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStorediSCSIVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStorediSCSIVolumesRequest method.
//    req, resp := client.DescribeStorediSCSIVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeStorediSCSIVolumesRequest(input *DescribeStorediSCSIVolumesInput) (req *request.Request, output *DescribeStorediSCSIVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeStorediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStorediSCSIVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStorediSCSIVolumesOutput{}
	req.Data = output
	return
}

// DescribeStorediSCSIVolumes API operation for AWS Storage Gateway.
//
// Returns the description of the gateway volumes specified in the request.
// The list of gateway volumes in the request must be from one gateway. In the
// response Amazon Storage Gateway returns volume information sorted by volume
// ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeStorediSCSIVolumes for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeStorediSCSIVolumes(input *DescribeStorediSCSIVolumesInput) (*DescribeStorediSCSIVolumesOutput, error) {
	req, out := c.DescribeStorediSCSIVolumesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTapeArchives = "DescribeTapeArchives"

// DescribeTapeArchivesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapeArchives operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTapeArchives for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTapeArchives method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTapeArchivesRequest method.
//    req, resp := client.DescribeTapeArchivesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeTapeArchivesRequest(input *DescribeTapeArchivesInput) (req *request.Request, output *DescribeTapeArchivesOutput) {
	op := &request.Operation{
		Name:       opDescribeTapeArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeArchivesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTapeArchivesOutput{}
	req.Data = output
	return
}

// DescribeTapeArchives API operation for AWS Storage Gateway.
//
// Returns a description of specified virtual tapes in the virtual tape shelf
// (VTS).
//
// If a specific TapeARN is not specified, AWS Storage Gateway returns a description
// of all virtual tapes found in the VTS associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapeArchives for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeTapeArchives(input *DescribeTapeArchivesInput) (*DescribeTapeArchivesOutput, error) {
	req, out := c.DescribeTapeArchivesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeTapeArchivesPages iterates over the pages of a DescribeTapeArchives operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapeArchives method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapeArchives operation.
//    pageNum := 0
//    err := client.DescribeTapeArchivesPages(params,
//        func(page *DescribeTapeArchivesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapeArchivesPages(input *DescribeTapeArchivesInput, fn func(p *DescribeTapeArchivesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTapeArchivesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTapeArchivesOutput), lastPage)
	})
}

const opDescribeTapeRecoveryPoints = "DescribeTapeRecoveryPoints"

// DescribeTapeRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapeRecoveryPoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTapeRecoveryPoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTapeRecoveryPoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTapeRecoveryPointsRequest method.
//    req, resp := client.DescribeTapeRecoveryPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeTapeRecoveryPointsRequest(input *DescribeTapeRecoveryPointsInput) (req *request.Request, output *DescribeTapeRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opDescribeTapeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeRecoveryPointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTapeRecoveryPointsOutput{}
	req.Data = output
	return
}

// DescribeTapeRecoveryPoints API operation for AWS Storage Gateway.
//
// Returns a list of virtual tape recovery points that are available for the
// specified gateway-VTL.
//
// A recovery point is a point-in-time view of a virtual tape at which all the
// data on the virtual tape is consistent. If your gateway crashes, virtual
// tapes that have recovery points can be recovered to a new gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapeRecoveryPoints for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeTapeRecoveryPoints(input *DescribeTapeRecoveryPointsInput) (*DescribeTapeRecoveryPointsOutput, error) {
	req, out := c.DescribeTapeRecoveryPointsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeTapeRecoveryPointsPages iterates over the pages of a DescribeTapeRecoveryPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapeRecoveryPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapeRecoveryPoints operation.
//    pageNum := 0
//    err := client.DescribeTapeRecoveryPointsPages(params,
//        func(page *DescribeTapeRecoveryPointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapeRecoveryPointsPages(input *DescribeTapeRecoveryPointsInput, fn func(p *DescribeTapeRecoveryPointsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTapeRecoveryPointsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTapeRecoveryPointsOutput), lastPage)
	})
}

const opDescribeTapes = "DescribeTapes"

// DescribeTapesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTapes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTapes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTapesRequest method.
//    req, resp := client.DescribeTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeTapesRequest(input *DescribeTapesInput) (req *request.Request, output *DescribeTapesOutput) {
	op := &request.Operation{
		Name:       opDescribeTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTapesOutput{}
	req.Data = output
	return
}

// DescribeTapes API operation for AWS Storage Gateway.
//
// Returns a description of the specified Amazon Resource Name (ARN) of virtual
// tapes. If a TapeARN is not specified, returns a description of all virtual
// tapes associated with the specified gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapes for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeTapes(input *DescribeTapesInput) (*DescribeTapesOutput, error) {
	req, out := c.DescribeTapesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeTapesPages iterates over the pages of a DescribeTapes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapes operation.
//    pageNum := 0
//    err := client.DescribeTapesPages(params,
//        func(page *DescribeTapesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapesPages(input *DescribeTapesInput, fn func(p *DescribeTapesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTapesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTapesOutput), lastPage)
	})
}

const opDescribeUploadBuffer = "DescribeUploadBuffer"

// DescribeUploadBufferRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUploadBuffer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeUploadBuffer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeUploadBuffer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeUploadBufferRequest method.
//    req, resp := client.DescribeUploadBufferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeUploadBufferRequest(input *DescribeUploadBufferInput) (req *request.Request, output *DescribeUploadBufferOutput) {
	op := &request.Operation{
		Name:       opDescribeUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUploadBufferInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeUploadBufferOutput{}
	req.Data = output
	return
}

// DescribeUploadBuffer API operation for AWS Storage Gateway.
//
// Returns information about the upload buffer of a gateway. This operation
// is supported for both the gateway-stored and gateway-cached volume architectures.
//
// The response includes disk IDs that are configured as upload buffer space,
// and it includes the amount of upload buffer space allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeUploadBuffer for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeUploadBuffer(input *DescribeUploadBufferInput) (*DescribeUploadBufferOutput, error) {
	req, out := c.DescribeUploadBufferRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVTLDevices = "DescribeVTLDevices"

// DescribeVTLDevicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVTLDevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVTLDevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVTLDevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVTLDevicesRequest method.
//    req, resp := client.DescribeVTLDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeVTLDevicesRequest(input *DescribeVTLDevicesInput) (req *request.Request, output *DescribeVTLDevicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVTLDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVTLDevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVTLDevicesOutput{}
	req.Data = output
	return
}

// DescribeVTLDevices API operation for AWS Storage Gateway.
//
// Returns a description of virtual tape library (VTL) devices for the specified
// gateway. In the response, AWS Storage Gateway returns VTL device information.
//
// The list of VTL devices must be from one gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeVTLDevices for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeVTLDevices(input *DescribeVTLDevicesInput) (*DescribeVTLDevicesOutput, error) {
	req, out := c.DescribeVTLDevicesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeVTLDevicesPages iterates over the pages of a DescribeVTLDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeVTLDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeVTLDevices operation.
//    pageNum := 0
//    err := client.DescribeVTLDevicesPages(params,
//        func(page *DescribeVTLDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeVTLDevicesPages(input *DescribeVTLDevicesInput, fn func(p *DescribeVTLDevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeVTLDevicesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeVTLDevicesOutput), lastPage)
	})
}

const opDescribeWorkingStorage = "DescribeWorkingStorage"

// DescribeWorkingStorageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkingStorage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeWorkingStorage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeWorkingStorage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeWorkingStorageRequest method.
//    req, resp := client.DescribeWorkingStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DescribeWorkingStorageRequest(input *DescribeWorkingStorageInput) (req *request.Request, output *DescribeWorkingStorageOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkingStorageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeWorkingStorageOutput{}
	req.Data = output
	return
}

// DescribeWorkingStorage API operation for AWS Storage Gateway.
//
// Returns information about the working storage of a gateway. This operation
// is supported only for the gateway-stored volume architecture. This operation
// is deprecated in cached-volumes API version (20120630). Use DescribeUploadBuffer
// instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// DescribeUploadBuffer operation to add upload buffer to a stored-volume gateway.
//
// The response includes disk IDs that are configured as working storage, and
// it includes the amount of working storage allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeWorkingStorage for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DescribeWorkingStorage(input *DescribeWorkingStorageInput) (*DescribeWorkingStorageOutput, error) {
	req, out := c.DescribeWorkingStorageRequest(input)
	err := req.Send()
	return out, err
}

const opDisableGateway = "DisableGateway"

// DisableGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DisableGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableGatewayRequest method.
//    req, resp := client.DisableGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) DisableGatewayRequest(input *DisableGatewayInput) (req *request.Request, output *DisableGatewayOutput) {
	op := &request.Operation{
		Name:       opDisableGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableGatewayOutput{}
	req.Data = output
	return
}

// DisableGateway API operation for AWS Storage Gateway.
//
// Disables a gateway when the gateway is no longer functioning. For example,
// if your gateway VM is damaged, you can disable the gateway so you can recover
// virtual tapes.
//
// Use this operation for a gateway-VTL that is not reachable or not functioning.
//
// Once a gateway is disabled it cannot be enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DisableGateway for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) DisableGateway(input *DisableGatewayInput) (*DisableGatewayOutput, error) {
	req, out := c.DisableGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGatewaysRequest method.
//    req, resp := client.ListGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGatewaysOutput{}
	req.Data = output
	return
}

// ListGateways API operation for AWS Storage Gateway.
//
// Lists gateways owned by an AWS account in a region specified in the request.
// The returned list is ordered by gateway Amazon Resource Name (ARN).
//
// By default, the operation returns a maximum of 100 gateways. This operation
// supports pagination that allows you to optionally reduce the number of gateways
// returned in a response.
//
// If you have more gateways than are returned in a response (that is, the response
// returns only a truncated list of your gateways), the response contains a
// marker that you can specify in your next request to fetch the next page of
// gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListGateways for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	err := req.Send()
	return out, err
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGateways operation.
//    pageNum := 0
//    err := client.ListGatewaysPages(params,
//        func(page *ListGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListGatewaysPages(input *ListGatewaysInput, fn func(p *ListGatewaysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGatewaysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGatewaysOutput), lastPage)
	})
}

const opListLocalDisks = "ListLocalDisks"

// ListLocalDisksRequest generates a "aws/request.Request" representing the
// client's request for the ListLocalDisks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListLocalDisks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListLocalDisks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListLocalDisksRequest method.
//    req, resp := client.ListLocalDisksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListLocalDisksRequest(input *ListLocalDisksInput) (req *request.Request, output *ListLocalDisksOutput) {
	op := &request.Operation{
		Name:       opListLocalDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLocalDisksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListLocalDisksOutput{}
	req.Data = output
	return
}

// ListLocalDisks API operation for AWS Storage Gateway.
//
// Returns a list of the gateway's local disks. To specify which gateway to
// describe, you use the Amazon Resource Name (ARN) of the gateway in the body
// of the request.
//
// The request returns a list of all disks, specifying which are configured
// as working storage, cache storage, or stored volume or not configured at
// all. The response includes a DiskStatus field. This field can have a value
// of present (the disk is available to use), missing (the disk is no longer
// connected to the gateway), or mismatch (the disk node is occupied by a disk
// that has incorrect metadata or the disk content is corrupted).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListLocalDisks for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListLocalDisks(input *ListLocalDisksInput) (*ListLocalDisksOutput, error) {
	req, out := c.ListLocalDisksRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// ListTagsForResource API operation for AWS Storage Gateway.
//
// Lists the tags that have been added to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opListTapes = "ListTapes"

// ListTapesRequest generates a "aws/request.Request" representing the
// client's request for the ListTapes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTapes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTapes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTapesRequest method.
//    req, resp := client.ListTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListTapesRequest(input *ListTapesInput) (req *request.Request, output *ListTapesOutput) {
	op := &request.Operation{
		Name:       opListTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTapesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTapesOutput{}
	req.Data = output
	return
}

// ListTapes API operation for AWS Storage Gateway.
//
// Lists virtual tapes in your virtual tape library (VTL) and your virtual tape
// shelf (VTS). You specify the tapes to list by specifying one or more tape
// Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation
// lists all virtual tapes in both your VTL and VTS.
//
// This operation supports pagination. By default, the operation returns a maximum
// of up to 100 tapes. You can optionally specify the Limit parameter in the
// body to limit the number of tapes in the response. If the number of tapes
// returned in the response is truncated, the response includes a Marker element
// that you can use in your subsequent request to retrieve the next set of tapes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTapes for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListTapes(input *ListTapesInput) (*ListTapesOutput, error) {
	req, out := c.ListTapesRequest(input)
	err := req.Send()
	return out, err
}

const opListVolumeInitiators = "ListVolumeInitiators"

// ListVolumeInitiatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumeInitiators operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVolumeInitiators for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVolumeInitiators method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVolumeInitiatorsRequest method.
//    req, resp := client.ListVolumeInitiatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListVolumeInitiatorsRequest(input *ListVolumeInitiatorsInput) (req *request.Request, output *ListVolumeInitiatorsOutput) {
	op := &request.Operation{
		Name:       opListVolumeInitiators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeInitiatorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVolumeInitiatorsOutput{}
	req.Data = output
	return
}

// ListVolumeInitiators API operation for AWS Storage Gateway.
//
// Lists iSCSI initiators that are connected to a volume. You can use this operation
// to determine whether a volume is being used or not.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumeInitiators for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListVolumeInitiators(input *ListVolumeInitiatorsInput) (*ListVolumeInitiatorsOutput, error) {
	req, out := c.ListVolumeInitiatorsRequest(input)
	err := req.Send()
	return out, err
}

const opListVolumeRecoveryPoints = "ListVolumeRecoveryPoints"

// ListVolumeRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumeRecoveryPoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVolumeRecoveryPoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVolumeRecoveryPoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVolumeRecoveryPointsRequest method.
//    req, resp := client.ListVolumeRecoveryPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListVolumeRecoveryPointsRequest(input *ListVolumeRecoveryPointsInput) (req *request.Request, output *ListVolumeRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opListVolumeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeRecoveryPointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVolumeRecoveryPointsOutput{}
	req.Data = output
	return
}

// ListVolumeRecoveryPoints API operation for AWS Storage Gateway.
//
// Lists the recovery points for a specified gateway. This operation is supported
// only for the gateway-cached volume architecture.
//
// Each gateway-cached volume has one recovery point. A volume recovery point
// is a point in time at which all data of the volume is consistent and from
// which you can create a snapshot. To create a snapshot from a volume recovery
// point use the CreateSnapshotFromVolumeRecoveryPoint operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumeRecoveryPoints for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListVolumeRecoveryPoints(input *ListVolumeRecoveryPointsInput) (*ListVolumeRecoveryPointsOutput, error) {
	req, out := c.ListVolumeRecoveryPointsRequest(input)
	err := req.Send()
	return out, err
}

const opListVolumes = "ListVolumes"

// ListVolumesRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVolumesRequest method.
//    req, resp := client.ListVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ListVolumesRequest(input *ListVolumesInput) (req *request.Request, output *ListVolumesOutput) {
	op := &request.Operation{
		Name:       opListVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVolumesOutput{}
	req.Data = output
	return
}

// ListVolumes API operation for AWS Storage Gateway.
//
// Lists the iSCSI stored volumes of a gateway. Results are sorted by volume
// ARN. The response includes only the volume ARNs. If you want additional volume
// information, use the DescribeStorediSCSIVolumes API.
//
// The operation supports pagination. By default, the operation returns a maximum
// of up to 100 volumes. You can optionally specify the Limit field in the body
// to limit the number of volumes in the response. If the number of volumes
// returned in the response is truncated, the response includes a Marker field.
// You can use this Marker value in your subsequent request to retrieve the
// next set of volumes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumes for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ListVolumes(input *ListVolumesInput) (*ListVolumesOutput, error) {
	req, out := c.ListVolumesRequest(input)
	err := req.Send()
	return out, err
}

// ListVolumesPages iterates over the pages of a ListVolumes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVolumes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVolumes operation.
//    pageNum := 0
//    err := client.ListVolumesPages(params,
//        func(page *ListVolumesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListVolumesPages(input *ListVolumesInput, fn func(p *ListVolumesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListVolumesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListVolumesOutput), lastPage)
	})
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromResourceOutput{}
	req.Data = output
	return
}

// RemoveTagsFromResource API operation for AWS Storage Gateway.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

const opResetCache = "ResetCache"

// ResetCacheRequest generates a "aws/request.Request" representing the
// client's request for the ResetCache operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetCache for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetCache method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetCacheRequest method.
//    req, resp := client.ResetCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ResetCacheRequest(input *ResetCacheInput) (req *request.Request, output *ResetCacheOutput) {
	op := &request.Operation{
		Name:       opResetCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResetCacheOutput{}
	req.Data = output
	return
}

// ResetCache API operation for AWS Storage Gateway.
//
// Resets all cache disks that have encountered a error and makes the disks
// available for reconfiguration as cache storage. If your cache disk encounters
// a error, the gateway prevents read and write operations on virtual tapes
// in the gateway. For example, an error can occur when a disk is corrupted
// or removed from the gateway. When a cache is reset, the gateway loses its
// cache storage. At this point you can reconfigure the disks as cache disks.
//
// If the cache disk you are resetting contains data that has not been uploaded
// to Amazon S3 yet, that data can be lost. After you reset cache disks, there
// will be no configured cache disks left in the gateway, so you must configure
// at least one new cache disk for your gateway to function properly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ResetCache for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ResetCache(input *ResetCacheInput) (*ResetCacheOutput, error) {
	req, out := c.ResetCacheRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveTapeArchive = "RetrieveTapeArchive"

// RetrieveTapeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveTapeArchive operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RetrieveTapeArchive for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RetrieveTapeArchive method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RetrieveTapeArchiveRequest method.
//    req, resp := client.RetrieveTapeArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) RetrieveTapeArchiveRequest(input *RetrieveTapeArchiveInput) (req *request.Request, output *RetrieveTapeArchiveOutput) {
	op := &request.Operation{
		Name:       opRetrieveTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeArchiveInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveTapeArchiveOutput{}
	req.Data = output
	return
}

// RetrieveTapeArchive API operation for AWS Storage Gateway.
//
// Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a
// gateway-VTL. Virtual tapes archived in the VTS are not associated with any
// gateway. However after a tape is retrieved, it is associated with a gateway,
// even though it is also listed in the VTS.
//
// Once a tape is successfully retrieved to a gateway, it cannot be retrieved
// again to another gateway. You must archive the tape again before you can
// retrieve it to another gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RetrieveTapeArchive for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) RetrieveTapeArchive(input *RetrieveTapeArchiveInput) (*RetrieveTapeArchiveOutput, error) {
	req, out := c.RetrieveTapeArchiveRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveTapeRecoveryPoint = "RetrieveTapeRecoveryPoint"

// RetrieveTapeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveTapeRecoveryPoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RetrieveTapeRecoveryPoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RetrieveTapeRecoveryPoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RetrieveTapeRecoveryPointRequest method.
//    req, resp := client.RetrieveTapeRecoveryPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) RetrieveTapeRecoveryPointRequest(input *RetrieveTapeRecoveryPointInput) (req *request.Request, output *RetrieveTapeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opRetrieveTapeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeRecoveryPointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveTapeRecoveryPointOutput{}
	req.Data = output
	return
}

// RetrieveTapeRecoveryPoint API operation for AWS Storage Gateway.
//
// Retrieves the recovery point for the specified virtual tape.
//
// A recovery point is a point in time view of a virtual tape at which all the
// data on the tape is consistent. If your gateway crashes, virtual tapes that
// have recovery points can be recovered to a new gateway.
//
// The virtual tape can be retrieved to only one gateway. The retrieved tape
// is read-only. The virtual tape can be retrieved to only a gateway-VTL. There
// is no charge for retrieving recovery points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RetrieveTapeRecoveryPoint for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) RetrieveTapeRecoveryPoint(input *RetrieveTapeRecoveryPointInput) (*RetrieveTapeRecoveryPointOutput, error) {
	req, out := c.RetrieveTapeRecoveryPointRequest(input)
	err := req.Send()
	return out, err
}

const opSetLocalConsolePassword = "SetLocalConsolePassword"

// SetLocalConsolePasswordRequest generates a "aws/request.Request" representing the
// client's request for the SetLocalConsolePassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetLocalConsolePassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetLocalConsolePassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetLocalConsolePasswordRequest method.
//    req, resp := client.SetLocalConsolePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) SetLocalConsolePasswordRequest(input *SetLocalConsolePasswordInput) (req *request.Request, output *SetLocalConsolePasswordOutput) {
	op := &request.Operation{
		Name:       opSetLocalConsolePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLocalConsolePasswordInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetLocalConsolePasswordOutput{}
	req.Data = output
	return
}

// SetLocalConsolePassword API operation for AWS Storage Gateway.
//
// Sets the password for your VM local console. When you log in to the local
// console for the first time, you log in to the VM with the default credentials.
// We recommend that you set a new password. You don't need to know the default
// password to set a new password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation SetLocalConsolePassword for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) SetLocalConsolePassword(input *SetLocalConsolePasswordInput) (*SetLocalConsolePasswordOutput, error) {
	req, out := c.SetLocalConsolePasswordRequest(input)
	err := req.Send()
	return out, err
}

const opShutdownGateway = "ShutdownGateway"

// ShutdownGatewayRequest generates a "aws/request.Request" representing the
// client's request for the ShutdownGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ShutdownGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ShutdownGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ShutdownGatewayRequest method.
//    req, resp := client.ShutdownGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) ShutdownGatewayRequest(input *ShutdownGatewayInput) (req *request.Request, output *ShutdownGatewayOutput) {
	op := &request.Operation{
		Name:       opShutdownGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShutdownGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ShutdownGatewayOutput{}
	req.Data = output
	return
}

// ShutdownGateway API operation for AWS Storage Gateway.
//
// Shuts down a gateway. To specify which gateway to shut down, use the Amazon
// Resource Name (ARN) of the gateway in the body of your request.
//
// The operation shuts down the gateway service component running in the storage
// gateway's virtual machine (VM) and not the VM.
//
// If you want to shut down the VM, it is recommended that you first shut down
// the gateway component in the VM to avoid unpredictable conditions.
//
// After the gateway is shutdown, you cannot call any other API except StartGateway,
// DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway.
// Your applications cannot read from or write to the gateway's storage volumes,
// and there are no snapshots taken.
//
// When you make a shutdown request, you will get a 200 OK success response
// immediately. However, it might take some time for the gateway to shut down.
// You can call the DescribeGatewayInformation API to check the status. For
// more information, see ActivateGateway.
//
// If do not intend to use the gateway again, you must delete the gateway (using
// DeleteGateway) to no longer pay software charges associated with the gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ShutdownGateway for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) ShutdownGateway(input *ShutdownGatewayInput) (*ShutdownGatewayOutput, error) {
	req, out := c.ShutdownGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opStartGateway = "StartGateway"

// StartGatewayRequest generates a "aws/request.Request" representing the
// client's request for the StartGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartGatewayRequest method.
//    req, resp := client.StartGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) StartGatewayRequest(input *StartGatewayInput) (req *request.Request, output *StartGatewayOutput) {
	op := &request.Operation{
		Name:       opStartGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartGatewayOutput{}
	req.Data = output
	return
}

// StartGateway API operation for AWS Storage Gateway.
//
// Starts a gateway that you previously shut down (see ShutdownGateway). After
// the gateway starts, you can then make other API calls, your applications
// can read from or write to the gateway's storage volumes and you will be able
// to take snapshot backups.
//
// When you make a request, you will get a 200 OK success response immediately.
// However, it might take some time for the gateway to be ready. You should
// call DescribeGatewayInformation and check the status before making any additional
// API calls. For more information, see ActivateGateway.
//
// To specify which gateway to start, use the Amazon Resource Name (ARN) of
// the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation StartGateway for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) StartGateway(input *StartGatewayInput) (*StartGatewayOutput, error) {
	req, out := c.StartGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateBandwidthRateLimit = "UpdateBandwidthRateLimit"

// UpdateBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBandwidthRateLimit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateBandwidthRateLimit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateBandwidthRateLimit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateBandwidthRateLimitRequest method.
//    req, resp := client.UpdateBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateBandwidthRateLimitRequest(input *UpdateBandwidthRateLimitInput) (req *request.Request, output *UpdateBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opUpdateBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBandwidthRateLimitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateBandwidthRateLimitOutput{}
	req.Data = output
	return
}

// UpdateBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Updates the bandwidth rate limits of a gateway. You can update both the upload
// and download bandwidth rate limit or specify only one of the two. If you
// don't set a bandwidth rate limit, the existing rate limit remains.
//
// By default, a gateway's bandwidth rate limits are not set. If you don't set
// any limit, the gateway does not have any limitations on its bandwidth usage
// and could potentially use the maximum available bandwidth.
//
// To specify which gateway to update, use the Amazon Resource Name (ARN) of
// the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateBandwidthRateLimit for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateBandwidthRateLimit(input *UpdateBandwidthRateLimitInput) (*UpdateBandwidthRateLimitOutput, error) {
	req, out := c.UpdateBandwidthRateLimitRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateChapCredentials = "UpdateChapCredentials"

// UpdateChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChapCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateChapCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateChapCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateChapCredentialsRequest method.
//    req, resp := client.UpdateChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateChapCredentialsRequest(input *UpdateChapCredentialsInput) (req *request.Request, output *UpdateChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opUpdateChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateChapCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateChapCredentialsOutput{}
	req.Data = output
	return
}

// UpdateChapCredentials API operation for AWS Storage Gateway.
//
// Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials
// for a specified iSCSI target. By default, a gateway does not have CHAP enabled;
// however, for added security, you might use it.
//
// When you update CHAP credentials, all existing connections on the target
// are closed and initiators must reconnect with the new credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateChapCredentials for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateChapCredentials(input *UpdateChapCredentialsInput) (*UpdateChapCredentialsOutput, error) {
	req, out := c.UpdateChapCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGatewayInformation = "UpdateGatewayInformation"

// UpdateGatewayInformationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayInformation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateGatewayInformation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateGatewayInformation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateGatewayInformationRequest method.
//    req, resp := client.UpdateGatewayInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateGatewayInformationRequest(input *UpdateGatewayInformationInput) (req *request.Request, output *UpdateGatewayInformationOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayInformationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateGatewayInformationOutput{}
	req.Data = output
	return
}

// UpdateGatewayInformation API operation for AWS Storage Gateway.
//
// Updates a gateway's metadata, which includes the gateway's name and time
// zone. To specify which gateway to update, use the Amazon Resource Name (ARN)
// of the gateway in your request.
//
// For Gateways activated after September 2, 2015, the gateway's ARN contains
// the gateway ID rather than the gateway name. However, changing the name of
// the gateway has no effect on the gateway's ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateGatewayInformation for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateGatewayInformation(input *UpdateGatewayInformationInput) (*UpdateGatewayInformationOutput, error) {
	req, out := c.UpdateGatewayInformationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGatewaySoftwareNow = "UpdateGatewaySoftwareNow"

// UpdateGatewaySoftwareNowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewaySoftwareNow operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateGatewaySoftwareNow for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateGatewaySoftwareNow method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateGatewaySoftwareNowRequest method.
//    req, resp := client.UpdateGatewaySoftwareNowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateGatewaySoftwareNowRequest(input *UpdateGatewaySoftwareNowInput) (req *request.Request, output *UpdateGatewaySoftwareNowOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewaySoftwareNow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewaySoftwareNowInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateGatewaySoftwareNowOutput{}
	req.Data = output
	return
}

// UpdateGatewaySoftwareNow API operation for AWS Storage Gateway.
//
// Updates the gateway virtual machine (VM) software. The request immediately
// triggers the software update.
//
// When you make this request, you get a 200 OK success response immediately.
// However, it might take some time for the update to complete. You can call
// DescribeGatewayInformation to verify the gateway is in the STATE_RUNNING
// state.
//
// A software update forces a system restart of your gateway. You can minimize
// the chance of any disruption to your applications by increasing your iSCSI
// Initiators' timeouts. For more information about increasing iSCSI Initiator
// timeouts for Windows and Linux, see Customizing Your Windows iSCSI Settings
// (http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings)
// and Customizing Your Linux iSCSI Settings (http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings),
// respectively.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateGatewaySoftwareNow for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateGatewaySoftwareNow(input *UpdateGatewaySoftwareNowInput) (*UpdateGatewaySoftwareNowOutput, error) {
	req, out := c.UpdateGatewaySoftwareNowRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateMaintenanceStartTime = "UpdateMaintenanceStartTime"

// UpdateMaintenanceStartTimeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceStartTime operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateMaintenanceStartTime for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateMaintenanceStartTime method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateMaintenanceStartTimeRequest method.
//    req, resp := client.UpdateMaintenanceStartTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateMaintenanceStartTimeRequest(input *UpdateMaintenanceStartTimeInput) (req *request.Request, output *UpdateMaintenanceStartTimeOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceStartTimeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateMaintenanceStartTimeOutput{}
	req.Data = output
	return
}

// UpdateMaintenanceStartTime API operation for AWS Storage Gateway.
//
// Updates a gateway's weekly maintenance start time information, including
// day and time of the week. The maintenance time is the time in your gateway's
// time zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateMaintenanceStartTime for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateMaintenanceStartTime(input *UpdateMaintenanceStartTimeInput) (*UpdateMaintenanceStartTimeOutput, error) {
	req, out := c.UpdateMaintenanceStartTimeRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSnapshotSchedule = "UpdateSnapshotSchedule"

// UpdateSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSnapshotSchedule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSnapshotSchedule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSnapshotSchedule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSnapshotScheduleRequest method.
//    req, resp := client.UpdateSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateSnapshotScheduleRequest(input *UpdateSnapshotScheduleInput) (req *request.Request, output *UpdateSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotScheduleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateSnapshotScheduleOutput{}
	req.Data = output
	return
}

// UpdateSnapshotSchedule API operation for AWS Storage Gateway.
//
// Updates a snapshot schedule configured for a gateway volume.
//
// The default snapshot schedule for volume is once every 24 hours, starting
// at the creation time of the volume. You can use this API to change the snapshot
// schedule configured for the volume.
//
// In the request you must identify the gateway volume whose snapshot schedule
// you want to update, and the schedule information, including when you want
// the snapshot to begin on a day and the frequency (in hours) of snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateSnapshotSchedule(input *UpdateSnapshotScheduleInput) (*UpdateSnapshotScheduleOutput, error) {
	req, out := c.UpdateSnapshotScheduleRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateVTLDeviceType = "UpdateVTLDeviceType"

// UpdateVTLDeviceTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVTLDeviceType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateVTLDeviceType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateVTLDeviceType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateVTLDeviceTypeRequest method.
//    req, resp := client.UpdateVTLDeviceTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *StorageGateway) UpdateVTLDeviceTypeRequest(input *UpdateVTLDeviceTypeInput) (req *request.Request, output *UpdateVTLDeviceTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateVTLDeviceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVTLDeviceTypeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateVTLDeviceTypeOutput{}
	req.Data = output
	return
}

// UpdateVTLDeviceType API operation for AWS Storage Gateway.
//
// Updates the type of medium changer in a gateway-VTL. When you activate a
// gateway-VTL, you select a medium changer type for the gateway-VTL. This operation
// enables you to select a different type of medium changer after a gateway-VTL
// is activated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateVTLDeviceType for usage and error information.
//
// Returned Error Codes:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
func (c *StorageGateway) UpdateVTLDeviceType(input *UpdateVTLDeviceTypeInput) (*UpdateVTLDeviceTypeOutput, error) {
	req, out := c.UpdateVTLDeviceTypeRequest(input)
	err := req.Send()
	return out, err
}

// A JSON object containing one or more of the following fields:
//
//    * ActivateGatewayInput$ActivationKey
//
//    * ActivateGatewayInput$GatewayName
//
//    * ActivateGatewayInput$GatewayRegion
//
//    * ActivateGatewayInput$GatewayTimezone
//
//    * ActivateGatewayInput$GatewayType
//
//    * ActivateGatewayInput$TapeDriveType
//
//    * ActivateGatewayInput$MediumChangerType
type ActivateGatewayInput struct {
	_ struct{} `type:"structure"`

	// Your gateway activation key. You can obtain the activation key by sending
	// an HTTP GET request with redirects enabled to the gateway IP address (port
	// 80). The redirect URL returned in the response provides you the activation
	// key for your gateway in the query string parameter activationKey. It may
	// also include other activation-related parameters, however, these are merely
	// defaults -- the arguments you pass to the ActivateGateway API call determine
	// the actual configuration of your gateway.
	//
	// ActivationKey is a required field
	ActivationKey *string `min:"1" type:"string" required:"true"`

	// The name you configured for your gateway.
	//
	// GatewayName is a required field
	GatewayName *string `min:"2" type:"string" required:"true"`

	// A value that indicates the region where you want to store the snapshot backups.
	// The gateway region specified must be the same region as the region in your
	// Host header in the request. For more information about available regions
	// and endpoints for AWS Storage Gateway, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region)
	// in the Amazon Web Services Glossary.
	//
	// Valid Values: "us-east-1", "us-west-1", "us-west-2", "eu-west-1", "eu-central-1",
	// "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "sa-east-1"
	//
	// GatewayRegion is a required field
	GatewayRegion *string `min:"1" type:"string" required:"true"`

	// A value that indicates the time zone you want to set for the gateway. The
	// time zone is used, for example, for scheduling snapshots and your gateway's
	// maintenance schedule.
	//
	// GatewayTimezone is a required field
	GatewayTimezone *string `min:"3" type:"string" required:"true"`

	// A value that defines the type of gateway to activate. The type specified
	// is critical to all later functions of the gateway and cannot be changed after
	// activation. The default value is STORED.
	GatewayType *string `min:"2" type:"string"`

	// The value that indicates the type of medium changer to use for gateway-VTL.
	// This field is optional.
	//
	// Valid Values: "STK-L700", "AWS-Gateway-VTL"
	MediumChangerType *string `min:"2" type:"string"`

	// The value that indicates the type of tape drive to use for gateway-VTL. This
	// field is optional.
	//
	// Valid Values: "IBM-ULT3580-TD5"
	TapeDriveType *string `min:"2" type:"string"`
}

// String returns the string representation
func (s ActivateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateGatewayInput"}
	if s.ActivationKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationKey"))
	}
	if s.ActivationKey != nil && len(*s.ActivationKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivationKey", 1))
	}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 2))
	}
	if s.GatewayRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRegion"))
	}
	if s.GatewayRegion != nil && len(*s.GatewayRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRegion", 1))
	}
	if s.GatewayTimezone == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayTimezone"))
	}
	if s.GatewayTimezone != nil && len(*s.GatewayTimezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayTimezone", 3))
	}
	if s.GatewayType != nil && len(*s.GatewayType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayType", 2))
	}
	if s.MediumChangerType != nil && len(*s.MediumChangerType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediumChangerType", 2))
	}
	if s.TapeDriveType != nil && len(*s.TapeDriveType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TapeDriveType", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// AWS Storage Gateway returns the Amazon Resource Name (ARN) of the activated
// gateway. It is a string made of information such as your account, gateway
// name, and region. This ARN is used to reference the gateway in other API
// operations as well as resource-based authorization.
//
// For gateways activated prior to September 02, 2015 the gateway ARN contains
// the gateway name rather than the gateway id. Changing the name of the gateway
// has no effect on the gateway ARN.
type ActivateGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ActivateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayOutput) GoString() string {
	return s.String()
}

type AddCacheInput struct {
	_ struct{} `type:"structure"`

	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCacheInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheOutput) GoString() string {
	return s.String()
}

// AddTagsToResourceInput
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`

	// The key-value pair that represents the tag you want to add to the resource.
	// The value can be an empty string.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// AddTagsToResourceOutput
type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	ResourceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type AddUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddUploadBufferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddUploadBufferInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * AddWorkingStorageInput$DiskIds
type AddWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string have a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddWorkingStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddWorkingStorageInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway for which working storage was
// configured.
type AddWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageOutput) GoString() string {
	return s.String()
}

type CachediSCSIVolume struct {
	_ struct{} `type:"structure"`

	SourceSnapshotId *string `type:"string"`

	VolumeARN *string `min:"50" type:"string"`

	VolumeId *string `min:"12" type:"string"`

	VolumeProgress *float64 `type:"double"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeStatus *string `min:"3" type:"string"`

	VolumeType *string `min:"3" type:"string"`

	// Lists iSCSI information about a volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`
}

// String returns the string representation
func (s CachediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachediSCSIVolume) GoString() string {
	return s.String()
}

// CancelArchivalInput
type CancelArchivalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
	// for.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelArchivalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelArchivalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelArchivalInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CancelArchivalOutput
type CancelArchivalOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which archiving was
	// canceled.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CancelArchivalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalOutput) GoString() string {
	return s.String()
}

// CancelRetrievalInput
type CancelRetrievalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
	// for.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelRetrievalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelRetrievalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelRetrievalInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CancelRetrievalOutput
type CancelRetrievalOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which retrieval was
	// canceled.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CancelRetrievalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalOutput) GoString() string {
	return s.String()
}

// Describes Challenge-Handshake Authentication Protocol (CHAP) information
// that supports authentication between your gateway and iSCSI initiators.
type ChapInfo struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	SecretToAuthenticateInitiator *string `min:"1" type:"string"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	SecretToAuthenticateTarget *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the volume.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ChapInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChapInfo) GoString() string {
	return s.String()
}

type CreateCachediSCSIVolumeInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	SnapshotId *string `type:"string"`

	// TargetName is a required field
	TargetName *string `min:"1" type:"string" required:"true"`

	// VolumeSizeInBytes is a required field
	VolumeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCachediSCSIVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCachediSCSIVolumeInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}
	if s.VolumeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCachediSCSIVolumeOutput struct {
	_ struct{} `type:"structure"`

	TargetARN *string `min:"50" type:"string"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeOutput) GoString() string {
	return s.String()
}

type CreateSnapshotFromVolumeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// SnapshotDescription is a required field
	SnapshotDescription *string `min:"1" type:"string" required:"true"`

	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotFromVolumeRecoveryPointInput"}
	if s.SnapshotDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotDescription"))
	}
	if s.SnapshotDescription != nil && len(*s.SnapshotDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotDescription", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateSnapshotFromVolumeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	SnapshotId *string `type:"string"`

	VolumeARN *string `min:"50" type:"string"`

	VolumeRecoveryPointTime *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * CreateSnapshotInput$SnapshotDescription
//
//    * CreateSnapshotInput$VolumeARN
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Textual description of the snapshot that appears in the Amazon EC2 console,
	// Elastic Block Store snapshots panel in the Description field, and in the
	// AWS Storage Gateway snapshot Details pane, Description field
	//
	// SnapshotDescription is a required field
	SnapshotDescription *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.SnapshotDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotDescription"))
	}
	if s.SnapshotDescription != nil && len(*s.SnapshotDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotDescription", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot ID that is used to refer to the snapshot in future operations
	// such as describing snapshots (Amazon Elastic Compute Cloud API DescribeSnapshots)
	// or creating a volume from a snapshot (CreateStorediSCSIVolume).
	SnapshotId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * CreateStorediSCSIVolumeInput$DiskId
//
//    * CreateStorediSCSIVolumeInput$NetworkInterfaceId
//
//    * CreateStorediSCSIVolumeInput$PreserveExistingData
//
//    * CreateStorediSCSIVolumeInput$SnapshotId
//
//    * CreateStorediSCSIVolumeInput$TargetName
type CreateStorediSCSIVolumeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the gateway local disk that is configured as a
	// stored volume. Use ListLocalDisks (http://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html)
	// to list disk IDs for a gateway.
	//
	// DiskId is a required field
	DiskId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The network interface of the gateway on which to expose the iSCSI target.
	// Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a
	// list of the network interfaces available on a gateway.
	//
	// Valid Values: A valid IP address.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	// Specify this field as true if you want to preserve the data on the local
	// disk. Otherwise, specifying this field as false creates an empty volume.
	//
	// Valid Values: true, false
	//
	// PreserveExistingData is a required field
	PreserveExistingData *bool `type:"boolean" required:"true"`

	// The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the
	// new stored volume. Specify this field if you want to create the iSCSI storage
	// volume from a snapshot otherwise do not include this field. To list snapshots
	// for your account use DescribeSnapshots (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
	// in the Amazon Elastic Compute Cloud API Reference.
	SnapshotId *string `type:"string"`

	// The name of the iSCSI target used by initiators to connect to the target
	// and as a suffix for the target ARN. For example, specifying TargetName as
	// myvolume results in the target ARN of arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes of a gateway.
	//
	// TargetName is a required field
	TargetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStorediSCSIVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStorediSCSIVolumeInput"}
	if s.DiskId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskId"))
	}
	if s.DiskId != nil && len(*s.DiskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiskId", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.PreserveExistingData == nil {
		invalidParams.Add(request.NewErrParamRequired("PreserveExistingData"))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type CreateStorediSCSIVolumeOutput struct {
	_ struct{} `type:"structure"`

	// he Amazon Resource Name (ARN) of the volume target that includes the iSCSI
	// name that initiators can use to connect to the target.
	TargetARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of the configured volume.
	VolumeARN *string `min:"50" type:"string"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeOutput) GoString() string {
	return s.String()
}

// CreateTapeWithBarcodeInput
type CreateTapeWithBarcodeInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tape with. Use the ListGateways operation to return a list of
	// gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The barcode that you want to assign to the tape.
	//
	// TapeBarcode is a required field
	TapeBarcode *string `min:"7" type:"string" required:"true"`

	// The size, in bytes, of the virtual tape that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 byte).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapeWithBarcodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapeWithBarcodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapeWithBarcodeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeBarcode == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcode"))
	}
	if s.TapeBarcode != nil && len(*s.TapeBarcode) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcode", 7))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CreateTapeOutput
type CreateTapeWithBarcodeOutput struct {
	_ struct{} `type:"structure"`

	// A unique Amazon Resource Name (ARN) that represents the virtual tape that
	// was created.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapeWithBarcodeOutput) GoString() string {
	return s.String()
}

// CreateTapesInput
type CreateTapesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you use to retry a request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// Using the same ClientToken prevents creating the tape multiple times.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tapes with. Use the ListGateways operation to return a list of
	// gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The number of virtual tapes that you want to create.
	//
	// NumTapesToCreate is a required field
	NumTapesToCreate *int64 `min:"1" type:"integer" required:"true"`

	// A prefix that you append to the barcode of the virtual tape you are creating.
	// This prefix makes the barcode unique.
	//
	// The prefix must be 1 to 4 characters in length and must be one of the uppercase
	// letters from A to Z.
	//
	// TapeBarcodePrefix is a required field
	TapeBarcodePrefix *string `min:"1" type:"string" required:"true"`

	// The size, in bytes, of the virtual tapes that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 byte).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapesInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NumTapesToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("NumTapesToCreate"))
	}
	if s.NumTapesToCreate != nil && *s.NumTapesToCreate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumTapesToCreate", 1))
	}
	if s.TapeBarcodePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcodePrefix"))
	}
	if s.TapeBarcodePrefix != nil && len(*s.TapeBarcodePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcodePrefix", 1))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CreateTapeOutput
type CreateTapesOutput struct {
	_ struct{} `type:"structure"`

	// A list of unique Amazon Resource Names (ARNs) that represents the virtual
	// tapes that were created.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s CreateTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesOutput) GoString() string {
	return s.String()
}

type DeleteBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// BandwidthType is a required field
	BandwidthType *string `min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBandwidthRateLimitInput"}
	if s.BandwidthType == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthType"))
	}
	if s.BandwidthType != nil && len(*s.BandwidthType) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BandwidthType", 3))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway whose bandwidth rate information
// was deleted.
type DeleteBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * DeleteChapCredentialsInput$InitiatorName
//
//    * DeleteChapCredentialsInput$TargetARN
type DeleteChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChapCredentialsInput"}
	if s.InitiatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitiatorName", 1))
	}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type DeleteChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsOutput) GoString() string {
	return s.String()
}

// A JSON object containing the id of the gateway to delete.
type DeleteGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the id of the deleted gateway.
type DeleteGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

type DeleteSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotScheduleInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// DeleteTapeArchiveInput
type DeleteTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual
	// tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapeArchiveInput"}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DeleteTapeArchiveOutput
type DeleteTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape that was deleted from
	// the virtual tape shelf (VTS).
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveOutput) GoString() string {
	return s.String()
}

// DeleteTapeInput
type DeleteTapeInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) of the gateway that the virtual tape
	// to delete is associated with. Use the ListGateways operation to return a
	// list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DeleteTapeOutput
type DeleteTapeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeOutput) GoString() string {
	return s.String()
}

// A JSON object containing the DeleteVolumeInput$VolumeARN to delete.
type DeleteVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVolumeInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the storage volume that was deleted
type DeleteVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the storage volume that was deleted. It
	// is the same ARN you provided in the request.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type DescribeBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBandwidthRateLimitInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type DescribeBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The average download bandwidth rate limit in bits per second. This field
	// does not appear in the response if the download rate limit is not set.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload bandwidth rate limit in bits per second. This field does
	// not appear in the response if the upload rate limit is not set.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

type DescribeCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCacheInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCacheOutput struct {
	_ struct{} `type:"structure"`

	CacheAllocatedInBytes *int64 `type:"long"`

	CacheDirtyPercentage *float64 `type:"double"`

	CacheHitPercentage *float64 `type:"double"`

	CacheMissPercentage *float64 `type:"double"`

	CacheUsedPercentage *float64 `type:"double"`

	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheOutput) GoString() string {
	return s.String()
}

type DescribeCachediSCSIVolumesInput struct {
	_ struct{} `type:"structure"`

	// VolumeARNs is a required field
	VolumeARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCachediSCSIVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCachediSCSIVolumesInput"}
	if s.VolumeARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type DescribeCachediSCSIVolumesOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects where each object contains metadata about one cached
	// volume.
	CachediSCSIVolumes []*CachediSCSIVolume `type:"list"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume
// target.
type DescribeChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChapCredentialsInput"}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing a .
type DescribeChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChapInfo objects that represent CHAP credentials. Each object
	// in the array contains CHAP credential information for one target-initiator
	// pair. If no CHAP credentials are set, an empty array is returned. CHAP credential
	// information is provided in a JSON object with the following fields:
	//
	//    * InitiatorName: The iSCSI initiator that connects to the target.
	//
	//    * SecretToAuthenticateInitiator: The secret key that the initiator (for
	//    example, the Windows client) must provide to participate in mutual CHAP
	//    with the target.
	//
	//    * SecretToAuthenticateTarget: The secret key that the target must provide
	//    to participate in mutual CHAP with the initiator (e.g. Windows client).
	//
	//    * TargetARN: The Amazon Resource Name (ARN) of the storage volume.
	ChapCredentials []*ChapInfo `type:"list"`
}

// String returns the string representation
func (s DescribeChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsOutput) GoString() string {
	return s.String()
}

// A JSON object containing the id of the gateway.
type DescribeGatewayInformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInformationInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type DescribeGatewayInformationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	GatewayId *string `min:"12" type:"string"`

	// The name you configured for your gateway.
	GatewayName *string `type:"string"`

	// A NetworkInterface array that contains descriptions of the gateway network
	// interfaces.
	GatewayNetworkInterfaces []*NetworkInterface `type:"list"`

	// A value that indicates the operating state of the gateway.
	GatewayState *string `min:"2" type:"string"`

	// A value that indicates the time zone configured for the gateway.
	GatewayTimezone *string `min:"3" type:"string"`

	// The type of the gateway.
	GatewayType *string `min:"2" type:"string"`

	// The date on which the last software update was applied to the gateway. If
	// the gateway has never been updated, this field does not return a value in
	// the response.
	LastSoftwareUpdate *string `min:"1" type:"string"`

	// The date on which an update to the gateway is available. This date is in
	// the time zone of the gateway. If the gateway is not available for an update
	// this field is not returned in the response.
	NextUpdateAvailabilityDate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type DescribeMaintenanceStartTimeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceStartTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceStartTimeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeMaintenanceStartTimeOutput struct {
	_ struct{} `type:"structure"`

	DayOfWeek *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	HourOfDay *int64 `type:"integer"`

	MinuteOfHour *int64 `type:"integer"`

	Timezone *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// A JSON object containing the DescribeSnapshotScheduleInput$VolumeARN of the
// volume.
type DescribeSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSnapshotScheduleInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	Description *string `min:"1" type:"string"`

	RecurrenceInHours *int64 `min:"1" type:"integer"`

	StartAt *int64 `type:"integer"`

	Timezone *string `min:"3" type:"string"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// A JSON object containing a list of DescribeStorediSCSIVolumesInput$VolumeARNs.
type DescribeStorediSCSIVolumesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings where each string represents the Amazon Resource Name
	// (ARN) of a stored volume. All of the specified stored volumes must from the
	// same gateway. Use ListVolumes to get volume ARNs for a gateway.
	//
	// VolumeARNs is a required field
	VolumeARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStorediSCSIVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStorediSCSIVolumesInput"}
	if s.VolumeARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeStorediSCSIVolumesOutput struct {
	_ struct{} `type:"structure"`

	StorediSCSIVolumes []*StorediSCSIVolume `type:"list"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// DescribeTapeArchivesInput
type DescribeTapeArchivesInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the number of virtual tapes descried be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// virtual tapes.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeArchivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapeArchivesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeTapeArchivesOutput
type DescribeTapeArchivesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which the virtual tapes that
	// were fetched for description ended. Use this marker in your next request
	// to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If
	// there are no more virtual tapes to describe, this field does not appear in
	// the response.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape objects in the virtual tape shelf (VTS). The description
	// includes of the Amazon Resource Name(ARN) of the virtual tapes. The information
	// returned includes the Amazon Resource Names (ARNs) of the tapes, size of
	// the tapes, status of the tapes, progress of the description and tape barcode.
	TapeArchives []*TapeArchive `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesOutput) GoString() string {
	return s.String()
}

// DescribeTapeRecoveryPointsInput
type DescribeTapeRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tape recovery points that are described
	// be limited to the specified number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the virtual tape recovery points.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapeRecoveryPointsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeTapeRecoveryPointsOutput
type DescribeTapeRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// An opaque string that indicates the position at which the virtual tape recovery
	// points that were listed for description ended.
	//
	// Use this marker in your next request to list the next set of virtual tape
	// recovery points in the list. If there are no more recovery points to describe,
	// this field does not appear in the response.
	Marker *string `min:"1" type:"string"`

	// An array of TapeRecoveryPointInfos that are available for the specified gateway.
	TapeRecoveryPointInfos []*TapeRecoveryPointInfo `type:"list"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// DescribeTapesInput
type DescribeTapesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	//
	// Amazon Web Services may impose its own limit, if this field is not set.
	Limit *int64 `min:"1" type:"integer"`

	// A marker value, obtained in a previous call to DescribeTapes. This marker
	// indicates which page of results to retrieve.
	//
	// If not specified, the first page of results is retrieved.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe. If this parameter is not specified,
	// AWS Storage Gateway returns a description of all virtual tapes associated
	// with the specified gateway.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapesInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeTapesOutput
type DescribeTapesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string which can be used as part of a subsequent DescribeTapes
	// call to retrieve the next page of results.
	//
	// If a response does not contain a marker, then there are no more results to
	// be retrieved.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape descriptions.
	Tapes []*Tape `type:"list"`
}

// String returns the string representation
func (s DescribeTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesOutput) GoString() string {
	return s.String()
}

type DescribeUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUploadBufferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUploadBufferInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	UploadBufferAllocatedInBytes *int64 `type:"long"`

	UploadBufferUsedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferOutput) GoString() string {
	return s.String()
}

// DescribeVTLDevicesInput
type DescribeVTLDevicesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of VTL devices described be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the VTL devices.
	Marker *string `min:"1" type:"string"`

	// An array of strings, where each string represents the Amazon Resource Name
	// (ARN) of a VTL device.
	//
	// All of the specified VTL devices must be from the same gateway. If no VTL
	// devices are specified, the result will contain all devices on the specified
	// gateway.
	VTLDeviceARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeVTLDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVTLDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVTLDevicesInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeVTLDevicesOutput
type DescribeVTLDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// An opaque string that indicates the position at which the VTL devices that
	// were fetched for description ended. Use the marker in your next request to
	// fetch the next set of VTL devices in the list. If there are no more VTL devices
	// to describe, this field does not appear in the response.
	Marker *string `min:"1" type:"string"`

	// An array of VTL device objects composed of the Amazon Resource Name(ARN)
	// of the VTL devices.
	VTLDevices []*VTLDevice `type:"list"`
}

// String returns the string representation
func (s DescribeVTLDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type DescribeWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkingStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkingStorageInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type DescribeWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// An array of the gateway's local disk IDs that are configured as working storage.
	// Each local disk ID is specified as a string (minimum length of 1 and maximum
	// length of 300). If no local disks are configured as working storage, then
	// the DiskIds array is empty.
	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The total working storage in bytes allocated for the gateway. If no working
	// storage is configured for the gateway, this field returns 0.
	WorkingStorageAllocatedInBytes *int64 `type:"long"`

	// The total working storage in bytes in use by the gateway. If no working storage
	// is configured for the gateway, this field returns 0.
	WorkingStorageUsedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageOutput) GoString() string {
	return s.String()
}

// Lists iSCSI information about a VTL device.
type DeviceiSCSIAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The network interface identifier of the VTL device.
	NetworkInterfaceId *string `type:"string"`

	// The port used to communicate with iSCSI VTL device targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// Specifies the unique Amazon Resource Name(ARN) that encodes the iSCSI qualified
	// name(iqn) of a tape drive or media changer target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeviceiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceiSCSIAttributes) GoString() string {
	return s.String()
}

// DisableGatewayInput
type DisableGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DisableGatewayOutput
type DisableGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name of the disabled gateway.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DisableGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayOutput) GoString() string {
	return s.String()
}

type Disk struct {
	_ struct{} `type:"structure"`

	DiskAllocationResource *string `type:"string"`

	DiskAllocationType *string `min:"3" type:"string"`

	DiskId *string `min:"1" type:"string"`

	DiskNode *string `type:"string"`

	DiskPath *string `type:"string"`

	DiskSizeInBytes *int64 `type:"long"`

	DiskStatus *string `type:"string"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// Provides additional information about an error that was returned by the service
// as an or. See the errorCode and errorDetails members for more information
// about the error.
type Error struct {
	_ struct{} `type:"structure"`

	// Additional information about the error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// Human-readable text that provides detail about the error that occurred.
	ErrorDetails map[string]*string `locationName:"errorDetails" type:"map"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// Describes a gateway object.
type GatewayInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	GatewayId *string `min:"12" type:"string"`

	// The name of the gateway.
	GatewayName *string `type:"string"`

	// The state of the gateway.
	//
	// Valid Values: DISABLED or ACTIVE
	GatewayOperationalState *string `min:"2" type:"string"`

	// The type of the gateway.
	GatewayType *string `min:"2" type:"string"`
}

// String returns the string representation
func (s GatewayInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayInfo) GoString() string {
	return s.String()
}

// A JSON object containing zero or more of the following fields:
//
//    * ListGatewaysInput$Limit
//
//    * ListGatewaysInput$Marker
type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the list of gateways returned be limited to the specified
	// number of items.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin the returned
	// list of gateways.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	Gateways []*GatewayInfo `type:"list"`

	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type ListLocalDisksInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLocalDisksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLocalDisksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLocalDisksInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListLocalDisksOutput struct {
	_ struct{} `type:"structure"`

	Disks []*Disk `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ListLocalDisksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksOutput) GoString() string {
	return s.String()
}

// ListTagsForResourceInput
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the list of tags returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin returning
	// the list of tags.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// ListTagsForResourceOutput
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to stop returning the
	// list of tags.
	Marker *string `min:"1" type:"string"`

	// he Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	ResourceARN *string `min:"50" type:"string"`

	// An array that contains the tags for the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// A JSON object that contains one or more of the following fields:
//
//    * ListTapesInput$Limit
//
//    * ListTapesInput$Marker
//
//    * ListTapesInput$TapeARNs
type ListTapesInput struct {
	_ struct{} `type:"structure"`

	// An optional number limit for the tapes in the list returned by this call.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of tapes.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of each of the tapes you want to list. If
	// you don't specify a tape ARN, the response lists all tapes in both your VTL
	// and VTS.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s ListTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTapesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
//
//    * ListTapesOutput$Marker
//
//    * ListTapesOutput$VolumeInfos
type ListTapesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates the position at which to begin returning the next
	// list of tapes. Use the marker in your next request to continue pagination
	// of tapes. If there are no more tapes to list, this element does not appear
	// in the response body.
	Marker *string `min:"1" type:"string"`

	// An array of TapeInfo objects, where each object describes an a single tape.
	// If there not tapes in the tape library or VTS, then the TapeInfos is an empty
	// array.
	TapeInfos []*TapeInfo `type:"list"`
}

// String returns the string representation
func (s ListTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapesOutput) GoString() string {
	return s.String()
}

// ListVolumeInitiatorsInput
type ListVolumeInitiatorsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes for the gateway.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVolumeInitiatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumeInitiatorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumeInitiatorsInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// ListVolumeInitiatorsOutput
type ListVolumeInitiatorsOutput struct {
	_ struct{} `type:"structure"`

	// The host names and port numbers of all iSCSI initiators that are connected
	// to the gateway.
	Initiators []*string `type:"list"`
}

// String returns the string representation
func (s ListVolumeInitiatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsOutput) GoString() string {
	return s.String()
}

type ListVolumeRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumeRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumeRecoveryPointsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListVolumeRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	VolumeRecoveryPointInfos []*VolumeRecoveryPointInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// A JSON object that contains one or more of the following fields:
//
//    * ListVolumesInput$Limit
//
//    * ListVolumesInput$Marker
type ListVolumesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// Specifies that the list of volumes returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of volumes. Obtain the marker from the response of a previous List iSCSI
	// Volumes request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListVolumesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	Marker *string `min:"1" type:"string"`

	VolumeInfos []*VolumeInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesOutput) GoString() string {
	return s.String()
}

// Describes a gateway's network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The Internet Protocol version 4 (IPv4) address of the interface.
	Ipv4Address *string `type:"string"`

	// The Internet Protocol version 6 (IPv6) address of the interface. Currently
	// not supported.
	Ipv6Address *string `type:"string"`

	// The Media Access Control (MAC) address of the interface.
	//
	// This is currently unsupported and will not be returned in output.
	MacAddress *string `type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// RemoveTagsFromResourceInput
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to remove the tags
	// from.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`

	// The keys of the tags you want to remove from the specified resource. A tag
	// is composed of a key/value pair.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// RemoveTagsFromResourceOutput
type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that the tags were removed
	// from.
	ResourceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

type ResetCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetCacheInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ResetCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ResetCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheOutput) GoString() string {
	return s.String()
}

// RetrieveTapeArchiveInput
type RetrieveTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual
	// tape to. Use the ListGateways operation to return a list of gateways for
	// your account and region.
	//
	// You retrieve archived virtual tapes to only one gateway and the gateway must
	// be a gateway-VTL.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from
	// the virtual tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveTapeArchiveInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// RetrieveTapeArchiveOutput
type RetrieveTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the retrieved virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveOutput) GoString() string {
	return s.String()
}

// RetrieveTapeRecoveryPointInput
type RetrieveTapeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape for which you want to
	// retrieve the recovery point.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveTapeRecoveryPointInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// RetrieveTapeRecoveryPointOutput
type RetrieveTapeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which the recovery
	// point was retrieved.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetLocalConsolePasswordInput
type SetLocalConsolePasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The password you want to set for your VM local console.
	//
	// LocalConsolePassword is a required field
	LocalConsolePassword *string `min:"6" type:"string" required:"true"`
}

// String returns the string representation
func (s SetLocalConsolePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLocalConsolePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLocalConsolePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetLocalConsolePasswordInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.LocalConsolePassword == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalConsolePassword"))
	}
	if s.LocalConsolePassword != nil && len(*s.LocalConsolePassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("LocalConsolePassword", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetLocalConsolePasswordOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s SetLocalConsolePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLocalConsolePasswordOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway to shut down.
type ShutdownGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ShutdownGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShutdownGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShutdownGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway that was shut down.
type ShutdownGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ShutdownGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway to start.
type StartGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s StartGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway that was restarted.
type StartGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s StartGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayOutput) GoString() string {
	return s.String()
}

type StorediSCSIVolume struct {
	_ struct{} `type:"structure"`

	PreservedExistingData *bool `type:"boolean"`

	SourceSnapshotId *string `type:"string"`

	VolumeARN *string `min:"50" type:"string"`

	VolumeDiskId *string `min:"1" type:"string"`

	VolumeId *string `min:"12" type:"string"`

	VolumeProgress *float64 `type:"double"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeStatus *string `min:"3" type:"string"`

	VolumeType *string `min:"3" type:"string"`

	// Lists iSCSI information about a volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`
}

// String returns the string representation
func (s StorediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorediSCSIVolume) GoString() string {
	return s.String()
}

type Tag struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a virtual tape object.
type Tape struct {
	_ struct{} `type:"structure"`

	// For archiving virtual tapes, indicates how much data remains to be uploaded
	// before archiving is complete.
	//
	// Range: 0 (not started) to 100 (complete).
	Progress *float64 `type:"double"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The size, in bytes, of the virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the virtual tape.
	TapeStatus *string `type:"string"`

	// The virtual tape library (VTL) device that the virtual tape is associated
	// with.
	VTLDevice *string `min:"50" type:"string"`
}

// String returns the string representation
func (s Tape) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tape) GoString() string {
	return s.String()
}

// Represents a virtual tape that is archived in the virtual tape shelf (VTS).
type TapeArchive struct {
	_ struct{} `type:"structure"`

	// The time that the archiving of the virtual tape was completed.
	//
	// The string format of the completion time is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
	// format.
	CompletionTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the gateway-VTL that the virtual tape is
	// being retrieved to.
	//
	// The virtual tape is retrieved from the virtual tape shelf (VTS).
	RetrievedTo *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of an archived virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies the archived virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The size, in bytes, of the archived virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the archived virtual tape.
	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeArchive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeArchive) GoString() string {
	return s.String()
}

// Describes a virtual tape.
type TapeInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of a virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The size, in bytes, of a virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The status of the tape.
	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeInfo) GoString() string {
	return s.String()
}

// Describes a recovery point.
type TapeRecoveryPointInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The time when the point-in-time view of the virtual tape was replicated for
	// later recovery.
	//
	// The string format of the tape recovery point time is in the ISO8601 extended
	// YYYY-MM-DD'T'HH:MM:SS'Z' format.
	TapeRecoveryPointTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the virtual tapes to recover.
	TapeSizeInBytes *int64 `type:"long"`

	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeRecoveryPointInfo) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec
//
//    * UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec
type UpdateBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// The average download bandwidth rate limit in bits per second.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload bandwidth rate limit in bits per second.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBandwidthRateLimitInput"}
	if s.AverageDownloadRateLimitInBitsPerSec != nil && *s.AverageDownloadRateLimitInBitsPerSec < 102400 {
		invalidParams.Add(request.NewErrParamMinValue("AverageDownloadRateLimitInBitsPerSec", 102400))
	}
	if s.AverageUploadRateLimitInBitsPerSec != nil && *s.AverageUploadRateLimitInBitsPerSec < 51200 {
		invalidParams.Add(request.NewErrParamMinValue("AverageUploadRateLimitInBitsPerSec", 51200))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway whose throttle information was
// updated.
type UpdateBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateChapCredentialsInput$InitiatorName
//
//    * UpdateChapCredentialsInput$SecretToAuthenticateInitiator
//
//    * UpdateChapCredentialsInput$SecretToAuthenticateTarget
//
//    * UpdateChapCredentialsInput$TargetARN
type UpdateChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	//
	// SecretToAuthenticateInitiator is a required field
	SecretToAuthenticateInitiator *string `min:"1" type:"string" required:"true"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	//
	// Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	SecretToAuthenticateTarget *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChapCredentialsInput"}
	if s.InitiatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitiatorName", 1))
	}
	if s.SecretToAuthenticateInitiator == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretToAuthenticateInitiator"))
	}
	if s.SecretToAuthenticateInitiator != nil && len(*s.SecretToAuthenticateInitiator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToAuthenticateInitiator", 1))
	}
	if s.SecretToAuthenticateTarget != nil && len(*s.SecretToAuthenticateTarget) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToAuthenticateTarget", 1))
	}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
type UpdateChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target. This is the same initiator
	// name specified in the request.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target. This is the same target specified
	// in the request.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsOutput) GoString() string {
	return s.String()
}

type UpdateGatewayInformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The name you configured for your gateway.
	GatewayName *string `min:"2" type:"string"`

	GatewayTimezone *string `min:"3" type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInformationInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 2))
	}
	if s.GatewayTimezone != nil && len(*s.GatewayTimezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayTimezone", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the ARN of the gateway that was updated.
type UpdateGatewayInformationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	GatewayName *string `type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway to update.
type UpdateGatewaySoftwareNowInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewaySoftwareNowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewaySoftwareNowInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway that was updated.
type UpdateGatewaySoftwareNowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowOutput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
//
//    * UpdateMaintenanceStartTimeInput$DayOfWeek
//
//    * UpdateMaintenanceStartTimeInput$HourOfDay
//
//    * UpdateMaintenanceStartTimeInput$MinuteOfHour
type UpdateMaintenanceStartTimeInput struct {
	_ struct{} `type:"structure"`

	// The maintenance start time day of the week.
	//
	// DayOfWeek is a required field
	DayOfWeek *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The hour component of the maintenance start time represented as hh, where
	// hh is the hour (00 to 23). The hour of the day is in the time zone of the
	// gateway.
	//
	// HourOfDay is a required field
	HourOfDay *int64 `type:"integer" required:"true"`

	// The minute component of the maintenance start time represented as mm, where
	// mm is the minute (00 to 59). The minute of the hour is in the time zone of
	// the gateway.
	//
	// MinuteOfHour is a required field
	MinuteOfHour *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMaintenanceStartTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMaintenanceStartTimeInput"}
	if s.DayOfWeek == nil {
		invalidParams.Add(request.NewErrParamRequired("DayOfWeek"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.HourOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("HourOfDay"))
	}
	if s.MinuteOfHour == nil {
		invalidParams.Add(request.NewErrParamRequired("MinuteOfHour"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the gateway whose maintenance start time
// is updated.
type UpdateMaintenanceStartTimeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateSnapshotScheduleInput$Description
//
//    * UpdateSnapshotScheduleInput$RecurrenceInHours
//
//    * UpdateSnapshotScheduleInput$StartAt
//
//    * UpdateSnapshotScheduleInput$VolumeARN
type UpdateSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// Optional description of the snapshot that overwrites the existing description.
	Description *string `min:"1" type:"string"`

	// Frequency of snapshots. Specify the number of hours between snapshots.
	//
	// RecurrenceInHours is a required field
	RecurrenceInHours *int64 `min:"1" type:"integer" required:"true"`

	// The hour of the day at which the snapshot schedule begins represented as
	// hh, where hh is the hour (0 to 23). The hour of the day is in the time zone
	// of the gateway.
	//
	// StartAt is a required field
	StartAt *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSnapshotScheduleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RecurrenceInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RecurrenceInHours"))
	}
	if s.RecurrenceInHours != nil && *s.RecurrenceInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RecurrenceInHours", 1))
	}
	if s.StartAt == nil {
		invalidParams.Add(request.NewErrParamRequired("StartAt"))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the updated storage volume.
type UpdateSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleOutput) GoString() string {
	return s.String()
}

type UpdateVTLDeviceTypeInput struct {
	_ struct{} `type:"structure"`

	// The type of medium changer you want to select.
	//
	// Valid Values: "STK-L700", "AWS-Gateway-VTL"
	//
	// DeviceType is a required field
	DeviceType *string `min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the medium changer you want to select.
	//
	// VTLDeviceARN is a required field
	VTLDeviceARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVTLDeviceTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVTLDeviceTypeInput"}
	if s.DeviceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceType"))
	}
	if s.DeviceType != nil && len(*s.DeviceType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceType", 2))
	}
	if s.VTLDeviceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VTLDeviceARN"))
	}
	if s.VTLDeviceARN != nil && len(*s.VTLDeviceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VTLDeviceARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// UpdateVTLDeviceTypeOutput
type UpdateVTLDeviceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the medium changer you have selected.
	VTLDeviceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeOutput) GoString() string {
	return s.String()
}

// Represents a device object associated with a gateway-VTL.
type VTLDevice struct {
	_ struct{} `type:"structure"`

	// A list of iSCSI information about a VTL device.
	DeviceiSCSIAttributes *DeviceiSCSIAttributes `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) of the device (tape drive
	// or media changer).
	VTLDeviceARN *string `min:"50" type:"string"`

	VTLDeviceProductIdentifier *string `type:"string"`

	VTLDeviceType *string `type:"string"`

	VTLDeviceVendor *string `type:"string"`
}

// String returns the string representation
func (s VTLDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VTLDevice) GoString() string {
	return s.String()
}

// Describes a storage volume object.
type VolumeInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	GatewayId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) for the storage volume. For example, the following
	// is a valid ARN:
	//
	// arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeARN *string `min:"50" type:"string"`

	// The unique identifier assigned to the volume. This ID becomes part of the
	// volume Amazon Resource Name (ARN), which you use as input for other operations.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeId *string `min:"12" type:"string"`

	// The size, in bytes, of the volume.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeSizeInBytes *int64 `type:"long"`

	VolumeType *string `min:"3" type:"string"`
}

// String returns the string representation
func (s VolumeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeInfo) GoString() string {
	return s.String()
}

type VolumeRecoveryPointInfo struct {
	_ struct{} `type:"structure"`

	VolumeARN *string `min:"50" type:"string"`

	VolumeRecoveryPointTime *string `type:"string"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeUsageInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s VolumeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeRecoveryPointInfo) GoString() string {
	return s.String()
}

// Lists iSCSI information about a volume.
type VolumeiSCSIAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The logical disk number.
	LunNumber *int64 `min:"1" type:"integer"`

	// The network interface identifier.
	NetworkInterfaceId *string `type:"string"`

	// The port used to communicate with iSCSI targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the volume target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s VolumeiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeiSCSIAttributes) GoString() string {
	return s.String()
}

const (
	// ErrorCodeActivationKeyExpired is a ErrorCode enum value
	ErrorCodeActivationKeyExpired = "ActivationKeyExpired"

	// ErrorCodeActivationKeyInvalid is a ErrorCode enum value
	ErrorCodeActivationKeyInvalid = "ActivationKeyInvalid"

	// ErrorCodeActivationKeyNotFound is a ErrorCode enum value
	ErrorCodeActivationKeyNotFound = "ActivationKeyNotFound"

	// ErrorCodeGatewayInternalError is a ErrorCode enum value
	ErrorCodeGatewayInternalError = "GatewayInternalError"

	// ErrorCodeGatewayNotConnected is a ErrorCode enum value
	ErrorCodeGatewayNotConnected = "GatewayNotConnected"

	// ErrorCodeGatewayNotFound is a ErrorCode enum value
	ErrorCodeGatewayNotFound = "GatewayNotFound"

	// ErrorCodeGatewayProxyNetworkConnectionBusy is a ErrorCode enum value
	ErrorCodeGatewayProxyNetworkConnectionBusy = "GatewayProxyNetworkConnectionBusy"

	// ErrorCodeAuthenticationFailure is a ErrorCode enum value
	ErrorCodeAuthenticationFailure = "AuthenticationFailure"

	// ErrorCodeBandwidthThrottleScheduleNotFound is a ErrorCode enum value
	ErrorCodeBandwidthThrottleScheduleNotFound = "BandwidthThrottleScheduleNotFound"

	// ErrorCodeBlocked is a ErrorCode enum value
	ErrorCodeBlocked = "Blocked"

	// ErrorCodeCannotExportSnapshot is a ErrorCode enum value
	ErrorCodeCannotExportSnapshot = "CannotExportSnapshot"

	// ErrorCodeChapCredentialNotFound is a ErrorCode enum value
	ErrorCodeChapCredentialNotFound = "ChapCredentialNotFound"

	// ErrorCodeDiskAlreadyAllocated is a ErrorCode enum value
	ErrorCodeDiskAlreadyAllocated = "DiskAlreadyAllocated"

	// ErrorCodeDiskDoesNotExist is a ErrorCode enum value
	ErrorCodeDiskDoesNotExist = "DiskDoesNotExist"

	// ErrorCodeDiskSizeGreaterThanVolumeMaxSize is a ErrorCode enum value
	ErrorCodeDiskSizeGreaterThanVolumeMaxSize = "DiskSizeGreaterThanVolumeMaxSize"

	// ErrorCodeDiskSizeLessThanVolumeSize is a ErrorCode enum value
	ErrorCodeDiskSizeLessThanVolumeSize = "DiskSizeLessThanVolumeSize"

	// ErrorCodeDiskSizeNotGigAligned is a ErrorCode enum value
	ErrorCodeDiskSizeNotGigAligned = "DiskSizeNotGigAligned"

	// ErrorCodeDuplicateCertificateInfo is a ErrorCode enum value
	ErrorCodeDuplicateCertificateInfo = "DuplicateCertificateInfo"

	// ErrorCodeDuplicateSchedule is a ErrorCode enum value
	ErrorCodeDuplicateSchedule = "DuplicateSchedule"

	// ErrorCodeEndpointNotFound is a ErrorCode enum value
	ErrorCodeEndpointNotFound = "EndpointNotFound"

	// ErrorCodeIamnotSupported is a ErrorCode enum value
	ErrorCodeIamnotSupported = "IAMNotSupported"

	// ErrorCodeInitiatorInvalid is a ErrorCode enum value
	ErrorCodeInitiatorInvalid = "InitiatorInvalid"

	// ErrorCodeInitiatorNotFound is a ErrorCode enum value
	ErrorCodeInitiatorNotFound = "InitiatorNotFound"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"

	// ErrorCodeInvalidGateway is a ErrorCode enum value
	ErrorCodeInvalidGateway = "InvalidGateway"

	// ErrorCodeInvalidEndpoint is a ErrorCode enum value
	ErrorCodeInvalidEndpoint = "InvalidEndpoint"

	// ErrorCodeInvalidParameters is a ErrorCode enum value
	ErrorCodeInvalidParameters = "InvalidParameters"

	// ErrorCodeInvalidSchedule is a ErrorCode enum value
	ErrorCodeInvalidSchedule = "InvalidSchedule"

	// ErrorCodeLocalStorageLimitExceeded is a ErrorCode enum value
	ErrorCodeLocalStorageLimitExceeded = "LocalStorageLimitExceeded"

	// ErrorCodeLunAlreadyAllocated is a ErrorCode enum value
	ErrorCodeLunAlreadyAllocated = "LunAlreadyAllocated "

	// ErrorCodeLunInvalid is a ErrorCode enum value
	ErrorCodeLunInvalid = "LunInvalid"

	// ErrorCodeMaximumContentLengthExceeded is a ErrorCode enum value
	ErrorCodeMaximumContentLengthExceeded = "MaximumContentLengthExceeded"

	// ErrorCodeMaximumTapeCartridgeCountExceeded is a ErrorCode enum value
	ErrorCodeMaximumTapeCartridgeCountExceeded = "MaximumTapeCartridgeCountExceeded"

	// ErrorCodeMaximumVolumeCountExceeded is a ErrorCode enum value
	ErrorCodeMaximumVolumeCountExceeded = "MaximumVolumeCountExceeded"

	// ErrorCodeNetworkConfigurationChanged is a ErrorCode enum value
	ErrorCodeNetworkConfigurationChanged = "NetworkConfigurationChanged"

	// ErrorCodeNoDisksAvailable is a ErrorCode enum value
	ErrorCodeNoDisksAvailable = "NoDisksAvailable"

	// ErrorCodeNotImplemented is a ErrorCode enum value
	ErrorCodeNotImplemented = "NotImplemented"

	// ErrorCodeNotSupported is a ErrorCode enum value
	ErrorCodeNotSupported = "NotSupported"

	// ErrorCodeOperationAborted is a ErrorCode enum value
	ErrorCodeOperationAborted = "OperationAborted"

	// ErrorCodeOutdatedGateway is a ErrorCode enum value
	ErrorCodeOutdatedGateway = "OutdatedGateway"

	// ErrorCodeParametersNotImplemented is a ErrorCode enum value
	ErrorCodeParametersNotImplemented = "ParametersNotImplemented"

	// ErrorCodeRegionInvalid is a ErrorCode enum value
	ErrorCodeRegionInvalid = "RegionInvalid"

	// ErrorCodeRequestTimeout is a ErrorCode enum value
	ErrorCodeRequestTimeout = "RequestTimeout"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeSnapshotDeleted is a ErrorCode enum value
	ErrorCodeSnapshotDeleted = "SnapshotDeleted"

	// ErrorCodeSnapshotIdInvalid is a ErrorCode enum value
	ErrorCodeSnapshotIdInvalid = "SnapshotIdInvalid"

	// ErrorCodeSnapshotInProgress is a ErrorCode enum value
	ErrorCodeSnapshotInProgress = "SnapshotInProgress"

	// ErrorCodeSnapshotNotFound is a ErrorCode enum value
	ErrorCodeSnapshotNotFound = "SnapshotNotFound"

	// ErrorCodeSnapshotScheduleNotFound is a ErrorCode enum value
	ErrorCodeSnapshotScheduleNotFound = "SnapshotScheduleNotFound"

	// ErrorCodeStagingAreaFull is a ErrorCode enum value
	ErrorCodeStagingAreaFull = "StagingAreaFull"

	// ErrorCodeStorageFailure is a ErrorCode enum value
	ErrorCodeStorageFailure = "StorageFailure"

	// ErrorCodeTapeCartridgeNotFound is a ErrorCode enum value
	ErrorCodeTapeCartridgeNotFound = "TapeCartridgeNotFound"

	// ErrorCodeTargetAlreadyExists is a ErrorCode enum value
	ErrorCodeTargetAlreadyExists = "TargetAlreadyExists"

	// ErrorCodeTargetInvalid is a ErrorCode enum value
	ErrorCodeTargetInvalid = "TargetInvalid"

	// ErrorCodeTargetNotFound is a ErrorCode enum value
	ErrorCodeTargetNotFound = "TargetNotFound"

	// ErrorCodeUnauthorizedOperation is a ErrorCode enum value
	ErrorCodeUnauthorizedOperation = "UnauthorizedOperation"

	// ErrorCodeVolumeAlreadyExists is a ErrorCode enum value
	ErrorCodeVolumeAlreadyExists = "VolumeAlreadyExists"

	// ErrorCodeVolumeIdInvalid is a ErrorCode enum value
	ErrorCodeVolumeIdInvalid = "VolumeIdInvalid"

	// ErrorCodeVolumeInUse is a ErrorCode enum value
	ErrorCodeVolumeInUse = "VolumeInUse"

	// ErrorCodeVolumeNotFound is a ErrorCode enum value
	ErrorCodeVolumeNotFound = "VolumeNotFound"

	// ErrorCodeVolumeNotReady is a ErrorCode enum value
	ErrorCodeVolumeNotReady = "VolumeNotReady"
)
