// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package datapipeline provides a client for AWS Data Pipeline.
package datapipeline

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opActivatePipeline = "ActivatePipeline"

// ActivatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the ActivatePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ActivatePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ActivatePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ActivatePipelineRequest method.
//    req, resp := client.ActivatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) ActivatePipelineRequest(input *ActivatePipelineInput) (req *request.Request, output *ActivatePipelineOutput) {
	op := &request.Operation{
		Name:       opActivatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivatePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ActivatePipelineOutput{}
	req.Data = output
	return
}

// ActivatePipeline API operation for AWS Data Pipeline.
//
// Validates the specified pipeline and starts processing pipeline tasks. If
// the pipeline does not pass validation, activation fails.
//
// If you need to pause the pipeline to investigate an issue with a component,
// such as a data source or script, call DeactivatePipeline.
//
// To activate a finished pipeline, modify the end date for the pipeline and
// then activate it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation ActivatePipeline for usage and error information.
//
// Returned Error Codes:
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) ActivatePipeline(input *ActivatePipelineInput) (*ActivatePipelineOutput, error) {
	req, out := c.ActivatePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// AddTags API operation for AWS Data Pipeline.
//
// Adds or modifies tags for the specified pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePipelineRequest method.
//    req, resp := client.CreatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePipelineOutput{}
	req.Data = output
	return
}

// CreatePipeline API operation for AWS Data Pipeline.
//
// Creates a new, empty pipeline. Use PutPipelineDefinition to populate the
// pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opDeactivatePipeline = "DeactivatePipeline"

// DeactivatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeactivatePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeactivatePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeactivatePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeactivatePipelineRequest method.
//    req, resp := client.DeactivatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) DeactivatePipelineRequest(input *DeactivatePipelineInput) (req *request.Request, output *DeactivatePipelineOutput) {
	op := &request.Operation{
		Name:       opDeactivatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivatePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeactivatePipelineOutput{}
	req.Data = output
	return
}

// DeactivatePipeline API operation for AWS Data Pipeline.
//
// Deactivates the specified running pipeline. The pipeline is set to the DEACTIVATING
// state until the deactivation process completes.
//
// To resume a deactivated pipeline, use ActivatePipeline. By default, the pipeline
// resumes from the last completed execution. Optionally, you can specify the
// date and time to resume the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation DeactivatePipeline for usage and error information.
//
// Returned Error Codes:
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) DeactivatePipeline(input *DeactivatePipelineInput) (*DeactivatePipelineOutput, error) {
	req, out := c.DeactivatePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePipelineRequest method.
//    req, resp := client.DeletePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePipelineOutput{}
	req.Data = output
	return
}

// DeletePipeline API operation for AWS Data Pipeline.
//
// Deletes a pipeline, its pipeline definition, and its run history. AWS Data
// Pipeline attempts to cancel instances associated with the pipeline that are
// currently being processed by task runners.
//
// Deleting a pipeline cannot be undone. You cannot query or restore a deleted
// pipeline. To temporarily pause a pipeline instead of deleting it, call SetStatus
// with the status set to PAUSE on individual components. Components that are
// paused by SetStatus can be resumed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Codes:
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeObjects = "DescribeObjects"

// DescribeObjectsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeObjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeObjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeObjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeObjectsRequest method.
//    req, resp := client.DescribeObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) DescribeObjectsRequest(input *DescribeObjectsInput) (req *request.Request, output *DescribeObjectsOutput) {
	op := &request.Operation{
		Name:       opDescribeObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"marker"},
			LimitToken:      "",
			TruncationToken: "hasMoreResults",
		},
	}

	if input == nil {
		input = &DescribeObjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeObjectsOutput{}
	req.Data = output
	return
}

// DescribeObjects API operation for AWS Data Pipeline.
//
// Gets the object definitions for a set of objects associated with the pipeline.
// Object definitions are composed of a set of fields that define the properties
// of the object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation DescribeObjects for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) DescribeObjects(input *DescribeObjectsInput) (*DescribeObjectsOutput, error) {
	req, out := c.DescribeObjectsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeObjectsPages iterates over the pages of a DescribeObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeObjects operation.
//    pageNum := 0
//    err := client.DescribeObjectsPages(params,
//        func(page *DescribeObjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataPipeline) DescribeObjectsPages(input *DescribeObjectsInput, fn func(p *DescribeObjectsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeObjectsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeObjectsOutput), lastPage)
	})
}

const opDescribePipelines = "DescribePipelines"

// DescribePipelinesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePipelines operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribePipelines for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribePipelines method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribePipelinesRequest method.
//    req, resp := client.DescribePipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) DescribePipelinesRequest(input *DescribePipelinesInput) (req *request.Request, output *DescribePipelinesOutput) {
	op := &request.Operation{
		Name:       opDescribePipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePipelinesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePipelinesOutput{}
	req.Data = output
	return
}

// DescribePipelines API operation for AWS Data Pipeline.
//
// Retrieves metadata about one or more pipelines. The information retrieved
// includes the name of the pipeline, the pipeline identifier, its current state,
// and the user account that owns the pipeline. Using account credentials, you
// can retrieve metadata about pipelines that you or your IAM users have created.
// If you are using an IAM user account, you can retrieve metadata about only
// those pipelines for which you have read permissions.
//
// To retrieve the full pipeline definition instead of metadata about the pipeline,
// call GetPipelineDefinition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation DescribePipelines for usage and error information.
//
// Returned Error Codes:
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) DescribePipelines(input *DescribePipelinesInput) (*DescribePipelinesOutput, error) {
	req, out := c.DescribePipelinesRequest(input)
	err := req.Send()
	return out, err
}

const opEvaluateExpression = "EvaluateExpression"

// EvaluateExpressionRequest generates a "aws/request.Request" representing the
// client's request for the EvaluateExpression operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EvaluateExpression for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EvaluateExpression method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EvaluateExpressionRequest method.
//    req, resp := client.EvaluateExpressionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) EvaluateExpressionRequest(input *EvaluateExpressionInput) (req *request.Request, output *EvaluateExpressionOutput) {
	op := &request.Operation{
		Name:       opEvaluateExpression,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EvaluateExpressionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EvaluateExpressionOutput{}
	req.Data = output
	return
}

// EvaluateExpression API operation for AWS Data Pipeline.
//
// Task runners call EvaluateExpression to evaluate a string in the context
// of the specified object. For example, a task runner can evaluate SQL queries
// stored in Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation EvaluateExpression for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * TaskNotFoundException
//   The specified task was not found.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) EvaluateExpression(input *EvaluateExpressionInput) (*EvaluateExpressionOutput, error) {
	req, out := c.EvaluateExpressionRequest(input)
	err := req.Send()
	return out, err
}

const opGetPipelineDefinition = "GetPipelineDefinition"

// GetPipelineDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineDefinition operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPipelineDefinition for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPipelineDefinition method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPipelineDefinitionRequest method.
//    req, resp := client.GetPipelineDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) GetPipelineDefinitionRequest(input *GetPipelineDefinitionInput) (req *request.Request, output *GetPipelineDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetPipelineDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineDefinitionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPipelineDefinitionOutput{}
	req.Data = output
	return
}

// GetPipelineDefinition API operation for AWS Data Pipeline.
//
// Gets the definition of the specified pipeline. You can call GetPipelineDefinition
// to retrieve the pipeline definition that you provided using PutPipelineDefinition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation GetPipelineDefinition for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) GetPipelineDefinition(input *GetPipelineDefinitionInput) (*GetPipelineDefinitionOutput, error) {
	req, out := c.GetPipelineDefinitionRequest(input)
	err := req.Send()
	return out, err
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPipelines for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPipelines method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPipelinesRequest method.
//    req, resp := client.ListPipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"marker"},
			LimitToken:      "",
			TruncationToken: "hasMoreResults",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPipelinesOutput{}
	req.Data = output
	return
}

// ListPipelines API operation for AWS Data Pipeline.
//
// Lists the pipeline identifiers for all active pipelines that you have permission
// to access.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation ListPipelines for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	err := req.Send()
	return out, err
}

// ListPipelinesPages iterates over the pages of a ListPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelines operation.
//    pageNum := 0
//    err := client.ListPipelinesPages(params,
//        func(page *ListPipelinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataPipeline) ListPipelinesPages(input *ListPipelinesInput, fn func(p *ListPipelinesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPipelinesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPipelinesOutput), lastPage)
	})
}

const opPollForTask = "PollForTask"

// PollForTaskRequest generates a "aws/request.Request" representing the
// client's request for the PollForTask operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PollForTask for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PollForTask method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PollForTaskRequest method.
//    req, resp := client.PollForTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) PollForTaskRequest(input *PollForTaskInput) (req *request.Request, output *PollForTaskOutput) {
	op := &request.Operation{
		Name:       opPollForTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PollForTaskOutput{}
	req.Data = output
	return
}

// PollForTask API operation for AWS Data Pipeline.
//
// Task runners call PollForTask to receive a task to perform from AWS Data
// Pipeline. The task runner specifies which tasks it can perform by setting
// a value for the workerGroup parameter. The task returned can come from any
// of the pipelines that match the workerGroup value passed in by the task runner
// and that was launched using the IAM user credentials specified by the task
// runner.
//
// If tasks are ready in the work queue, PollForTask returns a response immediately.
// If no tasks are available in the queue, PollForTask uses long-polling and
// holds on to a poll connection for up to a 90 seconds, during which time the
// first newly scheduled task is handed to the task runner. To accomodate this,
// set the socket timeout in your task runner to 90 seconds. The task runner
// should not call PollForTask again on the same workerGroup until it receives
// a response, and this can take up to 90 seconds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation PollForTask for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * TaskNotFoundException
//   The specified task was not found.
//
func (c *DataPipeline) PollForTask(input *PollForTaskInput) (*PollForTaskOutput, error) {
	req, out := c.PollForTaskRequest(input)
	err := req.Send()
	return out, err
}

const opPutPipelineDefinition = "PutPipelineDefinition"

// PutPipelineDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the PutPipelineDefinition operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutPipelineDefinition for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutPipelineDefinition method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutPipelineDefinitionRequest method.
//    req, resp := client.PutPipelineDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) PutPipelineDefinitionRequest(input *PutPipelineDefinitionInput) (req *request.Request, output *PutPipelineDefinitionOutput) {
	op := &request.Operation{
		Name:       opPutPipelineDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPipelineDefinitionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutPipelineDefinitionOutput{}
	req.Data = output
	return
}

// PutPipelineDefinition API operation for AWS Data Pipeline.
//
// Adds tasks, schedules, and preconditions to the specified pipeline. You can
// use PutPipelineDefinition to populate a new pipeline.
//
// PutPipelineDefinition also validates the configuration as it adds it to the
// pipeline. Changes to the pipeline are saved unless one of the following three
// validation errors exists in the pipeline.
//
// An object is missing a name or identifier field.
// A string or reference field is empty.
// The number of objects in the pipeline exceeds the maximum allowed objects.
//
// The pipeline is in a FINISHED state.
// Pipeline object definitions are passed to the PutPipelineDefinition action
// and returned by the GetPipelineDefinition action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation PutPipelineDefinition for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) PutPipelineDefinition(input *PutPipelineDefinitionInput) (*PutPipelineDefinitionOutput, error) {
	req, out := c.PutPipelineDefinitionRequest(input)
	err := req.Send()
	return out, err
}

const opQueryObjects = "QueryObjects"

// QueryObjectsRequest generates a "aws/request.Request" representing the
// client's request for the QueryObjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See QueryObjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the QueryObjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the QueryObjectsRequest method.
//    req, resp := client.QueryObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) QueryObjectsRequest(input *QueryObjectsInput) (req *request.Request, output *QueryObjectsOutput) {
	op := &request.Operation{
		Name:       opQueryObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"marker"},
			LimitToken:      "limit",
			TruncationToken: "hasMoreResults",
		},
	}

	if input == nil {
		input = &QueryObjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &QueryObjectsOutput{}
	req.Data = output
	return
}

// QueryObjects API operation for AWS Data Pipeline.
//
// Queries the specified pipeline for the names of objects that match the specified
// set of conditions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation QueryObjects for usage and error information.
//
// Returned Error Codes:
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) QueryObjects(input *QueryObjectsInput) (*QueryObjectsOutput, error) {
	req, out := c.QueryObjectsRequest(input)
	err := req.Send()
	return out, err
}

// QueryObjectsPages iterates over the pages of a QueryObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See QueryObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a QueryObjects operation.
//    pageNum := 0
//    err := client.QueryObjectsPages(params,
//        func(page *QueryObjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataPipeline) QueryObjectsPages(input *QueryObjectsInput, fn func(p *QueryObjectsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.QueryObjectsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*QueryObjectsOutput), lastPage)
	})
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// RemoveTags API operation for AWS Data Pipeline.
//
// Removes existing tags from the specified pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opReportTaskProgress = "ReportTaskProgress"

// ReportTaskProgressRequest generates a "aws/request.Request" representing the
// client's request for the ReportTaskProgress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReportTaskProgress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReportTaskProgress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReportTaskProgressRequest method.
//    req, resp := client.ReportTaskProgressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) ReportTaskProgressRequest(input *ReportTaskProgressInput) (req *request.Request, output *ReportTaskProgressOutput) {
	op := &request.Operation{
		Name:       opReportTaskProgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReportTaskProgressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReportTaskProgressOutput{}
	req.Data = output
	return
}

// ReportTaskProgress API operation for AWS Data Pipeline.
//
// Task runners call ReportTaskProgress when assigned a task to acknowledge
// that it has the task. If the web service does not receive this acknowledgement
// within 2 minutes, it assigns the task in a subsequent PollForTask call. After
// this initial acknowledgement, the task runner only needs to report progress
// every 15 minutes to maintain its ownership of the task. You can change this
// reporting time from 15 minutes by specifying a reportProgressTimeout field
// in your pipeline.
//
// If a task runner does not report its status after 5 minutes, AWS Data Pipeline
// assumes that the task runner is unable to process the task and reassigns
// the task in a subsequent response to PollForTask. Task runners should call
// ReportTaskProgress every 60 seconds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation ReportTaskProgress for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * TaskNotFoundException
//   The specified task was not found.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) ReportTaskProgress(input *ReportTaskProgressInput) (*ReportTaskProgressOutput, error) {
	req, out := c.ReportTaskProgressRequest(input)
	err := req.Send()
	return out, err
}

const opReportTaskRunnerHeartbeat = "ReportTaskRunnerHeartbeat"

// ReportTaskRunnerHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the ReportTaskRunnerHeartbeat operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReportTaskRunnerHeartbeat for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReportTaskRunnerHeartbeat method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReportTaskRunnerHeartbeatRequest method.
//    req, resp := client.ReportTaskRunnerHeartbeatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) ReportTaskRunnerHeartbeatRequest(input *ReportTaskRunnerHeartbeatInput) (req *request.Request, output *ReportTaskRunnerHeartbeatOutput) {
	op := &request.Operation{
		Name:       opReportTaskRunnerHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReportTaskRunnerHeartbeatInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReportTaskRunnerHeartbeatOutput{}
	req.Data = output
	return
}

// ReportTaskRunnerHeartbeat API operation for AWS Data Pipeline.
//
// Task runners call ReportTaskRunnerHeartbeat every 15 minutes to indicate
// that they are operational. If the AWS Data Pipeline Task Runner is launched
// on a resource managed by AWS Data Pipeline, the web service can use this
// call to detect when the task runner application has failed and restart a
// new instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation ReportTaskRunnerHeartbeat for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) ReportTaskRunnerHeartbeat(input *ReportTaskRunnerHeartbeatInput) (*ReportTaskRunnerHeartbeatOutput, error) {
	req, out := c.ReportTaskRunnerHeartbeatRequest(input)
	err := req.Send()
	return out, err
}

const opSetStatus = "SetStatus"

// SetStatusRequest generates a "aws/request.Request" representing the
// client's request for the SetStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetStatusRequest method.
//    req, resp := client.SetStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) SetStatusRequest(input *SetStatusInput) (req *request.Request, output *SetStatusOutput) {
	op := &request.Operation{
		Name:       opSetStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStatusInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetStatusOutput{}
	req.Data = output
	return
}

// SetStatus API operation for AWS Data Pipeline.
//
// Requests that the status of the specified physical or logical pipeline objects
// be updated in the specified pipeline. This update might not occur immediately,
// but is eventually consistent. The status that can be set depends on the type
// of object (for example, DataNode or Activity). You cannot perform this operation
// on FINISHED pipelines and attempting to do so returns InvalidRequestException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation SetStatus for usage and error information.
//
// Returned Error Codes:
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
func (c *DataPipeline) SetStatus(input *SetStatusInput) (*SetStatusOutput, error) {
	req, out := c.SetStatusRequest(input)
	err := req.Send()
	return out, err
}

const opSetTaskStatus = "SetTaskStatus"

// SetTaskStatusRequest generates a "aws/request.Request" representing the
// client's request for the SetTaskStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetTaskStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetTaskStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetTaskStatusRequest method.
//    req, resp := client.SetTaskStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) SetTaskStatusRequest(input *SetTaskStatusInput) (req *request.Request, output *SetTaskStatusOutput) {
	op := &request.Operation{
		Name:       opSetTaskStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTaskStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetTaskStatusOutput{}
	req.Data = output
	return
}

// SetTaskStatus API operation for AWS Data Pipeline.
//
// Task runners call SetTaskStatus to notify AWS Data Pipeline that a task is
// completed and provide information about the final status. A task runner makes
// this call regardless of whether the task was sucessful. A task runner does
// not need to call SetTaskStatus for tasks that are canceled by the web service
// during a call to ReportTaskProgress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation SetTaskStatus for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * TaskNotFoundException
//   The specified task was not found.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) SetTaskStatus(input *SetTaskStatusInput) (*SetTaskStatusOutput, error) {
	req, out := c.SetTaskStatusRequest(input)
	err := req.Send()
	return out, err
}

const opValidatePipelineDefinition = "ValidatePipelineDefinition"

// ValidatePipelineDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the ValidatePipelineDefinition operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ValidatePipelineDefinition for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ValidatePipelineDefinition method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ValidatePipelineDefinitionRequest method.
//    req, resp := client.ValidatePipelineDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DataPipeline) ValidatePipelineDefinitionRequest(input *ValidatePipelineDefinitionInput) (req *request.Request, output *ValidatePipelineDefinitionOutput) {
	op := &request.Operation{
		Name:       opValidatePipelineDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidatePipelineDefinitionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ValidatePipelineDefinitionOutput{}
	req.Data = output
	return
}

// ValidatePipelineDefinition API operation for AWS Data Pipeline.
//
// Validates the specified pipeline definition to ensure that it is well formed
// and can be run without error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Data Pipeline's
// API operation ValidatePipelineDefinition for usage and error information.
//
// Returned Error Codes:
//   * InternalServiceError
//   An internal service error occurred.
//
//   * InvalidRequestException
//   The request was not valid. Verify that your request was properly formatted,
//   that the signature was generated with the correct credentials, and that you
//   haven't exceeded any of the service limits for your account.
//
//   * PipelineNotFoundException
//   The specified pipeline was not found. Verify that you used the correct user
//   and account identifiers.
//
//   * PipelineDeletedException
//   The specified pipeline has been deleted.
//
func (c *DataPipeline) ValidatePipelineDefinition(input *ValidatePipelineDefinitionInput) (*ValidatePipelineDefinitionOutput, error) {
	req, out := c.ValidatePipelineDefinitionRequest(input)
	err := req.Send()
	return out, err
}

// Contains the parameters for ActivatePipeline.
type ActivatePipelineInput struct {
	_ struct{} `type:"structure"`

	// A list of parameter values to pass to the pipeline at activation.
	ParameterValues []*ParameterValue `locationName:"parameterValues" type:"list"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The date and time to resume the pipeline. By default, the pipeline resumes
	// from the last completed execution.
	StartTimestamp *time.Time `locationName:"startTimestamp" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ActivatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivatePipelineInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.ParameterValues != nil {
		for i, v := range s.ParameterValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ActivatePipeline.
type ActivatePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ActivatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivatePipelineOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AddTags.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The tags to add, as key/value pairs.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of AddTags.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreatePipeline.
type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// The description for the pipeline.
	Description *string `locationName:"description" type:"string"`

	// The name for the pipeline. You can use the same name for multiple pipelines
	// associated with your AWS account, because AWS Data Pipeline assigns each
	// pipeline a unique pipeline identifier.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of tags to associate with the pipeline at creation. Tags let you control
	// access to pipelines. For more information, see Controlling User Access to
	// Pipelines (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html)
	// in the AWS Data Pipeline Developer Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A unique identifier. This identifier is not the same as the pipeline identifier
	// assigned by AWS Data Pipeline. You are responsible for defining the format
	// and ensuring the uniqueness of this identifier. You use this parameter to
	// ensure idempotency during repeated calls to CreatePipeline. For example,
	// if the first call to CreatePipeline does not succeed, you can pass in the
	// same unique identifier and pipeline name combination on a subsequent call
	// to CreatePipeline. CreatePipeline ensures that if a pipeline already exists
	// with the same name and unique identifier, a new pipeline is not created.
	// Instead, you'll receive the pipeline identifier from the previous attempt.
	// The uniqueness of the name and unique identifier combination is scoped to
	// the AWS account or IAM user credentials.
	//
	// UniqueId is a required field
	UniqueId *string `locationName:"uniqueId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipelineInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UniqueId == nil {
		invalidParams.Add(request.NewErrParamRequired("UniqueId"))
	}
	if s.UniqueId != nil && len(*s.UniqueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreatePipeline.
type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The ID that AWS Data Pipeline assigns the newly created pipeline. For example,
	// df-06372391ZG65EXAMPLE.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeactivatePipeline.
type DeactivatePipelineInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to cancel any running objects. The default is true, which
	// sets the state of any running objects to CANCELED. If this value is false,
	// the pipeline is deactivated after all running objects finish.
	CancelActive *bool `locationName:"cancelActive" type:"boolean"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivatePipelineInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeactivatePipeline.
type DeactivatePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeactivatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivatePipelineOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeletePipeline.
type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipelineInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeObjects.
type DescribeObjectsInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether any expressions in the object should be evaluated when
	// the object descriptions are returned.
	EvaluateExpressions *bool `locationName:"evaluateExpressions" type:"boolean"`

	// The starting point for the results to be returned. For the first call, this
	// value should be empty. As long as there are more results, continue to call
	// DescribeObjects with the marker value from the previous call to retrieve
	// the next set of results.
	Marker *string `locationName:"marker" type:"string"`

	// The IDs of the pipeline objects that contain the definitions to be described.
	// You can pass as many as 25 identifiers in a single call to DescribeObjects.
	//
	// ObjectIds is a required field
	ObjectIds []*string `locationName:"objectIds" type:"list" required:"true"`

	// The ID of the pipeline that contains the object definitions.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeObjectsInput"}
	if s.ObjectIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectIds"))
	}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeObjects.
type DescribeObjectsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are more results to return.
	HasMoreResults *bool `locationName:"hasMoreResults" type:"boolean"`

	// The starting point for the next page of results. To view the next page of
	// results, call DescribeObjects again with this marker value. If the value
	// is null, there are no more results.
	Marker *string `locationName:"marker" type:"string"`

	// An array of object definitions.
	//
	// PipelineObjects is a required field
	PipelineObjects []*PipelineObject `locationName:"pipelineObjects" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeObjectsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribePipelines.
type DescribePipelinesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the pipelines to describe. You can pass as many as 25 identifiers
	// in a single call. To obtain pipeline IDs, call ListPipelines.
	//
	// PipelineIds is a required field
	PipelineIds []*string `locationName:"pipelineIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribePipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePipelinesInput"}
	if s.PipelineIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribePipelines.
type DescribePipelinesOutput struct {
	_ struct{} `type:"structure"`

	// An array of descriptions for the specified pipelines.
	//
	// PipelineDescriptionList is a required field
	PipelineDescriptionList []*PipelineDescription `locationName:"pipelineDescriptionList" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribePipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePipelinesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for EvaluateExpression.
type EvaluateExpressionInput struct {
	_ struct{} `type:"structure"`

	// The expression to evaluate.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" type:"string" required:"true"`

	// The ID of the object.
	//
	// ObjectId is a required field
	ObjectId *string `locationName:"objectId" min:"1" type:"string" required:"true"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EvaluateExpressionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluateExpressionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluateExpressionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluateExpressionInput"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.ObjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectId"))
	}
	if s.ObjectId != nil && len(*s.ObjectId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectId", 1))
	}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of EvaluateExpression.
type EvaluateExpressionOutput struct {
	_ struct{} `type:"structure"`

	// The evaluated expression.
	//
	// EvaluatedExpression is a required field
	EvaluatedExpression *string `locationName:"evaluatedExpression" type:"string" required:"true"`
}

// String returns the string representation
func (s EvaluateExpressionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluateExpressionOutput) GoString() string {
	return s.String()
}

// A key-value pair that describes a property of a pipeline object. The value
// is specified as either a string value (StringValue) or a reference to another
// object (RefValue) but not as both.
type Field struct {
	_ struct{} `type:"structure"`

	// The field identifier.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The field value, expressed as the identifier of another object.
	RefValue *string `locationName:"refValue" min:"1" type:"string"`

	// The field value, expressed as a String.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation
func (s Field) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Field) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Field) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Field"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RefValue != nil && len(*s.RefValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RefValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for GetPipelineDefinition.
type GetPipelineDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The version of the pipeline definition to retrieve. Set this parameter to
	// latest (default) to use the last definition saved to the pipeline or active
	// to use the last definition that was activated.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s GetPipelineDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineDefinitionInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of GetPipelineDefinition.
type GetPipelineDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The parameter objects used in the pipeline definition.
	ParameterObjects []*ParameterObject `locationName:"parameterObjects" type:"list"`

	// The parameter values used in the pipeline definition.
	ParameterValues []*ParameterValue `locationName:"parameterValues" type:"list"`

	// The objects defined in the pipeline.
	PipelineObjects []*PipelineObject `locationName:"pipelineObjects" type:"list"`
}

// String returns the string representation
func (s GetPipelineDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineDefinitionOutput) GoString() string {
	return s.String()
}

// Identity information for the EC2 instance that is hosting the task runner.
// You can get this value by calling a metadata URI from the EC2 instance. For
// more information, see Instance Metadata (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html)
// in the Amazon Elastic Compute Cloud User Guide. Passing in this value proves
// that your task runner is running on an EC2 instance, and ensures the proper
// AWS Data Pipeline service charges are applied to your pipeline.
type InstanceIdentity struct {
	_ struct{} `type:"structure"`

	// A description of an EC2 instance that is generated when the instance is launched
	// and exposed to the instance via the instance metadata service in the form
	// of a JSON representation of an object.
	Document *string `locationName:"document" type:"string"`

	// A signature which can be used to verify the accuracy and authenticity of
	// the information provided in the instance identity document.
	Signature *string `locationName:"signature" type:"string"`
}

// String returns the string representation
func (s InstanceIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceIdentity) GoString() string {
	return s.String()
}

// Contains the parameters for ListPipelines.
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// The starting point for the results to be returned. For the first call, this
	// value should be empty. As long as there are more results, continue to call
	// ListPipelines with the marker value from the previous call to retrieve the
	// next set of results.
	Marker *string `locationName:"marker" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// Contains the output of ListPipelines.
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are more results that can be obtained by a subsequent
	// call.
	HasMoreResults *bool `locationName:"hasMoreResults" type:"boolean"`

	// The starting point for the next page of results. To view the next page of
	// results, call ListPipelinesOutput again with this marker value. If the value
	// is null, there are no more results.
	Marker *string `locationName:"marker" type:"string"`

	// The pipeline identifiers. If you require additional information about the
	// pipelines, you can use these identifiers to call DescribePipelines and GetPipelineDefinition.
	//
	// PipelineIdList is a required field
	PipelineIdList []*PipelineIdName `locationName:"pipelineIdList" type:"list" required:"true"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// Contains a logical operation for comparing the value of a field with a specified
// value.
type Operator struct {
	_ struct{} `type:"structure"`

	// The logical operation to be performed: equal (EQ), equal reference (REF_EQ),
	// less than or equal (LE), greater than or equal (GE), or between (BETWEEN).
	// Equal reference (REF_EQ) can be used only with reference fields. The other
	// comparison types can be used only with String fields. The comparison types
	// you can use apply only to certain object fields, as detailed below.
	//
	// The comparison operators EQ and REF_EQ act on the following fields:
	//
	//    * name
	//    * @sphere
	//    * parent
	//    * @componentParent
	//    * @instanceParent
	//    * @status
	//    * @scheduledStartTime
	//    * @scheduledEndTime
	//    * @actualStartTime
	//    * @actualEndTime
	// The comparison operators GE, LE, and BETWEEN act on the following fields:
	//
	//    * @scheduledStartTime
	//    * @scheduledEndTime
	//    * @actualStartTime
	//    * @actualEndTime
	// Note that fields beginning with the at sign (@) are read-only and set by
	// the web service. When you name fields, you should choose names containing
	// only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline.
	// User-defined fields that you add to a pipeline should prefix their name with
	// the string "my".
	Type *string `locationName:"type" type:"string" enum:"OperatorType"`

	// The value that the actual field value will be compared with.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s Operator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Operator) GoString() string {
	return s.String()
}

// The attributes allowed or specified with a parameter object.
type ParameterAttribute struct {
	_ struct{} `type:"structure"`

	// The field identifier.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The field value, expressed as a String.
	//
	// StringValue is a required field
	StringValue *string `locationName:"stringValue" type:"string" required:"true"`
}

// String returns the string representation
func (s ParameterAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.StringValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StringValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a parameter object.
type ParameterObject struct {
	_ struct{} `type:"structure"`

	// The attributes of the parameter object.
	//
	// Attributes is a required field
	Attributes []*ParameterAttribute `locationName:"attributes" type:"list" required:"true"`

	// The ID of the parameter object.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ParameterObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterObject"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A value or list of parameter values.
type ParameterValue struct {
	_ struct{} `type:"structure"`

	// The ID of the parameter value.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The field value, expressed as a String.
	//
	// StringValue is a required field
	StringValue *string `locationName:"stringValue" type:"string" required:"true"`
}

// String returns the string representation
func (s ParameterValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterValue"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StringValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StringValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains pipeline metadata.
type PipelineDescription struct {
	_ struct{} `type:"structure"`

	// Description of the pipeline.
	Description *string `locationName:"description" type:"string"`

	// A list of read-only fields that contain metadata about the pipeline: @userId,
	// @accountId, and @pipelineState.
	//
	// Fields is a required field
	Fields []*Field `locationName:"fields" type:"list" required:"true"`

	// The name of the pipeline.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The pipeline identifier that was assigned by AWS Data Pipeline. This is a
	// string of the form df-297EG78HU43EEXAMPLE.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// A list of tags to associated with a pipeline. Tags let you control access
	// to pipelines. For more information, see Controlling User Access to Pipelines
	// (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html)
	// in the AWS Data Pipeline Developer Guide.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PipelineDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineDescription) GoString() string {
	return s.String()
}

// Contains the name and identifier of a pipeline.
type PipelineIdName struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline that was assigned by AWS Data Pipeline. This is a
	// string of the form df-297EG78HU43EEXAMPLE.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s PipelineIdName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineIdName) GoString() string {
	return s.String()
}

// Contains information about a pipeline object. This can be a logical, physical,
// or physical attempt pipeline object. The complete set of components of a
// pipeline defines the pipeline.
type PipelineObject struct {
	_ struct{} `type:"structure"`

	// Key-value pairs that define the properties of the object.
	//
	// Fields is a required field
	Fields []*Field `locationName:"fields" type:"list" required:"true"`

	// The ID of the object.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the object.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PipelineObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineObject"}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for PollForTask.
type PollForTaskInput struct {
	_ struct{} `type:"structure"`

	// The public DNS name of the calling task runner.
	Hostname *string `locationName:"hostname" min:"1" type:"string"`

	// Identity information for the EC2 instance that is hosting the task runner.
	// You can get this value from the instance using http://169.254.169.254/latest/meta-data/instance-id.
	// For more information, see Instance Metadata (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html)
	// in the Amazon Elastic Compute Cloud User Guide. Passing in this value proves
	// that your task runner is running on an EC2 instance, and ensures the proper
	// AWS Data Pipeline service charges are applied to your pipeline.
	InstanceIdentity *InstanceIdentity `locationName:"instanceIdentity" type:"structure"`

	// The type of task the task runner is configured to accept and process. The
	// worker group is set as a field on objects in the pipeline when they are created.
	// You can only specify a single value for workerGroup in the call to PollForTask.
	// There are no wildcard values permitted in workerGroup; the string must be
	// an exact, case-sensitive, match.
	//
	// WorkerGroup is a required field
	WorkerGroup *string `locationName:"workerGroup" type:"string" required:"true"`
}

// String returns the string representation
func (s PollForTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForTaskInput"}
	if s.Hostname != nil && len(*s.Hostname) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Hostname", 1))
	}
	if s.WorkerGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PollForTask.
type PollForTaskOutput struct {
	_ struct{} `type:"structure"`

	// The information needed to complete the task that is being assigned to the
	// task runner. One of the fields returned in this object is taskId, which contains
	// an identifier for the task being assigned. The calling task runner uses taskId
	// in subsequent calls to ReportTaskProgress and SetTaskStatus.
	TaskObject *TaskObject `locationName:"taskObject" type:"structure"`
}

// String returns the string representation
func (s PollForTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForTaskOutput) GoString() string {
	return s.String()
}

// Contains the parameters for PutPipelineDefinition.
type PutPipelineDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The parameter objects used with the pipeline.
	ParameterObjects []*ParameterObject `locationName:"parameterObjects" type:"list"`

	// The parameter values used with the pipeline.
	ParameterValues []*ParameterValue `locationName:"parameterValues" type:"list"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The objects that define the pipeline. These objects overwrite the existing
	// pipeline definition.
	//
	// PipelineObjects is a required field
	PipelineObjects []*PipelineObject `locationName:"pipelineObjects" type:"list" required:"true"`
}

// String returns the string representation
func (s PutPipelineDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPipelineDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPipelineDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPipelineDefinitionInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.PipelineObjects == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineObjects"))
	}
	if s.ParameterObjects != nil {
		for i, v := range s.ParameterObjects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterObjects", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ParameterValues != nil {
		for i, v := range s.ParameterValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PipelineObjects != nil {
		for i, v := range s.PipelineObjects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineObjects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutPipelineDefinition.
type PutPipelineDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there were validation errors, and the pipeline definition
	// is stored but cannot be activated until you correct the pipeline and call
	// PutPipelineDefinition to commit the corrected pipeline.
	//
	// Errored is a required field
	Errored *bool `locationName:"errored" type:"boolean" required:"true"`

	// The validation errors that are associated with the objects defined in pipelineObjects.
	ValidationErrors []*ValidationError `locationName:"validationErrors" type:"list"`

	// The validation warnings that are associated with the objects defined in pipelineObjects.
	ValidationWarnings []*ValidationWarning `locationName:"validationWarnings" type:"list"`
}

// String returns the string representation
func (s PutPipelineDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPipelineDefinitionOutput) GoString() string {
	return s.String()
}

// Defines the query to run against an object.
type Query struct {
	_ struct{} `type:"structure"`

	// List of selectors that define the query. An object must satisfy all of the
	// selectors to match the query.
	Selectors []*Selector `locationName:"selectors" type:"list"`
}

// String returns the string representation
func (s Query) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Query) GoString() string {
	return s.String()
}

// Contains the parameters for QueryObjects.
type QueryObjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of object names that QueryObjects will return in a single
	// call. The default value is 100.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The starting point for the results to be returned. For the first call, this
	// value should be empty. As long as there are more results, continue to call
	// QueryObjects with the marker value from the previous call to retrieve the
	// next set of results.
	Marker *string `locationName:"marker" type:"string"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The query that defines the objects to be returned. The Query object can contain
	// a maximum of ten selectors. The conditions in the query are limited to top-level
	// String fields in the object. These filters can be applied to components,
	// instances, and attempts.
	Query *Query `locationName:"query" type:"structure"`

	// Indicates whether the query applies to components or instances. The possible
	// values are: COMPONENT, INSTANCE, and ATTEMPT.
	//
	// Sphere is a required field
	Sphere *string `locationName:"sphere" type:"string" required:"true"`
}

// String returns the string representation
func (s QueryObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryObjectsInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.Sphere == nil {
		invalidParams.Add(request.NewErrParamRequired("Sphere"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of QueryObjects.
type QueryObjectsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are more results that can be obtained by a subsequent
	// call.
	HasMoreResults *bool `locationName:"hasMoreResults" type:"boolean"`

	// The identifiers that match the query selectors.
	Ids []*string `locationName:"ids" type:"list"`

	// The starting point for the next page of results. To view the next page of
	// results, call QueryObjects again with this marker value. If the value is
	// null, there are no more results.
	Marker *string `locationName:"marker" type:"string"`
}

// String returns the string representation
func (s QueryObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryObjectsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for RemoveTags.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of RemoveTags.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ReportTaskProgress.
type ReportTaskProgressInput struct {
	_ struct{} `type:"structure"`

	// Key-value pairs that define the properties of the ReportTaskProgressInput
	// object.
	Fields []*Field `locationName:"fields" type:"list"`

	// The ID of the task assigned to the task runner. This value is provided in
	// the response for PollForTask.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReportTaskProgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportTaskProgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportTaskProgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportTaskProgressInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ReportTaskProgress.
type ReportTaskProgressOutput struct {
	_ struct{} `type:"structure"`

	// If true, the calling task runner should cancel processing of the task. The
	// task runner does not need to call SetTaskStatus for canceled tasks.
	//
	// Canceled is a required field
	Canceled *bool `locationName:"canceled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s ReportTaskProgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportTaskProgressOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ReportTaskRunnerHeartbeat.
type ReportTaskRunnerHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The public DNS name of the task runner.
	Hostname *string `locationName:"hostname" min:"1" type:"string"`

	// The ID of the task runner. This value should be unique across your AWS account.
	// In the case of AWS Data Pipeline Task Runner launched on a resource managed
	// by AWS Data Pipeline, the web service provides a unique identifier when it
	// launches the application. If you have written a custom task runner, you should
	// assign a unique identifier for the task runner.
	//
	// TaskrunnerId is a required field
	TaskrunnerId *string `locationName:"taskrunnerId" min:"1" type:"string" required:"true"`

	// The type of task the task runner is configured to accept and process. The
	// worker group is set as a field on objects in the pipeline when they are created.
	// You can only specify a single value for workerGroup. There are no wildcard
	// values permitted in workerGroup; the string must be an exact, case-sensitive,
	// match.
	WorkerGroup *string `locationName:"workerGroup" type:"string"`
}

// String returns the string representation
func (s ReportTaskRunnerHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportTaskRunnerHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportTaskRunnerHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportTaskRunnerHeartbeatInput"}
	if s.Hostname != nil && len(*s.Hostname) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Hostname", 1))
	}
	if s.TaskrunnerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskrunnerId"))
	}
	if s.TaskrunnerId != nil && len(*s.TaskrunnerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskrunnerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ReportTaskRunnerHeartbeat.
type ReportTaskRunnerHeartbeatOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the calling task runner should terminate.
	//
	// Terminate is a required field
	Terminate *bool `locationName:"terminate" type:"boolean" required:"true"`
}

// String returns the string representation
func (s ReportTaskRunnerHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportTaskRunnerHeartbeatOutput) GoString() string {
	return s.String()
}

// A comparision that is used to determine whether a query should return this
// object.
type Selector struct {
	_ struct{} `type:"structure"`

	// The name of the field that the operator will be applied to. The field name
	// is the "key" portion of the field definition in the pipeline definition syntax
	// that is used by the AWS Data Pipeline API. If the field is not set on the
	// object, the condition fails.
	FieldName *string `locationName:"fieldName" type:"string"`

	// Contains a logical operation for comparing the value of a field with a specified
	// value.
	Operator *Operator `locationName:"operator" type:"structure"`
}

// String returns the string representation
func (s Selector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Selector) GoString() string {
	return s.String()
}

// Contains the parameters for SetStatus.
type SetStatusInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the objects. The corresponding objects can be either physical
	// or components, but not a mix of both types.
	//
	// ObjectIds is a required field
	ObjectIds []*string `locationName:"objectIds" type:"list" required:"true"`

	// The ID of the pipeline that contains the objects.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The status to be set on all the objects specified in objectIds. For components,
	// use PAUSE or RESUME. For instances, use TRY_CANCEL, RERUN, or MARK_FINISHED.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s SetStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetStatusInput"}
	if s.ObjectIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectIds"))
	}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStatusOutput) GoString() string {
	return s.String()
}

// Contains the parameters for SetTaskStatus.
type SetTaskStatusInput struct {
	_ struct{} `type:"structure"`

	// If an error occurred during the task, this value specifies the error code.
	// This value is set on the physical attempt object. It is used to display error
	// information to the user. It should not start with string "Service_" which
	// is reserved by the system.
	ErrorId *string `locationName:"errorId" type:"string"`

	// If an error occurred during the task, this value specifies a text description
	// of the error. This value is set on the physical attempt object. It is used
	// to display error information to the user. The web service does not parse
	// this value.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// If an error occurred during the task, this value specifies the stack trace
	// associated with the error. This value is set on the physical attempt object.
	// It is used to display error information to the user. The web service does
	// not parse this value.
	ErrorStackTrace *string `locationName:"errorStackTrace" type:"string"`

	// The ID of the task assigned to the task runner. This value is provided in
	// the response for PollForTask.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" min:"1" type:"string" required:"true"`

	// If FINISHED, the task successfully completed. If FAILED, the task ended unsuccessfully.
	// Preconditions use false.
	//
	// TaskStatus is a required field
	TaskStatus *string `locationName:"taskStatus" type:"string" required:"true" enum:"TaskStatus"`
}

// String returns the string representation
func (s SetTaskStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTaskStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTaskStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTaskStatusInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}
	if s.TaskStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetTaskStatus.
type SetTaskStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTaskStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTaskStatusOutput) GoString() string {
	return s.String()
}

// Tags are key/value pairs defined by a user and associated with a pipeline
// to control access. AWS Data Pipeline allows you to associate ten tags per
// pipeline. For more information, see Controlling User Access to Pipelines
// (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html)
// in the AWS Data Pipeline Developer Guide.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key name of a tag defined by a user. For more information, see Controlling
	// User Access to Pipelines (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html)
	// in the AWS Data Pipeline Developer Guide.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The optional value portion of a tag defined by a user. For more information,
	// see Controlling User Access to Pipelines (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html)
	// in the AWS Data Pipeline Developer Guide.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a pipeline task that is assigned to a task runner.
type TaskObject struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline task attempt object. AWS Data Pipeline uses this value
	// to track how many times a task is attempted.
	AttemptId *string `locationName:"attemptId" min:"1" type:"string"`

	// Connection information for the location where the task runner will publish
	// the output of the task.
	Objects map[string]*PipelineObject `locationName:"objects" type:"map"`

	// The ID of the pipeline that provided the task.
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string"`

	// An internal identifier for the task. This ID is passed to the SetTaskStatus
	// and ReportTaskProgress actions.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation
func (s TaskObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskObject) GoString() string {
	return s.String()
}

// Contains the parameters for ValidatePipelineDefinition.
type ValidatePipelineDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The parameter objects used with the pipeline.
	ParameterObjects []*ParameterObject `locationName:"parameterObjects" type:"list"`

	// The parameter values used with the pipeline.
	ParameterValues []*ParameterValue `locationName:"parameterValues" type:"list"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The objects that define the pipeline changes to validate against the pipeline.
	//
	// PipelineObjects is a required field
	PipelineObjects []*PipelineObject `locationName:"pipelineObjects" type:"list" required:"true"`
}

// String returns the string representation
func (s ValidatePipelineDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidatePipelineDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidatePipelineDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidatePipelineDefinitionInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineId", 1))
	}
	if s.PipelineObjects == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineObjects"))
	}
	if s.ParameterObjects != nil {
		for i, v := range s.ParameterObjects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterObjects", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ParameterValues != nil {
		for i, v := range s.ParameterValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PipelineObjects != nil {
		for i, v := range s.PipelineObjects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineObjects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ValidatePipelineDefinition.
type ValidatePipelineDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there were validation errors.
	//
	// Errored is a required field
	Errored *bool `locationName:"errored" type:"boolean" required:"true"`

	// Any validation errors that were found.
	ValidationErrors []*ValidationError `locationName:"validationErrors" type:"list"`

	// Any validation warnings that were found.
	ValidationWarnings []*ValidationWarning `locationName:"validationWarnings" type:"list"`
}

// String returns the string representation
func (s ValidatePipelineDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidatePipelineDefinitionOutput) GoString() string {
	return s.String()
}

// Defines a validation error. Validation errors prevent pipeline activation.
// The set of validation errors that can be returned are defined by AWS Data
// Pipeline.
type ValidationError struct {
	_ struct{} `type:"structure"`

	// A description of the validation error.
	Errors []*string `locationName:"errors" type:"list"`

	// The identifier of the object that contains the validation error.
	Id *string `locationName:"id" min:"1" type:"string"`
}

// String returns the string representation
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationError) GoString() string {
	return s.String()
}

// Defines a validation warning. Validation warnings do not prevent pipeline
// activation. The set of validation warnings that can be returned are defined
// by AWS Data Pipeline.
type ValidationWarning struct {
	_ struct{} `type:"structure"`

	// The identifier of the object that contains the validation warning.
	Id *string `locationName:"id" min:"1" type:"string"`

	// A description of the validation warning.
	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s ValidationWarning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationWarning) GoString() string {
	return s.String()
}

const (
	// OperatorTypeEq is a OperatorType enum value
	OperatorTypeEq = "EQ"

	// OperatorTypeRefEq is a OperatorType enum value
	OperatorTypeRefEq = "REF_EQ"

	// OperatorTypeLe is a OperatorType enum value
	OperatorTypeLe = "LE"

	// OperatorTypeGe is a OperatorType enum value
	OperatorTypeGe = "GE"

	// OperatorTypeBetween is a OperatorType enum value
	OperatorTypeBetween = "BETWEEN"
)

const (
	// TaskStatusFinished is a TaskStatus enum value
	TaskStatusFinished = "FINISHED"

	// TaskStatusFailed is a TaskStatus enum value
	TaskStatusFailed = "FAILED"

	// TaskStatusFalse is a TaskStatus enum value
	TaskStatusFalse = "FALSE"
)
