// Code generated by smithy-go-codegen DO NOT EDIT.

package taxsettings

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/taxsettings/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchDeleteTaxRegistration struct {
}

func (*awsRestjson1_serializeOpBatchDeleteTaxRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteTaxRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteTaxRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/BatchDeleteTaxRegistration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteTaxRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteTaxRegistrationInput(v *BatchDeleteTaxRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteTaxRegistrationInput(v *BatchDeleteTaxRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentAccountIds(v.AccountIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchPutTaxRegistration struct {
}

func (*awsRestjson1_serializeOpBatchPutTaxRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchPutTaxRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutTaxRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/BatchPutTaxRegistration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchPutTaxRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchPutTaxRegistrationInput(v *BatchPutTaxRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchPutTaxRegistrationInput(v *BatchPutTaxRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountIds != nil {
		ok := object.Key("accountIds")
		if err := awsRestjson1_serializeDocumentAccountIds(v.AccountIds, ok); err != nil {
			return err
		}
	}

	if v.TaxRegistrationEntry != nil {
		ok := object.Key("taxRegistrationEntry")
		if err := awsRestjson1_serializeDocumentTaxRegistrationEntry(v.TaxRegistrationEntry, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTaxRegistration struct {
}

func (*awsRestjson1_serializeOpDeleteTaxRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTaxRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTaxRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DeleteTaxRegistration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteTaxRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTaxRegistrationInput(v *DeleteTaxRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteTaxRegistrationInput(v *DeleteTaxRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

type awsRestjson1_serializeOpGetTaxRegistration struct {
}

func (*awsRestjson1_serializeOpGetTaxRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTaxRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTaxRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GetTaxRegistration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetTaxRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTaxRegistrationInput(v *GetTaxRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetTaxRegistrationInput(v *GetTaxRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

type awsRestjson1_serializeOpGetTaxRegistrationDocument struct {
}

func (*awsRestjson1_serializeOpGetTaxRegistrationDocument) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTaxRegistrationDocument) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTaxRegistrationDocumentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GetTaxRegistrationDocument")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetTaxRegistrationDocumentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTaxRegistrationDocumentInput(v *GetTaxRegistrationDocumentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetTaxRegistrationDocumentInput(v *GetTaxRegistrationDocumentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationS3Location != nil {
		ok := object.Key("destinationS3Location")
		if err := awsRestjson1_serializeDocumentDestinationS3Location(v.DestinationS3Location, ok); err != nil {
			return err
		}
	}

	if v.TaxDocumentMetadata != nil {
		ok := object.Key("taxDocumentMetadata")
		if err := awsRestjson1_serializeDocumentTaxDocumentMetadata(v.TaxDocumentMetadata, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTaxRegistrations struct {
}

func (*awsRestjson1_serializeOpListTaxRegistrations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTaxRegistrations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTaxRegistrationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListTaxRegistrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTaxRegistrationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTaxRegistrationsInput(v *ListTaxRegistrationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTaxRegistrationsInput(v *ListTaxRegistrationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutTaxRegistration struct {
}

func (*awsRestjson1_serializeOpPutTaxRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutTaxRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutTaxRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/PutTaxRegistration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutTaxRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutTaxRegistrationInput(v *PutTaxRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutTaxRegistrationInput(v *PutTaxRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	if v.TaxRegistrationEntry != nil {
		ok := object.Key("taxRegistrationEntry")
		if err := awsRestjson1_serializeDocumentTaxRegistrationEntry(v.TaxRegistrationEntry, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAdditionalInfoRequest(v *types.AdditionalInfoRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanadaAdditionalInfo != nil {
		ok := object.Key("canadaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentCanadaAdditionalInfo(v.CanadaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.EstoniaAdditionalInfo != nil {
		ok := object.Key("estoniaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentEstoniaAdditionalInfo(v.EstoniaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.GeorgiaAdditionalInfo != nil {
		ok := object.Key("georgiaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentGeorgiaAdditionalInfo(v.GeorgiaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.IsraelAdditionalInfo != nil {
		ok := object.Key("israelAdditionalInfo")
		if err := awsRestjson1_serializeDocumentIsraelAdditionalInfo(v.IsraelAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.ItalyAdditionalInfo != nil {
		ok := object.Key("italyAdditionalInfo")
		if err := awsRestjson1_serializeDocumentItalyAdditionalInfo(v.ItalyAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.KenyaAdditionalInfo != nil {
		ok := object.Key("kenyaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentKenyaAdditionalInfo(v.KenyaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.MalaysiaAdditionalInfo != nil {
		ok := object.Key("malaysiaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentMalaysiaAdditionalInfo(v.MalaysiaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.PolandAdditionalInfo != nil {
		ok := object.Key("polandAdditionalInfo")
		if err := awsRestjson1_serializeDocumentPolandAdditionalInfo(v.PolandAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.RomaniaAdditionalInfo != nil {
		ok := object.Key("romaniaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentRomaniaAdditionalInfo(v.RomaniaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.SaudiArabiaAdditionalInfo != nil {
		ok := object.Key("saudiArabiaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentSaudiArabiaAdditionalInfo(v.SaudiArabiaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.SouthKoreaAdditionalInfo != nil {
		ok := object.Key("southKoreaAdditionalInfo")
		if err := awsRestjson1_serializeDocumentSouthKoreaAdditionalInfo(v.SouthKoreaAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.SpainAdditionalInfo != nil {
		ok := object.Key("spainAdditionalInfo")
		if err := awsRestjson1_serializeDocumentSpainAdditionalInfo(v.SpainAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.TurkeyAdditionalInfo != nil {
		ok := object.Key("turkeyAdditionalInfo")
		if err := awsRestjson1_serializeDocumentTurkeyAdditionalInfo(v.TurkeyAdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.UkraineAdditionalInfo != nil {
		ok := object.Key("ukraineAdditionalInfo")
		if err := awsRestjson1_serializeDocumentUkraineAdditionalInfo(v.UkraineAdditionalInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddress(v *types.Address, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressLine1 != nil {
		ok := object.Key("addressLine1")
		ok.String(*v.AddressLine1)
	}

	if v.AddressLine2 != nil {
		ok := object.Key("addressLine2")
		ok.String(*v.AddressLine2)
	}

	if v.AddressLine3 != nil {
		ok := object.Key("addressLine3")
		ok.String(*v.AddressLine3)
	}

	if v.City != nil {
		ok := object.Key("city")
		ok.String(*v.City)
	}

	if v.CountryCode != nil {
		ok := object.Key("countryCode")
		ok.String(*v.CountryCode)
	}

	if v.DistrictOrCounty != nil {
		ok := object.Key("districtOrCounty")
		ok.String(*v.DistrictOrCounty)
	}

	if v.PostalCode != nil {
		ok := object.Key("postalCode")
		ok.String(*v.PostalCode)
	}

	if v.StateOrRegion != nil {
		ok := object.Key("stateOrRegion")
		ok.String(*v.StateOrRegion)
	}

	return nil
}

func awsRestjson1_serializeDocumentCanadaAdditionalInfo(v *types.CanadaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanadaQuebecSalesTaxNumber != nil {
		ok := object.Key("canadaQuebecSalesTaxNumber")
		ok.String(*v.CanadaQuebecSalesTaxNumber)
	}

	if v.CanadaRetailSalesTaxNumber != nil {
		ok := object.Key("canadaRetailSalesTaxNumber")
		ok.String(*v.CanadaRetailSalesTaxNumber)
	}

	if v.IsResellerAccount != nil {
		ok := object.Key("isResellerAccount")
		ok.Boolean(*v.IsResellerAccount)
	}

	if v.ProvincialSalesTaxId != nil {
		ok := object.Key("provincialSalesTaxId")
		ok.String(*v.ProvincialSalesTaxId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationS3Location(v *types.DestinationS3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentEstoniaAdditionalInfo(v *types.EstoniaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegistryCommercialCode != nil {
		ok := object.Key("registryCommercialCode")
		ok.String(*v.RegistryCommercialCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeorgiaAdditionalInfo(v *types.GeorgiaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PersonType) > 0 {
		ok := object.Key("personType")
		ok.String(string(v.PersonType))
	}

	return nil
}

func awsRestjson1_serializeDocumentIsraelAdditionalInfo(v *types.IsraelAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CustomerType) > 0 {
		ok := object.Key("customerType")
		ok.String(string(v.CustomerType))
	}

	if len(v.DealerType) > 0 {
		ok := object.Key("dealerType")
		ok.String(string(v.DealerType))
	}

	return nil
}

func awsRestjson1_serializeDocumentItalyAdditionalInfo(v *types.ItalyAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CigNumber != nil {
		ok := object.Key("cigNumber")
		ok.String(*v.CigNumber)
	}

	if v.CupNumber != nil {
		ok := object.Key("cupNumber")
		ok.String(*v.CupNumber)
	}

	if v.SdiAccountId != nil {
		ok := object.Key("sdiAccountId")
		ok.String(*v.SdiAccountId)
	}

	if v.TaxCode != nil {
		ok := object.Key("taxCode")
		ok.String(*v.TaxCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentKenyaAdditionalInfo(v *types.KenyaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PersonType) > 0 {
		ok := object.Key("personType")
		ok.String(string(v.PersonType))
	}

	return nil
}

func awsRestjson1_serializeDocumentMalaysiaAdditionalInfo(v *types.MalaysiaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ServiceTaxCodes != nil {
		ok := object.Key("serviceTaxCodes")
		if err := awsRestjson1_serializeDocumentMalaysiaServiceTaxCodesList(v.ServiceTaxCodes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMalaysiaServiceTaxCodesList(v []types.MalaysiaServiceTaxCode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentPolandAdditionalInfo(v *types.PolandAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndividualRegistrationNumber != nil {
		ok := object.Key("individualRegistrationNumber")
		ok.String(*v.IndividualRegistrationNumber)
	}

	if v.IsGroupVatEnabled != nil {
		ok := object.Key("isGroupVatEnabled")
		ok.Boolean(*v.IsGroupVatEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentRomaniaAdditionalInfo(v *types.RomaniaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TaxRegistrationNumberType) > 0 {
		ok := object.Key("taxRegistrationNumberType")
		ok.String(string(v.TaxRegistrationNumberType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSaudiArabiaAdditionalInfo(v *types.SaudiArabiaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TaxRegistrationNumberType) > 0 {
		ok := object.Key("taxRegistrationNumberType")
		ok.String(string(v.TaxRegistrationNumberType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceS3Location(v *types.SourceS3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeDocumentSouthKoreaAdditionalInfo(v *types.SouthKoreaAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BusinessRepresentativeName != nil {
		ok := object.Key("businessRepresentativeName")
		ok.String(*v.BusinessRepresentativeName)
	}

	if v.ItemOfBusiness != nil {
		ok := object.Key("itemOfBusiness")
		ok.String(*v.ItemOfBusiness)
	}

	if v.LineOfBusiness != nil {
		ok := object.Key("lineOfBusiness")
		ok.String(*v.LineOfBusiness)
	}

	return nil
}

func awsRestjson1_serializeDocumentSpainAdditionalInfo(v *types.SpainAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RegistrationType) > 0 {
		ok := object.Key("registrationType")
		ok.String(string(v.RegistrationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTaxDocumentMetadata(v *types.TaxDocumentMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TaxDocumentAccessToken != nil {
		ok := object.Key("taxDocumentAccessToken")
		ok.String(*v.TaxDocumentAccessToken)
	}

	if v.TaxDocumentName != nil {
		ok := object.Key("taxDocumentName")
		ok.String(*v.TaxDocumentName)
	}

	return nil
}

func awsRestjson1_serializeDocumentTaxRegistrationDocument(v *types.TaxRegistrationDocument, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Location != nil {
		ok := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentSourceS3Location(v.S3Location, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTaxRegistrationDocuments(v []types.TaxRegistrationDocument, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTaxRegistrationDocument(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTaxRegistrationEntry(v *types.TaxRegistrationEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalTaxInformation != nil {
		ok := object.Key("additionalTaxInformation")
		if err := awsRestjson1_serializeDocumentAdditionalInfoRequest(v.AdditionalTaxInformation, ok); err != nil {
			return err
		}
	}

	if v.CertifiedEmailId != nil {
		ok := object.Key("certifiedEmailId")
		ok.String(*v.CertifiedEmailId)
	}

	if v.LegalAddress != nil {
		ok := object.Key("legalAddress")
		if err := awsRestjson1_serializeDocumentAddress(v.LegalAddress, ok); err != nil {
			return err
		}
	}

	if v.LegalName != nil {
		ok := object.Key("legalName")
		ok.String(*v.LegalName)
	}

	if v.RegistrationId != nil {
		ok := object.Key("registrationId")
		ok.String(*v.RegistrationId)
	}

	if len(v.RegistrationType) > 0 {
		ok := object.Key("registrationType")
		ok.String(string(v.RegistrationType))
	}

	if len(v.Sector) > 0 {
		ok := object.Key("sector")
		ok.String(string(v.Sector))
	}

	if v.VerificationDetails != nil {
		ok := object.Key("verificationDetails")
		if err := awsRestjson1_serializeDocumentVerificationDetails(v.VerificationDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTurkeyAdditionalInfo(v *types.TurkeyAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Industries) > 0 {
		ok := object.Key("industries")
		ok.String(string(v.Industries))
	}

	if v.KepEmailId != nil {
		ok := object.Key("kepEmailId")
		ok.String(*v.KepEmailId)
	}

	if v.SecondaryTaxId != nil {
		ok := object.Key("secondaryTaxId")
		ok.String(*v.SecondaryTaxId)
	}

	if v.TaxOffice != nil {
		ok := object.Key("taxOffice")
		ok.String(*v.TaxOffice)
	}

	return nil
}

func awsRestjson1_serializeDocumentUkraineAdditionalInfo(v *types.UkraineAdditionalInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.UkraineTrnType) > 0 {
		ok := object.Key("ukraineTrnType")
		ok.String(string(v.UkraineTrnType))
	}

	return nil
}

func awsRestjson1_serializeDocumentVerificationDetails(v *types.VerificationDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateOfBirth != nil {
		ok := object.Key("dateOfBirth")
		ok.String(*v.DateOfBirth)
	}

	if v.TaxRegistrationDocuments != nil {
		ok := object.Key("taxRegistrationDocuments")
		if err := awsRestjson1_serializeDocumentTaxRegistrationDocuments(v.TaxRegistrationDocuments, ok); err != nil {
			return err
		}
	}

	return nil
}
