// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieve the CountryRuleSet for the specified NumberCapability from a protect
// configuration.
func (c *Client) GetProtectConfigurationCountryRuleSet(ctx context.Context, params *GetProtectConfigurationCountryRuleSetInput, optFns ...func(*Options)) (*GetProtectConfigurationCountryRuleSetOutput, error) {
	if params == nil {
		params = &GetProtectConfigurationCountryRuleSetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetProtectConfigurationCountryRuleSet", params, optFns, c.addOperationGetProtectConfigurationCountryRuleSetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetProtectConfigurationCountryRuleSetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetProtectConfigurationCountryRuleSetInput struct {

	// The capability type to return the CountryRuleSet for. Valid values are SMS ,
	// VOICE , or MMS .
	//
	// This member is required.
	NumberCapability types.NumberCapability

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	noSmithyDocumentSerde
}

type GetProtectConfigurationCountryRuleSetOutput struct {

	// A map of ProtectConfigurationCountryRuleSetInformation objects that contain the
	// details for the requested NumberCapability. The Key is the two-letter ISO
	// country code. For a list of supported ISO country codes, see [Supported countries and regions (SMS channel)]in the Amazon
	// Pinpoint SMS user guide.
	//
	// [Supported countries and regions (SMS channel)]: https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html
	//
	// This member is required.
	CountryRuleSet map[string]types.ProtectConfigurationCountryRuleSetInformation

	// The capability type associated with the returned
	// ProtectConfigurationCountryRuleSetInformation objects.
	//
	// This member is required.
	NumberCapability types.NumberCapability

	// The Amazon Resource Name (ARN) of the protect configuration.
	//
	// This member is required.
	ProtectConfigurationArn *string

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetProtectConfigurationCountryRuleSetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetProtectConfigurationCountryRuleSet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetProtectConfigurationCountryRuleSet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetProtectConfigurationCountryRuleSet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetProtectConfigurationCountryRuleSetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetProtectConfigurationCountryRuleSet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetProtectConfigurationCountryRuleSet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetProtectConfigurationCountryRuleSet",
	}
}
