// Code generated by smithy-go-codegen DO NOT EDIT.

package neptune

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptune/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The DeleteDBInstance action deletes a previously provisioned DB instance. When
// you delete a DB instance, all automated backups for that instance are deleted
// and can't be recovered. Manual DB snapshots of the DB instance to be deleted by
// DeleteDBInstance are not deleted.
//
// If you request a final DB snapshot the status of the Amazon Neptune DB instance
// is deleting until the DB snapshot is created. The API action DescribeDBInstance
// is used to monitor the status of this operation. The action can't be canceled or
// reverted once submitted.
//
// Note that when a DB instance is in a failure state and has a status of failed ,
// incompatible-restore , or incompatible-network , you can only delete it when the
// SkipFinalSnapshot parameter is set to true .
//
// You can't delete a DB instance if it is the only instance in the DB cluster, or
// if it has deletion protection enabled.
func (c *Client) DeleteDBInstance(ctx context.Context, params *DeleteDBInstanceInput, optFns ...func(*Options)) (*DeleteDBInstanceOutput, error) {
	if params == nil {
		params = &DeleteDBInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteDBInstance", params, optFns, c.addOperationDeleteDBInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteDBInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteDBInstanceInput struct {

	// The DB instance identifier for the DB instance to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//   - Must match the name of an existing DB instance.
	//
	// This member is required.
	DBInstanceIdentifier *string

	//  The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot
	// is set to false .
	//
	// Specifying this parameter and also setting the SkipFinalShapshot parameter to
	// true results in an error.
	//
	// Constraints:
	//
	//   - Must be 1 to 255 letters or numbers.
	//
	//   - First character must be a letter
	//
	//   - Cannot end with a hyphen or contain two consecutive hyphens
	//
	//   - Cannot be specified when deleting a Read Replica.
	FinalDBSnapshotIdentifier *string

	//  Determines whether a final DB snapshot is created before the DB instance is
	// deleted. If true is specified, no DBSnapshot is created. If false is specified,
	// a DB snapshot is created before the DB instance is deleted.
	//
	// Note that when a DB instance is in a failure state and has a status of
	// 'failed', 'incompatible-restore', or 'incompatible-network', it can only be
	// deleted when the SkipFinalSnapshot parameter is set to "true".
	//
	// Specify true when deleting a Read Replica.
	//
	// The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot
	// is false .
	//
	// Default: false
	SkipFinalSnapshot *bool

	noSmithyDocumentSerde
}

type DeleteDBInstanceOutput struct {

	// Contains the details of an Amazon Neptune DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *types.DBInstance

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteDBInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDeleteDBInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDeleteDBInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteDBInstance"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteDBInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteDBInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteDBInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteDBInstance",
	}
}
