// Code generated by smithy-go-codegen DO NOT EDIT.

package m2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/m2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the details of a specific batch job execution for a specific application.
func (c *Client) GetBatchJobExecution(ctx context.Context, params *GetBatchJobExecutionInput, optFns ...func(*Options)) (*GetBatchJobExecutionOutput, error) {
	if params == nil {
		params = &GetBatchJobExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBatchJobExecution", params, optFns, c.addOperationGetBatchJobExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBatchJobExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBatchJobExecutionInput struct {

	// The identifier of the application.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier of the batch job execution.
	//
	// This member is required.
	ExecutionId *string

	noSmithyDocumentSerde
}

type GetBatchJobExecutionOutput struct {

	// The identifier of the application.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier for this batch job execution.
	//
	// This member is required.
	ExecutionId *string

	// The timestamp when the batch job execution started.
	//
	// This member is required.
	StartTime *time.Time

	// The status of the batch job execution.
	//
	// This member is required.
	Status types.BatchJobExecutionStatus

	// The unique identifier of this batch job.
	BatchJobIdentifier types.BatchJobIdentifier

	// The timestamp when the batch job execution ended.
	EndTime *time.Time

	// The unique identifier for this batch job.
	JobId *string

	// The name of this batch job.
	JobName *string

	// The restart steps information for the most recent restart operation.
	JobStepRestartMarker *types.JobStepRestartMarker

	// The type of job.
	JobType types.BatchJobType

	// The user for the job.
	JobUser *string

	// The batch job return code from either the Blu Age or Micro Focus runtime
	// engines. For more information, see [Batch return codes]in the IBM WebSphere Application Server
	// documentation.
	//
	// [Batch return codes]: https://www.ibm.com/docs/en/was/8.5.5?topic=model-batch-return-codes
	ReturnCode *string

	// The reason for the reported status.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBatchJobExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetBatchJobExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetBatchJobExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBatchJobExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetBatchJobExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBatchJobExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBatchJobExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBatchJobExecution",
	}
}
