// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables Lake query federation on the specified event data store. Federating an
// event data store lets you view the metadata associated with the event data store
// in the Glue Data Catalog (https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro)
// and run SQL queries against your event data using Amazon Athena. The table
// metadata stored in the Glue Data Catalog lets the Athena query engine know how
// to find, read, and process the data that you want to query. When you enable Lake
// query federation, CloudTrail creates a federated database named aws:cloudtrail
// (if the database doesn't already exist) and a federated table in the Glue Data
// Catalog. The event data store ID is used for the table name. CloudTrail
// registers the role ARN and event data store in Lake Formation (https://docs.aws.amazon.com/lake-formation/latest/dg/how-it-works.html)
// , the service responsible for revoking or granting permissions to the federated
// resources in the Glue Data Catalog. For more information about Lake query
// federation, see Federate an event data store (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html)
// .
func (c *Client) EnableFederation(ctx context.Context, params *EnableFederationInput, optFns ...func(*Options)) (*EnableFederationOutput, error) {
	if params == nil {
		params = &EnableFederationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableFederation", params, optFns, c.addOperationEnableFederationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableFederationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EnableFederationInput struct {

	// The ARN (or ID suffix of the ARN) of the event data store for which you want to
	// enable Lake query federation.
	//
	// This member is required.
	EventDataStore *string

	// The ARN of the federation role to use for the event data store. Amazon Web
	// Services services like Lake Formation use this federation role to access data
	// for the federated event data store. The federation role must exist in your
	// account and provide the required minimum permissions (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role)
	// .
	//
	// This member is required.
	FederationRoleArn *string

	noSmithyDocumentSerde
}

type EnableFederationOutput struct {

	// The ARN of the event data store for which you enabled Lake query federation.
	EventDataStoreArn *string

	// The ARN of the federation role.
	FederationRoleArn *string

	// The federation status.
	FederationStatus types.FederationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableFederationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpEnableFederation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpEnableFederation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableFederation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpEnableFederationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableFederation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableFederation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableFederation",
	}
}
