'use strict';

const Utils = imports.fixtures.utils;


describe('The ping plugin', function () {
    let testRig;
    let localPlugin, remotePlugin;

    beforeAll(async function () {
        testRig = new Utils.TestRig();
        await testRig.prepare({
            localDevice: {
                incomingCapabilities: ['kdeconnect.ping'],
                outgoingCapabilities: ['kdeconnect.ping'],
            },
            remoteDevice: {
                incomingCapabilities: ['kdeconnect.ping'],
                outgoingCapabilities: ['kdeconnect.ping'],
            },
        });
        testRig.setPaired(true);
    });

    afterAll(function () {
        testRig.destroy();
    });

    beforeEach(function () {
        if (remotePlugin) {
            spyOn(remotePlugin, 'handlePacket').and.callThrough();
            spyOn(remotePlugin.device, 'showNotification');
        }
    });

    it('can be loaded', async function () {
        await testRig.loadPlugins();

        localPlugin = testRig.localDevice._plugins.get('ping');
        remotePlugin = testRig.remoteDevice._plugins.get('ping');

        expect(localPlugin).toBeDefined();
        expect(remotePlugin).toBeDefined();
    });

    it('enables its GActions when connected', function () {
        testRig.setConnected(true);

        expect(localPlugin.device.get_action_enabled('ping')).toBeTrue();
        expect(remotePlugin.device.get_action_enabled('ping')).toBeTrue();
    });

    it('can send and receive pings', async function () {
        localPlugin.ping();
        await remotePlugin.awaitPacket('kdeconnect.ping');

        expect(remotePlugin.handlePacket).toHaveBeenCalled();
        expect(testRig.remoteDevice.showNotification).toHaveBeenCalled();
    });

    it('disables its GActions when disconnected', function () {
        testRig.setConnected(false);

        expect(localPlugin.device.get_action_enabled('ping')).toBeFalse();
        expect(remotePlugin.device.get_action_enabled('ping')).toBeFalse();
    });
});

