-------------------------------------------------------------------------------
--                                                                           --
--                      GNADE  : GNu Ada Database Environment                --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/support/gnu-db-support-number_list.adb,v $
--  Description     : Testcode for the support packages                      --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 16-Mar-2002                                            --
--  Last Modified By: $Author: persan $
--  Last Modified On: $Date: 2007/08/24 21:35:12 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2000-2002 Michael Erdmann                                  --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  <a>                                                                      --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  </a>                                                                     --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  R.1 - The handling of the tree nodes is currently not task save          --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;          use Ada.Text_IO;

package body GNU.DB.Support.Number_List is

   -------------
   -- Destroy --
   -------------
   procedure Destroy (Element : in Number_List_Element;
                      Ptr     : in out List_Element_Access) is
      pragma Unreferenced (Element, Ptr);
   begin
      Put_Line ("*** Destroy element ***");
   end Destroy;

   -----------------
   -- Create_Copy --
   -----------------
   function Create_Copy (Element : in Number_List_Element) return List_Element_Access is
      Result  : constant List_Element_Access := new Number_List_Element (Element.I);
   begin
      Number_List_Element (Result.all) := Element;
      return Result;
   end Create_Copy;

   --------------------
   -- Print_Iterator --
   --------------------
   type Print_Iterator is new List_Iterator_Type with null record;

   ------------
   -- Action --
   ------------
   procedure Action (IC      : in out Print_Iterator;
                     Element : in out List_Element_Access) is
                     pragma Unreferenced (IC);
      This    : Number_List_Element renames Number_List_Element (Element.all);
   begin
      Put_Line (Integer'Image (This.I));
   end Action;

   -----------
   -- Print --
   -----------
   procedure Print (This     : in List_Element_Access) is
      Iterator : Print_Iterator;
   begin
      Perform (This, Iterator);
   end Print;

   -------------
   -- Element --
   -------------
   function Element (Value  : in Integer) return List_Element_Access is
      Result : constant List_Element_Access := new Number_List_Element (Value);
   begin
      return Result;
   end Element;

end GNU.DB.Support.Number_List;
