/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/matrixop.h
*       Authors:  Christoph Hafemeister
*
*       Copyright (C) 2007-2008 Alexander Schliep
*	Copyright (C) 2007-2008 Max-Planck-Institut fuer Molekulare Genetik,
*                               Berlin
*
*       Contact: schliep@ghmm.org
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*******************************************************************************/

#ifndef GHMM_MATRIXOP_H
#define GHMM_MATRIXOP_H

/**@name Help functions for matrix operations */
/*@{ (Doc++-Group: matrix operations) */

#ifdef __cplusplus
extern "C" {
#endif

/**
   Calculates the inverse and the determinant of a covariance matrix.
   @return          0
   @param sigmainv  pointer to linearized double matrix that will hold the inverse
   @param det       pointer to double that will hold the determinant
   @param length    length = n of the n x n matrix
   @param cov       the covariance matrix
   */
  int ighmm_invert_det(double *sigmainv, double *det, int length, double *cov);

/**
   Calculates the determinant of a covariance matrix.
   @return          determinant
   @param cov       pointer to the covariance matrix
   @param n         dimension of the covariance matrix
   */
  double ighmm_determinant(double *cov, int n);

/**
   Calculates the inverse of a square matrix.
   @return          0 on success
   @param cov       pointer to the (covariance) matrix
   @param n         dimension of the (covariance) matrix
   @param det       determinant of the (covariance) matrix
   @param inv       pointer to the inverse matrix (the result will replace old values)
   */
  int ighmm_inverse(double *cov, int n, double det, double *inv);

/**
   Calculates the Cholesky decomposition G of a covariance matrix A. A = GG'.
   @return            0: success; !0 error
   @param sigmacd     pointer to double matrix that will hold the decomposed matrix G
   @param dim         dimension of covariance matrix
   @param cov         covariance matrix with size dim x dim
   */
  int ighmm_cholesky_decomposition (double *sigmacd, int dim, double *cov);


#ifdef __cplusplus
}
#endif

#endif                          /* GHMM_MATRIXOP_H */

/*@} (Doc++-Group: matrix operations) */
