static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2003,2004,2007 Øyvind Kolås <pippin@gimp.org>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#include <libswscale/swscale.h>                                               \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (path, _(\"File\"), \"/tmp/fnord.mp4\")                       \n"
"    description (_(\"Target path and filename, use '-' for stdout.\"))        \n"
"                                                                              \n"
"property_double (bitrate, _(\"Target bitrate\"), 800000.0)                    \n"
"     value_range (0.0, 100000000.0)                                           \n"
"                                                                              \n"
"property_double (fps, _(\"Frames/second\"), 25)                               \n"
"     value_range (0.0, 100.0)                                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE ff-save.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#ifdef HAVE_LIBAVFORMAT_AVFORMAT_H                                            \n"
"#include <libavformat/avformat.h>                                             \n"
"#else                                                                         \n"
"#include <avformat.h>                                                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble    frame;                                                           \n"
"  gdouble    frames;                                                          \n"
"  gdouble    width;                                                           \n"
"  gdouble    height;                                                          \n"
"  GeglBuffer *input;                                                          \n"
"                                                                              \n"
"  AVOutputFormat *fmt;                                                        \n"
"  AVFormatContext *oc;                                                        \n"
"  AVStream *video_st;                                                         \n"
"                                                                              \n"
"  AVFrame  *picture, *tmp_picture;                                            \n"
"  uint8_t  *video_outbuf;                                                     \n"
"  int       frame_count, video_outbuf_size;                                   \n"
"                                                                              \n"
"    /** the rest is for audio handling within oxide, note that the interface  \n"
"     * used passes all used functions in the oxide api through the reg_sym api\n"
"     * of gggl, this means that the ops should be usable by other applications\n"
"     * using gggl directly,. without needing to link with the oxide library   \n"
"     */                                                                       \n"
"                                                                              \n"
"  AVStream *audio_st;                                                         \n"
"                                                                              \n"
"  void     *oxide_audio_instance;                                             \n"
"  /*< non NULL audio_query,. means audio present */                           \n"
"                                                                              \n"
"  int32_t (*oxide_audio_query) (void *audio_instance,                         \n"
"                                uint32_t * sample_rate,                       \n"
"                                uint32_t * bits,                              \n"
"                                uint32_t * channels,                          \n"
"                                uint32_t * fragment_samples,                  \n"
"                                uint32_t * fragment_size);                    \n"
"                                                                              \n"
"  /* get audio samples for the current video frame, this should provide all   \n"
"   * audiosamples associated with the frame, frame centering on audio stream is\n"
"   * undefined (FIXME:<<)                                                     \n"
"   */                                                                         \n"
"                                                                              \n"
"  int32_t (*oxide_audio_get_fragment) (void *audio_instance, uint8_t * buf);  \n"
"                                                                              \n"
"  uint32_t  sample_rate;                                                      \n"
"  uint32_t  bits;                                                             \n"
"  uint32_t  channels;                                                         \n"
"  uint32_t  fragment_samples;                                                 \n"
"  uint32_t  fragment_size;                                                    \n"
"                                                                              \n"
"  uint8_t  *fragment;                                                         \n"
"                                                                              \n"
"  int       buffer_size;                                                      \n"
"  int       buffer_read_pos;                                                  \n"
"  int       buffer_write_pos;                                                 \n"
"  uint8_t  *buffer;   /* optimal buffer size should be calculated,. preferably\n"
"                         run time,. no magic numbers needed for the filewrite \n"
"                         case, perhaps a tiny margin for ntsc since it has a  \n"
"                         strange framerate */                                 \n"
"                                                                              \n"
"  int       audio_outbuf_size;                                                \n"
"  int       audio_input_frame_size;                                           \n"
"  int16_t  *samples;                                                          \n"
"  uint8_t  *audio_outbuf;                                                     \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"#define DISABLE_AUDIO                                                         \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  static gint inited = 0; /*< this is actually meant to be static, only to be done once */\n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    {                                                                         \n"
"      p = g_new0 (Priv, 1);                                                   \n"
"      o->user_data = (void*) p;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!inited)                                                                \n"
"    {                                                                         \n"
"      av_register_all ();                                                     \n"
"      avcodec_register_all ();                                                \n"
"      inited = 1;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"#ifndef DISABLE_AUDIO                                                         \n"
"  p->oxide_audio_instance = gggl_op_sym (op, \"oxide_audio_instance\");       \n"
"  p->oxide_audio_query = gggl_op_sym (op, \"oxide_audio_query()\");           \n"
"  p->oxide_audio_get_fragment =                                               \n"
"    gggl_op_sym (op, \"oxide_audio_get_fragment()\");                         \n"
"                                                                              \n"
"  if (p->oxide_audio_instance && p->oxide_audio_query)                        \n"
"    {                                                                         \n"
"      p->oxide_audio_query (p->oxide_audio_instance,                          \n"
"                            &p->sample_rate,                                  \n"
"                            &p->bits,                                         \n"
"                            &p->channels,                                     \n"
"                            &p->fragment_samples, &p->fragment_size);         \n"
"                                                                              \n"
"      /* FIXME: for now, the buffer is set to a size double that of a oxide   \n"
"       * provided fragment,. should be enough no matter how things are handled,\n"
"       * but it should also be more than needed,. find out exact amount needed later\n"
"       */                                                                     \n"
"                                                                              \n"
"      if (!p->buffer)                                                         \n"
"        {                                                                     \n"
"          int size =                                                          \n"
"            (p->sample_rate / p->fps) * p->channels * (p->bits / 8) * 2;      \n"
"          buffer_open (op, size);                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (!p->fragment)                                                       \n"
"        p->fragment = gggl_op_calloc (op, 1, p->fragment_size);               \n"
"    }                                                                         \n"
"#endif                                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void close_video       (Priv            *p,                            \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"void        close_audio       (Priv            *p,                            \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"static int  tfile             (GeglProperties      *self);                    \n"
"static void write_video_frame (GeglProperties      *self,                     \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"static void write_audio_frame (GeglProperties      *self,                     \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"#define STREAM_FRAME_RATE 25    /* 25 images/s */                             \n"
"                                                                              \n"
"static int                                                                    \n"
"buffer_used (Priv * p)                                                        \n"
"{                                                                             \n"
"  int       ret;                                                              \n"
"  if (!p || !p->buffer_size || !p->buffer)                                    \n"
"    return -1;                                                                \n"
"                                                                              \n"
"  if (p->buffer_write_pos == p->buffer_read_pos)                              \n"
"    return 0;                                                                 \n"
"  if (p->buffer_write_pos > p->buffer_read_pos)                               \n"
"    {                                                                         \n"
"      ret = p->buffer_write_pos - p->buffer_read_pos;                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      ret = p->buffer_size - (p->buffer_read_pos - p->buffer_write_pos);      \n"
"    }                                                                         \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"buffer_unused (Priv * p)                                                      \n"
"{                                                                             \n"
"  int       ret;                                                              \n"
"  ret = p->buffer_size - buffer_used (p) - 1;   /* 1 byte for indicating full */\n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"#ifndef DISABLE_AUDIO                                                         \n"
"static void                                                                   \n"
"buffer_flush (Priv * p)                                                       \n"
"{                                                                             \n"
"  if (!p->buffer)                                                             \n"
"    return;                                                                   \n"
"  p->buffer_write_pos = 0;                                                    \n"
"  p->buffer_read_pos = 0;                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"buffer_open (GeglOpOperation *op, int size)                                   \n"
"{                                                                             \n"
"  Priv     *p = (Priv*)op->priv;                                              \n"
"                                                                              \n"
"  if (p->buffer)                                                              \n"
"    {                                                                         \n"
"      fprintf (stderr, \"double init of buffer, eek!\\n\");                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->buffer_size = size;                                                      \n"
"  p->buffer = g_malloc (size);                                                \n"
"  buffer_flush (p);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"buffer_close (GeglOpOperation *op)                                            \n"
"{                                                                             \n"
"  Priv     *p = (Priv*)op->priv;                                              \n"
"                                                                              \n"
"  if (!p->buffer)                                                             \n"
"    return;                                                                   \n"
"  g_free (p->buffer);                                                         \n"
"  p->buffer = NULL;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
"                                                                              \n"
"static int                                                                    \n"
"buffer_write (Priv * p, uint8_t * source, int count)                          \n"
"{                                                                             \n"
"  int       first_segment_size = 0;                                           \n"
"  int       second_segment_size = 0;                                          \n"
"                                                                              \n"
"  /* check if we have room for the data in the buffer */                      \n"
"  if (!p->buffer || buffer_unused (p) < count + 1)                            \n"
"    {                                                                         \n"
"      fprintf (stderr, \"ff_save audio buffer full!! shouldn't happen\\n\");  \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* calculate size of segments to write */                                   \n"
"  first_segment_size = p->buffer_size - p->buffer_write_pos;                  \n"
"                                                                              \n"
"  if (p->buffer_read_pos > p->buffer_write_pos)                               \n"
"    first_segment_size = p->buffer_read_pos - p->buffer_write_pos;            \n"
"                                                                              \n"
"  if (first_segment_size >= count)                                            \n"
"    {                                                                         \n"
"      first_segment_size = count;                                             \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      second_segment_size = count - first_segment_size;                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  memcpy (p->buffer + p->buffer_write_pos, source, first_segment_size);       \n"
"  p->buffer_write_pos += first_segment_size;                                  \n"
"                                                                              \n"
"  if (p->buffer_write_pos == p->buffer_size)                                  \n"
"    p->buffer_write_pos = 0;                                                  \n"
"                                                                              \n"
"  if (second_segment_size)                                                    \n"
"    {                                                                         \n"
"      memcpy (p->buffer + p->buffer_write_pos, source + first_segment_size,   \n"
"              second_segment_size);                                           \n"
"      p->buffer_write_pos = second_segment_size;                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return first_segment_size + second_segment_size;                            \n"
"}                                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
". = unused byte                                                               \n"
"# = used byte                                                                 \n"
"  all sizes are specified in contiguous bytes of memory                       \n"
"  __write_pos / __read_pos                                                    \n"
"  //                                                                          \n"
"  |................................... | empty buffer                         \n"
"  \\ _________________________________ /                                      \n"
"  size_ / __read_pos __write_pos / /|........                                 \n"
"#################..........|                                                  \n"
"  \\ ______________ / used ()_ / __write_pos __read_pos / /|                  \n"
"############..................#####|                                          \n"
"  \\______________ / unused ()_ / ___write_pos / __read_pos / /|              \n"
"#################.#################|    full buffer                           \n"
"#endif                                                                        \n"
"     static int                                                               \n"
"     buffer_read (Priv * p, uint8_t * dest, int count)                        \n"
"{                                                                             \n"
"  int       first_segment_size = 0;                                           \n"
"  int       second_segment_size = 0;                                          \n"
"                                                                              \n"
"  /* check if we have enough data to fulfil request */                        \n"
"  if (!p->buffer || buffer_used (p) < count)                                  \n"
"    {                                                                         \n"
"      fprintf (stderr, \"ff_save audio buffer doesn't have enough data\\n\"); \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* calculate size of segments to write */                                   \n"
"  first_segment_size = p->buffer_size - p->buffer_read_pos;                   \n"
"                                                                              \n"
"  if (p->buffer_write_pos > p->buffer_read_pos)                               \n"
"    first_segment_size = p->buffer_write_pos - p->buffer_read_pos;            \n"
"                                                                              \n"
"  if (first_segment_size >= count)                                            \n"
"    {                                                                         \n"
"      first_segment_size = count;                                             \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      second_segment_size = count - first_segment_size;                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  memcpy (dest, p->buffer + p->buffer_read_pos, first_segment_size);          \n"
"  p->buffer_read_pos += first_segment_size;                                   \n"
"                                                                              \n"
"  if (p->buffer_read_pos == p->buffer_size)                                   \n"
"    p->buffer_read_pos = 0;                                                   \n"
"                                                                              \n"
"  if (second_segment_size)                                                    \n"
"    {                                                                         \n"
"      memcpy (dest + first_segment_size, p->buffer + p->buffer_read_pos,      \n"
"              second_segment_size);                                           \n"
"      p->buffer_read_pos = second_segment_size;                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return first_segment_size + second_segment_size;                            \n"
"}                                                                             \n"
"                                                                              \n"
"#ifndef DISABLE_AUDIO                                                         \n"
"/* add an audio output stream */                                              \n"
"static AVStream *                                                             \n"
"add_audio_stream (GeglOpOperation *op, AVFormatContext * oc, int codec_id)    \n"
"{                                                                             \n"
"  Priv     *p = (Priv*)op->priv;                                              \n"
"  AVCodecContext *c;                                                          \n"
"  AVStream *st;                                                               \n"
"                                                                              \n"
"  p = NULL;                                                                   \n"
"  st = av_new_stream (oc, 1);                                                 \n"
"  if (!st)                                                                    \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Could not alloc stream\\n\");                        \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"  c->codec_id = codec_id;                                                     \n"
"  c->codec_type = CODEC_TYPE_AUDIO;                                           \n"
"                                                                              \n"
"  c->bit_rate = 64000;                                                        \n"
"  c->sample_rate = 44100;                                                     \n"
"  c->channels = 2;                                                            \n"
"  return st;                                                                  \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"open_audio (Priv * p, AVFormatContext * oc, AVStream * st)                    \n"
"{                                                                             \n"
"  AVCodecContext *c;                                                          \n"
"  AVCodec  *codec;                                                            \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  /* find the audio encoder */                                                \n"
"  codec = avcodec_find_encoder (c->codec_id);                                 \n"
"  if (!codec)                                                                 \n"
"    {                                                                         \n"
"      fprintf (stderr, \"codec not found\\n\");                               \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* open it */                                                               \n"
"  if (avcodec_open2 (c, codec, NULL) < 0)                                     \n"
"    {                                                                         \n"
"      fprintf (stderr, \"could not open codec\\n\");                          \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->audio_outbuf_size = 10000;                                               \n"
"  p->audio_outbuf = malloc (p->audio_outbuf_size);                            \n"
"                                                                              \n"
"  /* ugly hack for PCM codecs (will be removed ASAP with new PCM              \n"
"     support to compute the input frame size in samples */                    \n"
"  if (c->frame_size <= 1)                                                     \n"
"    {                                                                         \n"
"      fprintf (stderr, \"eeko\\n\");                                          \n"
"      p->audio_input_frame_size = p->audio_outbuf_size / c->channels;         \n"
"      switch (st->codec->codec_id)                                            \n"
"        {                                                                     \n"
"        case CODEC_ID_PCM_S16LE:                                              \n"
"        case CODEC_ID_PCM_S16BE:                                              \n"
"        case CODEC_ID_PCM_U16LE:                                              \n"
"        case CODEC_ID_PCM_U16BE:                                              \n"
"          p->audio_input_frame_size >>= 1;                                    \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      p->audio_input_frame_size = c->frame_size;                              \n"
"    }                                                                         \n"
"  /*audio_input_frame_size = 44100/25;*/                                      \n"
"  p->samples = malloc (p->audio_input_frame_size * 2 * c->channels);          \n"
"}                                                                             \n"
"                                                                              \n"
"void                                                                          \n"
"write_audio_frame (GeglProperties *op, AVFormatContext * oc, AVStream * st)   \n"
"{                                                                             \n"
"  Priv *p = (Priv*)op->user_data;                                             \n"
"                                                                              \n"
"  AVCodecContext *c;                                                          \n"
"  AVPacket  pkt;                                                              \n"
"  av_init_packet (&pkt);                                                      \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  /*fprintf (stderr, \"going to grab %i\\n\", p->fragment_size);*/            \n"
"  if (p->oxide_audio_get_fragment (p->oxide_audio_instance,                   \n"
"                                   p->fragment) == (signed) p->fragment_size) \n"
"    {                                                                         \n"
"      buffer_write (p, p->fragment, p->fragment_size);                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (buffer_used (p) >= p->audio_input_frame_size * 2 * c->channels)      \n"
"    {                                                                         \n"
"      buffer_read (p, (uint8_t *) p->samples,                                 \n"
"                   p->audio_input_frame_size * 2 * c->channels);              \n"
"                                                                              \n"
"      pkt.size = avcodec_encode_audio2 (c, p->audio_outbuf,                   \n"
"                                       p->audio_outbuf_size, p->samples);     \n"
"                                                                              \n"
"      pkt.pts = c->coded_frame->pts;                                          \n"
"      pkt.flags |= AV_PKT_FLAG_KEY;                                           \n"
"      pkt.stream_index = st->index;                                           \n"
"      pkt.data = p->audio_outbuf;                                             \n"
"                                                                              \n"
"      if (av_write_frame (oc, &pkt) != 0)                                     \n"
"        {                                                                     \n"
"          fprintf (stderr, \"Error while writing audio frame\\n\");           \n"
"          exit (1);                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"/*p->audio_get_frame (samples, audio_input_frame_size, c->channels);*/        \n"
"                                                                              \n"
"void                                                                          \n"
"close_audio (Priv * p, AVFormatContext * oc, AVStream * st)                   \n"
"{                                                                             \n"
"  avcodec_close (st->codec);                                                  \n"
"                                                                              \n"
"  av_free (p->samples);                                                       \n"
"  av_free (p->audio_outbuf);                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"/* add a video output stream */                                               \n"
"static AVStream *                                                             \n"
"add_video_stream (GeglProperties *op, AVFormatContext * oc, int codec_id)     \n"
"{                                                                             \n"
"  Priv *p = (Priv*)op->user_data;                                             \n"
"                                                                              \n"
"  AVCodecContext *c;                                                          \n"
"  AVStream *st;                                                               \n"
"                                                                              \n"
"  st = av_new_stream (oc, 0);                                                 \n"
"  if (!st)                                                                    \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Could not alloc stream %p %p %i\\n\", op, oc, codec_id);\n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"  c->codec_id = codec_id;                                                     \n"
"  c->codec_type = AVMEDIA_TYPE_VIDEO;                                         \n"
"                                                                              \n"
"  /* put sample propeters */                                                  \n"
"  c->bit_rate = op->bitrate;                                                  \n"
"  /* resolution must be a multiple of two */                                  \n"
"  c->width = p->width;                                                        \n"
"  c->height = p->height;                                                      \n"
"  /* frames per second */                                                     \n"
"  /*c->frame_rate = op->fps;                                                  \n"
"  c->frame_rate_base = 1;*/                                                   \n"
"                                                                              \n"
"#if LIBAVCODEC_BUILD >= 4754                                                  \n"
"  c->time_base=(AVRational){1, op->fps};                                      \n"
"    #else                                                                     \n"
"        c->frame_rate=op->fps;                                                \n"
"        c->frame_rate_base=1;                                                 \n"
"    #endif                                                                    \n"
"     c->pix_fmt = PIX_FMT_YUV420P;                                            \n"
"                                                                              \n"
"                                                                              \n"
"  c->gop_size = 12;             /* emit one intra frame every twelve frames at most */\n"
"  if (c->codec_id == CODEC_ID_MPEG2VIDEO)                                     \n"
"    {                                                                         \n"
"      /* just for testing, we also add B frames */                            \n"
"      /*c->max_b_frames = 2;*/                                                \n"
"    }                                                                         \n"
"/*    if (!strcmp (oc->oformat->name, \"mp4\") ||                             \n"
"          !strcmp (oc->oformat->name, \"3gp\"))                               \n"
"    c->flags |= CODEC_FLAG_GLOBAL_HEADER;                                     \n"
"    */                                                                        \n"
"  return st;                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static AVFrame *                                                              \n"
"alloc_picture (int pix_fmt, int width, int height)                            \n"
"{                                                                             \n"
"  AVFrame  *picture;                                                          \n"
"  uint8_t  *picture_buf;                                                      \n"
"  int       size;                                                             \n"
"                                                                              \n"
"  picture = avcodec_alloc_frame ();                                           \n"
"  if (!picture)                                                               \n"
"    return NULL;                                                              \n"
"  size = avpicture_get_size (pix_fmt, width, height);                         \n"
"  picture_buf = malloc (size);                                                \n"
"  if (!picture_buf)                                                           \n"
"    {                                                                         \n"
"      av_free (picture);                                                      \n"
"      return NULL;                                                            \n"
"    }                                                                         \n"
"  avpicture_fill ((AVPicture *) picture, picture_buf, pix_fmt, width, height);\n"
"  return picture;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"open_video (Priv * p, AVFormatContext * oc, AVStream * st)                    \n"
"{                                                                             \n"
"  AVCodec  *codec;                                                            \n"
"  AVCodecContext *c;                                                          \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  /* find the video encoder */                                                \n"
"  codec = avcodec_find_encoder (c->codec_id);                                 \n"
"  if (!codec)                                                                 \n"
"    {                                                                         \n"
"      fprintf (stderr, \"codec not found\\n\");                               \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* open the codec */                                                        \n"
"  if (avcodec_open (c, codec) < 0)                                            \n"
"    {                                                                         \n"
"      fprintf (stderr, \"could not open codec\\n\");                          \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->video_outbuf = NULL;                                                     \n"
"  if (!(oc->oformat->flags & AVFMT_RAWPICTURE))                               \n"
"    {                                                                         \n"
"      /* allocate output buffer */                                            \n"
"      /* XXX: API change will be done */                                      \n"
"      p->video_outbuf_size = 200000;                                          \n"
"      p->video_outbuf = malloc (p->video_outbuf_size);                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* allocate the encoded raw picture */                                      \n"
"  p->picture = alloc_picture (c->pix_fmt, c->width, c->height);               \n"
"  if (!p->picture)                                                            \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Could not allocate picture\\n\");                    \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* if the output format is not YUV420P, then a temporary YUV420P            \n"
"     picture is needed too. It is then converted to the required              \n"
"     output format */                                                         \n"
"  p->tmp_picture = NULL;                                                      \n"
"  if (c->pix_fmt != PIX_FMT_RGB24)                                            \n"
"    {                                                                         \n"
"      p->tmp_picture = alloc_picture (PIX_FMT_RGB24, c->width, c->height);    \n"
"      if (!p->tmp_picture)                                                    \n"
"        {                                                                     \n"
"          fprintf (stderr, \"Could not allocate temporary picture\\n\");      \n"
"          exit (1);                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"close_video (Priv * p, AVFormatContext * oc, AVStream * st)                   \n"
"{                                                                             \n"
"  avcodec_close (st->codec);                                                  \n"
"  av_free (p->picture->data[0]);                                              \n"
"  av_free (p->picture);                                                       \n"
"  if (p->tmp_picture)                                                         \n"
"    {                                                                         \n"
"      av_free (p->tmp_picture->data[0]);                                      \n"
"      av_free (p->tmp_picture);                                               \n"
"    }                                                                         \n"
"  av_free (p->video_outbuf);                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"string.h\"                                                         \n"
"                                                                              \n"
"/* prepare a dummy image */                                                   \n"
"static void                                                                   \n"
"fill_yuv_image (GeglProperties *op,                                           \n"
"                AVFrame *pict, int frame_index, int width, int height)        \n"
"{                                                                             \n"
"  Priv     *p = (Priv*)op->user_data;                                         \n"
"  /*memcpy (pict->data[0],                                                    \n"
"                                                                              \n"
"   op->input_pad[0]->data,                                                    \n"
"                                                                              \n"
"          op->input_pad[0]->width * op->input_pad[0]->height * 3);*/          \n"
"  GeglRectangle rect={0,0,width,height};                                      \n"
"  gegl_buffer_get (p->input, &rect, 1.0, babl_format (\"R'G'B' u8\"), pict->data[0], GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"write_video_frame (GeglProperties *op,                                        \n"
"                   AVFormatContext *oc, AVStream *st)                         \n"
"{                                                                             \n"
"  Priv     *p = (Priv*)op->user_data;                                         \n"
"  int       out_size, ret;                                                    \n"
"  AVCodecContext *c;                                                          \n"
"  AVFrame  *picture_ptr;                                                      \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  if (c->pix_fmt != PIX_FMT_RGB24)                                            \n"
"    {                                                                         \n"
"      struct SwsContext *img_convert_ctx;                                     \n"
"                                                                              \n"
"      /* as we only generate a RGB24 picture, we must convert it              \n"
"         to the codec pixel format if needed */                               \n"
"      fill_yuv_image (op, p->tmp_picture, p->frame_count, c->width,           \n"
"                      c->height);                                             \n"
"                                                                              \n"
"      img_convert_ctx = sws_getContext(c->width, c->height, c->pix_fmt,       \n"
"                                       c->width, c->height, PIX_FMT_RGB24,    \n"
"                                       SWS_BICUBIC, NULL, NULL, NULL);        \n"
"                                                                              \n"
"      if (img_convert_ctx == NULL)                                            \n"
"        {                                                                     \n"
"          fprintf(stderr, \"ff_save: Cannot initialize conversion context.\");\n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          sws_scale(img_convert_ctx,                                          \n"
"                    p->tmp_picture->data,                                     \n"
"                    p->tmp_picture->linesize,                                 \n"
"                    0,                                                        \n"
"                    c->height,                                                \n"
"                    p->picture->data,                                         \n"
"                    p->picture->linesize);                                    \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      fill_yuv_image (op, p->picture, p->frame_count, c->width, c->height);   \n"
"    }                                                                         \n"
"  picture_ptr = p->picture;                                                   \n"
"                                                                              \n"
"  if (oc->oformat->flags & AVFMT_RAWPICTURE)                                  \n"
"    {                                                                         \n"
"      /* raw video case. The API will change slightly in the near             \n"
"         future for that */                                                   \n"
"      AVPacket  pkt;                                                          \n"
"      av_init_packet (&pkt);                                                  \n"
"                                                                              \n"
"      pkt.flags |= AV_PKT_FLAG_KEY;                                           \n"
"      pkt.stream_index = st->index;                                           \n"
"      pkt.data = (uint8_t *) picture_ptr;                                     \n"
"      pkt.size = sizeof (AVPicture);                                          \n"
"                                                                              \n"
"      ret = av_write_frame (oc, &pkt);                                        \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      /* encode the image */                                                  \n"
"      out_size =                                                              \n"
"        avcodec_encode_video (c,                                              \n"
"                              p->video_outbuf,                                \n"
"                              p->video_outbuf_size, picture_ptr);             \n"
"                                                                              \n"
"      /* if zero size, it means the image was buffered */                     \n"
"      if (out_size != 0)                                                      \n"
"        {                                                                     \n"
"          AVPacket  pkt;                                                      \n"
"          av_init_packet (&pkt);                                              \n"
"                                                                              \n"
"          pkt.pts = c->coded_frame->pts;                                      \n"
"          if (c->coded_frame->key_frame)                                      \n"
"            pkt.flags |= AV_PKT_FLAG_KEY;                                     \n"
"          pkt.stream_index = st->index;                                       \n"
"          pkt.data = p->video_outbuf;                                         \n"
"          pkt.size = out_size;                                                \n"
"                                                                              \n"
"          /* write the compressed frame in the media file */                  \n"
"          ret = av_write_frame (oc, &pkt);                                    \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          ret = 0;                                                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  if (ret != 0)                                                               \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Error while writing video frame\\n\");               \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"  p->frame_count++;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"tfile (GeglProperties *self)                                                  \n"
"{                                                                             \n"
"  Priv *p = (Priv*)self->user_data;                                           \n"
"                                                                              \n"
"  p->fmt = av_guess_format (NULL, self->path, NULL);                          \n"
"  if (!p->fmt)                                                                \n"
"    {                                                                         \n"
"      fprintf (stderr,                                                        \n"
"               \"ff_save couldn't deduce outputformat from file extension: using MPEG.\\n%s\",\n"
"               \"\");                                                         \n"
"      p->fmt = av_guess_format (\"mpeg\", NULL, NULL);                        \n"
"    }                                                                         \n"
"  p->oc = avformat_alloc_context ();/*g_malloc (sizeof (AVFormatContext));*/  \n"
"  if (!p->oc)                                                                 \n"
"    {                                                                         \n"
"      fprintf (stderr, \"memory error\\n%s\", \"\");                          \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->oc->oformat = p->fmt;                                                    \n"
"                                                                              \n"
"  snprintf (p->oc->filename, sizeof (p->oc->filename), \"%s\", self->path);   \n"
"                                                                              \n"
"  p->video_st = NULL;                                                         \n"
"  p->audio_st = NULL;                                                         \n"
"                                                                              \n"
"  if (p->fmt->video_codec != CODEC_ID_NONE)                                   \n"
"    {                                                                         \n"
"      p->video_st = add_video_stream (self, p->oc, p->fmt->video_codec);      \n"
"    }                                                                         \n"
"  if (p->oxide_audio_query && p->fmt->audio_codec != CODEC_ID_NONE)           \n"
"    {                                                                         \n"
"     /*XXX: FOO p->audio_st = add_audio_stream (op, p->oc, p->fmt->audio_codec);*/\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (av_set_parameters (p->oc, NULL) < 0)                                    \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Invalid output format propeters\\n%s\", \"\");       \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  dump_format (p->oc, 0, self->path, 1);                                      \n"
"                                                                              \n"
"  if (p->video_st)                                                            \n"
"    open_video (p, p->oc, p->video_st);                                       \n"
"  if (p->audio_st)                                                            \n"
"    open_audio (p, p->oc, p->audio_st);                                       \n"
"                                                                              \n"
"  if (url_fopen (&p->oc->pb, self->path, URL_WRONLY) < 0)                     \n"
"    {                                                                         \n"
"      fprintf (stderr, \"couldn't open '%s'\\n\", self->path);                \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  av_write_header (p->oc);                                                    \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
"static int                                                                    \n"
"filechanged (GeglOpOperation *op, const char *att)                            \n"
"{                                                                             \n"
"  init (op);                                                                  \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  static gint inited = 0;                                                     \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  g_assert (input);                                                           \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  p->width = result->width;                                                   \n"
"  p->height = result->height;                                                 \n"
"  p->input = input;                                                           \n"
"                                                                              \n"
"  if (!inited)                                                                \n"
"    {                                                                         \n"
"      tfile (o);                                                              \n"
"      inited = 1;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  write_video_frame (o, p->oc, p->video_st);                                  \n"
"  if (p->audio_st)                                                            \n"
"    write_audio_frame (o, p->oc, p->audio_st);                                \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"                                                                              \n"
"    if (p->oc)                                                                \n"
"      {                                                                       \n"
"        gint i;                                                               \n"
"        if (p->video_st)                                                      \n"
"          close_video (p, p->oc, p->video_st);                                \n"
"        if (p->audio_st)                                                      \n"
"          close_audio (p, p->oc, p->audio_st);                                \n"
"                                                                              \n"
"        av_write_trailer (p->oc);                                             \n"
"                                                                              \n"
"        for (i = 0; i < p->oc->nb_streams; i++)                               \n"
"          {                                                                   \n"
"            av_freep (&p->oc->streams[i]);                                    \n"
"          }                                                                   \n"
"                                                                              \n"
"        url_fclose (&p->oc->pb);                                              \n"
"        free (p->oc);                                                         \n"
"      }                                                                       \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (g_type_class_peek_parent (G_OBJECT_GET_CLASS (object)))->finalize (object);\n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:ff-save\",                                       \n"
"    \"categories\"  , \"output:video\",                                       \n"
"    \"description\" , _(\"FFmpeg video output sink\"),                        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
