package jpeg

import "github.com/wader/fq/pkg/scalar"

// based on https://www.adobe.com/devnet-apps/photoshop/fileformatashtml
var psImageResourceBlockNames = scalar.UintMapDescription{
	0x03E8: `Contains five 2-byte values: number of channels, rows, columns, depth, and mode`,
	0x03E9: `Macintosh print manager print info record`,
	0x03EA: `Macintosh page format information. No longer read by Photoshop. (Obsolete)`,
	0x03EB: `Indexed color table`,
	0x03ED: `ResolutionInfo structure. See Appendix A in Photoshop API Guide.pdf`,
	0x03EE: `Names of the alpha channels as a series of Pascal strings`,
	0x03EF: `(Obsolete) See ID 1077DisplayInfo structure. See Appendix A in Photoshop API Guide.pdf`,
	0x03F0: `The caption as a Pascal string`,
	0x03F1: `Border information. Contains a fixed number (2 bytes real, 2 bytes fraction) for the border width, and 2 bytes for border units (1 = inches, 2 = cm, 3 = points, 4 = picas, 5 = columns)`,
	0x03F2: `Background color. See See Color structure`,
	0x03F3: `Print flags. A series of one-byte boolean values (see Page Setup dialog): labels, crop marks, color bars, registration marks, negative, flip, interpolate, caption, print flags`,
	0x03F4: `Grayscale and multichannel halftoning information`,
	0x03F5: `Color halftoning information`,
	0x03F6: `Duotone halftoning information`,
	0x03F7: `Grayscale and multichannel transfer function`,
	0x03F8: `Color transfer functions`,
	0x03F9: `Duotone transfer functions`,
	0x03FA: `Duotone image information`,
	0x03FB: `Two bytes for the effective black and white values for the dot range`,
	0x03FC: `(Obsolete)`,
	0x03FD: `EPS options`,
	0x03FE: `Quick Mask information. 2 bytes containing Quick Mask channel ID; 1- byte boolean indicating whether the mask was initially empty`,
	0x03FF: `(Obsolete)`,
	0x0400: `Layer state information. 2 bytes containing the index of target layer (0 = bottom layer)`,
	0x0401: `Working path (not saved). See See Path resource format`,
	0x0402: `Layers group information. 2 bytes per layer containing a group ID for the dragging groups. Layers in a group have the same group ID`,
	0x0403: `(Obsolete)`,
	0x0404: `IPTC-NAA record. Contains the File Info... information. See the documentation in the IPTC folder of the Documentation folder`,
	0x0405: `Image mode for raw format files`,
	0x0406: `JPEG quality. Private`,
	0x0408: `(Photoshop 4.0) Grid and guides information. See See Grid and guides resource format`,
	0x0409: `(Photoshop 4.0) Thumbnail resource for Photoshop 4.0 only. See See Thumbnail resource format`,
	0x040A: `(Photoshop 4.0) Copyright flag. Boolean indicating whether image is copyrighted. Can be set via Property suite or by user in File Info`,
	0x040B: `(Photoshop 4.0) URL. Handle of a text string with uniform resource locator. Can be set via Property suite or by user in File Info`,
	0x040C: `(Photoshop 5.0) Thumbnail resource (supersedes resource 1033). See See Thumbnail resource format`,
	0x040D: `(Photoshop 5.0) Global Angle. 4 bytes that contain an integer between 0 and 359, which is the global lighting angle for effects layer. If not present, assumed to be 30`,
	0x040E: `(Obsolete) See ID 1073 below. (Photoshop 5.0) Color samplers resource. See See Color samplers resource format`,
	0x040F: `(Photoshop 5.0) ICC Profile. The raw bytes of an ICC (International Color Consortium) format profile. See ICC1v42_2006-05.pdf in the Documentation folder and icProfileHeader.h in Sample Code\Common\Includes `,
	0x0410: `(Photoshop 5.0) Watermark. One byte`,
	0x0411: `(Photoshop 5.0) ICC Untagged Profile. 1 byte that disables any assumed profile handling when opening the file. 1 = intentionally untagged`,
	0x0412: `(Photoshop 5.0) Effects visible. 1-byte global flag to show/hide all the effects layer. Only present when they are hidden`,
	0x0413: `(Photoshop 5.0) Spot Halftone. 4 bytes for version, 4 bytes for length, and the variable length data`,
	0x0414: `(Photoshop 5.0) Document-specific IDs seed number. 4 bytes: Base value, starting at which layer IDs will be generated (or a greater value if existing IDs already exceed it). Its purpose is to avoid the case where we add layers, flatten, save, open, and then add more layers that end up with the same IDs as the first set`,
	0x0415: `(Photoshop 5.0) Unicode Alpha Names. Unicode string`,
	0x0416: `(Photoshop 6.0) Indexed Color Table Count. 2 bytes for the number of colors in table that are actually defined`,
	0x0417: `(Photoshop 6.0) Transparency Index. 2 bytes for the index of transparent color, if any`,
	0x0419: `(Photoshop 6.0) Global Altitude. 4 byte entry for altitude`,
	0x041A: `(Photoshop 6.0) Slices. See See Slices resource format`,
	0x041B: `(Photoshop 6.0) Workflow URL. Unicode string`,
	0x041C: `(Photoshop 6.0) Jump To XPEP. 2 bytes major version, 2 bytes minor version, 4 bytes count. Following is repeated for count: 4 bytes block size, 4 bytes key, if key = 'jtDd' , then next is a Boolean for the dirty flag; otherwise it's a 4 byte entry for the mod date`,
	0x041D: `(Photoshop 6.0) Alpha Identifiers. 4 bytes of length, followed by 4 bytes each for every alpha identifier`,
	0x041E: `(Photoshop 6.0) URL List. 4 byte count of URLs, followed by 4 byte long, 4 byte ID, and Unicode string for each count`,
	0x0421: `(Photoshop 6.0) Version Info. 4 bytes version, 1 byte hasRealMergedData , Unicode string: writer name, Unicode string: reader name, 4 bytes file version`,
	0x0422: `(Photoshop 7.0) EXIF data 1. See http://www.kodak.com/global/plugins/acrobat/en/service/digCam/exifStandard2.pdf`,
	0x0423: `(Photoshop 7.0) EXIF data 3. See http://www.kodak.com/global/plugins/acrobat/en/service/digCam/exifStandard2.pdf`,
	0x0424: `(Photoshop 7.0) XMP metadata. File info as XML description. See http://www.adobe.com/devnet/xmp/`,
	0x0425: `(Photoshop 7.0) Caption digest. 16 bytes: RSA Data Security, MD5 message-digest algorithm`,
	0x0426: `(Photoshop 7.0) Print scale. 2 bytes style (0 = centered, 1 = size to fit, 2 = user defined). 4 bytes x location (floating point). 4 bytes y location (floating point). 4 bytes scale (floating point)`,
	0x0428: `(Photoshop CS) Pixel Aspect Ratio. 4 bytes (version = 1 or 2), 8 bytes double, x / y of a pixel. Version 2, attempting to correct values for NTSC and PAL, previously off by a factor of approx. 5%`,
	0x0429: `(Photoshop CS) Layer Comps. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure)`,
	0x042A: `(Photoshop CS) Alternate Duotone Colors. 2 bytes (version = 1), 2 bytes count, following is repeated for each count: [ Color: 2 bytes for space followed by 4 * 2 byte color component ], following this is another 2 byte count, usually 256, followed by Lab colors one byte each for L, a, b. This resource is not read or used by Photoshop`,
	0x042B: `(Photoshop CS)Alternate Spot Colors. 2 bytes (version = 1), 2 bytes channel count, following is repeated for each count: 4 bytes channel ID, Color: 2 bytes for space followed by 4 * 2 byte color component. This resource is not read or used by Photoshop`,
	0x042D: `(Photoshop CS2) Layer Selection ID(s). 2 bytes count, following is repeated for each count: 4 bytes layer ID`,
	0x042E: `(Photoshop CS2) HDR Toning information`,
	0x042F: `(Photoshop CS2) Print info`,
	0x0430: `(Photoshop CS2) Layer Group(s) Enabled ID. 1 byte for each layer in the document, repeated by length of the resource. NOTE: Layer groups have start and end markers`,
	0x0431: `(Photoshop CS3) Color samplers resource. Also see ID 1038 for old format. See See Color samplers resource format`,
	0x0432: `(Photoshop CS3) Measurement Scale. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure)`,
	0x0433: `(Photoshop CS3) Timeline Information. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure)`,
	0x0434: `(Photoshop CS3) Sheet Disclosure. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure)`,
	0x0435: `(Photoshop CS3) DisplayInfo structure to support floating point clors. Also see ID 1007. See Appendix A in Photoshop API Guide.pdf `,
	0x0436: `(Photoshop CS3) Onion Skins. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure)`,
	0x0438: `(Photoshop CS4) Count Information. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure) Information about the count in the document. See the Count Tool`,
	0x043A: `(Photoshop CS5) Print Information. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure) Information about the current print settings in the document. The color management options`,
	0x043B: `(Photoshop CS5) Print Style. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure) Information about the current print style in the document. The printing marks, labels, ornaments, etc`,
	0x043C: `(Photoshop CS5) Macintosh NSPrintInfo. Variable OS specific info for Macintosh. NSPrintInfo. It is recommended that you do not interpret or use this data`,
	0x043D: `(Photoshop CS5) Windows DEVMODE. Variable OS specific info for Windows. DEVMODE. It is recommended that you do not interpret or use this data`,
	0x043E: `(Photoshop CS6) Auto Save File Path. Unicode string. It is recommended that you do not interpret or use this data`,
	0x043F: `(Photoshop CS6) Auto Save Format. Unicode string. It is recommended that you do not interpret or use this data`,
	0x0440: `(Photoshop CC) Path Selection State. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure) Information about the current path selection state`,
	// 0x07D0 - 0x0BB6: `Path Information (saved paths). See See Path resource format`},
	0x0BB7: `Name of clipping path. See See Path resource format`,
	0x0BB8: `(Photoshop CC) Origin Path Info. 4 bytes (descriptor version = 16), Descriptor (see See Descriptor structure) Information about the origin path data`,
	// 0x0FA0 - 0x1387: `Plug-In resource(s). Resources added by a plug-in. See the plug-in API found in the SDK documentation`},
	0x1B58: `Image Ready variables. XML representation of variables definition`,
	0x1B59: `Image Ready data sets`,
	0x1B5A: `Image Ready default selected state`,
	0x1B5B: `Image Ready 7 rollover expanded state`,
	0x1B5C: `Image Ready rollover expanded state`,
	0x1B5D: `Image Ready save layer settings`,
	0x1B5E: `Image Ready version`,
	0x1F40: `(Photoshop CS3) Lightroom workflow, if present the document is in the middle of a Lightroom workflow`,
	0x2710: `Print flags information. 2 bytes version ( = 1), 1 byte center crop marks, 1 byte ( = 0), 4 bytes bleed width value, 2 bytes bleed width scale`,
}
