/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAnnotation;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.Node;

public class UseSingleton
extends AbstractRule {
    public Object visit(ASTClassOrInterfaceBody decl, Object data) {
        if (decl.jjtGetParent() instanceof ASTClassOrInterfaceDeclaration) {
            ASTClassOrInterfaceDeclaration parent = (ASTClassOrInterfaceDeclaration)decl.jjtGetParent();
            if (parent.isAbstract() || parent.isInterface()) {
                return super.visit(decl, data);
            }
            int i = decl.jjtGetNumChildren();
            int methodCount = 0;
            boolean isOK = false;
            while (i > 0) {
                ASTResultType res;
                ASTClassOrInterfaceType c;
                Node p;
                if ((p = decl.jjtGetChild(--i)).jjtGetNumChildren() == 0) continue;
                Node n = p.jjtGetChild(0);
                if (n instanceof ASTAnnotation) {
                    n = p.jjtGetChild(1);
                }
                if (n instanceof ASTFieldDeclaration) {
                    if (((ASTFieldDeclaration)n).isStatic()) continue;
                    isOK = true;
                    break;
                }
                if (n instanceof ASTConstructorDeclaration) {
                    if (!((ASTConstructorDeclaration)n).isPrivate()) continue;
                    isOK = true;
                    break;
                }
                if (!(n instanceof ASTMethodDeclaration)) continue;
                ASTMethodDeclaration m = (ASTMethodDeclaration)n;
                if (!m.isPrivate()) {
                    ++methodCount;
                }
                if (!m.isStatic()) {
                    isOK = true;
                    break;
                }
                if (!m.getMethodName().equals("suite") || (c = (res = m.getResultType()).getFirstChildOfType(ASTClassOrInterfaceType.class)) == null || !c.hasImageEqualTo("Test")) continue;
                isOK = true;
                break;
            }
            if (!isOK && methodCount > 0) {
                this.addViolation(data, decl);
            }
        }
        return super.visit(decl, data);
    }
}

