#ifndef FFRENZY_PACKETS_H
#define FFRENZY_PACKETS_H

#include <stdio.h>

#include "global.h"
#include "network.h"

#define PACKET_CLIENT_INFO    (1 << 0)
#define PACKET_REPLY          (1 << 1)
#define PACKET_PLAYER_REQ     (1 << 2)
#define PACKET_SYNC           (1 << 3)
#define PACKET_ACTION         (1 << 4)
#define PACKET_PLAYER_INFO    (1 << 5)
#define PACKET_CONN_REQ       (1 << 6)
#define PACKET_LEVEL_INFO     (1 << 7)

#define MAXSTRINGSIZE  256

typedef struct {
  uint32_t type;
} Packet_base;

typedef struct {
  Packet_base base;
  char version[MAXSTRINGSIZE+1];
} Packet_client_info;


typedef struct {
  Packet_base base;
  uint32_t player;
  uint32_t action;
} Packet_action;

typedef struct {
  Packet_base base;
  int32_t reply;
} Packet_reply;

typedef struct {
  Packet_base base;
} Packet_sync;

typedef struct {
  Packet_base base;
  char name[MAXSTRINGSIZE+1];
} Packet_player_req;

typedef struct {
  Packet_base base;
  uint32_t player;
  char name[MAXSTRINGSIZE+1];
} Packet_player_info;

typedef struct {
  Packet_base base;
  char host[MAXSTRINGSIZE+1];
  uint32_t port;
} Packet_conn_req;

typedef struct {
  Packet_base base;
  char data[MAXSTRINGSIZE+1];
} Packet_level_info;

int packet_get_type(Network_packet *packet);

Network_packet *new_packet_client_info(char *version);
char *packet_client_info_get_version(Network_packet *packet);

Network_packet *new_packet_reply(int32_t reply);
int32_t packet_reply_get_reply(Network_packet *packet);

Network_packet *new_packet_sync(void);

Network_packet *new_packet_action(uint32_t player, uint32_t event);
uint32_t packet_action_get_player(Network_packet *packet);
uint32_t packet_action_get_event(Network_packet *packet);

Network_packet *new_packet_player_req(char *name);
char *packet_player_req_get_name(Network_packet *packet);

Network_packet *new_packet_player_info(uint32_t player, char *name);
char *packet_player_info_get_name(Network_packet *packet);
uint32_t packet_player_info_get_number(Network_packet *packet);

Network_packet *new_packet_conn_req(char *host,uint32_t port);
char *packet_conn_req_gethost(Network_packet *p);
uint32_t packet_conn_req_getport(Network_packet *p);

Network_packet *new_packet_level_info(char *data,int *len);
char *packet_level_info_get_data(Network_packet *p);

#endif /* FFRENZY_PACKETS_H */
