/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.logging.Logger;
import visad.util.FloatTupleArray;

public class FloatTupleArrayImpl
implements FloatTupleArray {
    private static Logger log = Logger.getLogger(FloatTupleArrayImpl.class.getName());
    public static final float DEF_GROW_FACTOR = 1.5f;
    protected float[][] elements;
    private int size;
    private final int dim;
    private final float growFactor;

    public FloatTupleArrayImpl(int dim, int initialSize) {
        this(dim, initialSize, 1.5f);
    }

    public FloatTupleArrayImpl(int dim, int initialSize, float growFactor) {
        assert (initialSize > 1);
        this.dim = dim;
        this.elements = new float[dim][initialSize];
        this.growFactor = growFactor;
    }

    protected void grow() {
        int newSize = (int)((float)this.elements[0].length * this.growFactor);
        log.fine("growing from " + this.elements[0].length + " to " + newSize);
        float[][] newArr = new float[this.elements.length][newSize];
        for (int i = 0; i < this.elements.length; ++i) {
            System.arraycopy(this.elements[i], 0, newArr[i], 0, this.elements[0].length);
        }
        this.elements = newArr;
        newArr = null;
    }

    public void add(float[][] values, int start, int num) {
        int spaceLeft = this.elements[0].length - this.size;
        while (spaceLeft < num) {
            this.grow();
            spaceLeft = this.elements[0].length - this.size;
        }
        for (int i = 0; i < this.dim; ++i) {
            System.arraycopy(values[i], start, this.elements[i], this.size, num);
        }
        this.size += num;
    }

    public float[][] elements() {
        return this.elements;
    }

    public void add(float[][] values) {
        this.add(values, 0, values[0].length);
    }

    public void set(int i, int j, float val) {
        assert (i < this.dim);
        assert (j < this.size);
        this.elements[i][j] = val;
    }

    public float[] get(int idx) {
        assert (idx >= 0 && idx < this.size);
        float[] point = new float[this.dim()];
        for (int i = 0; i < this.dim(); ++i) {
            point[i] = this.elements[i][idx];
        }
        return point;
    }

    public float get(int i, int j) {
        assert (i < this.elements.length);
        assert (i < this.size);
        return this.elements[i][j];
    }

    public float[][] toArray() {
        float[][] ret = new float[this.dim][this.size];
        for (int i = 0; i < this.dim; ++i) {
            System.arraycopy(this.elements[i], 0, ret[i], 0, this.size);
        }
        return ret;
    }

    public int size() {
        return this.size;
    }

    public int dim() {
        return this.dim;
    }
}

