/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;

public class BaseMapAdapter {
    private boolean isCoordinateSystem = false;
    private int latMax = 900000;
    private int latMin = -900000;
    private int lonMax = 1800000;
    private int lonMin = -1800000;
    private int segmentPointer = 0;
    private int numEles = 0;
    private int numLines = 0;
    private CoordinateSystem cs = null;
    private DataInputStream din;
    private MathType coordMathType;
    private int position;
    private int numSegments = 0;
    private int[][] segList;
    private boolean isEastPositive = true;
    private int xfirst = 0;
    private int xlast = 0;
    private int yfirst = 0;
    private int ylast = 0;
    private int MAX_SEGMENTS = 100000;

    public BaseMapAdapter(String filename) throws IOException, VisADException {
        this(new FileInputStream(filename), null);
    }

    public BaseMapAdapter(String filename, Rectangle2D bbox) throws IOException, VisADException {
        this(new FileInputStream(filename), null);
    }

    public BaseMapAdapter(URL url) throws IOException, VisADException {
        this(url.openStream(), null);
    }

    public BaseMapAdapter(URL url, Rectangle2D bbox) throws IOException, VisADException {
        this(url.openStream(), bbox);
    }

    public BaseMapAdapter(InputStream is) throws IOException, VisADException {
        this(is, null);
    }

    public BaseMapAdapter(InputStream is, Rectangle2D bbox) throws IOException, VisADException {
        this.din = new DataInputStream(new BufferedInputStream(is));
        this.InitFile();
        if (bbox != null) {
            this.setLatLonLimits((float)bbox.getMinY(), (float)bbox.getMaxY(), (float)bbox.getMinX(), (float)bbox.getMaxX());
        }
    }

    public void setLatLonLimits(Rectangle2D bbox) {
        this.setLatLonLimits((float)bbox.getMinY(), (float)bbox.getMaxY(), (float)bbox.getMinX(), (float)bbox.getMaxX());
    }

    public void setLatLonLimits(float latmin, float latmax, float lonmin, float lonmax) {
        this.latMin = latmin == Float.NaN ? -900000 : (int)(latmin * 10000.0f);
        this.latMax = latmax == Float.NaN ? 900000 : (int)(latmax * 10000.0f);
        this.lonMin = lonmin == Float.NaN ? -1800000 : (int)(lonmin * 10000.0f);
        this.lonMax = lonmax == Float.NaN ? 1800000 : (int)(lonmax * 10000.0f);
    }

    public void setDomainSet(Linear2DSet domainSet) throws VisADException {
        this.coordMathType = domainSet.getType();
        this.cs = domainSet.getCoordinateSystem();
        this.numEles = domainSet.getX().getLength();
        this.numLines = domainSet.getY().getLength();
        this.xfirst = (int)domainSet.getX().getFirst();
        this.xlast = (int)domainSet.getX().getLast();
        this.yfirst = (int)domainSet.getY().getFirst();
        this.ylast = (int)domainSet.getY().getLast();
        this.computeLimits();
    }

    public void setCoordinateSystem(CoordinateSystem cs, int numEles, int numLines, RealTupleType domain) throws VisADException {
        this.numEles = numEles;
        this.numLines = numLines;
        this.cs = cs;
        this.coordMathType = domain;
        this.xlast = numEles - 1;
        this.ylast = numLines - 1;
        this.computeLimits();
    }

    public void doByLatLon() {
        this.isCoordinateSystem = false;
        try {
            this.coordMathType = new RealTupleType(RealType.Latitude, RealType.Longitude);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void computeLimits() {
        float[][] linele = new float[][]{{this.xfirst, this.xlast, this.xlast, this.xfirst}, {this.yfirst, this.yfirst, this.ylast, this.ylast}};
        try {
            float[][] latlon = this.cs.toReference(linele);
            if (Float.isNaN(latlon[0][0])) {
                latlon[0][0] = 90.0f;
            }
            if (Float.isNaN(latlon[1][0])) {
                latlon[1][0] = 180.0f;
            }
            if (Float.isNaN(latlon[0][1])) {
                latlon[0][1] = 90.0f;
            }
            if (Float.isNaN(latlon[1][1])) {
                latlon[1][1] = -180.0f;
            }
            if (Float.isNaN(latlon[0][2])) {
                latlon[0][2] = -90.0f;
            }
            if (Float.isNaN(latlon[1][2])) {
                latlon[1][2] = 180.0f;
            }
            if (Float.isNaN(latlon[0][3])) {
                latlon[0][3] = -90.0f;
            }
            if (Float.isNaN(latlon[1][3])) {
                latlon[1][3] = -180.0f;
            }
            this.setLatLonLimits(Math.min(latlon[0][0], Math.min(latlon[0][1], Math.min(latlon[0][2], latlon[0][3]))), Math.max(latlon[0][0], Math.max(latlon[0][1], Math.max(latlon[0][2], latlon[0][3]))), Math.min(latlon[1][0], Math.min(latlon[1][1], Math.min(latlon[1][2], latlon[1][3]))), Math.max(latlon[1][0], Math.max(latlon[1][1], Math.max(latlon[1][2], latlon[1][3]))));
        }
        catch (Exception ell) {
            System.out.println(ell);
        }
        this.isCoordinateSystem = true;
    }

    private void InitFile() throws VisADException {
        this.coordMathType = RealTupleType.LatitudeLongitudeTuple;
        try {
            this.numSegments = this.din.readInt();
        }
        catch (IOException e) {
            throw new VisADException("Error reading map file " + e);
        }
        if (this.numSegments <= 0 || this.numSegments > this.MAX_SEGMENTS) {
            throw new VisADException("McIDAS map file format error: number of segments = " + this.numSegments);
        }
        this.position = 4;
        this.segList = new int[this.numSegments][6];
        for (int i = 0; i < this.numSegments; ++i) {
            try {
                for (int j = 0; j < 6; ++j) {
                    this.segList[i][j] = this.din.readInt();
                    if (j == 4 && this.segList[i][4] < 0) {
                        throw new VisADException("McIDAS map file format error: Negative pointer (" + this.segList[i][4] + ") to start of data for segment " + i);
                    }
                    if (j == 5 && (this.segList[i][5] < 0 || this.segList[i][5] % 2 != 0)) {
                        throw new VisADException("McIDAS map file format error: Wrong number of words (" + this.segList[i][5] + ") to read for segment " + i);
                    }
                    this.position += 4;
                }
                continue;
            }
            catch (IOException e) {
                throw new VisADException("Base Map: Error reading map file: " + e);
            }
        }
        this.segmentPointer = -1;
    }

    private int findNextSegment() throws VisADException {
        while (true) {
            ++this.segmentPointer;
            if (this.segmentPointer >= this.numSegments) {
                return 0;
            }
            if (this.segList[this.segmentPointer][0] > this.latMax || this.segList[this.segmentPointer][1] < this.latMin) continue;
            if (this.isEastPositive) {
                int mx = -this.segList[this.segmentPointer][2];
                int mn = -this.segList[this.segmentPointer][3];
                if (this.lonMax > 1800000) {
                    if (mx < 0 && mx < this.lonMin) {
                        mx += 3600000;
                    }
                    if (mn < 0 && mn < this.lonMin) {
                        mn += 3600000;
                    }
                }
                if (mx <= this.lonMax && mn >= this.lonMin) break;
                continue;
            }
            if (this.segList[this.segmentPointer][2] <= this.lonMax && this.segList[this.segmentPointer][3] >= this.lonMin) break;
        }
        return this.segList[this.segmentPointer][5] / 2;
    }

    private float[][] getLatLons() throws VisADException {
        float[][] lalo;
        int skipByte;
        int numPairs = this.segList[this.segmentPointer][5] / 2;
        if (numPairs < 0) {
            throw new VisADException("Error in map file: Negative number of lat/lon pairs");
        }
        float dLonMin = (float)this.lonMin / 10000.0f;
        try {
            skipByte = this.segList[this.segmentPointer][4] * 4 - this.position;
            try {
                this.din.skipBytes(skipByte);
            }
            catch (Exception e) {
                throw new VisADException("Base Map: IOException in skip" + e);
            }
            lalo = new float[2][numPairs];
            for (int i = 0; i < numPairs; ++i) {
                int lat = this.din.readInt();
                int lon = this.din.readInt();
                lalo[0][i] = (float)lat / 10000.0f;
                lalo[1][i] = (float)lon / 10000.0f;
                if (!this.isEastPositive) continue;
                lalo[1][i] = -lalo[1][i];
                if (!((double)lalo[1][i] < 0.0) || !(lalo[1][i] < dLonMin) || this.lonMax <= 1800000) continue;
                lalo[1][i] = 360.0f + lalo[1][i];
            }
        }
        catch (IOException e) {
            throw new VisADException("Base Map: read past EOF");
        }
        this.position = this.position + skipByte + 8 * numPairs;
        return lalo;
    }

    public UnionSet getData() {
        UnionSet maplines = null;
        int st = 1;
        Vector<Gridded2DSet> sets = new Vector<Gridded2DSet>();
        float maxEle = (float)this.numEles / 2.0f;
        try {
            int inum = 0;
            while ((st = this.findNextSegment()) != 0) {
                Gridded2DSet gs;
                float[][] lalo = this.getLatLons();
                int ll = lalo[0].length;
                int lbeg = 0;
                int lnum = 0;
                if (this.isCoordinateSystem) {
                    float[][] llout;
                    float[][] linele = this.cs.fromReference(lalo);
                    boolean missing = false;
                    for (int i = 0; i < ll; ++i) {
                        if (Float.isNaN(linele[0][i])) {
                            missing = true;
                            break;
                        }
                        if (i > 0 && Math.abs(linele[0][i] - linele[0][i - 1]) > maxEle) {
                            if (lnum > 1) {
                                llout = new float[2][lnum];
                                System.arraycopy(linele[0], lbeg, llout[0], 0, lnum);
                                System.arraycopy(linele[1], lbeg, llout[1], 0, lnum);
                                gs = new Gridded2DSet(this.coordMathType, llout, lnum);
                                sets.addElement(gs);
                            }
                            lnum = 0;
                            lbeg = i;
                        }
                        ++lnum;
                    }
                    if (missing) continue;
                    if (lnum == ll) {
                        gs = new Gridded2DSet(this.coordMathType, linele, ll);
                        sets.addElement(gs);
                    } else if (lnum > 1) {
                        llout = new float[2][lnum];
                        System.arraycopy(linele[0], lbeg, llout[0], 0, lnum);
                        System.arraycopy(linele[1], lbeg, llout[1], 0, lnum);
                        gs = new Gridded2DSet(this.coordMathType, llout, lnum);
                        sets.addElement(gs);
                    }
                } else {
                    gs = new Gridded2DSet(this.coordMathType, lalo, ll);
                    sets.addElement(gs);
                }
                inum += ll;
            }
            if (!sets.isEmpty()) {
                Object[] basemaplines = new Gridded2DSet[sets.size()];
                sets.copyInto(basemaplines);
                maplines = new UnionSet(this.coordMathType, (SampledSet[])basemaplines, null, null, null, false);
            }
        }
        catch (Exception em) {
            em.printStackTrace();
            return null;
        }
        return maplines;
    }

    public void setEastPositive(boolean value) {
        this.isEastPositive = value;
    }

    public boolean isEastPositive() {
        return this.isEastPositive;
    }
}

