/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.GribReadTextIndex;
import ucar.grib.Index;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Indexer;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1IndexExtender
extends Grib1Indexer {
    private final boolean showTime = false;
    private long indexLength = 0L;
    private final ArrayList origPds = new ArrayList();
    private final HashMap origGds = new HashMap();
    private static final Pattern idxlength = Pattern.compile("length = (\\d+)$");
    private static final Pattern gdskey = Pattern.compile("GDSkey = (\\d+)$");
    private static final Pattern endOfData = Pattern.compile("\\s(\\d*)\\s(\\d*)\\s(true|false)");
    private long startSeek = 0L;
    private final String delimiter = "--------------------------------------------------------------------";

    public final Index extendIndex(RandomAccessFile inputRaf, File indexFile, Index index) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(Grib2WriteIndex.indexRafBufferSize);
        PrintStream ps = null;
        File tmp = null;
        boolean rename = false;
        try {
            this.getPdsAndGdsFromOrigIndex(indexFile);
            if (this.indexLength == inputRaf.length()) {
                Index index2 = index;
                return index2;
            }
            inputRaf.seek(this.startSeek);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            tmp = indexFile.getParent() == null ? new File("." + indexFile.getName()) : new File(indexFile.getParent() + "/." + indexFile.getName());
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(tmp, false)));
            ps.println("index_version = " + GribReadTextIndex.currentTextIndexVersion);
            ps.println("grid_edition = 1");
            ps.println("location = " + inputRaf.getLocation().replaceAll(" ", "%20"));
            ps.println("length = " + inputRaf.length());
            ps.println("created = " + dateFormat.format(now));
            if (index != null) {
                index.addGlobalAttribute("length", Long.toString(inputRaf.length()));
                index.addGlobalAttribute("location", inputRaf.getLocation().replaceAll(" ", "%20"));
                index.addGlobalAttribute("created", dateFormat.format(now));
            }
            HashMap<String, Grib1GridDefinitionSection> gdsHM = g1i.getGDSs();
            ArrayList<Grib1Product> products = g1i.getProducts();
            if (products.size() == 0) {
                ps.close();
                ps = null;
                tmp.delete();
                Index index3 = null;
                return index3;
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                if (i == 0) {
                    ps.println("center = " + pds.getCenter());
                    ps.println("sub_center = " + pds.getSubCenter());
                    ps.println("table_version = " + pds.getTableVersion());
                    this.checkForTiledThinEnsemble(index != null, index, pds, gdsHM, this.origGds, ps);
                    ps.println("--------------------------------------------------------------------");
                    for (int j = 0; j < this.origPds.size(); ++j) {
                        ps.println((String)this.origPds.get(j));
                    }
                }
                ps.println(pds.getProductDefinition() + " " + product.getDiscipline() + " " + product.getCategory() + " " + pds.getParameter().getNumber() + " " + pds.getTypeGenProcess() + " " + pds.getLevelType() + " " + pds.getLevelValue1() + " " + "255 " + pds.getLevelValue2() + " " + dateFormat.format(pds.getBaseTime()) + " " + pds.getForecastTime() + " " + product.getGDSkey() + " " + product.getOffset1() + " " + product.getOffset2() + " " + pds.getDecimalScale() + " " + pds.bmsExists() + " " + pds.getCenter() + " " + pds.getSubCenter() + " " + pds.getTableVersion());
                if (index != null) {
                    index.addGribRecord(Grib1IndexExtender.makeGribRecord(index, product));
                }
                ++count;
            }
            Iterator<Object> it = this.origGds.keySet().iterator();
            while (it.hasNext()) {
                ps.println("--------------------------------------------------------------------");
                String key = (String)it.next();
                ps.print((String)this.origGds.get(key));
            }
            for (String key : gdsHM.keySet()) {
                Grib1GridDefinitionSection gds;
                if (this.origGds.containsKey(key) || (gds = gdsHM.get(key)).getGridType() != 0 && gds.getGridType() != 4) continue;
                ps.println("--------------------------------------------------------------------");
                ps.println("GDSkey = " + key);
                this.printGDS(gds, ps);
                if (index == null) continue;
                index.addHorizCoordSys(Grib1IndexExtender.makeGdsRecord(gds));
            }
            rename = true;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
            if (ps != null) {
                ps.close();
                if (rename && indexFile.delete() && !tmp.renameTo(indexFile)) {
                    throw new IOException("Failed to rename indexFile to " + indexFile.getPath());
                }
            }
        }
        return index;
    }

    private void getPdsAndGdsFromOrigIndex(File indexFile) throws IOException {
        this.open(indexFile.getPath());
    }

    private void open(String location) throws IOException {
        InputStream ios = null;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        this.open(ios);
    }

    private void open(InputStream ios) throws IOException {
        String line;
        String line2;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        String lastLine = "";
        while ((line2 = dataIS.readLine()) != null) {
            Matcher m = idxlength.matcher(line2);
            if (m.find()) {
                this.indexLength = Long.parseLong(m.group(1));
            }
            if (!line2.startsWith("--")) continue;
            break;
        }
        while ((line2 = dataIS.readLine()) != null && !line2.startsWith("--")) {
            this.origPds.add(line2);
            lastLine = line2;
        }
        Matcher m = endOfData.matcher(lastLine);
        if (m.find()) {
            this.startSeek = Long.parseLong(m.group(1));
        }
        StringBuffer gdsBuffer = new StringBuffer();
        String gdsKey = "";
        while ((line = dataIS.readLine()) != null) {
            m = gdskey.matcher(line);
            if (m.find()) {
                gdsKey = m.group(1);
            }
            if (line.startsWith("--")) {
                this.origGds.put(gdsKey, gdsBuffer.toString());
                gdsBuffer.delete(0, gdsBuffer.length());
                gdsKey = "";
                continue;
            }
            gdsBuffer.append(line).append("\n");
        }
        this.origGds.put(gdsKey, gdsBuffer.toString());
        dataIS.close();
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans for index");
        System.out.println();
        System.out.println("java -Xmx256m " + className + " <GribFileToRead>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1IndexExtender indexExt = new Grib1IndexExtender();
        if (args.length < 1) {
            Class<?> cl = indexExt.getClass();
            Grib1IndexExtender.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = new RandomAccessFile(args[0], "r");
        raf.order(0);
        File indexFile = new File(args[0].concat(".gbx"));
        Index index = null;
        if (indexFile.canWrite()) {
            Index idxExt = indexExt.extendIndex(raf, indexFile, index);
        } else {
            System.err.println("index open failed, no write permission");
            System.exit(0);
        }
    }
}

