/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.A3DTableHDU;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.util.BufferedDataInputStream;

public class HDU {
    public static BasicHDU create(Object x) throws FitsException {
        String className = x.getClass().getName();
        if (className.equals("[[Ljava.lang.Object;")) {
            return new BinaryTableHDU((Object[][])x);
        }
        if (className.startsWith("[")) {
            return new ImageHDU(x);
        }
        throw new FitsException("Expected an array of some sort, not " + className);
    }

    public static RandomGroupsHDU createRandomGroups(Object[][] x) throws FitsException {
        return new RandomGroupsHDU(x);
    }

    public static AsciiTableHDU createAsciiTable(Object[][] x) throws FitsException {
        throw new FitsException("ASCII tables not yet supported");
    }

    public static BasicHDU create(Header header) throws FitsException {
        if (PrimaryHDU.isHeader(header)) {
            return new PrimaryHDU(header);
        }
        if (ImageHDU.isHeader(header)) {
            return new ImageHDU(header);
        }
        if (BinaryTableHDU.isHeader(header)) {
            return new BinaryTableHDU(header);
        }
        if (AsciiTableHDU.isHeader(header)) {
            return new AsciiTableHDU(header);
        }
        if (RandomGroupsHDU.isHeader(header)) {
            return new RandomGroupsHDU(header);
        }
        if (A3DTableHDU.isHeader(header)) {
            return new A3DTableHDU(header);
        }
        throw new BadHeaderException("Unknown FITS header: Card 1=" + header.getCard(0).trim() + ')');
    }

    public static BasicHDU readHDU(BufferedDataInputStream stream) throws FitsException, IOException {
        BasicHDU hdu;
        Header hdr = Header.readHeader(stream);
        if (hdr == null || !hdr.isValidHeader()) {
            return null;
        }
        try {
            hdu = HDU.create(hdr);
        }
        catch (BadHeaderException e) {
            try {
                BasicHDU.skipData(stream, hdr);
                throw e;
            }
            catch (FitsException fe) {
                throw new BadHeaderException("Could not skip Data section of unknown FITS header (Card 1=" + hdr.getCard(0).trim() + ").  Error is: " + fe.getMessage());
            }
        }
        hdu.readData(stream);
        return hdu;
    }

    public static boolean skipHDU(BufferedDataInputStream input) throws FitsException, IOException {
        Header nextHeader = Header.readHeader(input);
        if (nextHeader == null || !nextHeader.isValidHeader()) {
            return false;
        }
        try {
            BasicHDU.skipData(input, nextHeader);
        }
        catch (IOException e) {
            throw new FitsException("Error skipping data section:" + e.getMessage());
        }
        return true;
    }
}

