//######################################## harp.dsp ######################################
// A simple smart phone based harp (if we dare to call it like that). 
//
// ## `SmartKeyboard` Use Strategy
//
// Since the sounds generated by this synth are very short, the strategy here is to take
// advantage of the polyphony capabilities of the iOSKeyboard architecture by creating
// a new voice every time a new key is pressed. Since the `SmartKeyboard` interface has a 
// large number of keys here (128), lots of sounds are generated when sliding a 
// finger across the keyboard.
//
// ## Compilation Instructions
//
// This Faust code will compile fine with any of the standard Faust targets. However
// it was specifically designed to be used with `faust2smartkeyb`. For best results,
// we recommend to use the following parameters to compile it:
//
// ```
// faust2smartkeyb [-ios/-android] harp.dsp
// ```
//
// ## Version/Licence
//
// Version 0.0, Feb. 2017
// Copyright Romain Michon CCRMA (Stanford University)/GRAME 2017
// MIT Licence: https://opensource.org/licenses/MIT
//########################################################################################

declare name "harp";

import("stdfaust.lib");

//========================= Smart Keyboard Configuration ================================= 
// (8 keyboards with 16 keys configured as a pitch matrix.
//========================================================================================

declare interface "SmartKeyboard{
	'Number of Keyboards':'8',
	'Keyboard 0 - Number of Keys':'16',
	'Keyboard 1 - Number of Keys':'16',
	'Keyboard 2 - Number of Keys':'16',
	'Keyboard 3 - Number of Keys':'16',
	'Keyboard 4 - Number of Keys':'16',
	'Keyboard 5 - Number of Keys':'16',
	'Keyboard 6 - Number of Keys':'16',
	'Keyboard 7 - Number of Keys':'16',
	'Keyboard 0 - Lowest Key':'40',
	'Keyboard 1 - Lowest Key':'45',
	'Keyboard 2 - Lowest Key':'50',
	'Keyboard 3 - Lowest Key':'55',
	'Keyboard 4 - Lowest Key':'60',
	'Keyboard 5 - Lowest Key':'65',
	'Keyboard 6 - Lowest Key':'70',
	'Keyboard 7 - Lowest Key':'75',
	'Keyboard 0 - Piano Keyboard':'0',
	'Keyboard 1 - Piano Keyboard':'0',
	'Keyboard 2 - Piano Keyboard':'0',
	'Keyboard 3 - Piano Keyboard':'0',
	'Keyboard 4 - Piano Keyboard':'0',
	'Keyboard 5 - Piano Keyboard':'0',
	'Keyboard 6 - Piano Keyboard':'0',
	'Keyboard 7 - Piano Keyboard':'0'
}";

//================================ Instrument Parameters =================================
// Creates the connection between the synth and the mobile device
//========================================================================================

// the string resonance in second is controlled by the x axis of the accelerometer
res = hslider("res[acc: 0 0 -10 0 10]",2,0.1,4,0.01);
// Smart Keyboard frequency parameter
freq = hslider("freq",400,50,2000,0.01);
// Smart Keyboard gate parameter
gate = button("gate");

//=================================== Parameters Mapping =================================
//========================================================================================

stringFreq = freq;

//============================================ DSP =======================================
//========================================================================================

process = sy.combString(freq,res,gate);
