/*
 * $Id: sig_mech_mouse.h,v 1.7 2012-03-06 14:46:49 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_MECH_MOUSE_H_INCLUDED
#define __SIG_MECH_MOUSE_H_INCLUDED

#include "sig_boolean.h"
#include "sig_integer.h"

struct sig_mech_mouse {
	struct sig_boolean *button0;
	struct sig_boolean *button1;
	struct sig_boolean *button2;
	struct sig_boolean *button3;
	struct sig_boolean *button4;
	struct sig_integer *wheel0;
	struct sig_integer *wheel1;
	struct sig_integer *wheel2;
};

extern struct sig_mech_mouse *
sig_mech_mouse_create(const char *name);
extern void
sig_mech_mouse_destroy(struct sig_mech_mouse *sig);

extern void
sig_mech_mouse_suspend(struct sig_mech_mouse *b, FILE *fSig);
extern void
sig_mech_mouse_resume(struct sig_mech_mouse *b, FILE *fSig);

#endif /* __SIG_MECH_MOUSE_H_INCLUDED */
