#!/bin/sh
#
#   Copyright
#
#       Copyright (C) 2009-2010 Jari Aalto <jari.aalto@cante.net>
#
#   License
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   Description
#
#       Check licenses in *.svg files or FILES given on command line
#

AtExit ()
{
    rm -f $$.*
}

Help ()
{
    echo "
SYNOPSIS
  $0 FILE [FILE ...]

DESCRIPTION
  Examine *.svg files for 'License' and 'Copyright' information."

    exit 0
}

Main ()
{
    case "$*" in
        -h | --help ) Help ;;
    esac

    if [ ! "$1" ]; then
	echo "[ERROR] Need list of SVG files to examine. See --help" >&2
	return 1
    fi

    trap AtExit 0 1 3 15

    TMP=$$.log

    # [AWK OUTPUT]
    # applyall.svg              http://creativecommons.org/licenses/LGPL/2.1/

    awk '

	! oldfile {
	    oldfile = FILENAME
	}

	function Print ()
	{
	    if ( ! license )
	    {
		printf("%-25s UNKNOWN\n", oldfile)
		return 0
	    }

	    if ( author )
		author = " " author;

	    printf("%-25s %s%s\n", oldfile, license, author)

	    license = ""
	    author = ""
	}

	/http.*license/ {
	    sub(".*=.","")
	    sub("\".*","")
	    license = $0;
	}

	/dc:title/ {
	    sub(".*<dc:title>","")
	    sub("</dc.*","")
	    author = $0;
	}

	{
	    if ( oldfile != FILENAME )
	    {
		Print()
		oldfile = FILENAME
	    }
	}

	END {
	    Print()
	}

    ' "$@"
}

Main "$@"

# End of file
