#!/bin/sh -e

echo "/* autogenerated, don't edit */"

while read prefix base name type typedef; do
    echo "// $base.$name ($type)"
    case "$type" in
        string )
            echo "#define ${prefix}_has_${name}(d) (bool)((d).${base}.has_${name})
#define ${prefix}_${name}(d) (const uint8_t*)((d).${base}.${name}.data)
#define ${prefix}_${name}_length(d) (size_t)((d).${base}.${name}.len)
#define ${prefix}_set_${name}(d, v, l) (d).${base}.has_${name} = true; (d).${base}.${name}.data = v; (d).${base}.${name}.len = l
#define ${prefix}_set_${name}_string(d, v) (d).${base}.has_${name} = true; (d).${base}.${name}.data = (uint8_t*)v; (d).${base}.${name}.len = strlen(v)"
            ;;
        bytes )
            echo "#define ${prefix}_has_${name}(d) (bool)((d).${base}.has_${name})
#define ${prefix}_${name}(d) (const uint8_t*)((d).${base}.${name}.data)
#define ${prefix}_${name}_length(d) (size_t)((d).${base}.${name}.len)
#define ${prefix}_set_${name}(d, v, l) (d).${base}.has_${name} = true; (d).${base}.${name}.data = (uint8_t*)v; (d).${base}.${name}.len = l"
            ;;
        enum )
            echo "#define ${prefix}_has_${name}(d) (bool)((d).${base}.has_${name})
#define ${prefix}_${name}(d) (enum ${typedef})((d).${base}.${name})"
            ;;
        value )
            echo "#define ${prefix}_has_${name}(d) (bool)((d).${base}.has_${name})
#define ${prefix}_${name}(d) (${typedef})((d).${base}.${name})
#define ${prefix}_set_${name}(d, v) (d).${base}.has_${name} = true; (d).${base}.${name} = v"
            ;;
        * )
            echo "#error \"invalid type $type for $base.$name\""
            ;;
    esac
done < "$1"
