/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/not_implemented.hpp
 * 
 * @brief Exception to be thrown in case a part of code is reached that is not
 * (fully) implemented and thus should not have been reached.
 *
 * @author Christian Schallhart
 *
 * @version $Id: not_implemented.hpp 296 2007-11-27 00:21:41Z tautschn $
 */

#ifndef DIAGNOSTICS__BASIC_EXCEPTIONS__NOT_IMPLEMENTED_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__BASIC_EXCEPTIONS__NOT_IMPLEMENTED_HPP__INCLUDE_GUARD

#include <diagnostics/basic_exceptions/low_level_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Not_Implemented 
 *
 * @brief Exception to be thrown in case a part of code is reached that is not
 * (fully) implemented and thus should not have been reached.
 *
 * @nosubgrouping
 */
class Not_Implemented
    : public Low_Level_Exception
{
    typedef Not_Implemented Self;
    typedef Low_Level_Exception Super;
public:
    virtual ~Not_Implemented() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    explicit Not_Implemented(::std::string const & what);
    virtual char const * name() const;
    Not_Implemented(Self const & other);
};

DIAGNOSTICS_NAMESPACE_END;

#endif /* DIAGNOSTICS__BASIC_EXCEPTIONS__NOT_IMPLEMENTED_HPP__INCLUDE_GUARD */
