//
// C++ Interface: shareitemmodel
//
// Description:
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SHAREITEMMODEL_H
#define SHAREITEMMODEL_H

#include "global.h"
#include <vector>
#include <QAbstractTableModel>
using namespace std;

//! Represents an item in the ShareItemModel.
struct ShareItem
{
    ShareItem()
    {}
    ShareItem(const QString& v,const QString& r,qint64 s)
    {
        virtualDir=v;
        realDir=r;
        shareSize=s;
    }
    QString virtualDir;
    QString realDir;
    qint64 shareSize;
};

/**
	Data model for shared directories / files.
	@author Rikard Björklind
*/
class ShareItemModel : public QAbstractTableModel
{
Q_OBJECT
public:
    ShareItemModel();

    virtual ~ShareItemModel()
    {}

    /*
    * From QAbstractTableModel
    */
    int rowCount ( const QModelIndex& ) const
    {
        return items.size()>0?items.size():1;
    }
    int columnCount ( const QModelIndex& ) const
    {
        return items.size()>0?3:1;
    }
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
    virtual bool dropMimeData ( const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent );
    virtual Qt::DropActions supportedDropActions () const;

    /* Public interface */
    void add
        (const ShareItem& item)
    {
        items.push_back(item);
        emit layoutChanged();
    }
    void add
        (const QString& name,const QString& dir);
    const QString& getName(int row)
    {
        return items[row].virtualDir;
    }
    const QString& getDir(int row)
    {
        return items[row].realDir;
    }
    void remove
        (int row);
    void clear();
    virtual Qt::ItemFlags flags(const QModelIndex &index) const;
    virtual QStringList mimeTypes () const;
	
	signals:
		void dirDropped(const QString&);
	
	
private:
    vector<ShareItem> items;
};

#endif
