/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>
#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

extern int errno;
extern int debug_level; /* declared in debug module */

extern int format;

int DBAudio_Set_Format(int fmt)
{	
	switch(fmt)
	{
	case AFMT_U8:
	case AFMT_S8: 
	case AFMT_S16_LE: 
	case AFMT_S16_BE:
		format = fmt;
		return SUCCESS;
	default: 
		errno = ERROR_BAD_FORMAT; 
		return FAILURE;
	}
}

int DBAudio_Get_Format()
{
	return format;
}


#ifdef __cplusplus
}
#endif
