/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.FormatNumber2;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class FloatValue
extends NumericValue {
    public static final FloatValue ZERO = new FloatValue(0.0f);
    public static final FloatValue ONE = new FloatValue(1.0f);
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    private float value;
    static Pattern roundablePattern = Pattern.compile(".*99999.*|.*00000.*");

    public FloatValue(CharSequence charSequence) throws DynamicError {
        try {
            this.value = (float)Value.stringToNumber(charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DynamicError("Cannot convert string " + Err.wrap(charSequence, 4) + " to a float");
        }
    }

    public FloatValue(float f) {
        this.value = f;
    }

    public float getFloatValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return (double)this.value != 0.0 && !Float.isNaN(this.value);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 514: {
                return BooleanValue.get((double)this.value != 0.0 && !Float.isNaN(this.value));
            }
            case 88: 
            case 516: 
            case 643: 
            case 646: {
                return this;
            }
            case 532: {
                if (Float.isNaN(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert float NaN to an integer");
                    validationException.setErrorCode("FOCA0002");
                    return new ValidationErrorValue(validationException);
                }
                if (Float.isInfinite(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert float infinity to an integer");
                    validationException.setErrorCode("FOCA0002");
                    return new ValidationErrorValue(validationException);
                }
                if (this.value > 9.223372E18f || this.value < -9.223372E18f) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return new IntegerValue((long)this.value);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException validationException) {
                    return new ValidationErrorValue(validationException);
                }
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert float to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public CharSequence getStringValueCS() {
        return FloatValue.floatToString(this.value);
    }

    static CharSequence floatToString(float f) {
        return FloatingPointConverter.appendFloat(new FastStringBuffer(20), f);
    }

    static CharSequence floatToStringOLD(float f, String string) {
        String string2;
        if ((double)f == 0.0) {
            if (string.charAt(0) == '-') {
                return "-0";
            }
            return "0";
        }
        if (Float.isInfinite(f)) {
            return f > 0.0f ? "INF" : "-INF";
        }
        if (Float.isNaN(f)) {
            return "NaN";
        }
        float f2 = Math.abs(f);
        String string3 = string;
        if (f2 < 1.0E-6f || f2 >= 1000000.0f) {
            int n = string3.indexOf(69);
            if (n < 0) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
                Matcher matcher = DoubleValue.nonExponentialPattern.matcher(string3);
                if (matcher.matches()) {
                    fastStringBuffer.append(matcher.group(1));
                    fastStringBuffer.append('.');
                    fastStringBuffer.append(matcher.group(2));
                    String string4 = matcher.group(4);
                    if ("0".equals(string4)) {
                        fastStringBuffer.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                        return fastStringBuffer.toString();
                    }
                    fastStringBuffer.append(matcher.group(3));
                    fastStringBuffer.append(matcher.group(4));
                    fastStringBuffer.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                    return fastStringBuffer;
                }
                return string3;
            }
            if (roundablePattern.matcher(string3).matches()) {
                BigDecimal bigDecimal = FormatNumber2.adjustToDecimal(f, 1);
                try {
                    return new DoubleValue(bigDecimal.toString()).getStringValue();
                }
                catch (ValidationException validationException) {
                    throw new AssertionError((Object)validationException);
                }
            }
            return string3;
        }
        int n = string3.length();
        if (string3.indexOf("E") >= 0 && string3.endsWith(".0")) {
            return DoubleValue.doubleToString(f);
        }
        if (string3.endsWith("E0")) {
            string3 = string3.substring(0, n - 2);
        }
        if (string3.endsWith(".0")) {
            return string3.substring(0, n - 2);
        }
        int n2 = string3.indexOf(69);
        if (n2 < 0) {
            while (string3.charAt(n - 1) == '0' && string3.charAt(n - 2) != '.') {
                string3 = string3.substring(0, --n);
            }
            return string3;
        }
        int n3 = Integer.parseInt(string3.substring(n2 + 1));
        if (string3.charAt(0) == '-') {
            string2 = "-";
            string3 = string3.substring(1);
            --n2;
        } else {
            string2 = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return string2 + string3.substring(0, 1) + string3.substring(2, n2) + DoubleValue.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return string2 + string3.substring(0, 1) + string3.substring(2, 2 + n3) + '.' + string3.substring(2 + n3, n2);
        }
        while (string3.charAt(n2 - 1) == '0') {
            --n2;
        }
        return string2 + "0." + DoubleValue.zeros(-1 - n3) + string3.substring(0, 1) + string3.substring(2, n2);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.FLOAT_TYPE;
    }

    public NumericValue negate() {
        return new FloatValue(-this.value);
    }

    public NumericValue floor() {
        return new FloatValue((float)Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new FloatValue((float)Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Float.isNaN(this.value)) {
            return this;
        }
        if (Float.isInfinite(this.value)) {
            return this;
        }
        if ((double)this.value == 0.0) {
            return this;
        }
        if ((double)this.value > -0.5 && (double)this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return new FloatValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundHalfToEven(int n) {
        try {
            return (FloatValue)new DoubleValue(this.value).roundHalfToEven(n).convert(516, null);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    public double signum() {
        if (Float.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0f) {
            return 1.0;
        }
        if (this.value == 0.0f) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return (double)this.value == Math.floor(this.value) && !Float.isInfinite(this.value);
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof FloatValue) {
            switch (n) {
                case 15: {
                    return new FloatValue(this.value + ((FloatValue)numericValue).value);
                }
                case 16: {
                    return new FloatValue(this.value - ((FloatValue)numericValue).value);
                }
                case 17: {
                    return new FloatValue(this.value * ((FloatValue)numericValue).value);
                }
                case 18: {
                    return new FloatValue(this.value / ((FloatValue)numericValue).value);
                }
                case 50: {
                    if ((double)((FloatValue)numericValue).value == 0.0) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setErrorCode("FOAR0001");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    if (this.isNaN() || Float.isInfinite(this.value)) {
                        DynamicError dynamicError = new DynamicError("First operand of idiv is NaN or infinity");
                        dynamicError.setErrorCode("FOAR0002");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    if (numericValue.isNaN()) {
                        DynamicError dynamicError = new DynamicError("Second operand of idiv is NaN");
                        dynamicError.setErrorCode("FOAR0002");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    return (NumericValue)new FloatValue(this.value / ((FloatValue)numericValue).value).convert(532, xPathContext);
                }
                case 19: {
                    return new FloatValue(this.value % ((FloatValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof DoubleValue) {
            return ((DoubleValue)this.convert(517, xPathContext)).arithmetic(n, numericValue, xPathContext);
        }
        return this.arithmetic(n, (FloatValue)numericValue.convert(516, xPathContext), xPathContext);
    }

    public int compareTo(Object object) {
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            return this.compareTo(((AtomicValue)object).getPrimitiveValue());
        }
        if (!(object instanceof NumericValue)) {
            throw new ClassCastException("Numeric values are not comparable to " + object.getClass());
        }
        if (object instanceof FloatValue) {
            float f = ((FloatValue)object).value;
            if (this.value == f) {
                return 0;
            }
            if (this.value < f) {
                return -1;
            }
            return 1;
        }
        if (object instanceof DoubleValue) {
            return super.compareTo(object);
        }
        try {
            return this.compareTo(((NumericValue)object).convert(516, null));
        }
        catch (XPathException xPathException) {
            throw new ClassCastException("Operand of comparison cannot be promoted to xs:float");
        }
    }

    public int compareTo(long l) {
        float f = l;
        if (this.value == f) {
            return 0;
        }
        if (this.value < f) {
            return -1;
        }
        return 1;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(DoubleValue.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (double)this.value != 0.0 && !Float.isNaN(this.value);
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new Character((char)this.value);
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of float to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SXJE0004");
        }
        return object;
    }
}

